# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['RepositoryFile']


class RepositoryFile(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_author: Optional[pulumi.Input[str]] = None,
                 commit_email: Optional[pulumi.Input[str]] = None,
                 commit_message: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 file: Optional[pulumi.Input[str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[bool]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        This resource allows you to create and manage files within a
        GitHub repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        foo_repository = github.Repository("fooRepository", auto_init=True)
        foo_repository_file = github.RepositoryFile("fooRepositoryFile",
            repository=foo_repository.name,
            branch="main",
            file=".gitignore",
            content="**/*.tfstate",
            commit_message="Managed by Terraform",
            commit_author="Terraform User",
            commit_email="terraform@example.com",
            overwrite_on_create=True)
        ```

        ## Import

        Repository files can be imported using a combination of the `repo` and `file`, e.g.

        ```sh
         $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore
        ```

         To import a file from a branch other than main, append `:` and the branch name, e.g.

        ```sh
         $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore:dev
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: Git branch (defaults to `main`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use.
        :param pulumi.Input[str] commit_email: Committer email address to use.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[bool] overwrite_on_create: Enable overwriting existing files
        :param pulumi.Input[str] repository: The repository name
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['branch'] = branch
            __props__['commit_author'] = commit_author
            __props__['commit_email'] = commit_email
            __props__['commit_message'] = commit_message
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__['content'] = content
            if file is None and not opts.urn:
                raise TypeError("Missing required property 'file'")
            __props__['file'] = file
            __props__['overwrite_on_create'] = overwrite_on_create
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__['repository'] = repository
            __props__['commit_sha'] = None
            __props__['sha'] = None
        super(RepositoryFile, __self__).__init__(
            'github:index/repositoryFile:RepositoryFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch: Optional[pulumi.Input[str]] = None,
            commit_author: Optional[pulumi.Input[str]] = None,
            commit_email: Optional[pulumi.Input[str]] = None,
            commit_message: Optional[pulumi.Input[str]] = None,
            commit_sha: Optional[pulumi.Input[str]] = None,
            content: Optional[pulumi.Input[str]] = None,
            file: Optional[pulumi.Input[str]] = None,
            overwrite_on_create: Optional[pulumi.Input[bool]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            sha: Optional[pulumi.Input[str]] = None) -> 'RepositoryFile':
        """
        Get an existing RepositoryFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: Git branch (defaults to `main`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use.
        :param pulumi.Input[str] commit_email: Committer email address to use.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[str] commit_sha: The SHA of the commit that modified the file.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[bool] overwrite_on_create: Enable overwriting existing files
        :param pulumi.Input[str] repository: The repository name
        :param pulumi.Input[str] sha: The SHA blob of the file.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["branch"] = branch
        __props__["commit_author"] = commit_author
        __props__["commit_email"] = commit_email
        __props__["commit_message"] = commit_message
        __props__["commit_sha"] = commit_sha
        __props__["content"] = content
        __props__["file"] = file
        __props__["overwrite_on_create"] = overwrite_on_create
        __props__["repository"] = repository
        __props__["sha"] = sha
        return RepositoryFile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Output[Optional[str]]:
        """
        Git branch (defaults to `main`).
        The branch must already exist, it will not be created if it does not already exist.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="commitAuthor")
    def commit_author(self) -> pulumi.Output[str]:
        """
        Committer author name to use.
        """
        return pulumi.get(self, "commit_author")

    @property
    @pulumi.getter(name="commitEmail")
    def commit_email(self) -> pulumi.Output[str]:
        """
        Committer email address to use.
        """
        return pulumi.get(self, "commit_email")

    @property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> pulumi.Output[str]:
        """
        Commit message when adding or updating the managed file.
        """
        return pulumi.get(self, "commit_message")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> pulumi.Output[str]:
        """
        The SHA of the commit that modified the file.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def file(self) -> pulumi.Output[str]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable overwriting existing files
        """
        return pulumi.get(self, "overwrite_on_create")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        The repository name
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def sha(self) -> pulumi.Output[str]:
        """
        The SHA blob of the file.
        """
        return pulumi.get(self, "sha")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

