# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ProjectCard']


class ProjectCard(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_id: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        This resource allows you to create and manage cards for GitHub projects.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        project = github.OrganizationProject("project", body="This is an organization project.")
        column = github.ProjectColumn("column", project_id=project.id)
        card = github.ProjectCard("card",
            column_id=column.column_id,
            note="## Unaccepted 👇")
        ```

        ## Import

        A GitHub Project Card can be imported using its [Card ID](https://developer.github.com/v3/projects/cards/#get-a-project-card)

        ```sh
         $ pulumi import github:index/projectCard:ProjectCard card 01234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column_id: The ID of the card.
        :param pulumi.Input[str] note: The note contents of the card. Markdown supported.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if column_id is None and not opts.urn:
                raise TypeError("Missing required property 'column_id'")
            __props__['column_id'] = column_id
            if note is None and not opts.urn:
                raise TypeError("Missing required property 'note'")
            __props__['note'] = note
            __props__['card_id'] = None
            __props__['etag'] = None
        super(ProjectCard, __self__).__init__(
            'github:index/projectCard:ProjectCard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            card_id: Optional[pulumi.Input[int]] = None,
            column_id: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            note: Optional[pulumi.Input[str]] = None) -> 'ProjectCard':
        """
        Get an existing ProjectCard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column_id: The ID of the card.
        :param pulumi.Input[str] note: The note contents of the card. Markdown supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["card_id"] = card_id
        __props__["column_id"] = column_id
        __props__["etag"] = etag
        __props__["note"] = note
        return ProjectCard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter(name="columnId")
    def column_id(self) -> pulumi.Output[str]:
        """
        The ID of the card.
        """
        return pulumi.get(self, "column_id")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def note(self) -> pulumi.Output[str]:
        """
        The note contents of the card. Markdown supported.
        """
        return pulumi.get(self, "note")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

