# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Branch']


class Branch(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 source_branch: Optional[pulumi.Input[str]] = None,
                 source_sha: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        This resource allows you to create and manage branches within your repository.

        Additional constraints can be applied to ensure your branch is created from
        another branch or commit.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        development = github.Branch("development",
            branch="development",
            repository="example")
        ```

        ## Import

        GitHub Branch can be imported using an ID made up of `repository:branch`, e.g.

        ```sh
         $ pulumi import github:index/branch:Branch terraform terraform:master
        ```

         Optionally, a source branch may be specified using an ID of `repository:branch:source_branch`. This is useful for importing branches that do not branch directly off master.

        ```sh
         $ pulumi import github:index/branch:Branch terraform terraform:feature-branch:dev
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: The repository branch to create.
        :param pulumi.Input[str] repository: The GitHub repository name.
        :param pulumi.Input[str] source_branch: The branch name to start from. Defaults to `master`.
        :param pulumi.Input[str] source_sha: The commit hash to start from. Defaults to the tip of `source_branch`. If provided, `source_branch` is ignored.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if branch is None and not opts.urn:
                raise TypeError("Missing required property 'branch'")
            __props__['branch'] = branch
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__['repository'] = repository
            __props__['source_branch'] = source_branch
            __props__['source_sha'] = source_sha
            __props__['etag'] = None
            __props__['ref'] = None
            __props__['sha'] = None
        super(Branch, __self__).__init__(
            'github:index/branch:Branch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            ref: Optional[pulumi.Input[str]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            sha: Optional[pulumi.Input[str]] = None,
            source_branch: Optional[pulumi.Input[str]] = None,
            source_sha: Optional[pulumi.Input[str]] = None) -> 'Branch':
        """
        Get an existing Branch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: The repository branch to create.
        :param pulumi.Input[str] etag: An etag representing the Branch object.
        :param pulumi.Input[str] ref: A string representing a branch reference, in the form of `refs/heads/<branch>`.
        :param pulumi.Input[str] repository: The GitHub repository name.
        :param pulumi.Input[str] sha: A string storing the reference's `HEAD` commit's SHA1.
        :param pulumi.Input[str] source_branch: The branch name to start from. Defaults to `master`.
        :param pulumi.Input[str] source_sha: The commit hash to start from. Defaults to the tip of `source_branch`. If provided, `source_branch` is ignored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["branch"] = branch
        __props__["etag"] = etag
        __props__["ref"] = ref
        __props__["repository"] = repository
        __props__["sha"] = sha
        __props__["source_branch"] = source_branch
        __props__["source_sha"] = source_sha
        return Branch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Output[str]:
        """
        The repository branch to create.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        An etag representing the Branch object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def ref(self) -> pulumi.Output[str]:
        """
        A string representing a branch reference, in the form of `refs/heads/<branch>`.
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        The GitHub repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def sha(self) -> pulumi.Output[str]:
        """
        A string storing the reference's `HEAD` commit's SHA1.
        """
        return pulumi.get(self, "sha")

    @property
    @pulumi.getter(name="sourceBranch")
    def source_branch(self) -> pulumi.Output[Optional[str]]:
        """
        The branch name to start from. Defaults to `master`.
        """
        return pulumi.get(self, "source_branch")

    @property
    @pulumi.getter(name="sourceSha")
    def source_sha(self) -> pulumi.Output[str]:
        """
        The commit hash to start from. Defaults to the tip of `source_branch`. If provided, `source_branch` is ignored.
        """
        return pulumi.get(self, "source_sha")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

