import * as ec2 from '@aws-cdk/aws-ec2';
import * as eks from '@aws-cdk/aws-eks';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import * as runner from './runner';
/**
 * @stability stable
 */
export interface ProviderProps {
    /**
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * @stability stable
 */
export interface RoleProps {
    /**
     * @stability stable
     */
    readonly accountId: string;
    /**
     * @stability stable
     */
    readonly externalId: string;
}
/**
 * @stability stable
 */
export interface EksClusterOptions {
    /**
     * create serivce account and rbac ClusterRoleBinding for gitlab.
     *
     * @default true
     * @see https://docs.gitlab.com/ee/user/project/clusters/add_remove_clusters.html#add-existing-cluster
     * @stability stable
     */
    readonly rbac?: boolean;
    /**
     * cluster properties for Amazon EKS cluster.
     *
     * @stability stable
     */
    readonly clusterOptions: eks.ClusterProps;
}
/**
 * @stability stable
 */
export interface HelmRunnerOptions {
    /**
     * tags for the runner.
     *
     * @default - ['eks', 'fargate', 'runner']
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * GitLab registration token for the runner, you put registrationToken in cdk.context.json like "GITLAB_REGISTRATION_TOKEN": "xxxxxxx".
     *
     * @stability stable
     */
    readonly registrationToken?: string;
    /**
     * gitlab URL prefix.
     *
     * @default - 'https://gitlab.com'
     * @stability stable
     */
    readonly gitlabURL?: string;
    /**
     * Number of run job in the same time.
     *
     * @default - 10
     * @stability stable
     */
    readonly concurrent?: number;
    /**
     * Gitlab runners default image when job start not set "image" in gitlab-ci.yaml.
     *
     * @default - alpine:3.11
     * @stability stable
     */
    readonly jobDefaultImage?: string;
    /**
     * Gitlab helm chart install namespace.
     *
     * if you change this to other namespace, please addFargateProfile() add that you want namespace.
     *
     * @default - default.
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface FargateEksClusterOptions {
    /**
     * create serivce account and rbac ClusterRoleBinding for gitlab.
     *
     * @default true
     * @see https://docs.gitlab.com/ee/user/project/clusters/add_remove_clusters.html#add-existing-cluster
     * @stability stable
     */
    readonly rbac?: boolean;
    /**
     * cluster properties for Amazon EKS cluster.
     *
     * @stability stable
     */
    readonly clusterOptions: eks.FargateClusterProps;
    /**
     * Gitlab helm Chart runner install Options.
     *
     * see https://docs.gitlab.com/runner/install/kubernetes.html
     *
     * @stability stable
     */
    readonly helmRunnerOptions?: HelmRunnerOptions;
}
/**
 * The Provider to create GitLab Integrations with AWS.
 *
 * @stability stable
 */
export declare class Provider extends cdk.Construct {
    /**
     * @stability stable
     */
    gitlabEksRole?: iam.IRole;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: ProviderProps);
    /**
     * @stability stable
     */
    createFargateRunner(executor?: runner.FargateJobExecutor): void;
    /**
     * @stability stable
     */
    createEksCluster(scope: cdk.Construct, id: string, props: EksClusterOptions): eks.Cluster;
    /**
     * @stability stable
     */
    createFargateEksCluster(scope: cdk.Construct, id: string, props: FargateEksClusterOptions): eks.Cluster;
    /**
     * @stability stable
     */
    createSecurityGroup(): ec2.SecurityGroup;
    /**
     * @stability stable
     */
    createEksServiceRole(): iam.Role;
    /**
     * @stability stable
     */
    createGitlabManagedEksRole(props: RoleProps): void;
    private synthesizeTags;
}
