# mypy-boto3-lambda

[![PyPI - mypy-boto3-lambda](https://img.shields.io/pypi/v/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Lambda 1.13.4](https://boto3.amazonaws.com/v1/documentation/api/1.13.4/reference/services/lambda.html#Lambda) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-lambda](#mypy-boto3-lambda)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Lambda` service.

```bash
python -m pip install boto3-stubs[lambda]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import lambda_
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_lambda as lambda_

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("lambda")
client: lambda_.LambdaClient = boto3.client("lambda")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: lambda_.LambdaClient = session.client("lambda")


# Waiters need type annotation on creation
function_active_waiter: lambda_.FunctionActiveWaiter = client.get_waiter("function_active")
function_exists_waiter: lambda_.FunctionExistsWaiter = client.get_waiter("function_exists")
function_updated_waiter: lambda_.FunctionUpdatedWaiter = client.get_waiter("function_updated")

# Paginators need type annotation on creation
list_aliases_paginator: lambda_.ListAliasesPaginator = client.get_paginator("list_aliases")
list_event_source_mappings_paginator: lambda_.ListEventSourceMappingsPaginator = client.get_paginator("list_event_source_mappings")
list_function_event_invoke_configs_paginator: lambda_.ListFunctionEventInvokeConfigsPaginator = client.get_paginator("list_function_event_invoke_configs")
list_functions_paginator: lambda_.ListFunctionsPaginator = client.get_paginator("list_functions")
list_layer_versions_paginator: lambda_.ListLayerVersionsPaginator = client.get_paginator("list_layer_versions")
list_layers_paginator: lambda_.ListLayersPaginator = client.get_paginator("list_layers")
list_provisioned_concurrency_configs_paginator: lambda_.ListProvisionedConcurrencyConfigsPaginator = client.get_paginator("list_provisioned_concurrency_configs")
list_versions_by_function_paginator: lambda_.ListVersionsByFunctionPaginator = client.get_paginator("list_versions_by_function")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.