import requests
from factionpy.config import AUTH_ENDPOINT
from factionpy.logger import log


def validate_authorization_header(header_value):
    log(f"got header {header_value}", "debug")
    success = False
    result = None
    try:
        headers = {"Authorization": header_value}
        url = f"{AUTH_ENDPOINT}/verify/"
        log(f"using url: {url}", "debug")
        r = requests.get(url, headers=headers).json()
        log(f"got response {r}", "debug")
        if r['success'] == "True":
            success = True
            result = r
    except Exception as e:
        result = e
    rsp = {"success": success, "result": result}
    log(f"returning: {rsp}", "debug")
    return rsp
