#!/bin/bash
SCRIPTPATH="$( cd "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
. $SCRIPTPATH/mylog.sh --source-only

_e="\e[0m"
_r="\e[1;49;91m"
_o="\e[1;49;93m"
_g="\e[1;49;32m"
_p="\e[0;49;95m"

#  .----------------.  .----------------.  .----------------. 
# | .--------------. || .--------------. || .--------------. |
# | | ____    ____ | || |   ______     | || | ____    ____ | |
# | ||_   \  /   _|| || |  |_   __ \   | || ||_   \  /   _|| |
# | |  |   \/   |  | || |    | |__) |  | || |  |   \/   |  | |
# | |  | |\  /| |  | || |    |  ___/   | || |  | |\  /| |  | |
# | | _| |_\/_| |_ | || |   _| |_      | || | _| |_\/_| |_ | |
# | ||_____||_____|| || |  |_____|     | || ||_____||_____|| |
# | |              | || |              | || |              | |
# | '--------------' || '--------------' || '--------------' |
#  '----------------'  '----------------'  '----------------' 

print_logo() {
    echo -e "$_p .----------------.  .----------------.  .----------------. $_e";
    echo -e "$_p| $_r.--------------.$_e$_p || $_o.--------------.$_e$_p || $_g.--------------.$_e$_p |$_e";
    echo -e "$_p| $_r| ____    ____ |$_e$_p || $_o|   ______     |$_e$_p || $_g| ____    ____ |$_e$_p |$_e";
    echo -e "$_p| $_r||_   \  /   _||$_e$_p || $_o|  |_   __ \   |$_e$_p || $_g||_   \  /   _||$_e$_p |$_e";
    echo -e "$_p| $_r|  |   \/   |  |$_e$_p || $_o|    | |__) |  |$_e$_p || $_g|  |   \/   |  |$_e$_p |$_e";
    echo -e "$_p| $_r|  | |\  /| |  |$_e$_p || $_o|    |  ___/   |$_e$_p || $_g|  | |\  /| |  |$_e$_p |$_e";
    echo -e "$_p| $_r| _| |_\/_| |_ |$_e$_p || $_o|   _| |_      |$_e$_p || $_g| _| |_\/_| |_ |$_e$_p |$_e";
    echo -e "$_p| $_r||_____||_____||$_e$_p || $_o|  |_____|     |$_e$_p || $_g||_____||_____||$_e$_p |$_e";
    echo -e "$_p| $_r|              |$_e$_p || $_o|              |$_e$_p || $_g|              |$_e$_p |$_e";
    echo -e "$_p| $_r'--------------'$_e$_p || $_o'--------------'$_e$_p || $_g'--------------'$_e$_p |$_e";
    echo -e "$_p '----------------'  '----------------'  '----------------' $_e";
}


main() {
    mylog_info "Print logo!"
    print_logo
    mylog_success "Printed"
}

if [ "${1}" != "--source-only" ]; then
    main "${@}"
fi