"""
    Proxy Service

    This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.   # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: eden.trainor@compassdigital.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from insights_engine.api_client import ApiClient, Endpoint as _Endpoint
from insights_engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from insights_engine.model.add_subscription_input import AddSubscriptionInput
from insights_engine.model.delete_subscription_input import DeleteSubscriptionInput
from insights_engine.model.get_user_subscriptions_output import GetUserSubscriptionsOutput


class SubscriptionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_subscription_endpoint = _Endpoint(
            settings={
                'response_type': (GetUserSubscriptionsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/subscription/user',
                'operation_id': 'add_subscription',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'add_subscription_input',
                    'context',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'add_subscription_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'add_subscription_input':
                        (AddSubscriptionInput,),
                    'context':
                        (bool,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                    'context': 'context',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'add_subscription_input': 'body',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_subscription_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/subscription/user',
                'operation_id': 'delete_subscription',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'delete_subscription_input',
                    'context',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'delete_subscription_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'delete_subscription_input':
                        (DeleteSubscriptionInput,),
                    'context':
                        (bool,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                    'context': 'context',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'delete_subscription_input': 'body',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_app_subscriptions_endpoint = _Endpoint(
            settings={
                'response_type': (GetUserSubscriptionsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/subscription',
                'operation_id': 'get_app_subscriptions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'context',
                ],
                'required': [
                    'app_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'context':
                        (bool,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'context': 'context',
                },
                'location_map': {
                    'app_name': 'query',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_user_subscriptions_endpoint = _Endpoint(
            settings={
                'response_type': (GetUserSubscriptionsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/subscription/user',
                'operation_id': 'get_user_subscriptions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'context',
                ],
                'required': [
                    'app_name',
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'context':
                        (bool,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                    'context': 'context',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def add_subscription(
        self,
        app_name,
        user_name,
        add_subscription_input,
        **kwargs
    ):
        """Add a subscription for this user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_subscription(app_name, user_name, add_subscription_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            add_subscription_input (AddSubscriptionInput):

        Keyword Args:
            context (bool): If you want to see subscribed context or not. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetUserSubscriptionsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['add_subscription_input'] = \
            add_subscription_input
        return self.add_subscription_endpoint.call_with_http_info(**kwargs)

    def delete_subscription(
        self,
        app_name,
        user_name,
        delete_subscription_input,
        **kwargs
    ):
        """deletes a subscription for this user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_subscription(app_name, user_name, delete_subscription_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            delete_subscription_input (DeleteSubscriptionInput):

        Keyword Args:
            context (bool): If you want to see subscribed context or not. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['delete_subscription_input'] = \
            delete_subscription_input
        return self.delete_subscription_endpoint.call_with_http_info(**kwargs)

    def get_app_subscriptions(
        self,
        app_name,
        **kwargs
    ):
        """Get all subscriptions for app  # noqa: E501

        Fetches all the subscriptions active for this app.  This is a close indicator for how many generators are being run to update the insights. Set context to true for all subscription with contexts, Set context to false to see non context subscriptions   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_app_subscriptions(app_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.

        Keyword Args:
            context (bool): If you want to see subscribed context or not. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetUserSubscriptionsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        return self.get_app_subscriptions_endpoint.call_with_http_info(**kwargs)

    def get_user_subscriptions(
        self,
        app_name,
        user_name,
        **kwargs
    ):
        """Get subscribed windows for this user  # noqa: E501

        Gets all the windows this user is subscribed to.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_subscriptions(app_name, user_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.

        Keyword Args:
            context (bool): If you want to see subscribed context or not. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetUserSubscriptionsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        return self.get_user_subscriptions_endpoint.call_with_http_info(**kwargs)

