"""
    Proxy Service

    This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.   # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: eden.trainor@compassdigital.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from insights_engine.api_client import ApiClient, Endpoint as _Endpoint
from insights_engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from insights_engine.model.save_insight_input import SaveInsightInput
from insights_engine.model.unsave_insight_input import UnsaveInsightInput


class SaveApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.save_insight_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/save',
                'operation_id': 'save_insight',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'save_insight_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'save_insight_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'save_insight_input':
                        (SaveInsightInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'save_insight_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.unsave_insight_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/save',
                'operation_id': 'unsave_insight',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'unsave_insight_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'unsave_insight_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'unsave_insight_input':
                        (UnsaveInsightInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'unsave_insight_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def save_insight(
        self,
        app_name,
        user_name,
        save_insight_input,
        **kwargs
    ):
        """Save Insight Payload  # noqa: E501

        Saves an insight payload for this user so that it shows up in their \"saved\" payloads.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_insight(app_name, user_name, save_insight_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            save_insight_input (SaveInsightInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['save_insight_input'] = \
            save_insight_input
        return self.save_insight_endpoint.call_with_http_info(**kwargs)

    def unsave_insight(
        self,
        app_name,
        user_name,
        unsave_insight_input,
        **kwargs
    ):
        """Unsave Insight Payload  # noqa: E501

        \"Unsaves an insight payload for a user.  WARNING: This is ireversible and the payload will be lost if a new one has already replaced it for that window.\"   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unsave_insight(app_name, user_name, unsave_insight_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            unsave_insight_input (UnsaveInsightInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['unsave_insight_input'] = \
            unsave_insight_input
        return self.unsave_insight_endpoint.call_with_http_info(**kwargs)

