"""
    Proxy Service

    This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.   # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: eden.trainor@compassdigital.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from insights_engine.api_client import ApiClient, Endpoint as _Endpoint
from insights_engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from insights_engine.model.add_filter_batch_input import AddFilterBatchInput
from insights_engine.model.add_filter_batch_output import AddFilterBatchOutput
from insights_engine.model.add_filter_input import AddFilterInput
from insights_engine.model.add_filter_output import AddFilterOutput
from insights_engine.model.delete_batch_filter_output import DeleteBatchFilterOutput
from insights_engine.model.delete_filter_batch_input import DeleteFilterBatchInput
from insights_engine.model.delete_filter_input import DeleteFilterInput
from insights_engine.model.delete_filter_output import DeleteFilterOutput
from insights_engine.model.get_filter_output import GetFilterOutput


class FilterApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_filter_endpoint = _Endpoint(
            settings={
                'response_type': (AddFilterOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/filter',
                'operation_id': 'add_filter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'add_filter_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'add_filter_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'add_filter_input':
                        (AddFilterInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'add_filter_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.add_filter_batch_endpoint = _Endpoint(
            settings={
                'response_type': (AddFilterBatchOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/filter_batch',
                'operation_id': 'add_filter_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'add_filter_batch_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'add_filter_batch_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'add_filter_batch_input':
                        (AddFilterBatchInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'add_filter_batch_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_filter_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteFilterOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/filter',
                'operation_id': 'delete_filter',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'delete_filter_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'delete_filter_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'delete_filter_input':
                        (DeleteFilterInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'delete_filter_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_filter_batch_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteBatchFilterOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/filter_batch',
                'operation_id': 'delete_filter_batch',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'delete_filter_batch_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'delete_filter_batch_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'delete_filter_batch_input':
                        (DeleteFilterBatchInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'delete_filter_batch_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_filter_endpoint = _Endpoint(
            settings={
                'response_type': (GetFilterOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/filter',
                'operation_id': 'get_filter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                ],
                'required': [
                    'app_name',
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def add_filter(
        self,
        app_name,
        user_name,
        add_filter_input,
        **kwargs
    ):
        """add single filters for a user  # noqa: E501

        Create filters for users based on categories/tags. Categories and tags need to mentioned in filter type.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_filter(app_name, user_name, add_filter_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            add_filter_input (AddFilterInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AddFilterOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['add_filter_input'] = \
            add_filter_input
        return self.add_filter_endpoint.call_with_http_info(**kwargs)

    def add_filter_batch(
        self,
        app_name,
        user_name,
        add_filter_batch_input,
        **kwargs
    ):
        """add an array of filters for a user  # noqa: E501

        create an array of filters for users based on categories/tags. category and tags need to mentioned in filter type and value in  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_filter_batch(app_name, user_name, add_filter_batch_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            add_filter_batch_input (AddFilterBatchInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AddFilterBatchOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['add_filter_batch_input'] = \
            add_filter_batch_input
        return self.add_filter_batch_endpoint.call_with_http_info(**kwargs)

    def delete_filter(
        self,
        app_name,
        user_name,
        delete_filter_input,
        **kwargs
    ):
        """Delete single filter for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_filter(app_name, user_name, delete_filter_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            delete_filter_input (DeleteFilterInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteFilterOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['delete_filter_input'] = \
            delete_filter_input
        return self.delete_filter_endpoint.call_with_http_info(**kwargs)

    def delete_filter_batch(
        self,
        app_name,
        user_name,
        delete_filter_batch_input,
        **kwargs
    ):
        """Delete array of filters for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_filter_batch(app_name, user_name, delete_filter_batch_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.
            delete_filter_batch_input (DeleteFilterBatchInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteBatchFilterOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['delete_filter_batch_input'] = \
            delete_filter_batch_input
        return self.delete_filter_batch_endpoint.call_with_http_info(**kwargs)

    def get_filter(
        self,
        app_name,
        user_name,
        **kwargs
    ):
        """Gets all filters for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_filter(app_name, user_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
            user_name (str): This is an individual Insights consumer registered with an external app on the Insights Engine.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetFilterOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        return self.get_filter_endpoint.call_with_http_info(**kwargs)

