# insights-engine
This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://GITHUB_TOKEN@github.com/compassdigital/insights-proxy-service.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://GITHUB_TOKEN@github.com/compassdigital/insights-proxy-service.git`)

Then import the package:
```python
import insights_engine
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import insights_engine
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import insights_engine
from pprint import pprint
from insights_engine.api import filter_api
from insights_engine.model.add_filter_batch_input import AddFilterBatchInput
from insights_engine.model.add_filter_batch_output import AddFilterBatchOutput
from insights_engine.model.add_filter_input import AddFilterInput
from insights_engine.model.add_filter_output import AddFilterOutput
from insights_engine.model.delete_batch_filter_output import DeleteBatchFilterOutput
from insights_engine.model.delete_filter_batch_input import DeleteFilterBatchInput
from insights_engine.model.delete_filter_input import DeleteFilterInput
from insights_engine.model.delete_filter_output import DeleteFilterOutput
from insights_engine.model.get_filter_output import GetFilterOutput
# Defining the host is optional and defaults to https://bygplz0jqk.execute-api.us-east-2.amazonaws.com/prod
# See configuration.py for a list of all supported configuration parameters.
configuration = insights_engine.Configuration(
    host = "https://bygplz0jqk.execute-api.us-east-2.amazonaws.com/prod"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Authorization
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'


# Enter a context with an instance of the API client
with insights_engine.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = filter_api.FilterApi(api_client)
    app_name = "app_name_example" # str | This is the name of a downstream application. Each unique value of this parameter signifies a partition of the Insight Engine, including the utilized Generators and Users.
user_name = "user_name_example" # str | This is an individual Insights consumer registered with an external app on the Insights Engine.
add_filter_input = AddFilterInput(
        value="value_example",
        filter_type="filter_type_example",
    ) # AddFilterInput | 

    try:
        # add single filters for a user
        api_response = api_instance.add_filter(app_name, user_name, add_filter_input)
        pprint(api_response)
    except insights_engine.ApiException as e:
        print("Exception when calling FilterApi->add_filter: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://bygplz0jqk.execute-api.us-east-2.amazonaws.com/prod*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FilterApi* | [**add_filter**](docs/FilterApi.md#add_filter) | **POST** /filter | add single filters for a user
*FilterApi* | [**add_filter_batch**](docs/FilterApi.md#add_filter_batch) | **POST** /filter_batch | add an array of filters for a user
*FilterApi* | [**delete_filter**](docs/FilterApi.md#delete_filter) | **DELETE** /filter | Delete single filter for a user
*FilterApi* | [**delete_filter_batch**](docs/FilterApi.md#delete_filter_batch) | **DELETE** /filter_batch | Delete array of filters for a user
*FilterApi* | [**get_filter**](docs/FilterApi.md#get_filter) | **GET** /filter | Gets all filters for a user
*GroupsApi* | [**add_members**](docs/GroupsApi.md#add_members) | **POST** /group/{group_name}/member | Add members to group
*GroupsApi* | [**create_group**](docs/GroupsApi.md#create_group) | **POST** /group | Create Admin Group
*GroupsApi* | [**delete_all_admin_groups**](docs/GroupsApi.md#delete_all_admin_groups) | **DELETE** /group | Delete Admin&#39;s Groups
*GroupsApi* | [**delete_group**](docs/GroupsApi.md#delete_group) | **DELETE** /group/{group_name} | Delete a group
*GroupsApi* | [**delete_group_members**](docs/GroupsApi.md#delete_group_members) | **DELETE** /group/{group_name}/member | Delete Group members
*GroupsApi* | [**get_all_admin_groups**](docs/GroupsApi.md#get_all_admin_groups) | **GET** /group | Fetch Admins Groups
*GroupsApi* | [**get_group_admins**](docs/GroupsApi.md#get_group_admins) | **GET** /group/{group_name} | Fetch admins for group name
*GroupsApi* | [**get_group_members**](docs/GroupsApi.md#get_group_members) | **GET** /group/{group_name}/member | Fetch group members
*InsightsApi* | [**get_group_insights**](docs/InsightsApi.md#get_group_insights) | **GET** /get_group_insights | Get unique insights payloads for this group
*InsightsApi* | [**get_real_time_insights**](docs/InsightsApi.md#get_real_time_insights) | **POST** /app/{app_name}/generator/{generator_name} | Generate and return the results of an insight generator immediately
*InsightsApi* | [**get_user_insights**](docs/InsightsApi.md#get_user_insights) | **GET** /get_user_insights | Get insight payloads for this user only
*InsightsApi* | [**run_generators**](docs/InsightsApi.md#run_generators) | **POST** /run | Refresh insights for app
*MetricsApi* | [**get_all_user_metrics**](docs/MetricsApi.md#get_all_user_metrics) | **GET** /metrics | Gets insight metrics for all registered users
*MetricsApi* | [**get_user_metrics**](docs/MetricsApi.md#get_user_metrics) | **GET** /metrics/user_name/{user_name} | Gets insight metrics for a user
*SaveApi* | [**save_insight**](docs/SaveApi.md#save_insight) | **POST** /save | Save Insight Payload
*SaveApi* | [**unsave_insight**](docs/SaveApi.md#unsave_insight) | **DELETE** /save | Unsave Insight Payload
*SubscriptionsApi* | [**add_subscription**](docs/SubscriptionsApi.md#add_subscription) | **POST** /subscription/user | Add a subscription for this user
*SubscriptionsApi* | [**delete_subscription**](docs/SubscriptionsApi.md#delete_subscription) | **DELETE** /subscription/user | deletes a subscription for this user
*SubscriptionsApi* | [**get_app_subscriptions**](docs/SubscriptionsApi.md#get_app_subscriptions) | **GET** /subscription | Get all subscriptions for app
*SubscriptionsApi* | [**get_user_subscriptions**](docs/SubscriptionsApi.md#get_user_subscriptions) | **GET** /subscription/user | Get subscribed windows for this user
*UserApi* | [**add_user**](docs/UserApi.md#add_user) | **POST** /user | Registers a new user to your app
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user | Delete this user from the app
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /user | Gets subscriptions for registered users
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /user | update users permissions


## Documentation For Models

 - [AddFilterBatchInput](docs/AddFilterBatchInput.md)
 - [AddFilterBatchOutput](docs/AddFilterBatchOutput.md)
 - [AddFilterInput](docs/AddFilterInput.md)
 - [AddFilterOutput](docs/AddFilterOutput.md)
 - [AddMembersInput](docs/AddMembersInput.md)
 - [AddMembersOutput](docs/AddMembersOutput.md)
 - [AddSubscriptionInput](docs/AddSubscriptionInput.md)
 - [AddUserInput](docs/AddUserInput.md)
 - [AddUserOutput](docs/AddUserOutput.md)
 - [Context](docs/Context.md)
 - [CreateGroupInput](docs/CreateGroupInput.md)
 - [CreateGroupOutput](docs/CreateGroupOutput.md)
 - [DeleteBatchFilterOutput](docs/DeleteBatchFilterOutput.md)
 - [DeleteFilterBatchInput](docs/DeleteFilterBatchInput.md)
 - [DeleteFilterInput](docs/DeleteFilterInput.md)
 - [DeleteFilterOutput](docs/DeleteFilterOutput.md)
 - [DeleteGroupMembersInput](docs/DeleteGroupMembersInput.md)
 - [DeleteSubscriptionInput](docs/DeleteSubscriptionInput.md)
 - [Filter](docs/Filter.md)
 - [FilterOut](docs/FilterOut.md)
 - [GetAllAdminGroupsOutput](docs/GetAllAdminGroupsOutput.md)
 - [GetFilterOutput](docs/GetFilterOutput.md)
 - [GetGroupAdminsOutput](docs/GetGroupAdminsOutput.md)
 - [GetGroupInsightsOutput](docs/GetGroupInsightsOutput.md)
 - [GetGroupMembersOuput](docs/GetGroupMembersOuput.md)
 - [GetRealTimeInsightsInput](docs/GetRealTimeInsightsInput.md)
 - [GetRealTimeInsightsOutput](docs/GetRealTimeInsightsOutput.md)
 - [GetUserInsightsOutput](docs/GetUserInsightsOutput.md)
 - [GetUserOutput](docs/GetUserOutput.md)
 - [GetUserSubscriptionsOutput](docs/GetUserSubscriptionsOutput.md)
 - [GroupDescription](docs/GroupDescription.md)
 - [InsightPayload](docs/InsightPayload.md)
 - [Permission](docs/Permission.md)
 - [SaveInsightInput](docs/SaveInsightInput.md)
 - [Subscription](docs/Subscription.md)
 - [TeamsPermissionValue](docs/TeamsPermissionValue.md)
 - [UnsaveInsightInput](docs/UnsaveInsightInput.md)
 - [UpdateUserInput](docs/UpdateUserInput.md)
 - [User](docs/User.md)
 - [UserOut](docs/UserOut.md)
 - [Window](docs/Window.md)


## Documentation For Authorization


## Authorization

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

eden.trainor@compassdigital.io


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in insights_engine.apis and insights_engine.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from insights_engine.api.default_api import DefaultApi`
- `from insights_engine.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import insights_engine
from insights_engine.apis import *
from insights_engine.models import *
```

