"""django_multi_apps URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from bokeh.server.django import autoload
from django.apps import apps
from django.contrib import admin
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.urls import path, include

import sliders.pn_app as sliders_app
import gbm.pn_app as gbm_app
import stockscreener.pn_app as stockscreener_app

from .themes import plot_themes

pn_app_config = apps.get_app_config('bokeh.server.django')

urlpatterns = [
    path('', include('landing.urls')),
    path('sliders/', include('sliders.urls')),
    path('gbm/', include('gbm.urls')),
    path('stockscreener/', include('stockscreener.urls')),
    path('admin/', admin.site.urls),
]

bokeh_apps = [
    autoload("sliders", sliders_app.app),
    autoload("gbm", gbm_app.app),
    autoload("stockscreener", stockscreener_app.app),
]

urlpatterns += staticfiles_urlpatterns()

# Set the themes
plot_themes()
