"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const eks = require("@aws-cdk/aws-eks");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor(props = {}) {
        var _a;
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const vpc = (_a = props.vpc) !== null && _a !== void 0 ? _a : getOrCreateVpc(stack);
        const provider = new _1.Provider(stack, 'GitlabProvider', { vpc });
        // create a Amazon EKS cluster
        provider.createFargateEksCluster(stack, 'GitlabEksCluster', {
            clusterOptions: {
                vpc,
                version: eks.KubernetesVersion.V1_19,
            },
        });
        // create a default fargate runner with its job executor
        provider.createFargateRunner();
        // alternatively, create the runner and the executor indivicually.
        // first, create the executor
        const executor = new _1.FargateJobExecutor(stack, 'JobExecutor', {
            image: _1.JobExecutorImage.JSII,
        });
        // second,create the runner with the task definition of the executor
        new _1.FargateRunner(stack, 'FargateRunner', {
            vpc,
            executor,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
process.env.GITLAB_REGISTRATION_TOKEN = 'mock';
process.env.CDK_INTEG_REGION = 'us-east-1';
new IntegTesting();
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1' ?
        ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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