# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['xmind2case']

package_data = \
{'': ['*']}

install_requires = \
['arrow>=0.15.8,<0.16.0', 'flask>=1.1.2,<2.0.0', 'xmind>=1.2.0,<2.0.0']

entry_points = \
{'console_scripts': ['xmind2case = xmind2case.cli:cli_main']}

setup_kwargs = {
    'name': 'xmind2case',
    'version': '1.0.4',
    'description': 'xmind to csv',
    'long_description': '# XMind2TestCase\n\n> **XMind2TestCase** 工具，提供了一个高效测试用例设计的解决方案！\n\n\n### 一、背景\n\n软件测试过程中，最重要、最核心就是测试用例的设计，也是测试童鞋、测试团队日常投入最多时间的工作内容之一。\n\n然而，传统的测试用例设计过程有很多痛点：\n- 1、使用Excel表格进行测试用例设计，虽然成本低，但版本管理麻烦，维护更新耗时，用例评审繁琐，过程报表统计难...\n- 2、使用TestLink、TestCenter、Redmine等传统测试管理工具，虽然测试用例的执行、管理、统计比较方便，但依然存在编写用例效率不高、思路不够发散、在产品快速迭代过程中比较耗时等问题...\n- 3、公司自研测试管理工具，这是个不错的选择，但对于大部分小公司、小团队来说，一方面研发维护成本高，另一方面对技术要有一定要求...\n- 4、...\n\n\n基于这些情况，现在越来越多公司选择使用**思维导图**这种高效的生产力工具进行用例设计，特别是敏捷开发团队。\n\n事实上也证明，思维导图其发散性思维、图形化思维的特点，跟测试用例设计时所需的思维非常吻合，所以在实际工作中极大提升了我们测试用例设计的效率，也非常方便测试用例评审。\n\n但是与此同时，使用思维导图进行测试用例设计的过程中也带来不少问题：\n- 1、测试用例难以量化管理、执行情况难以统计；\n- 2、测试用例执行结果与BUG管理系统难以打通；\n- 3、团队成员用思维导图设计用例的风格各异，沟通成本巨大；\n- 4、...\n\n综合以上情况，我们可以发现不同的测试用例设计方式，各有各个的优劣。\n\n那么问题来了，我们能不能将它们各自优点合在一起呢？这样不就可以提升我们的效率了！\n\n于是，这时候 **XMind2TestCase** 就应运而生了，该工具基于 Python 实现，通过制定**测试用例通用模板**，\n然后使用 **[XMind](https://www.xmind.cn/)** 这款广为流传且开源的思维导图工具进行用例设计。\n其中制定**测试用例通用模板**是一个非常核心的步骤（具体请看[使用指南](https://github.com/zhuifengshen/xmind2testcase/blob/master/webtool/static/guide/index.md)），有了通用的测试用例模板，我们就可以在 XMind 文件上解析并提取出测试用例所需的基本信息，\n然后合成常见**测试用例管理系统**所需的**用例导入文件**。这样就将 **XMind 设计测试用例的便利**与**常见测试用例系统的高效管理**结合起来了！\n\n当前 **XMind2TestCase** 已实现从 XMind 文件到 TestLink 和 Zentao(禅道) 两大常见用例管理系统的测试用例转换，同时也提供 XMind 文件解析后的两种数据接口\n（TestSuites、TestCases两种级别的JSON数据），方便快速与其他测试用例管理系统打通。\n\n\n### 二、使用示例\n\n#### 1、Web工具示例\n\n![webtool](https://raw.githubusercontent.com/zhuifengshen/xmind2testcase/master/webtool/static/guide/webtool.png)\n\n#### 2、转换后用例预览\n\n![testcase_preview](https://raw.githubusercontent.com/zhuifengshen/xmind2testcase/master/webtool/static/guide/xmind_to_testcase_preview.png)\n\n#### 3、TestLink导入结果示例\n\n![testlink](https://raw.githubusercontent.com/zhuifengshen/xmind2testcase/master/webtool/static/guide/testlink.png)\n\n#### 4、禅道（ZenTao）导入结果示例\n\n![zentao](https://raw.githubusercontent.com/zhuifengshen/xmind2testcase/master/webtool/static/guide/zentao_import_result.png)\n\n\n### 三、安装方式\n```\npip3 install xmind2testcase\n```\n\n\n### 四、版本升级\n```\npip3 install -U xmind2testcase\n```\n\n\n### 五、使用方式\n\n#### 1、命令行调用\n```\nUsage:\n xmind2testcase [path_to_xmind_file] [-csv] [-xml] [-json]\n\nExample:\n xmind2testcase /path/to/testcase.xmind        => output testcase.csv、testcase.xml、testcase.json\n xmind2testcase /path/to/testcase.xmind -csv   => output testcase.csv\n xmind2testcase /path/to/testcase.xmind -xml   => output testcase.xml\n xmind2testcase /path/to/testcase.xmind -json  => output testcase.json\n```\n\n#### 2、使用Web界面\n\n![web_tool_cli](https://raw.githubusercontent.com/zhuifengshen/xmind2testcase/master/webtool/static/guide/webtool_cli.png)\n\n```\nUsage:\n xmind2testcase [webtool] [port_num]\n\nExample:\n xmind2testcase webtool        => launch the web testcase convertion tool locally -> 127.0.0.1:5001\n xmind2testcase webtool 8000   => launch the web testcase convertion tool locally -> 127.0.0.1:8000\n```\n\n#### 3、API调用\n```\nimport json\nimport xmind\nfrom xmind2testcase.zentao import xmind_to_zentao_csv_file\nfrom xmind2testcase.testlink import xmind_to_testlink_xml_file\nfrom xmind2testcase.utils import xmind_testcase_to_json_file\nfrom xmind2testcase.utils import xmind_testsuite_to_json_file\nfrom xmind2testcase.utils import get_xmind_testcase_list\nfrom xmind2testcase.utils import get_xmind_testsuite_list\n\n\ndef main():\n    xmind_file = \'docs/xmind_testcase_template.xmind\'\n    print(\'Start to convert XMind file: %s\' % xmind_file)\n\n    zentao_csv_file = xmind_to_zentao_csv_file(xmind_file)\n    print(\'Convert XMind file to zentao csv file successfully: %s\' % zentao_csv_file)\n\n    testlink_xml_file = xmind_to_testlink_xml_file(xmind_file)\n    print(\'Convert XMind file to testlink xml file successfully: %s\' % testlink_xml_file)\n\n    testsuite_json_file = xmind_testsuite_to_json_file(xmind_file)\n    print(\'Convert XMind file to testsuite json file successfully: %s\' % testsuite_json_file)\n\n    testcase_json_file = xmind_testcase_to_json_file(xmind_file)\n    print(\'Convert XMind file to testcase json file successfully: %s\' % testcase_json_file)\n\n    testsuites = get_xmind_testsuite_list(xmind_file)\n    print(\'Convert XMind to testsuits dict data:\\n%s\' % json.dumps(testsuites, indent=2, separators=(\',\', \': \'), ensure_ascii=False))\n\n    testcases = get_xmind_testcase_list(xmind_file)\n    print(\'Convert Xmind to testcases dict data:\\n%s\' % json.dumps(testcases, indent=4, separators=(\',\', \': \')))\n\n    workbook = xmind.load(xmind_file)\n    print(\'Convert XMind to Json data:\\n%s\' % json.dumps(workbook.getData(), indent=2, separators=(\',\', \': \'), ensure_ascii=False))\n\n    print(\'Finished conversion, Congratulations!\')\n\n\nif __name__ == \'__main__\':\n    main()\n```\n\n#### 4、XMind用例文件转为JSON数据\n\n![xmind_testcase_demo](https://raw.githubusercontent.com/zhuifengshen/xmind2testcase/master/webtool/static/guide/xmind_testcase_demo.png)\n\n##### （1）转为TestCase JSON数据\n\n```\nfrom xmind2testcase.utils import get_xmind_testcase_list\nxmind_file = \'docs/xmind_testcase_demo.xmind\'\ntestcases = get_xmind_testcase_list(xmind_file)\nprint(testcases)\n\n\nOutput:\n\n[\n    {                                                # 测试用例\n        "name": "测试用例1",                           # 用例标题\n        "version": 1,                                 # 用例版本\n        "summary": "测试用例1",                        # 用例摘要\n        "preconditions": "前置条件",                   # 前置条件\n        "execution_type": 1,                          # 用例执行类型（1：手动、2：自动）\n        "importance": 1,                              # 优先级（1：高、2：中、3：低）\n        "estimated_exec_duration": 3,                 # 预计执行时间（分钟）\n        "status": 7,                                  # 用例状态（1：草稿、2：待评审、3：评审中、4：重做、5、废弃、6：feature、7：终稿）\n        "steps": [                                    # 测试步骤列表\n            {\n                "step_number": 1,                     # 编号\n                "actions": "测试步骤1",                 # 步骤内容\n                "expectedresults": "预期结果1",         # 预期结果\n                "execution_type": 1                    # 执行类型（1：手动，2：自动）\n            }, \n            {\n                "step_number": 2, \n                "actions": "测试步骤2", \n                "expectedresults": "预期结果2", \n                "execution_type": 1\n            }\n        ], \n        "product": "我是产品名",                          # 产品名称\n        "suite": "我是模块名(测试集1)"                     # 测试集（模块名）\n    }, \n    {\n        "name": "测试用例2", \n        "version": 1, \n        "summary": "测试用例2", \n        "preconditions": "前置条件", \n        "execution_type": 1, \n        "importance": 1, \n        "estimated_exec_duration": 3, \n        "status": 7, \n        "steps": [\n            {\n                "step_number": 1, \n                "actions": "测试步骤1", \n                "expectedresults": "预期结果1", \n                "execution_type": 1\n            }, \n            {\n                "step_number": 2, \n                "actions": "测试步骤2（预期结果2可以为空）", \n                "expectedresults": "", \n                "execution_type": 1\n            }, \n            {\n                "step_number": 3, \n                "actions": "测试步骤3", \n                "expectedresults": "预期结果3", \n                "execution_type": 1\n            }, \n            {\n                "step_number": 4, \n                "actions": "测试步骤4", \n                "expectedresults": "预期结果4", \n                "execution_type": 1\n            }\n        ], \n        "product": "我是产品名", \n        "suite": "我是模块名(测试集1)"\n    }, \n    {\n        "name": "测试用例3（测试步骤和预期结果可以都为空）", \n        "version": 1, \n        "summary": "测试用例3（测试步骤和预期结果可以都为空）", \n        "preconditions": "无", \n        "execution_type": 1, \n        "importance": 2, \n        "estimated_exec_duration": 3, \n        "status": 7, \n        "steps": [ ], \n        "product": "我是产品名", \n        "suite": "我是模块名(测试集1)"\n    }, \n    {\n        "name": "测试步骤2（优先级默认为中）", \n        "version": 1, \n        "summary": "测试步骤2（优先级默认为中）", \n        "preconditions": "无", \n        "execution_type": 1, \n        "importance": 3, \n        "estimated_exec_duration": 3, \n        "status": 7, \n        "steps": [\n            {\n                "step_number": 1, \n                "actions": "测试步骤1", \n                "expectedresults": "预期结果1", \n                "execution_type": 1\n            }, \n            {\n                "step_number": 2, \n                "actions": "测试步骤3", \n                "expectedresults": "", \n                "execution_type": 1\n            }\n        ], \n        "product": "我是产品名", \n        "suite": "我是模块名(测试集2)"\n    }, \n    {\n        "name": "测试用例3（前置条件默认为空） 无设置优先级，这里加入用例标题", \n        "version": 1, \n        "summary": "测试用例3（前置条件默认为空） 无设置优先级，这里加入用例标题", \n        "preconditions": "无", \n        "execution_type": 1, \n        "importance": 2, \n        "estimated_exec_duration": 3, \n        "status": 7, \n        "steps": [ ], \n        "product": "我是产品名", \n        "suite": "我是模块名(测试集2)"\n    }\n]\n```\n\n测试用例数据增加执行结果字段：result，示例如下：\n\n![测试用例数据](webtool/static/guide/testcase_json_demo.png)\n\n详情查看[使用指南](webtool/static/guide/index.md)，参考示例：[testcase json](docs/xmind_to_testcase_json.json)\n\n\n##### （2）转为TestSuite JSON数据\n\n```\nfrom xmind2testcase.utils import get_xmind_testsuite_list\nxmind_file = \'docs/xmind_testcase_demo.xmind\'\ntestsuites = get_xmind_testsuite_list(xmind_file)\nprint(testsuites)\n\n\nOutput:\n\n[\n  {                                                 # XMind画布（Sheet)列表\n    "name": "我是产品名",                             # 产品名称\n    "details": null,                                 # 产品摘要\n    "testcase_list": [],                             # 用例列表\n    "sub_suites": [                                  # 用例集列表\n      {\n        "name": "我是模块名(测试集1)",                  # 用例集1名称（模块名）\n        "details": null,                             # 用例集摘要\n        "testcase_list": [                           # 用例列表\n          {                                          # 具体用例\n            "name": "测试用例1",\n            "version": 1,\n            "summary": "测试用例1",\n            "preconditions": "前置条件",\n            "execution_type": 1,\n            "importance": 1,\n            "estimated_exec_duration": 3,\n            "status": 7,\n            "steps": [\n              {\n                "step_number": 1,\n                "actions": "测试步骤1",\n                "expectedresults": "预期结果1",\n                "execution_type": 1\n              },\n              {\n                "step_number": 2,\n                "actions": "测试步骤2",\n                "expectedresults": "预期结果2",\n                "execution_type": 1\n              }\n            ]\n          },\n          {\n            "name": "测试用例2",\n            "version": 1,\n            "summary": "测试用例2",\n            "preconditions": "前置条件",\n            "execution_type": 1,\n            "importance": 1,\n            "estimated_exec_duration": 3,\n            "status": 7,\n            "steps": [\n              {\n                "step_number": 1,\n                "actions": "测试步骤1",\n                "expectedresults": "预期结果1",\n                "execution_type": 1\n              },\n              {\n                "step_number": 2,\n                "actions": "测试步骤2（预期结果2可以为空）",\n                "expectedresults": "",\n                "execution_type": 1\n              },\n              {\n                "step_number": 3,\n                "actions": "测试步骤3",\n                "expectedresults": "预期结果3",\n                "execution_type": 1\n              },\n              {\n                "step_number": 4,\n                "actions": "测试步骤4",\n                "expectedresults": "预期结果4",\n                "execution_type": 1\n              }\n            ]\n          },\n          {\n            "name": "测试用例3（测试步骤和预期结果可以都为空）",\n            "version": 1,\n            "summary": "测试用例3（测试步骤和预期结果可以都为空）",\n            "preconditions": "无",\n            "execution_type": 1,\n            "importance": 2,\n            "estimated_exec_duration": 3,\n            "status": 7,\n            "steps": []\n          }\n        ],\n        "sub_suites": []                            # 用例集中可以包含子用例集（目前只要产品类别下有用例集）\n      },\n      {\n        "name": "我是模块名(测试集2)",                  # 用例集2名称（模块名）\n        "details": "测试集摘要（详情）",\n        "testcase_list": [\n          {\n            "name": "测试步骤2（优先级默认为中）",\n            "version": 1,\n            "summary": "测试步骤2（优先级默认为中）",\n            "preconditions": "无",\n            "execution_type": 1,\n            "importance": 3,\n            "estimated_exec_duration": 3,\n            "status": 7,\n            "steps": [\n              {\n                "step_number": 1,\n                "actions": "测试步骤1",\n                "expectedresults": "预期结果1",\n                "execution_type": 1\n              },\n              {\n                "step_number": 2,\n                "actions": "测试步骤3",\n                "expectedresults": "",\n                "execution_type": 1\n              }\n            ]\n          },\n          {\n            "name": "测试用例3（前置条件默认为空） 无设置优先级，这里加入用例标题",\n            "version": 1,\n            "summary": "测试用例3（前置条件默认为空） 无设置优先级，这里加入用例标题",\n            "preconditions": "无",\n            "execution_type": 1,\n            "importance": 2,\n            "estimated_exec_duration": 3,\n            "status": 7,\n            "steps": []\n          }\n        ],\n        "sub_suites": []\n      }\n    ]\n  }\n]\n```\n\nTestSuite增加执行结果统计字段：statistics，示例如下：\n\n![测试用例数据](webtool/static/guide/testsuite_json_demo.png)\n\n参考示例：[testsuite json](docs/xmind_to_testsuite_json.json)\n\n\n##### （3）XMind文件转换为JSON数据\n\n以上（1）TestCase数据、（2）TestSuite数据的获取，其实是基于**[XMind](https://github.com/zhuifengshen/xmind)**这个工具，对XMind文件进行解析和数据提取，然后转换而来。\n这个工具是在设计XMind2TestCase时，针对XMind单独抽取出来的库，提供了XMind思维导图创建、解析、更新的一系列方法。使用它可以直接将XMind文件转换为JSON数据：\n\n```\nimport xmind\nxmind_file = \'docs/xmind_testcase_demo.xmind\'\nworkbook = xmind.load(xmind_file)\ndata = workbook.getData()\nprint(data)\n\n\nOutput:\n\n[\n  {                                                    # XMind画布(sheet)列表\n    "id": "7hmnj6ahp0lonp4k2hodfok24f",                # 画布ID\n    "title": "画布 1",                                  # 画布名称\n    "topic": {                                         # 中心主题\n      "id": "7c8av5gt8qfbac641lth4g1p67",              # 主题ID\n      "link": null,                                    # 主题上的超链接信息\n      "title": "我是产品名",                             # 主题名称\n      "note": null,                                    # 主题上的备注信息\n      "label": null,                                   # 主题上标签信息\n      "comment": null,                                 # 主题上的批注（评论）信息\n      "markers": [],                                   # 主题上的图标信息\n      "topics": [                                      # 子主题列表\n        {\n          "id": "2rj4ek3nn4sk0lc4pje3gvgv9k",\n          "link": null,\n          "title": "我是模块名(测试集1)",                  # 子主题1\n          "note": null,\n          "label": null,\n          "comment": null,\n          "markers": [],\n          "topics": [                                    # 子主题下的子主题列表\n            {\n              "id": "3hjj43s7rv66uncr1srl3qsboi",\n              "link": null,\n              "title": "测试用例1",\n              "note": "前置条件\\n",\n              "label": "手动（执行方式默认为手动）",\n              "comment": null,\n              "markers": [\n                "priority-1"\n              ],\n              "topics": [\n                {\n                  "id": "3djn37j1fdc6081de319slf035",\n                  "link": null,\n                  "title": "测试步骤1",\n                  "note": null,\n                  "label": null,\n                  "comment": null,\n                  "markers": [],\n                  "topics": [\n                    {\n                      "id": "7v0f1152popou38ndaaamt49l5",\n                      "link": null,\n                      "title": "预期结果1",\n                      "note": null,\n                      "label": null,\n                      "comment": null,\n                      "markers": []\n                    }\n                  ]\n                },\n                {\n                  "id": "2srtqqjp818clkk1drm233lank",\n                  "link": null,\n                  "title": "测试步骤2",\n                  "note": null,\n                  "label": null,\n                  "comment": null,\n                  "markers": [],\n                  "topics": [\n                    {\n                      "id": "4jlbo280urmid3qkd01j7h8jnq",\n                      "link": null,\n                      "title": "预期结果2",\n                      "note": null,\n                      "label": null,\n                      "comment": null,\n                      "markers": []\n                    }\n                  ]\n                }\n              ]\n            },\n            ...\n          ]\n        },\n        ...\n      ]\n    }\n  }\n]\n```\n具体参考：[xmind_testcase_demo.json](https://github.com/zhuifengshen/xmind2testcase/blob/master/docs/xmind_testcase_demo.json)\n\n\n### 四、自动化发布：一键打 Tag 并上传至 PYPI \n\n每次在 __ about __.py 更新版本号后，运行以下命令，实现自动化更新打包上传至 [PYPI](https://pypi.org/) ，同时根据其版本号自动打 Tag 并推送到仓库：\n\n```\npython3 setup.py pypi\n```\n\n![upload_pypi](https://raw.githubusercontent.com/zhuifengshen/xmind2testcase/master/webtool/static/guide/pypi_upload.png)\n\n\n### 五、CHANGELOG\n\n```\nv1.0.0\n1、XMind用例模板定义和解析；\n2、XMind用例转换为TestLink用例文件；\n\nv1.1.0\n1、XMind用例文件转换为禅道用例文件；\n2、添加一键上传PYPI功能；\n\nv1.2.0\n1、添加Web工具进行用例转换；\n2、添加用户使用指南；\n\nv1.3.0\n1、XMind中支持标识测试用例执行结果；\n2、TestCase、TestSuite中添加用例执行结果统计数据；\n3、完善用户使用指南；\n\nv1.5.0\n1、支持通过标签设置用例类型（自动 or 手动）；\n2、支持导出文件中文显示；\n3、增加命令运行指引；\n4、修复服务器远程部署无法访问问题；\n5、取消测试用例关键字默认设置；\n\n备注：XMind2Testcase针对XMind经典系列版本，暂不支持XMind Zen版本！\n```\n\n\n### 六、致谢\n**XMind2TestCase** 工具的产生，受益于以下四个开源项目，并在此基础上扩展、优化，受益匪浅，感恩！\n\n- 1、**[XMind](https://github.com/zhuifengshen/xmind)**：XMind思维导图创建、解析、更新的一站式解决方案(Python实现)！  \n- 2、**[xmind2testlink](https://github.com/tobyqin/xmind2testlink)**：践行了XMind通用测试用例模板设计思路，同时提供了Web转换工具！\n- 3、**[TestLink](http://www.testlink.org/)**：提供了完整的测试用例管理流程和文档；\n- 4、**[禅道开源版(ZenTao)](https://www.zentao.net/)**：提供了完整的项目管理流程、文档和用户交流释疑群；\n\n得益于开源，也将坚持开源，并为努力开源贡献自己的点滴之力。后续，将继续根据实际项目需要，定期进行更新维护，\n欢迎大伙的[使用](https://github.com/zhuifengshen/xmind2testcase/blob/master/webtool/static/guide/index.md)和[意见反馈](https://github.com/zhuifengshen/xmind2testcase/issues/new)，谢谢！\n\n（如果本项目对你有帮助的话，也欢迎 _**[star](https://github.com/zhuifengshen/xmind2testcase)**_ ）\n\n![QA之禅](http://upload-images.jianshu.io/upload_images/139581-27c6030ba720846f.jpg?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)\n\n\n### LICENSE\n```\nMIT License\n\nCopyright (c) 2019 Devin https://zhangchuzhao.site\nCopyright (c) 2017 Toby Qin\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n```',
    'author': 'xuanke',
    'author_email': 'zhouliwei1989@126.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.0,<4.0',
}


setup(**setup_kwargs)
