# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-03-13 11:21
from __future__ import unicode_literals

from django.db import migrations


def set_null_to_blank(queryset, fields):
    for element in queryset:
        for field in fields:
            value = getattr(element, field)
            if value is None:
                setattr(element, field, '')
        element.save()


def run_data_migration(apps, schema_editor):
    Condition = apps.get_model('conditions', 'Condition')

    set_null_to_blank(Condition.objects.all(), [
        'uri',
        'uri_prefix',
        'key',
        'comment',
        'target_text',
    ])


class Migration(migrations.Migration):

    dependencies = [
        ('conditions', '0016_meta'),
    ]

    operations = [
        migrations.RunPython(run_data_migration),
    ]
