# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-03-13 11:21
from __future__ import unicode_literals

from django.db import migrations


def set_null_to_blank(queryset, fields):
    for element in queryset:
        for field in fields:
            value = getattr(element, field)
            if value is None:
                setattr(element, field, '')
        element.save()


def run_data_migration(apps, schema_editor):
    AdditionalField = apps.get_model('accounts', 'AdditionalField')

    set_null_to_blank(AdditionalField.objects.all(), [
        'text_lang1',
        'text_lang2',
        'text_lang3',
        'text_lang4',
        'text_lang5',
        'help_lang1',
        'help_lang2',
        'help_lang3',
        'help_lang4',
        'help_lang5',
    ])


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0014_add_language_fields'),
    ]

    operations = [
        migrations.RunPython(run_data_migration),
    ]
