# Generated by Django 2.2.5 on 2019-09-12 04:44

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='SanctionListObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='RegulationSummary',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('regulation_type', models.CharField(blank=True, default='', max_length=32, verbose_name='regulation type')),
                ('number_title', models.CharField(blank=True, default='', max_length=256, verbose_name='number title')),
                ('publication_date', models.DateField(blank=True, default=None, null=True, verbose_name='publication date')),
                ('publication_url', models.URLField(blank=True, default='', verbose_name='url')),
            ],
            options={
                'verbose_name': 'regulation summary',
                'verbose_name_plural': 'regulation summaries',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='SanctionsListFile',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('created', models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('imported', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True, verbose_name='imported')),
                ('generation_date', models.DateField(blank=True, db_index=True, default=None, editable=False, null=True, verbose_name='generation date')),
                ('file', models.FileField(upload_to='uploads', verbose_name='file')),
            ],
            options={
                'verbose_name': 'sanction list',
                'verbose_name_plural': 'sanction lists',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='SubjectType',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('code', models.CharField(blank=True, default='', max_length=256, verbose_name='code')),
                ('classification_code', models.CharField(blank=True, default='', max_length=32, verbose_name='classification code')),
            ],
            options={
                'verbose_name': 'subject type',
                'verbose_name_plural': 'subject types',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='Remark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField(blank=True, verbose_name='text')),
                ('container', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.SanctionListObject')),
            ],
            options={
                'verbose_name': 'remark',
                'verbose_name_plural': 'remarks',
            },
        ),
        migrations.CreateModel(
            name='EuCombinedSanctionsList',
            fields=[
                ('sanctionslistfile_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionsListFile')),
                ('global_file_id', models.CharField(blank=True, default='', max_length=256, verbose_name='global file id')),
            ],
            options={
                'verbose_name': 'EU combined sanction list',
                'verbose_name_plural': 'EU combined sanction lists',
            },
            bases=('jsanctions.sanctionslistfile',),
        ),
        migrations.CreateModel(
            name='SanctionEntity',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('designation_details', models.CharField(blank=True, default='', max_length=256, verbose_name='designation details')),
                ('united_nation_id', models.CharField(blank=True, default='', max_length=256, verbose_name='United Nation identifier')),
                ('eu_reference_number', models.CharField(blank=True, default='', max_length=256, verbose_name='EU reference number')),
                ('logical_id', models.BigIntegerField(blank=True, default=None, null=True, verbose_name='logical id')),
                ('subject_type', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='jsanctions.SubjectType', verbose_name='subject type')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.EuCombinedSanctionsList', verbose_name='source')),
            ],
            options={
                'verbose_name': 'sanction entity',
                'verbose_name_plural': 'sanction entities',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='Regulation',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('regulation_type', models.CharField(blank=True, default='', max_length=256, verbose_name='regulation type')),
                ('organisation_type', models.CharField(blank=True, default='', max_length=256, verbose_name='organization type')),
                ('publication_date', models.DateField(blank=True, default=None, null=True, verbose_name='publication date')),
                ('publication_url', models.URLField(blank=True, default='', verbose_name='url')),
                ('entry_into_force_date', models.DateField(blank=True, default=None, null=True, verbose_name='entry into force date')),
                ('number_title', models.CharField(blank=True, default='', max_length=256, verbose_name='number title')),
                ('programme', models.CharField(blank=True, default='', max_length=256, verbose_name='programmer')),
                ('logical_id', models.BigIntegerField(blank=True, default=None, null=True, verbose_name='logical id')),
                ('sanction', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.SanctionEntity', verbose_name='sanction entity')),
            ],
            options={
                'verbose_name': 'regulation',
                'verbose_name_plural': 'regulations',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='NameAlias',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('first_name', models.CharField(blank=True, default='', max_length=256, verbose_name='first name')),
                ('middle_name', models.CharField(blank=True, default='', max_length=256, verbose_name='middle name')),
                ('last_name', models.CharField(blank=True, default='', max_length=256, verbose_name='last name')),
                ('whole_name', models.CharField(blank=True, default='', max_length=256, verbose_name='whole name')),
                ('name_language', models.CharField(blank=True, default='', max_length=5, verbose_name='name language')),
                ('function', models.CharField(blank=True, default='', max_length=256, verbose_name='function')),
                ('title', models.CharField(blank=True, default='', max_length=256, verbose_name='title')),
                ('regulation_language', models.CharField(blank=True, default='', max_length=5, verbose_name='regulation language')),
                ('logical_id', models.BigIntegerField(blank=True, default=None, null=True, verbose_name='logical id')),
                ('regulation_summary', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='jsanctions.RegulationSummary', verbose_name='regulation summary')),
                ('sanction', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.SanctionEntity', verbose_name='sanction entity')),
            ],
            options={
                'verbose_name': 'name alias',
                'verbose_name_plural': 'name aliases',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='Identification',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('diplomatic', models.BooleanField(blank=True, default=None, null=True, verbose_name='diplomatic')),
                ('known_expired', models.BooleanField(blank=True, default=None, null=True, verbose_name='known expired')),
                ('known_false', models.BooleanField(blank=True, default=None, null=True, verbose_name='known false')),
                ('reported_lost', models.BooleanField(blank=True, default=None, null=True, verbose_name='reported lost')),
                ('revoked_by_issuer', models.BooleanField(blank=True, default=None, null=True, verbose_name='revoked by issuer')),
                ('issued_by', models.CharField(blank=True, default='', max_length=256, verbose_name='issued by')),
                ('latin_number', models.CharField(blank=True, default='', max_length=256, verbose_name='latin number')),
                ('name_on_document', models.CharField(blank=True, default='', max_length=256, verbose_name='name on document')),
                ('number', models.CharField(blank=True, default='', max_length=256, verbose_name='number')),
                ('region', models.CharField(blank=True, default='', max_length=256, verbose_name='region')),
                ('country_iso2_code', models.CharField(blank=True, default='', max_length=3, verbose_name='issued by')),
                ('country_description', models.CharField(blank=True, default='', max_length=256, verbose_name='country description')),
                ('identification_type_code', models.CharField(blank=True, default='', max_length=32, verbose_name='identification type code')),
                ('identification_type_description', models.CharField(blank=True, default='', max_length=256, verbose_name='identification type code')),
                ('regulation_language', models.CharField(blank=True, default='', max_length=5, verbose_name='regional language')),
                ('logical_id', models.BigIntegerField(blank=True, default=None, null=True, verbose_name='logical id')),
                ('regulation_summary', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='jsanctions.RegulationSummary', verbose_name='regulation summary')),
                ('sanction', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.SanctionEntity', verbose_name='sanction entity')),
            ],
            options={
                'verbose_name': 'identification',
                'verbose_name_plural': 'identifications',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='Citizenship',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('region', models.CharField(blank=True, default='', max_length=256, verbose_name='region')),
                ('country_iso2_code', models.CharField(blank=True, default='', max_length=3, verbose_name='country')),
                ('country_description', models.CharField(blank=True, default='', max_length=256, verbose_name='country description')),
                ('regulation_language', models.CharField(blank=True, default='', max_length=5, verbose_name='regional language')),
                ('logical_id', models.BigIntegerField(blank=True, default=None, null=True, verbose_name='logical id')),
                ('regulation_summary', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='jsanctions.RegulationSummary', verbose_name='regulation summary')),
                ('sanction', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.SanctionEntity', verbose_name='sanction entity')),
            ],
            options={
                'verbose_name': 'citizenship',
                'verbose_name_plural': 'citizenships',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='BirthDate',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('circa', models.BooleanField(blank=True, default=None, null=True, verbose_name='circa')),
                ('calendar_type', models.CharField(blank=True, default='', max_length=32, verbose_name='calendar type')),
                ('city', models.CharField(blank=True, default='', max_length=256, verbose_name='city')),
                ('zip_code', models.CharField(blank=True, default='', max_length=256, verbose_name='zip code')),
                ('birth_date', models.DateField(blank=True, default=None, null=True, verbose_name='birth date')),
                ('day_of_month', models.IntegerField(blank=True, default=None, null=True, verbose_name='day of month')),
                ('month_of_year', models.IntegerField(blank=True, default=None, null=True, verbose_name='month of year')),
                ('year', models.IntegerField(blank=True, default=None, null=True, verbose_name='year')),
                ('region', models.CharField(blank=True, default='', max_length=256, verbose_name='region')),
                ('place', models.CharField(blank=True, default='', max_length=256, verbose_name='place')),
                ('country_iso2_code', models.CharField(blank=True, default='', max_length=3, verbose_name='country')),
                ('country_description', models.CharField(blank=True, default='', max_length=256, verbose_name='country description')),
                ('regulation_language', models.CharField(blank=True, default='', max_length=5, verbose_name='regional language')),
                ('logical_id', models.BigIntegerField(blank=True, default=None, null=True, verbose_name='logical id')),
                ('sanction', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.SanctionEntity', verbose_name='sanction entity')),
            ],
            options={
                'verbose_name': 'birth date',
                'verbose_name_plural': 'birth dates',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
        migrations.CreateModel(
            name='Address',
            fields=[
                ('sanctionlistobject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='jsanctions.SanctionListObject')),
                ('city', models.CharField(blank=True, default='', max_length=256, verbose_name='city')),
                ('street', models.CharField(blank=True, default='', max_length=256, verbose_name='street')),
                ('po_box', models.CharField(blank=True, default='', max_length=256, verbose_name='p.o. box')),
                ('zip_code', models.CharField(blank=True, default='', max_length=256, verbose_name='zip code')),
                ('as_at_listing_time', models.BooleanField(blank=True, default=None, null=True, verbose_name='as at listing time')),
                ('place', models.CharField(blank=True, default='', max_length=256, verbose_name='place')),
                ('region', models.CharField(blank=True, default='', max_length=256, verbose_name='region')),
                ('country_iso2_code', models.CharField(blank=True, default='', max_length=3, verbose_name='country')),
                ('country_description', models.CharField(blank=True, default='', max_length=256, verbose_name='country description')),
                ('regulation_language', models.CharField(blank=True, default='', max_length=5, verbose_name='regional language')),
                ('logical_id', models.BigIntegerField(blank=True, default=None, null=True, verbose_name='logical id')),
                ('regulation_summary', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='jsanctions.RegulationSummary', verbose_name='regulation summary')),
                ('sanction', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jsanctions.SanctionEntity', verbose_name='sanction entity')),
            ],
            options={
                'verbose_name': 'address',
                'verbose_name_plural': 'addresses',
            },
            bases=('jsanctions.sanctionlistobject',),
        ),
    ]
