REPOSITORY_LOCATIONS_SPEC = dict(
    com_github_fmtlib_fmt = dict(
        project_name = "fmt",
        project_desc = "{fmt} is an open-source formatting library providing a fast and safe alternative to C stdio and C++ iostreams",
        project_url = "https://fmt.dev",
        version = "8.1.1",
        sha256 = "23778bad8edba12d76e4075da06db591f3b0e3c6c04928ced4a7282ca3400e5d",
        strip_prefix = "fmt-{version}",
        urls = ["https://github.com/fmtlib/fmt/releases/download/{version}/fmt-{version}.zip"],
        use_category = ["dataplane_core", "controlplane"],
        release_date = "2022-01-06",
        cpe = "cpe:2.3:a:fmt:fmt:*",
    ),
    com_github_gabime_spdlog = dict(
        project_name = "spdlog",
        project_desc = "Very fast, header-only/compiled, C++ logging library",
        project_url = "https://github.com/gabime/spdlog",
        version = "1.9.2",
        sha256 = "6fff9215f5cb81760be4cc16d033526d1080427d236e86d70bb02994f85e3d38",
        strip_prefix = "spdlog-{version}",
        urls = ["https://github.com/gabime/spdlog/archive/v{version}.tar.gz"],
        use_category = ["dataplane_core", "controlplane"],
        release_date = "2021-08-12",
        cpe = "N/A",
    ),
    org_python_ftp = dict(
        project_name = "python",
        project_desc = "Python programming language runtime",
        project_url = "https://python.org/",
        version = "3.10.7",
        sha256 = "1b2e4e2df697c52d36731666979e648beeda5941d0f95740aafbf4163e5cc126",
        strip_prefix = "Python-{version}",
        urls = ["https://www.python.org/ftp/python/3.10.7/Python-{version}.tgz"],
        use_category = ["dataplane_core", "controlplane"],
        release_date = "2022-09-06",
        cpe = "N/A",
    ),
    com_github_pybind_pybind11 = dict(
        project_name = "pybind11",
        project_desc = "A lightweight header-only library that exposes C++ types in Python",
        project_url = "https://github.com/pybind/pybind11",
        version = "2.10.0",
        sha256 = "225df6e6dea7cea7c5754d4ed954e9ca7c43947b849b3795f87cb56437f1bd19",
        strip_prefix = "pybind11-{version}",
        urls = ["https://github.com/pybind/pybind11/archive/refs/tags/v{version}.zip"],
        use_category = ["dataplane_core", "controlplane"],
        release_date = "2022-07-16",
        cpe = "N/A",
    ),
    com_github_khronosgroup_opencl_windows = dict(
        project_name = "OpenCL Windows SDK",
        project_desc = "This repository contains the OpenCL SDK for Windows",
        project_url = "https://github.com/KhronosGroup/OpenCL-SDK",
        version = "2023.02.06",
        sha256 = "c76b01b2b73e594b91bf12f3c7d7f63707c317d41cbe5573f2cd323e0edd8cb4",
        strip_prefix = "OpenCL-SDK-v{version}-Win-x64",
        urls = ["https://github.com/KhronosGroup/OpenCL-SDK/releases/download/v{version}/OpenCL-SDK-v{version}-Win-x64.zip"],
        use_category = ["dataplane_core", "controlplane"],
        release_date = "2023-02-06",
        cpe = "N/A",
    ),
)
