"""
    Precisely APIs

    Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.  # noqa: E501

    The version of the OpenAPI document: 12.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from com.precisely.apis.api_client import ApiClient, Endpoint as _Endpoint
from com.precisely.apis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from com.precisely.apis.model.basic_boundary import BasicBoundary
from com.precisely.apis.model.error_info import ErrorInfo
from com.precisely.apis.model.poi_boundary_address_request import POIBoundaryAddressRequest
from com.precisely.apis.model.poi_boundary_location_request import POIBoundaryLocationRequest
from com.precisely.apis.model.poi_boundary_response import POIBoundaryResponse
from com.precisely.apis.model.poi_boundary import PoiBoundary
from com.precisely.apis.model.travel_boundaries import TravelBoundaries


class ZonesServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_basic_boundary_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (BasicBoundary,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/basicboundary/byaddress',
                'operation_id': 'get_basic_boundary_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'country',
                    'distance',
                    'distance_unit',
                    'resolution',
                    'response_srs',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'country':
                        (str,),
                    'distance':
                        (str,),
                    'distance_unit':
                        (str,),
                    'resolution':
                        (str,),
                    'response_srs':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'country': 'country',
                    'distance': 'distance',
                    'distance_unit': 'distanceUnit',
                    'resolution': 'resolution',
                    'response_srs': 'responseSrs',
                },
                'location_map': {
                    'address': 'query',
                    'country': 'query',
                    'distance': 'query',
                    'distance_unit': 'query',
                    'resolution': 'query',
                    'response_srs': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_basic_boundary_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (BasicBoundary,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/basicboundary/bylocation',
                'operation_id': 'get_basic_boundary_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'latitude',
                    'longitude',
                    'distance',
                    'distance_unit',
                    'resolution',
                    'response_srs',
                    'srs_name',
                ],
                'required': [
                    'latitude',
                    'longitude',
                    'distance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'latitude':
                        (str,),
                    'longitude':
                        (str,),
                    'distance':
                        (str,),
                    'distance_unit':
                        (str,),
                    'resolution':
                        (str,),
                    'response_srs':
                        (str,),
                    'srs_name':
                        (str,),
                },
                'attribute_map': {
                    'latitude': 'latitude',
                    'longitude': 'longitude',
                    'distance': 'distance',
                    'distance_unit': 'distanceUnit',
                    'resolution': 'resolution',
                    'response_srs': 'responseSrs',
                    'srs_name': 'srsName',
                },
                'location_map': {
                    'latitude': 'query',
                    'longitude': 'query',
                    'distance': 'query',
                    'distance_unit': 'query',
                    'resolution': 'query',
                    'response_srs': 'query',
                    'srs_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_poi_boundary_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (PoiBoundary,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/poiboundary/byaddress',
                'operation_id': 'get_poi_boundary_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'category_code',
                    'sic_code',
                    'naics_code',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'category_code':
                        (str,),
                    'sic_code':
                        (str,),
                    'naics_code':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'category_code': 'categoryCode',
                    'sic_code': 'sicCode',
                    'naics_code': 'naicsCode',
                },
                'location_map': {
                    'address': 'query',
                    'category_code': 'query',
                    'sic_code': 'query',
                    'naics_code': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_poi_boundary_by_address_batch_endpoint = _Endpoint(
            settings={
                'response_type': (POIBoundaryResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/poiboundary/byaddress',
                'operation_id': 'get_poi_boundary_by_address_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'poi_boundary_address_request',
                ],
                'required': [
                    'poi_boundary_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'poi_boundary_address_request':
                        (POIBoundaryAddressRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'poi_boundary_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_poi_boundary_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (PoiBoundary,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/poiboundary/bylocation',
                'operation_id': 'get_poi_boundary_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'latitude',
                    'longitude',
                    'category_code',
                    'sic_code',
                    'naics_code',
                ],
                'required': [
                    'latitude',
                    'longitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'latitude':
                        (str,),
                    'longitude':
                        (str,),
                    'category_code':
                        (str,),
                    'sic_code':
                        (str,),
                    'naics_code':
                        (str,),
                },
                'attribute_map': {
                    'latitude': 'latitude',
                    'longitude': 'longitude',
                    'category_code': 'categoryCode',
                    'sic_code': 'sicCode',
                    'naics_code': 'naicsCode',
                },
                'location_map': {
                    'latitude': 'query',
                    'longitude': 'query',
                    'category_code': 'query',
                    'sic_code': 'query',
                    'naics_code': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_poi_boundary_by_location_batch_endpoint = _Endpoint(
            settings={
                'response_type': (POIBoundaryResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/poiboundary/bylocation',
                'operation_id': 'get_poi_boundary_by_location_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'poi_boundary_location_request',
                ],
                'required': [
                    'poi_boundary_location_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'poi_boundary_location_request':
                        (POIBoundaryLocationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'poi_boundary_location_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_travel_boundary_by_distance_endpoint = _Endpoint(
            settings={
                'response_type': (TravelBoundaries,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/travelboundary/bydistance',
                'operation_id': 'get_travel_boundary_by_distance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'point',
                    'address',
                    'costs',
                    'cost_unit',
                    'db',
                    'country',
                    'max_offroad_distance',
                    'max_offroad_distance_unit',
                    'destination_srs',
                    'major_roads',
                    'return_holes',
                    'return_islands',
                    'simplification_factor',
                    'banding_style',
                    'historic_traffic_time_bucket',
                    'default_ambient_speed',
                    'ambient_speed_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'point':
                        (str,),
                    'address':
                        (str,),
                    'costs':
                        (str,),
                    'cost_unit':
                        (str,),
                    'db':
                        (str,),
                    'country':
                        (str,),
                    'max_offroad_distance':
                        (str,),
                    'max_offroad_distance_unit':
                        (str,),
                    'destination_srs':
                        (str,),
                    'major_roads':
                        (str,),
                    'return_holes':
                        (str,),
                    'return_islands':
                        (str,),
                    'simplification_factor':
                        (str,),
                    'banding_style':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                    'default_ambient_speed':
                        (str,),
                    'ambient_speed_unit':
                        (str,),
                },
                'attribute_map': {
                    'point': 'point',
                    'address': 'address',
                    'costs': 'costs',
                    'cost_unit': 'costUnit',
                    'db': 'db',
                    'country': 'country',
                    'max_offroad_distance': 'maxOffroadDistance',
                    'max_offroad_distance_unit': 'maxOffroadDistanceUnit',
                    'destination_srs': 'destinationSrs',
                    'major_roads': 'majorRoads',
                    'return_holes': 'returnHoles',
                    'return_islands': 'returnIslands',
                    'simplification_factor': 'simplificationFactor',
                    'banding_style': 'bandingStyle',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                    'default_ambient_speed': 'defaultAmbientSpeed',
                    'ambient_speed_unit': 'ambientSpeedUnit',
                },
                'location_map': {
                    'point': 'query',
                    'address': 'query',
                    'costs': 'query',
                    'cost_unit': 'query',
                    'db': 'query',
                    'country': 'query',
                    'max_offroad_distance': 'query',
                    'max_offroad_distance_unit': 'query',
                    'destination_srs': 'query',
                    'major_roads': 'query',
                    'return_holes': 'query',
                    'return_islands': 'query',
                    'simplification_factor': 'query',
                    'banding_style': 'query',
                    'historic_traffic_time_bucket': 'query',
                    'default_ambient_speed': 'query',
                    'ambient_speed_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_travel_boundary_by_time_endpoint = _Endpoint(
            settings={
                'response_type': (TravelBoundaries,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/zones/v1/travelboundary/bytime',
                'operation_id': 'get_travel_boundary_by_time',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'point',
                    'address',
                    'costs',
                    'cost_unit',
                    'db',
                    'country',
                    'max_offroad_distance',
                    'max_offroad_distance_unit',
                    'destination_srs',
                    'major_roads',
                    'return_holes',
                    'return_islands',
                    'simplification_factor',
                    'banding_style',
                    'historic_traffic_time_bucket',
                    'default_ambient_speed',
                    'ambient_speed_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'point':
                        (str,),
                    'address':
                        (str,),
                    'costs':
                        (str,),
                    'cost_unit':
                        (str,),
                    'db':
                        (str,),
                    'country':
                        (str,),
                    'max_offroad_distance':
                        (str,),
                    'max_offroad_distance_unit':
                        (str,),
                    'destination_srs':
                        (str,),
                    'major_roads':
                        (str,),
                    'return_holes':
                        (str,),
                    'return_islands':
                        (str,),
                    'simplification_factor':
                        (str,),
                    'banding_style':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                    'default_ambient_speed':
                        (str,),
                    'ambient_speed_unit':
                        (str,),
                },
                'attribute_map': {
                    'point': 'point',
                    'address': 'address',
                    'costs': 'costs',
                    'cost_unit': 'costUnit',
                    'db': 'db',
                    'country': 'country',
                    'max_offroad_distance': 'maxOffroadDistance',
                    'max_offroad_distance_unit': 'maxOffroadDistanceUnit',
                    'destination_srs': 'destinationSrs',
                    'major_roads': 'majorRoads',
                    'return_holes': 'returnHoles',
                    'return_islands': 'returnIslands',
                    'simplification_factor': 'simplificationFactor',
                    'banding_style': 'bandingStyle',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                    'default_ambient_speed': 'defaultAmbientSpeed',
                    'ambient_speed_unit': 'ambientSpeedUnit',
                },
                'location_map': {
                    'point': 'query',
                    'address': 'query',
                    'costs': 'query',
                    'cost_unit': 'query',
                    'db': 'query',
                    'country': 'query',
                    'max_offroad_distance': 'query',
                    'max_offroad_distance_unit': 'query',
                    'destination_srs': 'query',
                    'major_roads': 'query',
                    'return_holes': 'query',
                    'return_islands': 'query',
                    'simplification_factor': 'query',
                    'banding_style': 'query',
                    'historic_traffic_time_bucket': 'query',
                    'default_ambient_speed': 'query',
                    'ambient_speed_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_basic_boundary_by_address(
        self,
        address,
        **kwargs
    ):
        """Gets Basic Boundary by Address.  # noqa: E501

        Gets Basic Boundary by Address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_basic_boundary_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Address around which Basic Boundary is requested

        Keyword Args:
            country (str): Three digit ISO country code. [optional]
            distance (str): [optional]
            distance_unit (str): [optional]
            resolution (str): This is resolution of the buffer. Curves generated in buffer are approximated by line segments and it is measured in segments per circle. The higher the resolution, the smoother the curves of the buffer but more points would be required in the boundary geometry. Number greater than 0 and in multiple of 4. If not in 4, then it is approximated to nearest multiple of 4.. [optional]
            response_srs (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            BasicBoundary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_basic_boundary_by_address_endpoint.call_with_http_info(**kwargs)

    def get_basic_boundary_by_location(
        self,
        latitude,
        longitude,
        distance,
        **kwargs
    ):
        """Gets Basic Boundary by Location.  # noqa: E501

        Gets Basic Boundary by Location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_basic_boundary_by_location(latitude, longitude, distance, async_req=True)
        >>> result = thread.get()

        Args:
            latitude (str): Latitude around which Basic Boundary is requested
            longitude (str): Longitude around which Basic Boundary is requested
            distance (str): This is width of the buffer (in a complete circular buffer, it would be radius of the buffer). This has to be a positive number.

        Keyword Args:
            distance_unit (str): [optional]
            resolution (str): This is resolution of the buffer. Curves generated in buffer are approximated by line segments and it is measured in segments per circle. The higher the resolution, the smoother the curves of the buffer but more points would be required in the boundary geometry. Number greater than 0 and in multiple of 4. If not in 4, then it is approximated to nearest multiple of 4.. [optional]
            response_srs (str): [optional]
            srs_name (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            BasicBoundary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['latitude'] = \
            latitude
        kwargs['longitude'] = \
            longitude
        kwargs['distance'] = \
            distance
        return self.get_basic_boundary_by_location_endpoint.call_with_http_info(**kwargs)

    def get_poi_boundary_by_address(
        self,
        address,
        **kwargs
    ):
        """Gets Point of Interests Boundary by Address.  # noqa: E501

        Gets Point of Interests Boundary by Address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_poi_boundary_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Address around which POI Boundary is requested

        Keyword Args:
            category_code (str): Specific Category/Categories Codes for the desired POIs. Accepts a mix of 4 digit (Top Category), 6 digit (Second-Level Category) and 11 digit (Low-Level Category) Category Codes.. [optional]
            sic_code (str): Specify starting digits or full sic code to filter the response. [optional]
            naics_code (str): Will accept naicsCode to filter POIs in results. Max 10 allowed.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PoiBoundary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_poi_boundary_by_address_endpoint.call_with_http_info(**kwargs)

    def get_poi_boundary_by_address_batch(
        self,
        poi_boundary_address_request,
        **kwargs
    ):
        """Batch method for getting Point of Interests Boundary by Address.  # noqa: E501

        Batch method for getting Point of Interests Boundary by Address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_poi_boundary_by_address_batch(poi_boundary_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            poi_boundary_address_request (POIBoundaryAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            POIBoundaryResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['poi_boundary_address_request'] = \
            poi_boundary_address_request
        return self.get_poi_boundary_by_address_batch_endpoint.call_with_http_info(**kwargs)

    def get_poi_boundary_by_location(
        self,
        latitude,
        longitude,
        **kwargs
    ):
        """Get Point of Interests Boundary by Location.  # noqa: E501

        Get Point of Interests Boundary by Location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_poi_boundary_by_location(latitude, longitude, async_req=True)
        >>> result = thread.get()

        Args:
            latitude (str): Latitude around which POI Boundary is requested
            longitude (str): Longitude around which POI Boundary is requested

        Keyword Args:
            category_code (str): Specific Category/Categories Codes for the desired POIs. Accepts a mix of 4 digit (Top Category), 6 digit (Second-Level Category) and 11 digit (Low-Level Category) Category Codes. [optional]
            sic_code (str): Specify starting digits or full sic code to filter the response. [optional]
            naics_code (str): Will accept naicsCode to filter POIs in results. Max 10 allowed.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PoiBoundary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['latitude'] = \
            latitude
        kwargs['longitude'] = \
            longitude
        return self.get_poi_boundary_by_location_endpoint.call_with_http_info(**kwargs)

    def get_poi_boundary_by_location_batch(
        self,
        poi_boundary_location_request,
        **kwargs
    ):
        """Batch method for getting Point of Interests Boundary by Location.  # noqa: E501

        Batch method for getting Point of Interests Boundary by Location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_poi_boundary_by_location_batch(poi_boundary_location_request, async_req=True)
        >>> result = thread.get()

        Args:
            poi_boundary_location_request (POIBoundaryLocationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            POIBoundaryResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['poi_boundary_location_request'] = \
            poi_boundary_location_request
        return self.get_poi_boundary_by_location_batch_endpoint.call_with_http_info(**kwargs)

    def get_travel_boundary_by_distance(
        self,
        **kwargs
    ):
        """Get TravelBoundary By Distance.  # noqa: E501

        Returns the travel boundary based on travel distance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_travel_boundary_by_distance(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            point (str): Starting point from where the travel boundary is calculated. Point in Lat,Long,coordsys format. [optional]
            address (str): Address around which Basic Boundary is requested.. [optional]
            costs (str): Travel time used to calculate the travel boundary.. [optional]
            cost_unit (str): Travel time unit such as min(Minute), h(Hour), s(Second) or msec(Millisecond).. [optional]
            db (str): Mode of commute.. [optional]
            country (str): 3 character ISO code or country name.. [optional]
            max_offroad_distance (str): Maximum distance to allow travel off the road network.. [optional]
            max_offroad_distance_unit (str): MaxOffroad Distance Unit such as ft(Foot), km(Kilometer), mi(Mile), m(Meter) or yd(Yard).. [optional]
            destination_srs (str): Desired coordinate system of the travel boundary.. [optional]
            major_roads (str): Whether to include all roads in the calculation or just major roads.. [optional] if omitted the server will use the default value of "true"
            return_holes (str): Whether to return holes, which are areas within the larger boundary that cannot be reached within the desired time. [optional]
            return_islands (str): Whether to return islands, which are small areas outside the main boundary that can be reached within the desired time. [optional]
            simplification_factor (str): Number between 0.0 and 1.0 where 0.0 is very simple and 1.0 means the most complex. [optional]
            banding_style (str): Style of banding to be used in the result. [optional]
            historic_traffic_time_bucket (str): Whether routing calculation uses the historic traffic speeds. [optional]
            default_ambient_speed (str): The speed to travel when going off a network road to find the travel boundary (for all road types).. [optional]
            ambient_speed_unit (str): The unit of measure to use to calculate the ambient speed.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TravelBoundaries
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_travel_boundary_by_distance_endpoint.call_with_http_info(**kwargs)

    def get_travel_boundary_by_time(
        self,
        **kwargs
    ):
        """Get TravelBoundary By Time.  # noqa: E501

        Travel boundary based on travel time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_travel_boundary_by_time(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            point (str): Starting point from where the travel boundary is calculated. Point in Lat,Long,coordsys format. [optional]
            address (str): Starting address from where the travel boundary is calculated.. [optional]
            costs (str): Travel time used to calculate the travel boundary.. [optional]
            cost_unit (str): Travel time unit such as min(Minute), h(Hour), s(Second) or msec(Millisecond).. [optional]
            db (str): Mode of commute.. [optional]
            country (str): 3 character ISO code or country name.. [optional]
            max_offroad_distance (str): Maximum distance to allow travel off the road network.. [optional]
            max_offroad_distance_unit (str): MaxOffroad Distance Unit such as ft(Foot), km(Kilometer), mi(Mile), m(Meter) or yd(Yard).. [optional]
            destination_srs (str): Desired coordinate system of the travel boundary.. [optional]
            major_roads (str): Whether to include all roads in the calculation or just major roads.. [optional] if omitted the server will use the default value of "true"
            return_holes (str): Whether to return holes, which are areas within the larger boundary that cannot be reached within the desired time. [optional]
            return_islands (str): Whether to return islands, which are small areas outside the main boundary that can be reached within the desired time. [optional]
            simplification_factor (str): Number between 0.0 and 1.0 where 0.0 is very simple and 1.0 means the most complex. [optional]
            banding_style (str): Style of banding to be used in the result. [optional]
            historic_traffic_time_bucket (str): Whether routing calculation uses the historic traffic speeds. [optional]
            default_ambient_speed (str): The speed to travel when going off a network road to find the travel boundary (for all road types).. [optional]
            ambient_speed_unit (str): The unit of measure to use to calculate the ambient speed.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TravelBoundaries
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_travel_boundary_by_time_endpoint.call_with_http_info(**kwargs)

