"""
    Precisely APIs

    Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.  # noqa: E501

    The version of the OpenAPI document: 12.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from com.precisely.apis.api_client import ApiClient, Endpoint as _Endpoint
from com.precisely.apis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from com.precisely.apis.model.error_info import ErrorInfo
from com.precisely.apis.model.route_response import RouteResponse
from com.precisely.apis.model.travel_cost_matrix_response import TravelCostMatrixResponse


class RoutingServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_route_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (RouteResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/routing/v1/route/byaddress',
                'operation_id': 'get_route_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_address',
                    'end_address',
                    'db',
                    'country',
                    'intermediate_addresses',
                    'return_intermediate_points',
                    'oip',
                    'destination_srs',
                    'optimize_by',
                    'return_distance',
                    'distance_unit',
                    'return_time',
                    'time_unit',
                    'language',
                    'directions_style',
                    'segment_geometry_style',
                    'primary_name_only',
                    'major_roads',
                    'historic_traffic_time_bucket',
                    'return_direction_geometry',
                    'use_cvr',
                    'loosening_barrier_restrictions',
                    'vehicle_type',
                    'weight',
                    'weight_unit',
                    'height',
                    'height_unit',
                    'length',
                    'length_unit',
                    'width',
                    'width_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_address':
                        (str,),
                    'end_address':
                        (str,),
                    'db':
                        (str,),
                    'country':
                        (str,),
                    'intermediate_addresses':
                        (str,),
                    'return_intermediate_points':
                        (str,),
                    'oip':
                        (str,),
                    'destination_srs':
                        (str,),
                    'optimize_by':
                        (str,),
                    'return_distance':
                        (str,),
                    'distance_unit':
                        (str,),
                    'return_time':
                        (str,),
                    'time_unit':
                        (str,),
                    'language':
                        (str,),
                    'directions_style':
                        (str,),
                    'segment_geometry_style':
                        (str,),
                    'primary_name_only':
                        (str,),
                    'major_roads':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                    'return_direction_geometry':
                        (str,),
                    'use_cvr':
                        (str,),
                    'loosening_barrier_restrictions':
                        (str,),
                    'vehicle_type':
                        (str,),
                    'weight':
                        (str,),
                    'weight_unit':
                        (str,),
                    'height':
                        (str,),
                    'height_unit':
                        (str,),
                    'length':
                        (str,),
                    'length_unit':
                        (str,),
                    'width':
                        (str,),
                    'width_unit':
                        (str,),
                },
                'attribute_map': {
                    'start_address': 'startAddress',
                    'end_address': 'endAddress',
                    'db': 'db',
                    'country': 'country',
                    'intermediate_addresses': 'intermediateAddresses',
                    'return_intermediate_points': 'returnIntermediatePoints',
                    'oip': 'oip',
                    'destination_srs': 'destinationSrs',
                    'optimize_by': 'optimizeBy',
                    'return_distance': 'returnDistance',
                    'distance_unit': 'distanceUnit',
                    'return_time': 'returnTime',
                    'time_unit': 'timeUnit',
                    'language': 'language',
                    'directions_style': 'directionsStyle',
                    'segment_geometry_style': 'segmentGeometryStyle',
                    'primary_name_only': 'primaryNameOnly',
                    'major_roads': 'majorRoads',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                    'return_direction_geometry': 'returnDirectionGeometry',
                    'use_cvr': 'useCvr',
                    'loosening_barrier_restrictions': 'looseningBarrierRestrictions',
                    'vehicle_type': 'vehicleType',
                    'weight': 'weight',
                    'weight_unit': 'weightUnit',
                    'height': 'height',
                    'height_unit': 'heightUnit',
                    'length': 'length',
                    'length_unit': 'lengthUnit',
                    'width': 'width',
                    'width_unit': 'widthUnit',
                },
                'location_map': {
                    'start_address': 'query',
                    'end_address': 'query',
                    'db': 'query',
                    'country': 'query',
                    'intermediate_addresses': 'query',
                    'return_intermediate_points': 'query',
                    'oip': 'query',
                    'destination_srs': 'query',
                    'optimize_by': 'query',
                    'return_distance': 'query',
                    'distance_unit': 'query',
                    'return_time': 'query',
                    'time_unit': 'query',
                    'language': 'query',
                    'directions_style': 'query',
                    'segment_geometry_style': 'query',
                    'primary_name_only': 'query',
                    'major_roads': 'query',
                    'historic_traffic_time_bucket': 'query',
                    'return_direction_geometry': 'query',
                    'use_cvr': 'query',
                    'loosening_barrier_restrictions': 'query',
                    'vehicle_type': 'query',
                    'weight': 'query',
                    'weight_unit': 'query',
                    'height': 'query',
                    'height_unit': 'query',
                    'length': 'query',
                    'length_unit': 'query',
                    'width': 'query',
                    'width_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_route_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (RouteResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/routing/v1/route/bylocation',
                'operation_id': 'get_route_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_point',
                    'end_point',
                    'db',
                    'intermediate_points',
                    'return_intermediate_points',
                    'oip',
                    'destination_srs',
                    'optimize_by',
                    'return_distance',
                    'distance_unit',
                    'return_time',
                    'time_unit',
                    'language',
                    'directions_style',
                    'segment_geometry_style',
                    'primary_name_only',
                    'major_roads',
                    'historic_traffic_time_bucket',
                    'return_direction_geometry',
                    'use_cvr',
                    'loosening_barrier_restrictions',
                    'vehicle_type',
                    'weight',
                    'weight_unit',
                    'height',
                    'height_unit',
                    'length',
                    'length_unit',
                    'width',
                    'width_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_point':
                        (str,),
                    'end_point':
                        (str,),
                    'db':
                        (str,),
                    'intermediate_points':
                        (str,),
                    'return_intermediate_points':
                        (str,),
                    'oip':
                        (str,),
                    'destination_srs':
                        (str,),
                    'optimize_by':
                        (str,),
                    'return_distance':
                        (str,),
                    'distance_unit':
                        (str,),
                    'return_time':
                        (str,),
                    'time_unit':
                        (str,),
                    'language':
                        (str,),
                    'directions_style':
                        (str,),
                    'segment_geometry_style':
                        (str,),
                    'primary_name_only':
                        (str,),
                    'major_roads':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                    'return_direction_geometry':
                        (str,),
                    'use_cvr':
                        (str,),
                    'loosening_barrier_restrictions':
                        (str,),
                    'vehicle_type':
                        (str,),
                    'weight':
                        (str,),
                    'weight_unit':
                        (str,),
                    'height':
                        (str,),
                    'height_unit':
                        (str,),
                    'length':
                        (str,),
                    'length_unit':
                        (str,),
                    'width':
                        (str,),
                    'width_unit':
                        (str,),
                },
                'attribute_map': {
                    'start_point': 'startPoint',
                    'end_point': 'endPoint',
                    'db': 'db',
                    'intermediate_points': 'intermediatePoints',
                    'return_intermediate_points': 'returnIntermediatePoints',
                    'oip': 'oip',
                    'destination_srs': 'destinationSrs',
                    'optimize_by': 'optimizeBy',
                    'return_distance': 'returnDistance',
                    'distance_unit': 'distanceUnit',
                    'return_time': 'returnTime',
                    'time_unit': 'timeUnit',
                    'language': 'language',
                    'directions_style': 'directionsStyle',
                    'segment_geometry_style': 'segmentGeometryStyle',
                    'primary_name_only': 'primaryNameOnly',
                    'major_roads': 'majorRoads',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                    'return_direction_geometry': 'returnDirectionGeometry',
                    'use_cvr': 'useCvr',
                    'loosening_barrier_restrictions': 'looseningBarrierRestrictions',
                    'vehicle_type': 'vehicleType',
                    'weight': 'weight',
                    'weight_unit': 'weightUnit',
                    'height': 'height',
                    'height_unit': 'heightUnit',
                    'length': 'length',
                    'length_unit': 'lengthUnit',
                    'width': 'width',
                    'width_unit': 'widthUnit',
                },
                'location_map': {
                    'start_point': 'query',
                    'end_point': 'query',
                    'db': 'query',
                    'intermediate_points': 'query',
                    'return_intermediate_points': 'query',
                    'oip': 'query',
                    'destination_srs': 'query',
                    'optimize_by': 'query',
                    'return_distance': 'query',
                    'distance_unit': 'query',
                    'return_time': 'query',
                    'time_unit': 'query',
                    'language': 'query',
                    'directions_style': 'query',
                    'segment_geometry_style': 'query',
                    'primary_name_only': 'query',
                    'major_roads': 'query',
                    'historic_traffic_time_bucket': 'query',
                    'return_direction_geometry': 'query',
                    'use_cvr': 'query',
                    'loosening_barrier_restrictions': 'query',
                    'vehicle_type': 'query',
                    'weight': 'query',
                    'weight_unit': 'query',
                    'height': 'query',
                    'height_unit': 'query',
                    'length': 'query',
                    'length_unit': 'query',
                    'width': 'query',
                    'width_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_travel_cost_matrix_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (TravelCostMatrixResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/routing/v1/travelcostmatrix/byaddress',
                'operation_id': 'get_travel_cost_matrix_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_addresses',
                    'end_addresses',
                    'country',
                    'db',
                    'optimize_by',
                    'return_distance',
                    'destination_srs',
                    'distance_unit',
                    'return_time',
                    'time_unit',
                    'major_roads',
                    'return_optimal_routes_only',
                    'historic_traffic_time_bucket',
                    'use_cvr',
                    'loosening_barrier_restrictions',
                    'vehicle_type',
                    'weight',
                    'weight_unit',
                    'height',
                    'height_unit',
                    'length',
                    'length_unit',
                    'width',
                    'width_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_addresses':
                        (str,),
                    'end_addresses':
                        (str,),
                    'country':
                        (str,),
                    'db':
                        (str,),
                    'optimize_by':
                        (str,),
                    'return_distance':
                        (str,),
                    'destination_srs':
                        (str,),
                    'distance_unit':
                        (str,),
                    'return_time':
                        (str,),
                    'time_unit':
                        (str,),
                    'major_roads':
                        (str,),
                    'return_optimal_routes_only':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                    'use_cvr':
                        (str,),
                    'loosening_barrier_restrictions':
                        (str,),
                    'vehicle_type':
                        (str,),
                    'weight':
                        (str,),
                    'weight_unit':
                        (str,),
                    'height':
                        (str,),
                    'height_unit':
                        (str,),
                    'length':
                        (str,),
                    'length_unit':
                        (str,),
                    'width':
                        (str,),
                    'width_unit':
                        (str,),
                },
                'attribute_map': {
                    'start_addresses': 'startAddresses',
                    'end_addresses': 'endAddresses',
                    'country': 'country',
                    'db': 'db',
                    'optimize_by': 'optimizeBy',
                    'return_distance': 'returnDistance',
                    'destination_srs': 'destinationSrs',
                    'distance_unit': 'distanceUnit',
                    'return_time': 'returnTime',
                    'time_unit': 'timeUnit',
                    'major_roads': 'majorRoads',
                    'return_optimal_routes_only': 'returnOptimalRoutesOnly',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                    'use_cvr': 'useCvr',
                    'loosening_barrier_restrictions': 'looseningBarrierRestrictions',
                    'vehicle_type': 'vehicleType',
                    'weight': 'weight',
                    'weight_unit': 'weightUnit',
                    'height': 'height',
                    'height_unit': 'heightUnit',
                    'length': 'length',
                    'length_unit': 'lengthUnit',
                    'width': 'width',
                    'width_unit': 'widthUnit',
                },
                'location_map': {
                    'start_addresses': 'query',
                    'end_addresses': 'query',
                    'country': 'query',
                    'db': 'query',
                    'optimize_by': 'query',
                    'return_distance': 'query',
                    'destination_srs': 'query',
                    'distance_unit': 'query',
                    'return_time': 'query',
                    'time_unit': 'query',
                    'major_roads': 'query',
                    'return_optimal_routes_only': 'query',
                    'historic_traffic_time_bucket': 'query',
                    'use_cvr': 'query',
                    'loosening_barrier_restrictions': 'query',
                    'vehicle_type': 'query',
                    'weight': 'query',
                    'weight_unit': 'query',
                    'height': 'query',
                    'height_unit': 'query',
                    'length': 'query',
                    'length_unit': 'query',
                    'width': 'query',
                    'width_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_travel_cost_matrix_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (TravelCostMatrixResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/routing/v1/travelcostmatrix/bylocation',
                'operation_id': 'get_travel_cost_matrix_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_points',
                    'end_points',
                    'db',
                    'optimize_by',
                    'return_distance',
                    'destination_srs',
                    'distance_unit',
                    'return_time',
                    'time_unit',
                    'major_roads',
                    'return_optimal_routes_only',
                    'historic_traffic_time_bucket',
                    'use_cvr',
                    'loosening_barrier_restrictions',
                    'vehicle_type',
                    'weight',
                    'weight_unit',
                    'height',
                    'height_unit',
                    'length',
                    'length_unit',
                    'width',
                    'width_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_points':
                        (str,),
                    'end_points':
                        (str,),
                    'db':
                        (str,),
                    'optimize_by':
                        (str,),
                    'return_distance':
                        (str,),
                    'destination_srs':
                        (str,),
                    'distance_unit':
                        (str,),
                    'return_time':
                        (str,),
                    'time_unit':
                        (str,),
                    'major_roads':
                        (str,),
                    'return_optimal_routes_only':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                    'use_cvr':
                        (str,),
                    'loosening_barrier_restrictions':
                        (str,),
                    'vehicle_type':
                        (str,),
                    'weight':
                        (str,),
                    'weight_unit':
                        (str,),
                    'height':
                        (str,),
                    'height_unit':
                        (str,),
                    'length':
                        (str,),
                    'length_unit':
                        (str,),
                    'width':
                        (str,),
                    'width_unit':
                        (str,),
                },
                'attribute_map': {
                    'start_points': 'startPoints',
                    'end_points': 'endPoints',
                    'db': 'db',
                    'optimize_by': 'optimizeBy',
                    'return_distance': 'returnDistance',
                    'destination_srs': 'destinationSrs',
                    'distance_unit': 'distanceUnit',
                    'return_time': 'returnTime',
                    'time_unit': 'timeUnit',
                    'major_roads': 'majorRoads',
                    'return_optimal_routes_only': 'returnOptimalRoutesOnly',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                    'use_cvr': 'useCvr',
                    'loosening_barrier_restrictions': 'looseningBarrierRestrictions',
                    'vehicle_type': 'vehicleType',
                    'weight': 'weight',
                    'weight_unit': 'weightUnit',
                    'height': 'height',
                    'height_unit': 'heightUnit',
                    'length': 'length',
                    'length_unit': 'lengthUnit',
                    'width': 'width',
                    'width_unit': 'widthUnit',
                },
                'location_map': {
                    'start_points': 'query',
                    'end_points': 'query',
                    'db': 'query',
                    'optimize_by': 'query',
                    'return_distance': 'query',
                    'destination_srs': 'query',
                    'distance_unit': 'query',
                    'return_time': 'query',
                    'time_unit': 'query',
                    'major_roads': 'query',
                    'return_optimal_routes_only': 'query',
                    'historic_traffic_time_bucket': 'query',
                    'use_cvr': 'query',
                    'loosening_barrier_restrictions': 'query',
                    'vehicle_type': 'query',
                    'weight': 'query',
                    'weight_unit': 'query',
                    'height': 'query',
                    'height_unit': 'query',
                    'length': 'query',
                    'length_unit': 'query',
                    'width': 'query',
                    'width_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_route_by_address(
        self,
        **kwargs
    ):
        """Gets Route By Address.  # noqa: E501

        Accepts addresses as input and Returns Point-to-Point and Multi-Point travel directions by various travel modes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_route_by_address(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_address (str): Starting address of the route.. [optional]
            end_address (str): Ending address of the route.. [optional]
            db (str): Mode of commute.. [optional] if omitted the server will use the default value of "driving"
            country (str): Three digit ISO country code.. [optional] if omitted the server will use the default value of "USA"
            intermediate_addresses (str): List of intermediate points of the route.. [optional]
            return_intermediate_points (str): return intermediate points. [optional] if omitted the server will use the default value of "false"
            oip (str): Specifies whether waypoints need to be optimized.. [optional] if omitted the server will use the default value of "false"
            destination_srs (str): Specifies the desired coordinate system of the returned route.. [optional]
            optimize_by (str): Specifies whether the route should be optimized by time or distance.. [optional] if omitted the server will use the default value of "time"
            return_distance (str): Specifies whether distance needs to be part of direction information in response.. [optional] if omitted the server will use the default value of "true"
            distance_unit (str): Return Distance Unit such as ft(Foot), km(Kilometer), mi(Mile), m(Meter) or yd(Yard).. [optional] if omitted the server will use the default value of "m"
            return_time (str): Specifies whether time needs to be part of direction information in response.. [optional] if omitted the server will use the default value of "true"
            time_unit (str): Return time unit such as min(Minute), h(Hour), s(Second) or msec(Millisecond). [optional] if omitted the server will use the default value of "min"
            language (str): Specifies the language of travel directions.. [optional]
            directions_style (str): Specifies whether route directions text is to be returned in the response and in what detail (Normal or Terse).. [optional] if omitted the server will use the default value of "None"
            segment_geometry_style (str): Specifies whether the route geometry is to be returned in the response and in what detail (End or All).. [optional] if omitted the server will use the default value of "none"
            primary_name_only (str): If true then only the primary street name is returned otherwise all the names for a street.. [optional] if omitted the server will use the default value of "false"
            major_roads (str): Whether to include all roads in route calculation or just major roads.. [optional] if omitted the server will use the default value of "false"
            historic_traffic_time_bucket (str): Specifies whether routing calculation uses the historic traffic speeds.. [optional] if omitted the server will use the default value of "None"
            return_direction_geometry (str): Whether to include geometry associated with each route instruction in response.. [optional] if omitted the server will use the default value of "false"
            use_cvr (str): This parameter will enable/disable CVR (Commercial Vehicle Restrictions) capability in our APIs.. [optional] if omitted the server will use the default value of "N"
            loosening_barrier_restrictions (str): Specifies that barriers will be removed when determining the route.. [optional] if omitted the server will use the default value of "Y"
            vehicle_type (str): vehicle type.. [optional] if omitted the server will use the default value of "ALL"
            weight (str): Specifies the maximum weight of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            weight_unit (str): The unit of weight eg. kg(kilogram), lb(pound), mt(metric ton), t(ton).. [optional] if omitted the server will use the default value of "kg"
            height (str): Specifies the maximum height of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            height_unit (str): The unit of height e.g m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            length (str): Specifies the maximum length of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            length_unit (str): The unit of length eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            width (str): Specifies the maximum width of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            width_unit (str): The unit of width eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RouteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_route_by_address_endpoint.call_with_http_info(**kwargs)

    def get_route_by_location(
        self,
        **kwargs
    ):
        """Gets Route By Location.  # noqa: E501

        Accepts latitude & longitude as input and Returns Point-to-Point and Multi-Point travel directions by various travel modes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_route_by_location(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_point (str): Start Point in 'Lat,Long,coordsys' format.. [optional]
            end_point (str): End Point in 'Lat,Long,coordsys' format.. [optional]
            db (str): Mode of commute.. [optional] if omitted the server will use the default value of "driving"
            intermediate_points (str): List of intermediate points of the route.. [optional]
            return_intermediate_points (str): returnIntermediatePoints route.. [optional] if omitted the server will use the default value of "false"
            oip (str): Specifies whether waypoints need to be optimized.. [optional] if omitted the server will use the default value of "false"
            destination_srs (str): Specifies the desired coordinate system of the returned route.. [optional]
            optimize_by (str): Specifies whether the route should be optimized by time or distance.. [optional] if omitted the server will use the default value of "time"
            return_distance (str): Specifies whether distance needs to be part of direction information in response.. [optional] if omitted the server will use the default value of "true"
            distance_unit (str): Return Distance Unit such as ft(Foot), km(Kilometer), mi(Mile), m(Meter) or yd(Yard).. [optional] if omitted the server will use the default value of "m"
            return_time (str): Specifies whether time needs to be part of direction information in response.. [optional] if omitted the server will use the default value of "true"
            time_unit (str): Return time unit such as min(Minute), h(Hour), s(Second) or msec(Millisecond). [optional] if omitted the server will use the default value of "min"
            language (str): Specifies the language of travel directions.. [optional]
            directions_style (str): Specifies whether route directions text is to be returned in the response and in what detail (Normal or Terse).. [optional] if omitted the server will use the default value of "None"
            segment_geometry_style (str): Specifies whether the route geometry is to be returned in the response and in what detail (End or All).. [optional] if omitted the server will use the default value of "none"
            primary_name_only (str): If true then only the primary street name is returned otherwise all the names for a street.. [optional] if omitted the server will use the default value of "false"
            major_roads (str): Whether to include all roads in route calculation or just major roads.. [optional] if omitted the server will use the default value of "false"
            historic_traffic_time_bucket (str): Specifies whether routing calculation uses the historic traffic speeds.. [optional] if omitted the server will use the default value of "None"
            return_direction_geometry (str): Whether to include geometry associated with each route instruction in response.. [optional] if omitted the server will use the default value of "false"
            use_cvr (str): This parameter will enable/disable CVR (Commercial Vehicle Restrictions) capability in our APIs.. [optional] if omitted the server will use the default value of "N"
            loosening_barrier_restrictions (str): Specifies that barriers will be removed when determining the route.. [optional] if omitted the server will use the default value of "Y"
            vehicle_type (str): vehicle type.. [optional] if omitted the server will use the default value of "ALL"
            weight (str): Specifies the maximum weight of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            weight_unit (str): The unit of weight eg. kg(kilogram), lb(pound), mt(metric ton), t(ton).. [optional] if omitted the server will use the default value of "kg"
            height (str): Specifies the maximum height of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            height_unit (str): The unit of height e.g m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            length (str): Specifies the maximum length of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            length_unit (str): The unit of length eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            width (str): Specifies the maximum width of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            width_unit (str): The unit of width eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RouteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_route_by_location_endpoint.call_with_http_info(**kwargs)

    def get_travel_cost_matrix_by_address(
        self,
        **kwargs
    ):
        """Get Cost Matrix By Address.  # noqa: E501

        Accepts addresses as input and Returns travel distances and times for multiple origins to multiple destinations by various travel modes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_travel_cost_matrix_by_address(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_addresses (str): Start locations in text based addresses.. [optional]
            end_addresses (str): End locations in text based addresses.. [optional]
            country (str): 3 Digit ISO country code.. [optional] if omitted the server will use the default value of "USA"
            db (str): Mode of commute.. [optional] if omitted the server will use the default value of "driving"
            optimize_by (str): Specifies whether routes should be optimized by time or distance.. [optional] if omitted the server will use the default value of "time"
            return_distance (str): Specifies whether distance needs to be returned in response.. [optional] if omitted the server will use the default value of "true"
            destination_srs (str): Specifies the desired coordinate system of returned routes.. [optional]
            distance_unit (str): Return Distance Unit such as ft(Foot), km(Kilometer), mi(Mile), m(Meter) or yd(Yard).. [optional] if omitted the server will use the default value of "m"
            return_time (str): Specifies whether time needs to be returned in response.. [optional] if omitted the server will use the default value of "true"
            time_unit (str): Return time unit such as min(Minute), h(Hour), s(Second) or msec(Millisecond).. [optional] if omitted the server will use the default value of "min"
            major_roads (str): Whether to include all roads in routes calculation or just major roads.. [optional] if omitted the server will use the default value of "false"
            return_optimal_routes_only (str): Specifies whether to return only the optimized route for each start and end point combination.. [optional] if omitted the server will use the default value of "true"
            historic_traffic_time_bucket (str): Specifies whether routing calculation uses the historic traffic speeds.. [optional] if omitted the server will use the default value of "None"
            use_cvr (str): This parameter will enable/disable CVR (Commercial Vehicle Restrictions) capability in our APIs.. [optional] if omitted the server will use the default value of "N"
            loosening_barrier_restrictions (str): Specifies that barriers will be removed when determining the route.. [optional] if omitted the server will use the default value of "Y"
            vehicle_type (str): vehicle type.. [optional] if omitted the server will use the default value of "ALL"
            weight (str): Specifies the maximum weight of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            weight_unit (str): The unit of weight eg. kg(kilogram), lb(pound), mt(metric ton), t(ton).. [optional] if omitted the server will use the default value of "kg"
            height (str): Specifies the maximum height of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            height_unit (str): The unit of height e.g m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            length (str): Specifies the maximum length of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            length_unit (str): The unit of length eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            width (str): Specifies the maximum width of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            width_unit (str): The unit of width eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TravelCostMatrixResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_travel_cost_matrix_by_address_endpoint.call_with_http_info(**kwargs)

    def get_travel_cost_matrix_by_location(
        self,
        **kwargs
    ):
        """Get Cost Matrix By Location.  # noqa: E501

        Accepts latitude & longitude as input and Returns travel distances and times for multiple origins to multiple destinations by various travel modes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_travel_cost_matrix_by_location(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_points (str): The address to be searched.. [optional]
            end_points (str): The address to be searched.. [optional]
            db (str): Mode of commute.. [optional] if omitted the server will use the default value of "driving"
            optimize_by (str): Specifies whether routes should be optimized by time or distance.. [optional] if omitted the server will use the default value of "time"
            return_distance (str): Specifies whether distance needs to be returned in response.. [optional] if omitted the server will use the default value of "true"
            destination_srs (str): Specifies the desired coordinate system of returned routes.. [optional] if omitted the server will use the default value of "epsg:4326"
            distance_unit (str): Return Distance Unit such as ft(Foot), km(Kilometer), mi(Mile), m(Meter) or yd(Yard).. [optional] if omitted the server will use the default value of "m"
            return_time (str): Specifies whether time needs to be returned in response.. [optional] if omitted the server will use the default value of "true"
            time_unit (str): Return time unit such as min(Minute), h(Hour), s(Second) or msec(Millisecond).. [optional] if omitted the server will use the default value of "min"
            major_roads (str): Whether to include all roads in routes calculation or just major roads.. [optional] if omitted the server will use the default value of "false"
            return_optimal_routes_only (str): Specifies whether to return only the optimized route for each start and end point combination.. [optional] if omitted the server will use the default value of "true"
            historic_traffic_time_bucket (str): Specifies whether routing calculation uses the historic traffic speeds.. [optional] if omitted the server will use the default value of "None"
            use_cvr (str): This parameter will enable/disable CVR (Commercial Vehicle Restrictions) capability in our APIs.. [optional] if omitted the server will use the default value of "N"
            loosening_barrier_restrictions (str): Specifies that barriers will be removed when determining the route.. [optional] if omitted the server will use the default value of "Y"
            vehicle_type (str): vehicle type.. [optional] if omitted the server will use the default value of "ALL"
            weight (str): Specifies the maximum weight of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            weight_unit (str): The unit of weight eg. kg(kilogram), lb(pound), mt(metric ton), t(ton).. [optional] if omitted the server will use the default value of "kg"
            height (str): Specifies the maximum height of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            height_unit (str): The unit of height e.g m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            length (str): Specifies the maximum length of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            length_unit (str): The unit of length eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            width (str): Specifies the maximum width of a vehicle. Any vehicles over this value will be restricted when determining the route.. [optional] if omitted the server will use the default value of ""
            width_unit (str): The unit of width eg. m(meter), km(kilometer), yd(yard), ft(foot), mi(mile).. [optional] if omitted the server will use the default value of "ft"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TravelCostMatrixResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_travel_cost_matrix_by_location_endpoint.call_with_http_info(**kwargs)

