"""
    Precisely APIs

    Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.  # noqa: E501

    The version of the OpenAPI document: 12.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from com.precisely.apis.api_client import ApiClient, Endpoint as _Endpoint
from com.precisely.apis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from com.precisely.apis.model.crime_risk_by_address_batch_request import CrimeRiskByAddressBatchRequest
from com.precisely.apis.model.crime_risk_by_location_batch_request import CrimeRiskByLocationBatchRequest
from com.precisely.apis.model.crime_risk_response import CrimeRiskResponse
from com.precisely.apis.model.crime_risk_response_list import CrimeRiskResponseList
from com.precisely.apis.model.distance_to_flood_hazard_address_request import DistanceToFloodHazardAddressRequest
from com.precisely.apis.model.distance_to_flood_hazard_location_request import DistanceToFloodHazardLocationRequest
from com.precisely.apis.model.distance_to_flood_hazard_response import DistanceToFloodHazardResponse
from com.precisely.apis.model.earthquake_history import EarthquakeHistory
from com.precisely.apis.model.earthquake_risk_by_address_request import EarthquakeRiskByAddressRequest
from com.precisely.apis.model.earthquake_risk_by_location_request import EarthquakeRiskByLocationRequest
from com.precisely.apis.model.earthquake_risk_response import EarthquakeRiskResponse
from com.precisely.apis.model.earthquake_risk_response_list import EarthquakeRiskResponseList
from com.precisely.apis.model.error_info import ErrorInfo
from com.precisely.apis.model.fire_history import FireHistory
from com.precisely.apis.model.fire_risk_by_address_request import FireRiskByAddressRequest
from com.precisely.apis.model.fire_risk_by_location_request import FireRiskByLocationRequest
from com.precisely.apis.model.fire_risk_response import FireRiskResponse
from com.precisely.apis.model.fire_risk_response_list import FireRiskResponseList
from com.precisely.apis.model.fire_stations import FireStations
from com.precisely.apis.model.flood_risk_by_address_request import FloodRiskByAddressRequest
from com.precisely.apis.model.flood_risk_by_location_request import FloodRiskByLocationRequest
from com.precisely.apis.model.flood_risk_response import FloodRiskResponse
from com.precisely.apis.model.flood_risk_response_list import FloodRiskResponseList
from com.precisely.apis.model.water_body_response import WaterBodyResponse


class RisksServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_crime_risk_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (CrimeRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/crime/byaddress',
                'operation_id': 'get_crime_risk_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'type',
                    'include_geometry',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'type':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'type': 'type',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'address': 'query',
                    'type': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_crime_risk_by_address_batch_endpoint = _Endpoint(
            settings={
                'response_type': (CrimeRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/crime/byaddress',
                'operation_id': 'get_crime_risk_by_address_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'crime_risk_by_address_batch_request',
                ],
                'required': [
                    'crime_risk_by_address_batch_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'crime_risk_by_address_batch_request':
                        (CrimeRiskByAddressBatchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'crime_risk_by_address_batch_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_crime_risk_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (CrimeRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/crime/bylocation',
                'operation_id': 'get_crime_risk_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'type',
                    'include_geometry',
                ],
                'required': [
                    'longitude',
                    'latitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'type':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'type': 'type',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'type': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_crime_risk_by_location_batch_endpoint = _Endpoint(
            settings={
                'response_type': (CrimeRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/crime/bylocation',
                'operation_id': 'get_crime_risk_by_location_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'crime_risk_by_location_batch_request',
                ],
                'required': [
                    'crime_risk_by_location_batch_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'crime_risk_by_location_batch_request':
                        (CrimeRiskByLocationBatchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'crime_risk_by_location_batch_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_distance_to_coast_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (WaterBodyResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/shoreline/distancetofloodhazard/byaddress',
                'operation_id': 'get_distance_to_coast_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'max_candidates',
                    'water_body_type',
                    'search_distance',
                    'search_distance_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'max_candidates':
                        (str,),
                    'water_body_type':
                        (str,),
                    'search_distance':
                        (str,),
                    'search_distance_unit':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'max_candidates': 'maxCandidates',
                    'water_body_type': 'waterBodyType',
                    'search_distance': 'searchDistance',
                    'search_distance_unit': 'searchDistanceUnit',
                },
                'location_map': {
                    'address': 'query',
                    'max_candidates': 'query',
                    'water_body_type': 'query',
                    'search_distance': 'query',
                    'search_distance_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_distance_to_coast_by_address_batch_endpoint = _Endpoint(
            settings={
                'response_type': (DistanceToFloodHazardResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/shoreline/distancetofloodhazard/byaddress',
                'operation_id': 'get_distance_to_coast_by_address_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'distance_to_flood_hazard_address_request',
                ],
                'required': [
                    'distance_to_flood_hazard_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'distance_to_flood_hazard_address_request':
                        (DistanceToFloodHazardAddressRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'distance_to_flood_hazard_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_distance_to_coast_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (WaterBodyResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/shoreline/distancetofloodhazard/bylocation',
                'operation_id': 'get_distance_to_coast_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'max_candidates',
                    'water_body_type',
                    'search_distance',
                    'search_distance_unit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'max_candidates':
                        (str,),
                    'water_body_type':
                        (str,),
                    'search_distance':
                        (str,),
                    'search_distance_unit':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'max_candidates': 'maxCandidates',
                    'water_body_type': 'waterBodyType',
                    'search_distance': 'searchDistance',
                    'search_distance_unit': 'searchDistanceUnit',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'max_candidates': 'query',
                    'water_body_type': 'query',
                    'search_distance': 'query',
                    'search_distance_unit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_distance_to_coast_by_location_batch_endpoint = _Endpoint(
            settings={
                'response_type': (DistanceToFloodHazardResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/shoreline/distancetofloodhazard/bylocation',
                'operation_id': 'get_distance_to_coast_by_location_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'distance_to_flood_hazard_location_request',
                ],
                'required': [
                    'distance_to_flood_hazard_location_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'distance_to_flood_hazard_location_request':
                        (DistanceToFloodHazardLocationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'distance_to_flood_hazard_location_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_earthquake_history_endpoint = _Endpoint(
            settings={
                'response_type': (EarthquakeHistory,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/earthquakehistory',
                'operation_id': 'get_earthquake_history',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'post_code',
                    'start_date',
                    'end_date',
                    'min_magnitude',
                    'max_magnitude',
                    'max_candidates',
                ],
                'required': [
                    'post_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'post_code':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'min_magnitude':
                        (str,),
                    'max_magnitude':
                        (str,),
                    'max_candidates':
                        (str,),
                },
                'attribute_map': {
                    'post_code': 'postCode',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'min_magnitude': 'minMagnitude',
                    'max_magnitude': 'maxMagnitude',
                    'max_candidates': 'maxCandidates',
                },
                'location_map': {
                    'post_code': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'min_magnitude': 'query',
                    'max_magnitude': 'query',
                    'max_candidates': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_earthquake_risk_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (EarthquakeRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/earthquake/byaddress',
                'operation_id': 'get_earthquake_risk_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'richter_value',
                    'include_geometry',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'richter_value':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'richter_value': 'richterValue',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'address': 'query',
                    'richter_value': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_earthquake_risk_by_address_batch_endpoint = _Endpoint(
            settings={
                'response_type': (EarthquakeRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/earthquake/byaddress',
                'operation_id': 'get_earthquake_risk_by_address_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'earthquake_risk_by_address_request',
                ],
                'required': [
                    'earthquake_risk_by_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'earthquake_risk_by_address_request':
                        (EarthquakeRiskByAddressRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'earthquake_risk_by_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_earthquake_risk_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (EarthquakeRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/earthquake/bylocation',
                'operation_id': 'get_earthquake_risk_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'richter_value',
                    'include_geometry',
                ],
                'required': [
                    'longitude',
                    'latitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'richter_value':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'richter_value': 'richterValue',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'richter_value': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_earthquake_risk_by_location_batch_endpoint = _Endpoint(
            settings={
                'response_type': (EarthquakeRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/earthquake/bylocation',
                'operation_id': 'get_earthquake_risk_by_location_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'earthquake_risk_by_location_request',
                ],
                'required': [
                    'earthquake_risk_by_location_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'earthquake_risk_by_location_request':
                        (EarthquakeRiskByLocationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'earthquake_risk_by_location_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_fire_history_endpoint = _Endpoint(
            settings={
                'response_type': (FireHistory,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/firehistory',
                'operation_id': 'get_fire_history',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'post_code',
                    'start_date',
                    'end_date',
                    'max_candidates',
                ],
                'required': [
                    'post_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'post_code':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'max_candidates':
                        (str,),
                },
                'attribute_map': {
                    'post_code': 'postCode',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'max_candidates': 'maxCandidates',
                },
                'location_map': {
                    'post_code': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'max_candidates': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_fire_risk_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (FireRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/fire/byaddress',
                'operation_id': 'get_fire_risk_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'include_geometry',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'address': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_fire_risk_by_address_batch_endpoint = _Endpoint(
            settings={
                'response_type': (FireRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/fire/byaddress',
                'operation_id': 'get_fire_risk_by_address_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'fire_risk_by_address_request',
                ],
                'required': [
                    'fire_risk_by_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'fire_risk_by_address_request':
                        (FireRiskByAddressRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'fire_risk_by_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_fire_risk_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (FireRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/fire/bylocation',
                'operation_id': 'get_fire_risk_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'include_geometry',
                ],
                'required': [
                    'longitude',
                    'latitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_fire_risk_by_location_batch_endpoint = _Endpoint(
            settings={
                'response_type': (FireRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/fire/bylocation',
                'operation_id': 'get_fire_risk_by_location_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'fire_risk_by_location_request',
                ],
                'required': [
                    'fire_risk_by_location_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'fire_risk_by_location_request':
                        (FireRiskByLocationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'fire_risk_by_location_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_fire_station_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (FireStations,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/firestation/byaddress',
                'operation_id': 'get_fire_station_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'max_candidates',
                    'travel_time',
                    'travel_time_unit',
                    'travel_distance',
                    'travel_distance_unit',
                    'sort_by',
                    'historic_traffic_time_bucket',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'max_candidates':
                        (str,),
                    'travel_time':
                        (str,),
                    'travel_time_unit':
                        (str,),
                    'travel_distance':
                        (str,),
                    'travel_distance_unit':
                        (str,),
                    'sort_by':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'max_candidates': 'maxCandidates',
                    'travel_time': 'travelTime',
                    'travel_time_unit': 'travelTimeUnit',
                    'travel_distance': 'travelDistance',
                    'travel_distance_unit': 'travelDistanceUnit',
                    'sort_by': 'sortBy',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                },
                'location_map': {
                    'address': 'query',
                    'max_candidates': 'query',
                    'travel_time': 'query',
                    'travel_time_unit': 'query',
                    'travel_distance': 'query',
                    'travel_distance_unit': 'query',
                    'sort_by': 'query',
                    'historic_traffic_time_bucket': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_fire_station_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (FireStations,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/firestation/bylocation',
                'operation_id': 'get_fire_station_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'max_candidates',
                    'travel_time',
                    'travel_time_unit',
                    'travel_distance',
                    'travel_distance_unit',
                    'sort_by',
                    'historic_traffic_time_bucket',
                ],
                'required': [
                    'longitude',
                    'latitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'max_candidates':
                        (str,),
                    'travel_time':
                        (str,),
                    'travel_time_unit':
                        (str,),
                    'travel_distance':
                        (str,),
                    'travel_distance_unit':
                        (str,),
                    'sort_by':
                        (str,),
                    'historic_traffic_time_bucket':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'max_candidates': 'maxCandidates',
                    'travel_time': 'travelTime',
                    'travel_time_unit': 'travelTimeUnit',
                    'travel_distance': 'travelDistance',
                    'travel_distance_unit': 'travelDistanceUnit',
                    'sort_by': 'sortBy',
                    'historic_traffic_time_bucket': 'historicTrafficTimeBucket',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'max_candidates': 'query',
                    'travel_time': 'query',
                    'travel_time_unit': 'query',
                    'travel_distance': 'query',
                    'travel_distance_unit': 'query',
                    'sort_by': 'query',
                    'historic_traffic_time_bucket': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flood_risk_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (FloodRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/flood/byaddress',
                'operation_id': 'get_flood_risk_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'include_zone_desc',
                    'include_geometry',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'include_zone_desc':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'include_zone_desc': 'includeZoneDesc',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'address': 'query',
                    'include_zone_desc': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flood_risk_by_address_batch_endpoint = _Endpoint(
            settings={
                'response_type': (FloodRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/flood/byaddress',
                'operation_id': 'get_flood_risk_by_address_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'flood_risk_by_address_request',
                ],
                'required': [
                    'flood_risk_by_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flood_risk_by_address_request':
                        (FloodRiskByAddressRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'flood_risk_by_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_flood_risk_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (FloodRiskResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/flood/bylocation',
                'operation_id': 'get_flood_risk_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'include_zone_desc',
                    'include_geometry',
                ],
                'required': [
                    'longitude',
                    'latitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'include_zone_desc':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'include_zone_desc': 'includeZoneDesc',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'include_zone_desc': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flood_risk_by_location_batch_endpoint = _Endpoint(
            settings={
                'response_type': (FloodRiskResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/risks/v1/flood/bylocation',
                'operation_id': 'get_flood_risk_by_location_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'flood_risk_by_location_request',
                ],
                'required': [
                    'flood_risk_by_location_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flood_risk_by_location_request':
                        (FloodRiskByLocationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'flood_risk_by_location_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )

    def get_crime_risk_by_address(
        self,
        address,
        **kwargs
    ):
        """Get Crime Risk By Address  # noqa: E501

        Accepts addresses as input and Returns local crime indexes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_crime_risk_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): free form address text

        Keyword Args:
            type (str): this is crime type; valid values are following 11 crime types with 'all' as default (more than one can also be given as comma separated types). [optional]
            include_geometry (str): Y or N (default is N) - if it is Y, then geometry will be part of response. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CrimeRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_crime_risk_by_address_endpoint.call_with_http_info(**kwargs)

    def get_crime_risk_by_address_batch(
        self,
        crime_risk_by_address_batch_request,
        **kwargs
    ):
        """Post Crime Risk By Address  # noqa: E501

        This is a Batch offering for 'Crime Risk By Address' service. It accepts a single address or a list of addresses and retrieve local crime indexes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_crime_risk_by_address_batch(crime_risk_by_address_batch_request, async_req=True)
        >>> result = thread.get()

        Args:
            crime_risk_by_address_batch_request (CrimeRiskByAddressBatchRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CrimeRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['crime_risk_by_address_batch_request'] = \
            crime_risk_by_address_batch_request
        return self.get_crime_risk_by_address_batch_endpoint.call_with_http_info(**kwargs)

    def get_crime_risk_by_location(
        self,
        longitude,
        latitude,
        **kwargs
    ):
        """Get Crime Risk By  Location  # noqa: E501

        Accepts latitude/longitude as input and returns and Returns local crime indexes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_crime_risk_by_location(longitude, latitude, async_req=True)
        >>> result = thread.get()

        Args:
            longitude (str): The longitude of the location
            latitude (str): The latitude of the location

        Keyword Args:
            type (str): this is crime type; valid values are following 11 crime types with 'all' as default (more than one can also be given as comma separated types). [optional]
            include_geometry (str): Y or N (default is N) - if it is Y, then geometry will be part of response. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CrimeRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['longitude'] = \
            longitude
        kwargs['latitude'] = \
            latitude
        return self.get_crime_risk_by_location_endpoint.call_with_http_info(**kwargs)

    def get_crime_risk_by_location_batch(
        self,
        crime_risk_by_location_batch_request,
        **kwargs
    ):
        """Post Crime Risk By Location  # noqa: E501

        This is a Batch offering for 'Crime Risk By Location' service. It accepts a single location coordinate or a list of location coordinates and retrieve local crime indexes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_crime_risk_by_location_batch(crime_risk_by_location_batch_request, async_req=True)
        >>> result = thread.get()

        Args:
            crime_risk_by_location_batch_request (CrimeRiskByLocationBatchRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CrimeRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['crime_risk_by_location_batch_request'] = \
            crime_risk_by_location_batch_request
        return self.get_crime_risk_by_location_batch_endpoint.call_with_http_info(**kwargs)

    def get_distance_to_coast_by_address(
        self,
        **kwargs
    ):
        """Get Distance To Flood Hazard By Address  # noqa: E501

        Accepts addresses as input and Returns the distance from nearest water bodies along with body name and location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_distance_to_coast_by_address(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            address (str): The address of the location. [optional]
            max_candidates (str): This specifies the value of maxCandidates. [optional]
            water_body_type (str): This specifies the value of waterBodyType. [optional]
            search_distance (str): This specifies the search distance. [optional]
            search_distance_unit (str): miles (default value),feet, kilometers, meters. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WaterBodyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_distance_to_coast_by_address_endpoint.call_with_http_info(**kwargs)

    def get_distance_to_coast_by_address_batch(
        self,
        distance_to_flood_hazard_address_request,
        **kwargs
    ):
        """Post Distance To Flood Hazard By Address  # noqa: E501

        This is a Batch offering for 'Distance To Flood Hazard By Address' service. It accepts a single address or a list of addresses and retrieve the distance from nearest water bodies along with body name and location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_distance_to_coast_by_address_batch(distance_to_flood_hazard_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            distance_to_flood_hazard_address_request (DistanceToFloodHazardAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DistanceToFloodHazardResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['distance_to_flood_hazard_address_request'] = \
            distance_to_flood_hazard_address_request
        return self.get_distance_to_coast_by_address_batch_endpoint.call_with_http_info(**kwargs)

    def get_distance_to_coast_by_location(
        self,
        **kwargs
    ):
        """Get Distance To Flood Hazard By Location  # noqa: E501

        Accepts latitude & longitude as input and Returns the distance from nearest water bodies along with body name and location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_distance_to_coast_by_location(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            longitude (str): The longitude of the location. [optional]
            latitude (str): The latitude of the location. [optional]
            max_candidates (str): This specifies the value of maxCandidates. [optional]
            water_body_type (str): This specifies the value of waterBodyType. [optional]
            search_distance (str): This specifies the search distance. [optional]
            search_distance_unit (str): miles (default value),feet, kilometers, meters. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WaterBodyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_distance_to_coast_by_location_endpoint.call_with_http_info(**kwargs)

    def get_distance_to_coast_by_location_batch(
        self,
        distance_to_flood_hazard_location_request,
        **kwargs
    ):
        """Post Distance To Flood Hazard By Location  # noqa: E501

        This is a Batch offering for 'Distance To Flood Hazard By Location' service. It accepts a single location coordinate or a list of location coordinates and retrieve the distance from nearest water bodies along with body name and location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_distance_to_coast_by_location_batch(distance_to_flood_hazard_location_request, async_req=True)
        >>> result = thread.get()

        Args:
            distance_to_flood_hazard_location_request (DistanceToFloodHazardLocationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DistanceToFloodHazardResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['distance_to_flood_hazard_location_request'] = \
            distance_to_flood_hazard_location_request
        return self.get_distance_to_coast_by_location_batch_endpoint.call_with_http_info(**kwargs)

    def get_earthquake_history(
        self,
        post_code,
        **kwargs
    ):
        """Earthquake History  # noqa: E501

        Accepts postcode as input and Returns historical earthquake details for a particular postcode.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_earthquake_history(post_code, async_req=True)
        >>> result = thread.get()

        Args:
            post_code (str): 5 digit Postal code to search

        Keyword Args:
            start_date (str): Start time in milliseconds(UTC). [optional]
            end_date (str): End time in milliseconds(UTC). [optional]
            min_magnitude (str): Minimum richter scale magnitude. [optional]
            max_magnitude (str): Maximum Richter scale magnitude. [optional]
            max_candidates (str): Maximum response events. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EarthquakeHistory
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['post_code'] = \
            post_code
        return self.get_earthquake_history_endpoint.call_with_http_info(**kwargs)

    def get_earthquake_risk_by_address(
        self,
        address,
        **kwargs
    ):
        """Get Earthquake Risk By Address  # noqa: E501

        Accepts addresses as input and Returns counts of earthquakes for various richter measurements and values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_earthquake_risk_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): free form address text

        Keyword Args:
            richter_value (str): all (default value), R0, R1, R2, R3, R4, R5, R6, R7, R0_GE, R1_GE, R2_GE, R3_GE, R4_GE, R5_GE, R6_GE, R7_GE. [optional]
            include_geometry (str): Y or N (default is N) - if it is Y, then geometry will be part of response. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EarthquakeRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_earthquake_risk_by_address_endpoint.call_with_http_info(**kwargs)

    def get_earthquake_risk_by_address_batch(
        self,
        earthquake_risk_by_address_request,
        **kwargs
    ):
        """Post Earthquake Risk By Address  # noqa: E501

        This is a Batch offering for 'Earthquake Risk By Address' service. It accepts a single address or a list of addresses and retrieve counts of earthquakes for various richter measurements and values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_earthquake_risk_by_address_batch(earthquake_risk_by_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            earthquake_risk_by_address_request (EarthquakeRiskByAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EarthquakeRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['earthquake_risk_by_address_request'] = \
            earthquake_risk_by_address_request
        return self.get_earthquake_risk_by_address_batch_endpoint.call_with_http_info(**kwargs)

    def get_earthquake_risk_by_location(
        self,
        longitude,
        latitude,
        **kwargs
    ):
        """Get Earthquake Risk By Location  # noqa: E501

        Accepts latitude & longitude as input and Returns counts of earthquakes for various richter measurements and values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_earthquake_risk_by_location(longitude, latitude, async_req=True)
        >>> result = thread.get()

        Args:
            longitude (str): The longitude of the location
            latitude (str): The latitude of the location

        Keyword Args:
            richter_value (str): all (default value), R0, R1, R2, R3, R4, R5, R6, R7, R0_GE, R1_GE, R2_GE, R3_GE, R4_GE, R5_GE, R6_GE, R7_GE. [optional]
            include_geometry (str): Y or N (default is N) - if it is Y, then geometry will be part of response. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EarthquakeRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['longitude'] = \
            longitude
        kwargs['latitude'] = \
            latitude
        return self.get_earthquake_risk_by_location_endpoint.call_with_http_info(**kwargs)

    def get_earthquake_risk_by_location_batch(
        self,
        earthquake_risk_by_location_request,
        **kwargs
    ):
        """Post Earthquake Risk By Location  # noqa: E501

        This is a Batch offering for 'Earthquake Risk By Location' service. It accepts a single location coordinate or a list of location coordinates and retrieve counts of earthquakes for various richter measurements and values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_earthquake_risk_by_location_batch(earthquake_risk_by_location_request, async_req=True)
        >>> result = thread.get()

        Args:
            earthquake_risk_by_location_request (EarthquakeRiskByLocationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EarthquakeRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['earthquake_risk_by_location_request'] = \
            earthquake_risk_by_location_request
        return self.get_earthquake_risk_by_location_batch_endpoint.call_with_http_info(**kwargs)

    def get_fire_history(
        self,
        post_code,
        **kwargs
    ):
        """Get Fire History  # noqa: E501

        Accepts postcode as input and Returns fire event details for a particular postcode.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fire_history(post_code, async_req=True)
        >>> result = thread.get()

        Args:
            post_code (str): 5 digit Postal code to search

        Keyword Args:
            start_date (str): Start time in milliseconds(UTC). [optional]
            end_date (str): End time in milliseconds(UTC). [optional]
            max_candidates (str): Maximum response events. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FireHistory
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['post_code'] = \
            post_code
        return self.get_fire_history_endpoint.call_with_http_info(**kwargs)

    def get_fire_risk_by_address(
        self,
        address,
        **kwargs
    ):
        """Get Fire Risk By Address  # noqa: E501

        Accepts addresses as input and Returns fire risk data by risk types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fire_risk_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Free form address text

        Keyword Args:
            include_geometry (str): Flag to return Geometry default is N. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FireRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_fire_risk_by_address_endpoint.call_with_http_info(**kwargs)

    def get_fire_risk_by_address_batch(
        self,
        fire_risk_by_address_request,
        **kwargs
    ):
        """Post Fire Risk By Address  # noqa: E501

        This is a Batch offering for 'Fire Risk By Address' service. It accepts a single address or a list of addresses and retrieve fire risk data by risk types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fire_risk_by_address_batch(fire_risk_by_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            fire_risk_by_address_request (FireRiskByAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FireRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['fire_risk_by_address_request'] = \
            fire_risk_by_address_request
        return self.get_fire_risk_by_address_batch_endpoint.call_with_http_info(**kwargs)

    def get_fire_risk_by_location(
        self,
        longitude,
        latitude,
        **kwargs
    ):
        """Get Fire Risk By Location  # noqa: E501

        Accepts latitude & longitude as input and Returns fire risk data by risk types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fire_risk_by_location(longitude, latitude, async_req=True)
        >>> result = thread.get()

        Args:
            longitude (str): Longitude of Location
            latitude (str): Latitude of Location

        Keyword Args:
            include_geometry (str): Flag to return Geometry default is N. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FireRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['longitude'] = \
            longitude
        kwargs['latitude'] = \
            latitude
        return self.get_fire_risk_by_location_endpoint.call_with_http_info(**kwargs)

    def get_fire_risk_by_location_batch(
        self,
        fire_risk_by_location_request,
        **kwargs
    ):
        """Post Fire Risk By Location  # noqa: E501

        This is a Batch offering for 'Fire Risk By Location' service. It accepts a single location coordinate or a list of location coordinates and retrieve fire risk data by risk types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fire_risk_by_location_batch(fire_risk_by_location_request, async_req=True)
        >>> result = thread.get()

        Args:
            fire_risk_by_location_request (FireRiskByLocationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FireRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['fire_risk_by_location_request'] = \
            fire_risk_by_location_request
        return self.get_fire_risk_by_location_batch_endpoint.call_with_http_info(**kwargs)

    def get_fire_station_by_address(
        self,
        address,
        **kwargs
    ):
        """Get Fire Station By Address  # noqa: E501

        Accepts addresses as input and Returns nearest fire stations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fire_station_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Free Address

        Keyword Args:
            max_candidates (str): Specifies the maximum number of fire stations that this service retrieves. The default value is 3 and maximum value is 5. The retrieved results are traveldistance sorted from the input location.. [optional]
            travel_time (str): Max travel time from input location to fire station. Maximum allowed is 2 hours. [optional]
            travel_time_unit (str): minutes (default), hours, seconds, milliseconds. [optional]
            travel_distance (str): Max travel distance from input location to fire station. Maximum allowed is 50 miles. [optional]
            travel_distance_unit (str): Feet (default), Kilometers, Miles, Meters. [optional]
            sort_by (str): time (default), distance. [optional]
            historic_traffic_time_bucket (str): Historic traffic time slab. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FireStations
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_fire_station_by_address_endpoint.call_with_http_info(**kwargs)

    def get_fire_station_by_location(
        self,
        longitude,
        latitude,
        **kwargs
    ):
        """Get Fire Station By Location  # noqa: E501

        Accepts latitude & longitude as input and Returns nearest fire stations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fire_station_by_location(longitude, latitude, async_req=True)
        >>> result = thread.get()

        Args:
            longitude (str): Longitude of Location
            latitude (str): Latitude of Location

        Keyword Args:
            max_candidates (str): Specifies the maximum number of fire stations that this service retrieves. The default value is 3 and maximum value is 5. The retrieved results are traveldistance sorted from the input location.. [optional]
            travel_time (str): Max travel time from input location to fire station. Maximum allowed is 2 hours. [optional]
            travel_time_unit (str): minutes (default), hours, seconds, milliseconds. [optional]
            travel_distance (str): Max travel distance from input location to fire station. Maximum allowed is 50 miles. [optional]
            travel_distance_unit (str): Feet (default), Kilometers, Miles, Meters. [optional]
            sort_by (str): time (default), distance. [optional]
            historic_traffic_time_bucket (str): Historic traffic time slab. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FireStations
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['longitude'] = \
            longitude
        kwargs['latitude'] = \
            latitude
        return self.get_fire_station_by_location_endpoint.call_with_http_info(**kwargs)

    def get_flood_risk_by_address(
        self,
        address,
        **kwargs
    ):
        """Get Flood Risk By Address  # noqa: E501

        Accepts addresses as input and Returns flood risk data for flood zones and base flood elevation values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flood_risk_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Free text Address

        Keyword Args:
            include_zone_desc (str): Flag to return zone description. [optional]
            include_geometry (str): Flag to return Geometry. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FloodRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_flood_risk_by_address_endpoint.call_with_http_info(**kwargs)

    def get_flood_risk_by_address_batch(
        self,
        flood_risk_by_address_request,
        **kwargs
    ):
        """Post Flood Risk By Address  # noqa: E501

        This is a Batch offering for 'Flood Risk By Address' service. It accepts a single address or a list of addresses and retrieve flood risk data for flood zones and base flood elevation values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flood_risk_by_address_batch(flood_risk_by_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            flood_risk_by_address_request (FloodRiskByAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FloodRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['flood_risk_by_address_request'] = \
            flood_risk_by_address_request
        return self.get_flood_risk_by_address_batch_endpoint.call_with_http_info(**kwargs)

    def get_flood_risk_by_location(
        self,
        longitude,
        latitude,
        **kwargs
    ):
        """Get Flood Risk By Location  # noqa: E501

        Accepts latitude & longitude as input and Returns flood risk data for flood zones and base flood elevation values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flood_risk_by_location(longitude, latitude, async_req=True)
        >>> result = thread.get()

        Args:
            longitude (str): Longitude of Location
            latitude (str): Latitude of Location

        Keyword Args:
            include_zone_desc (str): Flag to return zone description. [optional]
            include_geometry (str): Flag to return Geometry. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FloodRiskResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['longitude'] = \
            longitude
        kwargs['latitude'] = \
            latitude
        return self.get_flood_risk_by_location_endpoint.call_with_http_info(**kwargs)

    def get_flood_risk_by_location_batch(
        self,
        flood_risk_by_location_request,
        **kwargs
    ):
        """Post Flood Risk By Location  # noqa: E501

        This is a Batch offering for 'Flood Risk By Location' service. It accepts a single location coordinate or a list of location coordinates and retrieve flood risk data for flood zones and base flood elevation values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flood_risk_by_location_batch(flood_risk_by_location_request, async_req=True)
        >>> result = thread.get()

        Args:
            flood_risk_by_location_request (FloodRiskByLocationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FloodRiskResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['flood_risk_by_location_request'] = \
            flood_risk_by_location_request
        return self.get_flood_risk_by_location_batch_endpoint.call_with_http_info(**kwargs)

