"""
    Precisely APIs

    Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.  # noqa: E501

    The version of the OpenAPI document: 12.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from com.precisely.apis.api_client import ApiClient, Endpoint as _Endpoint
from com.precisely.apis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from com.precisely.apis.model.error_info import ErrorInfo
from com.precisely.apis.model.metadata_response import MetadataResponse
from com.precisely.apis.model.poiby_geometry_request import POIByGeometryRequest
from com.precisely.apis.model.places_response import PlacesResponse
from com.precisely.apis.model.poi import Poi
from com.precisely.apis.model.poi_count import PoiCount
from com.precisely.apis.model.poi_count_request import PoiCountRequest


class PlacesServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_category_code_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (MetadataResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/metadata/category',
                'operation_id': 'get_category_code_metadata',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'category_code',
                    'level',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'category_code':
                        (str,),
                    'level':
                        (str,),
                },
                'attribute_map': {
                    'category_code': 'categoryCode',
                    'level': 'level',
                },
                'location_map': {
                    'category_code': 'query',
                    'level': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_poiby_id_endpoint = _Endpoint(
            settings={
                'response_type': (Poi,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/poi/{id}',
                'operation_id': 'get_poiby_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_pois_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (PlacesResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/poi/byaddress',
                'operation_id': 'get_pois_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'country',
                    'name',
                    'type',
                    'category_code',
                    'sic_code',
                    'max_candidates',
                    'search_radius',
                    'search_radius_unit',
                    'travel_time',
                    'travel_time_unit',
                    'travel_distance',
                    'travel_distance_unit',
                    'travel_mode',
                    'sort_by',
                    'fuzzy_on_name',
                    'page',
                    'match_mode',
                    'specific_match_on',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'country':
                        (str,),
                    'name':
                        (str,),
                    'type':
                        (str,),
                    'category_code':
                        (str,),
                    'sic_code':
                        (str,),
                    'max_candidates':
                        (str,),
                    'search_radius':
                        (str,),
                    'search_radius_unit':
                        (str,),
                    'travel_time':
                        (str,),
                    'travel_time_unit':
                        (str,),
                    'travel_distance':
                        (str,),
                    'travel_distance_unit':
                        (str,),
                    'travel_mode':
                        (str,),
                    'sort_by':
                        (str,),
                    'fuzzy_on_name':
                        (str,),
                    'page':
                        (str,),
                    'match_mode':
                        (str,),
                    'specific_match_on':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'country': 'country',
                    'name': 'name',
                    'type': 'type',
                    'category_code': 'categoryCode',
                    'sic_code': 'sicCode',
                    'max_candidates': 'maxCandidates',
                    'search_radius': 'searchRadius',
                    'search_radius_unit': 'searchRadiusUnit',
                    'travel_time': 'travelTime',
                    'travel_time_unit': 'travelTimeUnit',
                    'travel_distance': 'travelDistance',
                    'travel_distance_unit': 'travelDistanceUnit',
                    'travel_mode': 'travelMode',
                    'sort_by': 'sortBy',
                    'fuzzy_on_name': 'fuzzyOnName',
                    'page': 'page',
                    'match_mode': 'matchMode',
                    'specific_match_on': 'specificMatchOn',
                },
                'location_map': {
                    'address': 'query',
                    'country': 'query',
                    'name': 'query',
                    'type': 'query',
                    'category_code': 'query',
                    'sic_code': 'query',
                    'max_candidates': 'query',
                    'search_radius': 'query',
                    'search_radius_unit': 'query',
                    'travel_time': 'query',
                    'travel_time_unit': 'query',
                    'travel_distance': 'query',
                    'travel_distance_unit': 'query',
                    'travel_mode': 'query',
                    'sort_by': 'query',
                    'fuzzy_on_name': 'query',
                    'page': 'query',
                    'match_mode': 'query',
                    'specific_match_on': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_pois_by_area_endpoint = _Endpoint(
            settings={
                'response_type': (PlacesResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/poi/byarea',
                'operation_id': 'get_pois_by_area',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'area_name1',
                    'area_name3',
                    'postcode1',
                    'postcode2',
                    'country',
                    'name',
                    'type',
                    'category_code',
                    'sic_code',
                    'max_candidates',
                    'fuzzy_on_name',
                    'page',
                    'match_mode',
                    'specific_match_on',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'area_name1':
                        (str,),
                    'area_name3':
                        (str,),
                    'postcode1':
                        (str,),
                    'postcode2':
                        (str,),
                    'country':
                        (str,),
                    'name':
                        (str,),
                    'type':
                        (str,),
                    'category_code':
                        (str,),
                    'sic_code':
                        (str,),
                    'max_candidates':
                        (str,),
                    'fuzzy_on_name':
                        (str,),
                    'page':
                        (str,),
                    'match_mode':
                        (str,),
                    'specific_match_on':
                        (str,),
                },
                'attribute_map': {
                    'area_name1': 'areaName1',
                    'area_name3': 'areaName3',
                    'postcode1': 'postcode1',
                    'postcode2': 'postcode2',
                    'country': 'country',
                    'name': 'name',
                    'type': 'type',
                    'category_code': 'categoryCode',
                    'sic_code': 'sicCode',
                    'max_candidates': 'maxCandidates',
                    'fuzzy_on_name': 'fuzzyOnName',
                    'page': 'page',
                    'match_mode': 'matchMode',
                    'specific_match_on': 'specificMatchOn',
                },
                'location_map': {
                    'area_name1': 'query',
                    'area_name3': 'query',
                    'postcode1': 'query',
                    'postcode2': 'query',
                    'country': 'query',
                    'name': 'query',
                    'type': 'query',
                    'category_code': 'query',
                    'sic_code': 'query',
                    'max_candidates': 'query',
                    'fuzzy_on_name': 'query',
                    'page': 'query',
                    'match_mode': 'query',
                    'specific_match_on': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_pois_by_geometry_endpoint = _Endpoint(
            settings={
                'response_type': (PlacesResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/poi/byboundary',
                'operation_id': 'get_pois_by_geometry',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'poiby_geometry_request',
                ],
                'required': [
                    'poiby_geometry_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'poiby_geometry_request':
                        (POIByGeometryRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'poiby_geometry_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_pois_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (PlacesResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/poi/bylocation',
                'operation_id': 'get_pois_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'name',
                    'type',
                    'category_code',
                    'sic_code',
                    'max_candidates',
                    'search_radius',
                    'search_radius_unit',
                    'travel_time',
                    'travel_time_unit',
                    'travel_distance',
                    'travel_distance_unit',
                    'travel_mode',
                    'sort_by',
                    'fuzzy_on_name',
                    'page',
                    'match_mode',
                    'specific_match_on',
                ],
                'required': [
                    'longitude',
                    'latitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'name':
                        (str,),
                    'type':
                        (str,),
                    'category_code':
                        (str,),
                    'sic_code':
                        (str,),
                    'max_candidates':
                        (str,),
                    'search_radius':
                        (str,),
                    'search_radius_unit':
                        (str,),
                    'travel_time':
                        (str,),
                    'travel_time_unit':
                        (str,),
                    'travel_distance':
                        (str,),
                    'travel_distance_unit':
                        (str,),
                    'travel_mode':
                        (str,),
                    'sort_by':
                        (str,),
                    'fuzzy_on_name':
                        (str,),
                    'page':
                        (str,),
                    'match_mode':
                        (str,),
                    'specific_match_on':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'name': 'name',
                    'type': 'type',
                    'category_code': 'categoryCode',
                    'sic_code': 'sicCode',
                    'max_candidates': 'maxCandidates',
                    'search_radius': 'searchRadius',
                    'search_radius_unit': 'searchRadiusUnit',
                    'travel_time': 'travelTime',
                    'travel_time_unit': 'travelTimeUnit',
                    'travel_distance': 'travelDistance',
                    'travel_distance_unit': 'travelDistanceUnit',
                    'travel_mode': 'travelMode',
                    'sort_by': 'sortBy',
                    'fuzzy_on_name': 'fuzzyOnName',
                    'page': 'page',
                    'match_mode': 'matchMode',
                    'specific_match_on': 'specificMatchOn',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'name': 'query',
                    'type': 'query',
                    'category_code': 'query',
                    'sic_code': 'query',
                    'max_candidates': 'query',
                    'search_radius': 'query',
                    'search_radius_unit': 'query',
                    'travel_time': 'query',
                    'travel_time_unit': 'query',
                    'travel_distance': 'query',
                    'travel_distance_unit': 'query',
                    'travel_mode': 'query',
                    'sort_by': 'query',
                    'fuzzy_on_name': 'query',
                    'page': 'query',
                    'match_mode': 'query',
                    'specific_match_on': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_pois_count_endpoint = _Endpoint(
            settings={
                'response_type': (PoiCount,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/poicount',
                'operation_id': 'get_pois_count',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'content_type',
                    'poi_count_request',
                ],
                'required': [
                    'content_type',
                    'poi_count_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'content_type':
                        (str,),
                    'poi_count_request':
                        (PoiCountRequest,),
                },
                'attribute_map': {
                    'content_type': 'Content-Type',
                },
                'location_map': {
                    'content_type': 'header',
                    'poi_count_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.get_sic_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (MetadataResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/metadata/sic',
                'operation_id': 'get_sic_metadata',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'sic_code',
                    'level',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sic_code':
                        (str,),
                    'level':
                        (str,),
                },
                'attribute_map': {
                    'sic_code': 'sicCode',
                    'level': 'level',
                },
                'location_map': {
                    'sic_code': 'query',
                    'level': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.pois_autocomplete_endpoint = _Endpoint(
            settings={
                'response_type': (PlacesResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/places/v1/poi/autocomplete',
                'operation_id': 'pois_autocomplete',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_forwarded_for',
                    'longitude',
                    'latitude',
                    'search_text',
                    'search_on_name_only',
                    'search_radius',
                    'search_radius_unit',
                    'travel_time',
                    'travel_time_unit',
                    'travel_distance',
                    'travel_distance_unit',
                    'travel_mode',
                    'country',
                    'area_name1',
                    'area_name3',
                    'postcode1',
                    'postcode2',
                    'ip_address',
                    'auto_detect_location',
                    'type',
                    'category_code',
                    'sic_code',
                    'max_candidates',
                    'sort_by',
                    'match_mode',
                    'specific_match_on',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_forwarded_for':
                        (str,),
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'search_text':
                        (str,),
                    'search_on_name_only':
                        (str,),
                    'search_radius':
                        (str,),
                    'search_radius_unit':
                        (str,),
                    'travel_time':
                        (str,),
                    'travel_time_unit':
                        (str,),
                    'travel_distance':
                        (str,),
                    'travel_distance_unit':
                        (str,),
                    'travel_mode':
                        (str,),
                    'country':
                        (str,),
                    'area_name1':
                        (str,),
                    'area_name3':
                        (str,),
                    'postcode1':
                        (str,),
                    'postcode2':
                        (str,),
                    'ip_address':
                        (str,),
                    'auto_detect_location':
                        (str,),
                    'type':
                        (str,),
                    'category_code':
                        (str,),
                    'sic_code':
                        (str,),
                    'max_candidates':
                        (str,),
                    'sort_by':
                        (str,),
                    'match_mode':
                        (str,),
                    'specific_match_on':
                        (str,),
                },
                'attribute_map': {
                    'x_forwarded_for': 'X-Forwarded-For',
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'search_text': 'searchText',
                    'search_on_name_only': 'searchOnNameOnly',
                    'search_radius': 'searchRadius',
                    'search_radius_unit': 'searchRadiusUnit',
                    'travel_time': 'travelTime',
                    'travel_time_unit': 'travelTimeUnit',
                    'travel_distance': 'travelDistance',
                    'travel_distance_unit': 'travelDistanceUnit',
                    'travel_mode': 'travelMode',
                    'country': 'country',
                    'area_name1': 'areaName1',
                    'area_name3': 'areaName3',
                    'postcode1': 'postcode1',
                    'postcode2': 'postcode2',
                    'ip_address': 'ipAddress',
                    'auto_detect_location': 'autoDetectLocation',
                    'type': 'type',
                    'category_code': 'categoryCode',
                    'sic_code': 'sicCode',
                    'max_candidates': 'maxCandidates',
                    'sort_by': 'sortBy',
                    'match_mode': 'matchMode',
                    'specific_match_on': 'specificMatchOn',
                },
                'location_map': {
                    'x_forwarded_for': 'header',
                    'longitude': 'query',
                    'latitude': 'query',
                    'search_text': 'query',
                    'search_on_name_only': 'query',
                    'search_radius': 'query',
                    'search_radius_unit': 'query',
                    'travel_time': 'query',
                    'travel_time_unit': 'query',
                    'travel_distance': 'query',
                    'travel_distance_unit': 'query',
                    'travel_mode': 'query',
                    'country': 'query',
                    'area_name1': 'query',
                    'area_name3': 'query',
                    'postcode1': 'query',
                    'postcode2': 'query',
                    'ip_address': 'query',
                    'auto_detect_location': 'query',
                    'type': 'query',
                    'category_code': 'query',
                    'sic_code': 'query',
                    'max_candidates': 'query',
                    'sort_by': 'query',
                    'match_mode': 'query',
                    'specific_match_on': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_category_code_metadata(
        self,
        **kwargs
    ):
        """Category Code Metadata.  # noqa: E501

        This service returns a list of Category codes & associated metadata which can then be used as inputs for querying the Points of Interest By Address or Location methods listed above.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_category_code_metadata(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            category_code (str): 4, 6, or 11 digits category code to filter the response.. [optional]
            level (str): 1, 2, or 3.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_category_code_metadata_endpoint.call_with_http_info(**kwargs)

    def get_poiby_id(
        self,
        id,
        **kwargs
    ):
        """Points Of Interest Details By Id  # noqa: E501

        This service returns complete details of a chosen point of interest by an identifier. The identifier could be selected from Autocomplete API response.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_poiby_id(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): POI unique Identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Poi
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.get_poiby_id_endpoint.call_with_http_info(**kwargs)

    def get_pois_by_address(
        self,
        **kwargs
    ):
        """Get POIs By Address.  # noqa: E501

        This service accepts an address as input and returns nearby points-of-interest places around that address. Additional input features include retrieving data by name, type, standard industrial classifications and category codes, as well as geographic filtering by radius, travel times and travel distances. Response features include JSON/XML as well as CSV download.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pois_by_address(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            address (str): The address to be searched.. [optional]
            country (str): Country ISO code.. [optional]
            name (str): Specifies the name of the place (POI) to be searched. Also performs search on partially specified names. It requires minimum 3 characters to search.. [optional]
            type (str): Filters the points of interest (POIs) by place types.. [optional]
            category_code (str): Acts as a filter to narrow down and refine POI search results. The category codes are unique 4, 6, or 11 digit numeric values.. [optional]
            sic_code (str): Acts as a filter to narrow down and refine POI search results. The SIC codes are unique 4 or 8 digit numerical values. [optional]
            max_candidates (str): Maximum number of POIs that can be retrieved. [optional]
            search_radius (str): Radius range within which search is performed.. [optional]
            search_radius_unit (str): Radius unit such as Feet, Kilometers, Miles or Meters (default).. [optional]
            travel_time (str): Travel time within which search is performed (POIs which can be reached within travel time).. [optional]
            travel_time_unit (str): Travel time unit such as minutes (default), hours, seconds or milliseconds.. [optional]
            travel_distance (str): Travel distance within which search is performed (POIs which can be reached within travel distance).. [optional]
            travel_distance_unit (str): Travel distance unit such as Feet (default), Kilometers, Miles or Meters.. [optional]
            travel_mode (str): Mode of commute.. [optional] if omitted the server will use the default value of "driving"
            sort_by (str): Whether to sort the results based on relevance (best match) or by nearest distance from input location.. [optional]
            fuzzy_on_name (str): Whether to allow fuzzy seacrh on name input.. [optional]
            page (str): Specifies the page number of results where page size is the value of maxCandidates input in request.. [optional]
            match_mode (str): Determine the leniency used to make a match between the input name and the reference data.. [optional]
            specific_match_on (str): Specifies the field for the Specific Match Mode.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PlacesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_pois_by_address_endpoint.call_with_http_info(**kwargs)

    def get_pois_by_area(
        self,
        **kwargs
    ):
        """GET Points Of Interest By Area.  # noqa: E501

        This service accepts city or postcode (alongwith country) and returns points-of-interest places within a city or postcode. Additional input features include retrieving data by name, type, standard industrial classifications and category codes, as well as geographic filtering by radius, travel times and travel distances. Response features include JSON/XML as well as CSV download.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pois_by_area(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            area_name1 (str): Specifies the largest geographical area, typically a state or province. [optional]
            area_name3 (str): Specifies a city or town name. [optional]
            postcode1 (str): Specifies the postcode(ZIP code) in the appropriate format for the country. [optional]
            postcode2 (str): Specifies the postcode(ZIP code) extension. [optional]
            country (str): Country ISO code. [optional]
            name (str): Specifies the name of the place (POI) to be searched. Also performs search on partially specified names. It requires minimum 3 characters to search. [optional]
            type (str): Filters the points of interest (POIs) by place types. [optional]
            category_code (str): Acts as a filter to narrow down and refine POI search results. The category codes are unique 4, 6, or 11 digit numeric values. [optional]
            sic_code (str): Acts as a filter to narrow down and refine POI search results. The SIC codes are unique 4 or 8 digit numerical values. [optional]
            max_candidates (str): Maximum number of POIs that can be retrieved. [optional]
            fuzzy_on_name (str): Whether to allow fuzzy seacrh on name input. [optional]
            page (str): Specifies the page number of results where page size is the value of maxCandidates input in request. [optional]
            match_mode (str): Determine the leniency used to make a match between the input name and the reference data. [optional]
            specific_match_on (str): Specifies the field for the Specific Match Mode. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PlacesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_pois_by_area_endpoint.call_with_http_info(**kwargs)

    def get_pois_by_geometry(
        self,
        poiby_geometry_request,
        **kwargs
    ):
        """Points Of Interest By Boundary  # noqa: E501

        Accepts a user-defined boundary as input and returns all Points of Interest within the boundary. Additionally, user can filter the response by name, type, standard industrial classifications and category codes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pois_by_geometry(poiby_geometry_request, async_req=True)
        >>> result = thread.get()

        Args:
            poiby_geometry_request (POIByGeometryRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PlacesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['poiby_geometry_request'] = \
            poiby_geometry_request
        return self.get_pois_by_geometry_endpoint.call_with_http_info(**kwargs)

    def get_pois_by_location(
        self,
        longitude,
        latitude,
        **kwargs
    ):
        """Get POIs By Location.  # noqa: E501

        This service accepts latitude/longitude as input and returns nearby points-of-interest places around that location. Additional input features include retrieving data by name, type, standard industrial classifications and category codes, as well as geographic filtering by radius, travel times and travel distances. Response features include JSON/XML as well as CSV download  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pois_by_location(longitude, latitude, async_req=True)
        >>> result = thread.get()

        Args:
            longitude (str): Longitude of the location.
            latitude (str): Latitude of the location.

        Keyword Args:
            name (str): Specifies the name of the place (POI) to be searched. Also performs search on partially specified names. It requires minimum 3 characters to search.. [optional]
            type (str): Filters the points of interest (POIs) by place types.. [optional]
            category_code (str): Acts as a filter to narrow down and refine POI search results. The category codes are unique 4, 6, or 11 digit numeric values.. [optional]
            sic_code (str): Acts as a filter to narrow down and refine POI search results. The SIC codes are unique 4 or 8 digit numerical values. [optional]
            max_candidates (str): Maximum number of POIs that can be retrieved. [optional]
            search_radius (str): Radius range within which search is performed.. [optional]
            search_radius_unit (str): Radius unit such as Feet, Kilometers, Miles or Meters (default).. [optional]
            travel_time (str): Travel time within which search is performed (POIs which can be reached within travel time).. [optional]
            travel_time_unit (str): Travel time unit such as minutes (default), hours, seconds or milliseconds.. [optional]
            travel_distance (str): Travel distance within which search is performed (POIs which can be reached within travel distance).. [optional]
            travel_distance_unit (str): Travel distance unit such as Feet (default), Kilometers, Miles or Meters.. [optional]
            travel_mode (str): Mode of commute.. [optional]
            sort_by (str): Whether to sort the results based on relevance (best match) or by nearest distance from input location.. [optional]
            fuzzy_on_name (str): Whether to allow fuzzy seacrh on name input.. [optional]
            page (str): Specifies the page number of results where page size is the value of maxCandidates input in request.. [optional]
            match_mode (str): Determine the leniency used to make a match between the input name and the reference data.. [optional]
            specific_match_on (str): Specifies the field for the Specific Match Mode.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PlacesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['longitude'] = \
            longitude
        kwargs['latitude'] = \
            latitude
        return self.get_pois_by_location_endpoint.call_with_http_info(**kwargs)

    def get_pois_count(
        self,
        content_type,
        poi_count_request,
        **kwargs
    ):
        """Points Of Interest Count  # noqa: E501

        Accepts a user-defined boundary as input and returns the Count number of POIs within the boundary. Additionally, user can request the count of filtered POIs by name, type, standard industrial classifications and category codes within the given polygon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pois_count(content_type, poi_count_request, async_req=True)
        >>> result = thread.get()

        Args:
            content_type (str):
            poi_count_request (PoiCountRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PoiCount
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['content_type'] = \
            content_type
        kwargs['poi_count_request'] = \
            poi_count_request
        return self.get_pois_count_endpoint.call_with_http_info(**kwargs)

    def get_sic_metadata(
        self,
        **kwargs
    ):
        """Get SIC Metadata  # noqa: E501

        This service returns a list of standard industrial classification codes & associated metadata which can then be used as inputs for querying the Points of Interest By Address or Location methods listed above.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sic_metadata(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            sic_code (str): 4 or 8 digits SIC code to filter the response.. [optional]
            level (str): 1 or 2.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_sic_metadata_endpoint.call_with_http_info(**kwargs)

    def pois_autocomplete(
        self,
        **kwargs
    ):
        """Points Of Interest Autocomplete  # noqa: E501

        This service accepts partial text input and returns matching points of interest, sorted by relevance or distance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pois_autocomplete(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            x_forwarded_for (str): [optional]
            longitude (str): Longitude of the location.. [optional]
            latitude (str): Latitude of the location.. [optional]
            search_text (str): Free text which will accept a multi-word string. Combination of POI name and address is possible.. [optional]
            search_on_name_only (str): [optional] if omitted the server will use the default value of "N"
            search_radius (str): Radius range within which search is performed.. [optional]
            search_radius_unit (str): Radius unit such as Feet, Kilometers, Miles or Meters (default).. [optional]
            travel_time (str): Travel time within which search is performed (POIs which can be reached within travel time).. [optional]
            travel_time_unit (str): Travel time unit such as minutes (default), hours, seconds or milliseconds.. [optional]
            travel_distance (str): Travel distance within which search is performed (POIs which can be reached within travel distance).. [optional]
            travel_distance_unit (str): Travel distance unit such as Feet (default), Kilometers, Miles or Meters.. [optional]
            travel_mode (str): Mode of commute.. [optional] if omitted the server will use the default value of "driving"
            country (str): Country ISO code.. [optional]
            area_name1 (str): Specifies the largest geographical area, typically a state or province.. [optional]
            area_name3 (str): Specifies a city or town name.. [optional]
            postcode1 (str): Specifies the postcode(ZIP code) in the appropriate format for the country.. [optional]
            postcode2 (str): Specifies the postcode(ZIP code) extension.. [optional]
            ip_address (str): IP address which will be used to auto detect the location in order to serve contextually relevant results.. [optional]
            auto_detect_location (str): Specifies whether to detect client's location using IP address. If IP address(below) is not provided and autoDetectLocation is set 'True' then IP address will be picked from HTTP request automatically.. [optional]
            type (str): Filters the points of interest (POIs) by place types.. [optional]
            category_code (str): Acts as a filter to narrow down and refine POI search results. The category codes are unique 4, 6, or 11 digit numeric values.. [optional]
            sic_code (str): Acts as a filter to narrow down and refine POI search results. The SIC codes are unique 4 or 8 digit numerical values.. [optional]
            max_candidates (str): Maximum number of POIs that can be retrieved.. [optional]
            sort_by (str): sortBy. [optional]
            match_mode (str): Determine the leniency used to make a match between the input name and the reference data.. [optional]
            specific_match_on (str): Specifies the field for the Specific Match Mode.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PlacesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.pois_autocomplete_endpoint.call_with_http_info(**kwargs)

