"""
    Precisely APIs

    Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.  # noqa: E501

    The version of the OpenAPI document: 12.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from com.precisely.apis.api_client import ApiClient, Endpoint as _Endpoint
from com.precisely.apis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from com.precisely.apis.model.error_info import ErrorInfo
from com.precisely.apis.model.ipd_tax_by_address_batch_request import IPDTaxByAddressBatchRequest
from com.precisely.apis.model.tax_address_request import TaxAddressRequest
from com.precisely.apis.model.tax_district_response import TaxDistrictResponse
from com.precisely.apis.model.tax_district_response_list import TaxDistrictResponseList
from com.precisely.apis.model.tax_location_request import TaxLocationRequest
from com.precisely.apis.model.tax_rate_address_request import TaxRateAddressRequest
from com.precisely.apis.model.tax_rate_location_request import TaxRateLocationRequest
from com.precisely.apis.model.tax_rate_response import TaxRateResponse
from com.precisely.apis.model.tax_responses import TaxResponses


class LocalTaxServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_batch_tax_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (TaxResponses,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/tax/{taxRateTypeId}/byaddress',
                'operation_id': 'get_batch_tax_by_address',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'tax_address_request',
                ],
                'required': [
                    'tax_rate_type_id',
                    'tax_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'tax_address_request':
                        (TaxAddressRequest,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'tax_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_batch_tax_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (TaxResponses,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/tax/{taxRateTypeId}/bylocation',
                'operation_id': 'get_batch_tax_by_location',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'tax_location_request',
                ],
                'required': [
                    'tax_rate_type_id',
                    'tax_location_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'tax_location_request':
                        (TaxLocationRequest,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'tax_location_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_batch_tax_rate_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (TaxResponses,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/taxrate/{taxRateTypeId}/byaddress',
                'operation_id': 'get_batch_tax_rate_by_address',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'tax_rate_address_request',
                ],
                'required': [
                    'tax_rate_type_id',
                    'tax_rate_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'tax_rate_address_request':
                        (TaxRateAddressRequest,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'tax_rate_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_batch_tax_rate_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (TaxResponses,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/taxrate/{taxRateTypeId}/bylocation',
                'operation_id': 'get_batch_tax_rate_by_location',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'tax_rate_location_request',
                ],
                'required': [
                    'tax_rate_type_id',
                    'tax_rate_location_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'tax_rate_location_request':
                        (TaxRateLocationRequest,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'tax_rate_location_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_ipd_tax_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (TaxDistrictResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/taxdistrict/ipd/byaddress',
                'operation_id': 'get_ipd_tax_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'return_lat_long_fields',
                    'lat_long_format',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'return_lat_long_fields':
                        (str,),
                    'lat_long_format':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'return_lat_long_fields': 'returnLatLongFields',
                    'lat_long_format': 'latLongFormat',
                },
                'location_map': {
                    'address': 'query',
                    'return_lat_long_fields': 'query',
                    'lat_long_format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ipd_tax_by_address_batch_endpoint = _Endpoint(
            settings={
                'response_type': (TaxDistrictResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/taxdistrict/ipd/byaddress',
                'operation_id': 'get_ipd_tax_by_address_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'ipd_tax_by_address_batch_request',
                ],
                'required': [
                    'ipd_tax_by_address_batch_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ipd_tax_by_address_batch_request':
                        (IPDTaxByAddressBatchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'ipd_tax_by_address_batch_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_specific_tax_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (TaxRateResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/tax/{taxRateTypeId}/byaddress',
                'operation_id': 'get_specific_tax_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'address',
                    'purchase_amount',
                ],
                'required': [
                    'tax_rate_type_id',
                    'address',
                    'purchase_amount',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'address':
                        (str,),
                    'purchase_amount':
                        (str,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                    'address': 'address',
                    'purchase_amount': 'purchaseAmount',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'address': 'query',
                    'purchase_amount': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_specific_tax_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (TaxRateResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/tax/{taxRateTypeId}/bylocation',
                'operation_id': 'get_specific_tax_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'latitude',
                    'longitude',
                    'purchase_amount',
                ],
                'required': [
                    'tax_rate_type_id',
                    'latitude',
                    'longitude',
                    'purchase_amount',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'latitude':
                        (str,),
                    'longitude':
                        (str,),
                    'purchase_amount':
                        (str,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                    'latitude': 'latitude',
                    'longitude': 'longitude',
                    'purchase_amount': 'purchaseAmount',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'latitude': 'query',
                    'longitude': 'query',
                    'purchase_amount': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_specific_tax_rate_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (TaxRateResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/taxrate/{taxRateTypeId}/byaddress',
                'operation_id': 'get_specific_tax_rate_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'address',
                ],
                'required': [
                    'tax_rate_type_id',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'address':
                        (str,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                    'address': 'address',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'address': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_specific_tax_rate_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (TaxRateResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/localtax/v1/taxrate/{taxRateTypeId}/bylocation',
                'operation_id': 'get_specific_tax_rate_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tax_rate_type_id',
                    'latitude',
                    'longitude',
                ],
                'required': [
                    'tax_rate_type_id',
                    'latitude',
                    'longitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tax_rate_type_id':
                        (str,),
                    'latitude':
                        (str,),
                    'longitude':
                        (str,),
                },
                'attribute_map': {
                    'tax_rate_type_id': 'taxRateTypeId',
                    'latitude': 'latitude',
                    'longitude': 'longitude',
                },
                'location_map': {
                    'tax_rate_type_id': 'path',
                    'latitude': 'query',
                    'longitude': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_batch_tax_by_address(
        self,
        tax_rate_type_id,
        tax_address_request,
        **kwargs
    ):
        """Post Tax By Address  # noqa: E501

        This is a Batch offering for 'Tax By Address' service. It accepts a single address, purchase amount or a list of addresses, purchase amounts and retrieve applicable taxes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_batch_tax_by_address(tax_rate_type_id, tax_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str):
            tax_address_request (TaxAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxResponses
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['tax_address_request'] = \
            tax_address_request
        return self.get_batch_tax_by_address_endpoint.call_with_http_info(**kwargs)

    def get_batch_tax_by_location(
        self,
        tax_rate_type_id,
        tax_location_request,
        **kwargs
    ):
        """Post Tax By Location  # noqa: E501

        This is a Batch offering for 'Tax By Location' service. It accepts a single location coordinate, purchase amount or a list of location coordinates, purchase amounts and retrieve applicable tax.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_batch_tax_by_location(tax_rate_type_id, tax_location_request, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str):
            tax_location_request (TaxLocationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxResponses
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['tax_location_request'] = \
            tax_location_request
        return self.get_batch_tax_by_location_endpoint.call_with_http_info(**kwargs)

    def get_batch_tax_rate_by_address(
        self,
        tax_rate_type_id,
        tax_rate_address_request,
        **kwargs
    ):
        """Post Taxrate By Address  # noqa: E501

        This is a Batch offering for 'Taxrate By Address' service. It accepts a single address or a list of addresses and retrieve applicable tax rates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_batch_tax_rate_by_address(tax_rate_type_id, tax_rate_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str):
            tax_rate_address_request (TaxRateAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxResponses
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['tax_rate_address_request'] = \
            tax_rate_address_request
        return self.get_batch_tax_rate_by_address_endpoint.call_with_http_info(**kwargs)

    def get_batch_tax_rate_by_location(
        self,
        tax_rate_type_id,
        tax_rate_location_request,
        **kwargs
    ):
        """Post Taxrate By Location  # noqa: E501

        This is a Batch offering for 'Taxrate By Location' service. It accepts a single location coordinate or a list of location coordinates and retrieve applicable tax rates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_batch_tax_rate_by_location(tax_rate_type_id, tax_rate_location_request, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str):
            tax_rate_location_request (TaxRateLocationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxResponses
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['tax_rate_location_request'] = \
            tax_rate_location_request
        return self.get_batch_tax_rate_by_location_endpoint.call_with_http_info(**kwargs)

    def get_ipd_tax_by_address(
        self,
        address,
        **kwargs
    ):
        """Get IPD Tax by Address  # noqa: E501

        Retrieves IPD (Insurance Premium District) tax rates applicable to a specific address. This service accepts address as input and returns one or many IPD tax rate details for that region in which address falls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ipd_tax_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): The address to be searched.

        Keyword Args:
            return_lat_long_fields (str): Y or N (default is N) - Returns Latitude Longitude Fields.. [optional]
            lat_long_format (str): (default is Decimal) - Returns Desired Latitude Longitude Format.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxDistrictResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_ipd_tax_by_address_endpoint.call_with_http_info(**kwargs)

    def get_ipd_tax_by_address_batch(
        self,
        ipd_tax_by_address_batch_request,
        **kwargs
    ):
        """Get IPD Tax for batch requests.  # noqa: E501

        This is a Batch offering for 'IPD Tax rates By Address'. It accepts multiple addresses as parameters along with geocoding and matching preferences and returns one or many IPD tax rate details for each address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ipd_tax_by_address_batch(ipd_tax_by_address_batch_request, async_req=True)
        >>> result = thread.get()

        Args:
            ipd_tax_by_address_batch_request (IPDTaxByAddressBatchRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxDistrictResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ipd_tax_by_address_batch_request'] = \
            ipd_tax_by_address_batch_request
        return self.get_ipd_tax_by_address_batch_endpoint.call_with_http_info(**kwargs)

    def get_specific_tax_by_address(
        self,
        tax_rate_type_id,
        address,
        purchase_amount,
        **kwargs
    ):
        """Get Tax By Address  # noqa: E501

        This service calculates and returns taxes applicable at a specific address. Address, purchase amount and supported tax rate type are inputs to the service.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_specific_tax_by_address(tax_rate_type_id, address, purchase_amount, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str): The tax rate id
            address (str): The address to be searched.
            purchase_amount (str): The amount on which tax to be calculated

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxRateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['address'] = \
            address
        kwargs['purchase_amount'] = \
            purchase_amount
        return self.get_specific_tax_by_address_endpoint.call_with_http_info(**kwargs)

    def get_specific_tax_by_location(
        self,
        tax_rate_type_id,
        latitude,
        longitude,
        purchase_amount,
        **kwargs
    ):
        """Get Tax By Location  # noqa: E501

        This service calculates and returns tax applicable at a specific location. Longitude, latitude, purchase amount and supported tax rate type are inputs to the service.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_specific_tax_by_location(tax_rate_type_id, latitude, longitude, purchase_amount, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str): The tax rate id
            latitude (str): Latitude of the location
            longitude (str): Longitude of the location
            purchase_amount (str): The amount on which tax to be calculated

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxRateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['latitude'] = \
            latitude
        kwargs['longitude'] = \
            longitude
        kwargs['purchase_amount'] = \
            purchase_amount
        return self.get_specific_tax_by_location_endpoint.call_with_http_info(**kwargs)

    def get_specific_tax_rate_by_address(
        self,
        tax_rate_type_id,
        address,
        **kwargs
    ):
        """Get Taxrate By Address  # noqa: E501

        Retrieves tax rates applicable to a specific address. This service accepts address and supported tax rate type as inputs to retrieve applicable tax rates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_specific_tax_rate_by_address(tax_rate_type_id, address, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str): The tax rate id
            address (str): The address to be searched.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxRateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['address'] = \
            address
        return self.get_specific_tax_rate_by_address_endpoint.call_with_http_info(**kwargs)

    def get_specific_tax_rate_by_location(
        self,
        tax_rate_type_id,
        latitude,
        longitude,
        **kwargs
    ):
        """Get Taxrate By Location  # noqa: E501

        Retrieves tax rates applicable to a specific location. This service accepts longitude, latitude and supported tax rate type as inputs to retrieve applicable tax rates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_specific_tax_rate_by_location(tax_rate_type_id, latitude, longitude, async_req=True)
        >>> result = thread.get()

        Args:
            tax_rate_type_id (str): The tax rate id
            latitude (str): Latitude of the location
            longitude (str): Longitude of the location

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaxRateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tax_rate_type_id'] = \
            tax_rate_type_id
        kwargs['latitude'] = \
            latitude
        kwargs['longitude'] = \
            longitude
        return self.get_specific_tax_rate_by_location_endpoint.call_with_http_info(**kwargs)

