"""
    Precisely APIs

    Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.  # noqa: E501

    The version of the OpenAPI document: 12.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from com.precisely.apis.api_client import ApiClient, Endpoint as _Endpoint
from com.precisely.apis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from com.precisely.apis.model.error_info import ErrorInfo
from com.precisely.apis.model.geocode_request import GeocodeRequest
from com.precisely.apis.model.geocode_service_response import GeocodeServiceResponse
from com.precisely.apis.model.geocode_service_response_list import GeocodeServiceResponseList
from com.precisely.apis.model.key_lookup_request import KeyLookupRequest
from com.precisely.apis.model.pb_key_address_request import PBKeyAddressRequest
from com.precisely.apis.model.pb_key_response import PBKeyResponse
from com.precisely.apis.model.pb_key_response_list import PBKeyResponseList
from com.precisely.apis.model.reverse_geocode_request import ReverseGeocodeRequest


class GeocodeServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.geocode_endpoint = _Endpoint(
            settings={
                'response_type': (GeocodeServiceResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/{datapackBundle}/geocode',
                'operation_id': 'geocode',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'datapack_bundle',
                    'country',
                    'main_address',
                    'match_mode',
                    'fallback_geo',
                    'fallback_postal',
                    'max_cands',
                    'street_offset',
                    'street_offset_units',
                    'corner_offset',
                    'corner_offset_units',
                    'remove_accent_marks',
                ],
                'required': [
                    'datapack_bundle',
                ],
                'nullable': [
                ],
                'enum': [
                    'datapack_bundle',
                    'match_mode',
                    'street_offset_units',
                    'corner_offset_units',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('datapack_bundle',): {

                        "PREMIUM": "premium",
                        "BASIC": "basic",
                        "ADVANCED": "advanced"
                    },
                    ('match_mode',): {

                        "EXACT": "Exact",
                        "STANDARD": "Standard",
                        "RELAXED": "Relaxed",
                        "CUSTOM": "Custom",
                        "INTERACTIVE(USA_ONLY)": "Interactive(USA Only)",
                        "CASS(USA_ONLY)": "CASS(USA Only)"
                    },
                    ('street_offset_units',): {

                        "METERS": "METERS",
                        "FEET": "FEET"
                    },
                    ('corner_offset_units',): {

                        "METERS": "METERS",
                        "FEET": "FEET"
                    },
                },
                'openapi_types': {
                    'datapack_bundle':
                        (str,),
                    'country':
                        (str,),
                    'main_address':
                        (str,),
                    'match_mode':
                        (str,),
                    'fallback_geo':
                        (str,),
                    'fallback_postal':
                        (str,),
                    'max_cands':
                        (str,),
                    'street_offset':
                        (str,),
                    'street_offset_units':
                        (str,),
                    'corner_offset':
                        (str,),
                    'corner_offset_units':
                        (str,),
                    'remove_accent_marks':
                        (str,),
                },
                'attribute_map': {
                    'datapack_bundle': 'datapackBundle',
                    'country': 'country',
                    'main_address': 'mainAddress',
                    'match_mode': 'matchMode',
                    'fallback_geo': 'fallbackGeo',
                    'fallback_postal': 'fallbackPostal',
                    'max_cands': 'maxCands',
                    'street_offset': 'streetOffset',
                    'street_offset_units': 'streetOffsetUnits',
                    'corner_offset': 'cornerOffset',
                    'corner_offset_units': 'cornerOffsetUnits',
                    'remove_accent_marks': 'removeAccentMarks',
                },
                'location_map': {
                    'datapack_bundle': 'path',
                    'country': 'query',
                    'main_address': 'query',
                    'match_mode': 'query',
                    'fallback_geo': 'query',
                    'fallback_postal': 'query',
                    'max_cands': 'query',
                    'street_offset': 'query',
                    'street_offset_units': 'query',
                    'corner_offset': 'query',
                    'corner_offset_units': 'query',
                    'remove_accent_marks': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.geocode_batch_endpoint = _Endpoint(
            settings={
                'response_type': (GeocodeServiceResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/{datapackBundle}/geocode',
                'operation_id': 'geocode_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'datapack_bundle',
                    'geocode_request',
                ],
                'required': [
                    'datapack_bundle',
                    'geocode_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'datapack_bundle':
                        (str,),
                    'geocode_request':
                        (GeocodeRequest,),
                },
                'attribute_map': {
                    'datapack_bundle': 'datapackBundle',
                },
                'location_map': {
                    'datapack_bundle': 'path',
                    'geocode_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_pb_key_endpoint = _Endpoint(
            settings={
                'response_type': (PBKeyResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/key/byaddress',
                'operation_id': 'get_pb_key',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'country',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'country':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'country': 'country',
                },
                'location_map': {
                    'address': 'query',
                    'country': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_pb_keys_endpoint = _Endpoint(
            settings={
                'response_type': (PBKeyResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/key/byaddress',
                'operation_id': 'get_pb_keys',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'pb_key_address_request',
                ],
                'required': [
                    'pb_key_address_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'pb_key_address_request':
                        (PBKeyAddressRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'pb_key_address_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.key_lookup_endpoint = _Endpoint(
            settings={
                'response_type': (GeocodeServiceResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/keylookup',
                'operation_id': 'key_lookup',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'key',
                    'type',
                    'country',
                ],
                'required': [
                    'key',
                    'type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'key':
                        (str,),
                    'type':
                        (str,),
                    'country':
                        (str,),
                },
                'attribute_map': {
                    'key': 'key',
                    'type': 'type',
                    'country': 'country',
                },
                'location_map': {
                    'key': 'query',
                    'type': 'query',
                    'country': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.key_lookup_batch_endpoint = _Endpoint(
            settings={
                'response_type': (GeocodeServiceResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/keylookup',
                'operation_id': 'key_lookup_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'key_lookup_request',
                ],
                'required': [
                    'key_lookup_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'key_lookup_request':
                        (KeyLookupRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'key_lookup_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.reverse_geocod_batch_endpoint = _Endpoint(
            settings={
                'response_type': (GeocodeServiceResponseList,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/{datapackBundle}/reverseGeocode',
                'operation_id': 'reverse_geocod_batch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'datapack_bundle',
                    'reverse_geocode_request',
                ],
                'required': [
                    'datapack_bundle',
                    'reverse_geocode_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'datapack_bundle':
                        (str,),
                    'reverse_geocode_request':
                        (ReverseGeocodeRequest,),
                },
                'attribute_map': {
                    'datapack_bundle': 'datapackBundle',
                },
                'location_map': {
                    'datapack_bundle': 'path',
                    'reverse_geocode_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json',
                    'application/xml'
                ]
            },
            api_client=api_client
        )
        self.reverse_geocode_endpoint = _Endpoint(
            settings={
                'response_type': (GeocodeServiceResponse,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/geocode/v1/{datapackBundle}/reverseGeocode',
                'operation_id': 'reverse_geocode',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'datapack_bundle',
                    'x',
                    'y',
                    'country',
                    'coord_sys_name',
                    'distance',
                    'distance_units',
                ],
                'required': [
                    'datapack_bundle',
                    'x',
                    'y',
                ],
                'nullable': [
                ],
                'enum': [
                    'datapack_bundle',
                    'distance_units',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('datapack_bundle',): {

                        "PREMIUM": "premium",
                        "BASIC": "basic",
                        "ADVANCED": "advanced"
                    },
                    ('distance_units',): {

                        "METERS": "METERS",
                        "FEET": "FEET"
                    },
                },
                'openapi_types': {
                    'datapack_bundle':
                        (str,),
                    'x':
                        (str,),
                    'y':
                        (str,),
                    'country':
                        (str,),
                    'coord_sys_name':
                        (str,),
                    'distance':
                        (str,),
                    'distance_units':
                        (str,),
                },
                'attribute_map': {
                    'datapack_bundle': 'datapackBundle',
                    'x': 'x',
                    'y': 'y',
                    'country': 'country',
                    'coord_sys_name': 'coordSysName',
                    'distance': 'distance',
                    'distance_units': 'distanceUnits',
                },
                'location_map': {
                    'datapack_bundle': 'path',
                    'x': 'query',
                    'y': 'query',
                    'country': 'query',
                    'coord_sys_name': 'query',
                    'distance': 'query',
                    'distance_units': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def geocode(
        self,
        datapack_bundle,
        **kwargs
    ):
        """Get Forward Geocode(Basic/Premium/Advanced)  # noqa: E501

        This service accepts an address and returns the location coordinates corresponding to that address. Premium offers the best accuracy and is a high precision geocoder leveraging Master Location Data - geocodes to Street or building level. Advanced offers advanced accuracy and geocodes to Street level.Basic offering will geocode to a Place or Postal level. Good accuracy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.geocode(datapack_bundle, async_req=True)
        >>> result = thread.get()

        Args:
            datapack_bundle (str): datapackBundle

        Keyword Args:
            country (str): Country name or ISO code.. [optional] if omitted the server will use the default value of "USA"
            main_address (str): Single line input, treated as collection of field elements.. [optional] if omitted the server will use the default value of "4750 Walnut St., Boulder CO, 80301"
            match_mode (str): Match modes determine the leniency used to make a match between the input address and the reference data.. [optional] if omitted the server will use the default value of "Standard"
            fallback_geo (str): Specifies whether to attempt to determine a geographic region centroid when an address-level geocode cannot be determined.. [optional] if omitted the server will use the default value of "true"
            fallback_postal (str): Specifies whether to attempt to determine a post code centroid when an address-level geocode cannot be determined.. [optional] if omitted the server will use the default value of "true"
            max_cands (str): The maximum number of candidates to return.. [optional] if omitted the server will use the default value of "1"
            street_offset (str): Indicates the offset distance from the street segments to use in street-level geocoding.. [optional] if omitted the server will use the default value of "7"
            street_offset_units (str): Specifies the unit of measurement for the street offset.. [optional] if omitted the server will use the default value of "METERS"
            corner_offset (str): Specifies the distance to offset the street end points in street-level matching.. [optional] if omitted the server will use the default value of "7"
            corner_offset_units (str): Specifies the unit of measurement for the corner offset.. [optional] if omitted the server will use the default value of "METERS"
            remove_accent_marks (str): Specifies whether to Suppress accents and other diacritical marks.. [optional] if omitted the server will use the default value of "false"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GeocodeServiceResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['datapack_bundle'] = \
            datapack_bundle
        return self.geocode_endpoint.call_with_http_info(**kwargs)

    def geocode_batch(
        self,
        datapack_bundle,
        geocode_request,
        **kwargs
    ):
        """Post Forward Geocode  # noqa: E501

        This is a Batch offering for geocode service. It accepts a single address or a list of addresses and returns location coordinates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.geocode_batch(datapack_bundle, geocode_request, async_req=True)
        >>> result = thread.get()

        Args:
            datapack_bundle (str):
            geocode_request (GeocodeRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GeocodeServiceResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['datapack_bundle'] = \
            datapack_bundle
        kwargs['geocode_request'] = \
            geocode_request
        return self.geocode_batch_endpoint.call_with_http_info(**kwargs)

    def get_pb_key(
        self,
        address,
        **kwargs
    ):
        """Get PreciselyID By Address  # noqa: E501

        This service accepts an address and returns the corresponding PreciselyID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pb_key(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): The address to be searched.

        Keyword Args:
            country (str): 3 letter ISO code of the country to be searched.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PBKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_pb_key_endpoint.call_with_http_info(**kwargs)

    def get_pb_keys(
        self,
        pb_key_address_request,
        **kwargs
    ):
        """Post PreciselyID By Address  # noqa: E501

        This is a Batch offering for 'PreciselyID By Address' service. It accepts a single address or a list of addresses and returns the corresponding PreciselyID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pb_keys(pb_key_address_request, async_req=True)
        >>> result = thread.get()

        Args:
            pb_key_address_request (PBKeyAddressRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PBKeyResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['pb_key_address_request'] = \
            pb_key_address_request
        return self.get_pb_keys_endpoint.call_with_http_info(**kwargs)

    def key_lookup(
        self,
        key,
        type,
        **kwargs
    ):
        """Get Key Lookup  # noqa: E501

        This service accepts a PreciselyID and returns the corresponding address associated with that PreciselyID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.key_lookup(key, type, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): PreciselyID which maps to a unique address.
            type (str): Specifies the key type - PreciselyID and GNAF_PID for Aus.

        Keyword Args:
            country (str): 3 letter ISO code of the country to be searched.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GeocodeServiceResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['key'] = \
            key
        kwargs['type'] = \
            type
        return self.key_lookup_endpoint.call_with_http_info(**kwargs)

    def key_lookup_batch(
        self,
        key_lookup_request,
        **kwargs
    ):
        """Post Key Lookup  # noqa: E501

        This service accepts batches of PreciselyID's and returns the corresponding address associated with those PreciselyID's.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.key_lookup_batch(key_lookup_request, async_req=True)
        >>> result = thread.get()

        Args:
            key_lookup_request (KeyLookupRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GeocodeServiceResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['key_lookup_request'] = \
            key_lookup_request
        return self.key_lookup_batch_endpoint.call_with_http_info(**kwargs)

    def reverse_geocod_batch(
        self,
        datapack_bundle,
        reverse_geocode_request,
        **kwargs
    ):
        """Post Reverse Geocode  # noqa: E501

        This is a Batch offering for geocode service. It accepts a single address or a list of addresses and returns location coordinates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reverse_geocod_batch(datapack_bundle, reverse_geocode_request, async_req=True)
        >>> result = thread.get()

        Args:
            datapack_bundle (str):
            reverse_geocode_request (ReverseGeocodeRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GeocodeServiceResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['datapack_bundle'] = \
            datapack_bundle
        kwargs['reverse_geocode_request'] = \
            reverse_geocode_request
        return self.reverse_geocod_batch_endpoint.call_with_http_info(**kwargs)

    def reverse_geocode(
        self,
        datapack_bundle,
        x="-105.240976",
        y="40.018301",
        **kwargs
    ):
        """Get Reverse Geocode(Basic/Premium/Advanced)  # noqa: E501

        This service accepts location coordinate and returns an address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reverse_geocode(datapack_bundle, x="-105.240976", y="40.018301", async_req=True)
        >>> result = thread.get()

        Args:
            datapack_bundle (str): datapackBundle
            x (str): Longitude of the location.. defaults to "-105.240976", must be one of ["-105.240976"]
            y (str): Latitude of the location.. defaults to "40.018301", must be one of ["40.018301"]

        Keyword Args:
            country (str): Country name or ISO code.. [optional]
            coord_sys_name (str): Coordinate system to convert geometry to in format codespace:code.. [optional] if omitted the server will use the default value of "EPSG:4326"
            distance (str): Radius in which search is performed.. [optional] if omitted the server will use the default value of "Radius in which search is performed."
            distance_units (str): Unit of measurement.. [optional] if omitted the server will use the default value of "METERS"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GeocodeServiceResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['datapack_bundle'] = \
            datapack_bundle
        kwargs['x'] = \
            x
        kwargs['y'] = \
            y
        return self.reverse_geocode_endpoint.call_with_http_info(**kwargs)

