"""
    Precisely APIs

    Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.  # noqa: E501

    The version of the OpenAPI document: 12.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from com.precisely.apis.api_client import ApiClient, Endpoint as _Endpoint
from com.precisely.apis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from com.precisely.apis.model.demographics import Demographics
from com.precisely.apis.model.demographics_advanced_request import DemographicsAdvancedRequest
from com.precisely.apis.model.error_info import ErrorInfo
from com.precisely.apis.model.segmentation import Segmentation


class DemographicsServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_demographics_advanced_endpoint = _Endpoint(
            settings={
                'response_type': (Demographics,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/demographics-segmentation/v1/advanced/demographics',
                'operation_id': 'get_demographics_advanced',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'demographics_advanced_request',
                ],
                'required': [
                    'demographics_advanced_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'demographics_advanced_request':
                        (DemographicsAdvancedRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'demographics_advanced_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_demographics_basic_endpoint = _Endpoint(
            settings={
                'response_type': (Demographics,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/demographics-segmentation/v1/basic/demographics',
                'operation_id': 'get_demographics_basic',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'longitude',
                    'latitude',
                    'search_radius',
                    'search_radius_unit',
                    'travel_time',
                    'travel_time_unit',
                    'travel_distance',
                    'travel_distance_unit',
                    'travel_mode',
                    'country',
                    'profile',
                    'filter',
                    'include_geometry',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'search_radius':
                        (str,),
                    'search_radius_unit':
                        (str,),
                    'travel_time':
                        (str,),
                    'travel_time_unit':
                        (str,),
                    'travel_distance':
                        (str,),
                    'travel_distance_unit':
                        (str,),
                    'travel_mode':
                        (str,),
                    'country':
                        (str,),
                    'profile':
                        (str,),
                    'filter':
                        (str,),
                    'include_geometry':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'search_radius': 'searchRadius',
                    'search_radius_unit': 'searchRadiusUnit',
                    'travel_time': 'travelTime',
                    'travel_time_unit': 'travelTimeUnit',
                    'travel_distance': 'travelDistance',
                    'travel_distance_unit': 'travelDistanceUnit',
                    'travel_mode': 'travelMode',
                    'country': 'country',
                    'profile': 'profile',
                    'filter': 'filter',
                    'include_geometry': 'includeGeometry',
                },
                'location_map': {
                    'address': 'query',
                    'longitude': 'query',
                    'latitude': 'query',
                    'search_radius': 'query',
                    'search_radius_unit': 'query',
                    'travel_time': 'query',
                    'travel_time_unit': 'query',
                    'travel_distance': 'query',
                    'travel_distance_unit': 'query',
                    'travel_mode': 'query',
                    'country': 'query',
                    'profile': 'query',
                    'filter': 'query',
                    'include_geometry': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_demographics_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (Demographics,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/demographics-segmentation/v1/demographics/byaddress',
                'operation_id': 'get_demographics_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'country',
                    'profile',
                    'filter',
                    'value_format',
                    'variable_level',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'country':
                        (str,),
                    'profile':
                        (str,),
                    'filter':
                        (str,),
                    'value_format':
                        (str,),
                    'variable_level':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'country': 'country',
                    'profile': 'profile',
                    'filter': 'filter',
                    'value_format': 'valueFormat',
                    'variable_level': 'variableLevel',
                },
                'location_map': {
                    'address': 'query',
                    'country': 'query',
                    'profile': 'query',
                    'filter': 'query',
                    'value_format': 'query',
                    'variable_level': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_demographics_by_boundary_ids_endpoint = _Endpoint(
            settings={
                'response_type': (Demographics,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/demographics-segmentation/v1/demographics/byboundaryids',
                'operation_id': 'get_demographics_by_boundary_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'boundary_ids',
                    'profile',
                    'filter',
                    'value_format',
                    'variable_level',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'boundary_ids':
                        (str,),
                    'profile':
                        (str,),
                    'filter':
                        (str,),
                    'value_format':
                        (str,),
                    'variable_level':
                        (str,),
                },
                'attribute_map': {
                    'boundary_ids': 'boundaryIds',
                    'profile': 'profile',
                    'filter': 'filter',
                    'value_format': 'valueFormat',
                    'variable_level': 'variableLevel',
                },
                'location_map': {
                    'boundary_ids': 'query',
                    'profile': 'query',
                    'filter': 'query',
                    'value_format': 'query',
                    'variable_level': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_demographics_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (Demographics,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/demographics-segmentation/v1/demographics/bylocation',
                'operation_id': 'get_demographics_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                    'profile',
                    'filter',
                    'value_format',
                    'variable_level',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                    'profile':
                        (str,),
                    'filter':
                        (str,),
                    'value_format':
                        (str,),
                    'variable_level':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                    'profile': 'profile',
                    'filter': 'filter',
                    'value_format': 'valueFormat',
                    'variable_level': 'variableLevel',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                    'profile': 'query',
                    'filter': 'query',
                    'value_format': 'query',
                    'variable_level': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_segmentation_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (Segmentation,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/demographics-segmentation/v1/segmentation/byaddress',
                'operation_id': 'get_segmentation_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'address',
                    'country',
                ],
                'required': [
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'address':
                        (str,),
                    'country':
                        (str,),
                },
                'attribute_map': {
                    'address': 'address',
                    'country': 'country',
                },
                'location_map': {
                    'address': 'query',
                    'country': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_segmentation_by_location_endpoint = _Endpoint(
            settings={
                'response_type': (Segmentation,),
                'auth': [
                    'oAuth2Password'
                ],
                'endpoint_path': '/demographics-segmentation/v1/segmentation/bylocation',
                'operation_id': 'get_segmentation_by_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'longitude',
                    'latitude',
                ],
                'required': [
                    'longitude',
                    'latitude',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'longitude':
                        (str,),
                    'latitude':
                        (str,),
                },
                'attribute_map': {
                    'longitude': 'longitude',
                    'latitude': 'latitude',
                },
                'location_map': {
                    'longitude': 'query',
                    'latitude': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/xml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_demographics_advanced(
        self,
        demographics_advanced_request,
        **kwargs
    ):
        """Demographics Advanced Endpoint  # noqa: E501

        Demographics Advanced Endpoint will return the aggregated values of the selected demographics variables of the regions falling inside a user provided geometry or travel time/distance boundaries. All the intersecting demographic boundaries will be snapped completely, and user will have option to request these boundaries in response.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_demographics_advanced(demographics_advanced_request, async_req=True)
        >>> result = thread.get()

        Args:
            demographics_advanced_request (DemographicsAdvancedRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Demographics
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['demographics_advanced_request'] = \
            demographics_advanced_request
        return self.get_demographics_advanced_endpoint.call_with_http_info(**kwargs)

    def get_demographics_basic(
        self,
        **kwargs
    ):
        """Demographics Basic  # noqa: E501

        Demographics Basic Endpoint will return the aggregated values of the selected demographics variables of the regions falling inside the search radius. All the intersecting demographic boundaries will be snapped completely and user will have option to request these boundaries in response.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_demographics_basic(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            address (str): Address to be searched. [optional]
            longitude (str): Longitude of the location. [optional]
            latitude (str): Latitude of the location. [optional]
            search_radius (str): Radius within which demographics details are required. Max. value is 52800 Feet or 10 miles. [optional]
            search_radius_unit (str): Radius unit such as Feet, Kilometers, Miles or Meters . [optional]
            travel_time (str): Travel Time based on ‘travelMode’ within which demographics details are required. Max. value is 1 hour.. [optional]
            travel_time_unit (str): minutes,hours,seconds,milliseconds. Default is meters.Default is minutes.. [optional]
            travel_distance (str): Travel Distance based on ‘travelMode’ within which demographics details are required. Max. value is 10 miles.. [optional]
            travel_distance_unit (str): feet,kilometers,miles,meters.  Default is feet.. [optional]
            travel_mode (str): Default is driving.. [optional]
            country (str): 3 digit ISO country code (Used in case address is mentioned).. [optional]
            profile (str): Applicable on ranged variables. Returns top sorted result based on the input value.. [optional]
            filter (str): If Y, demographic boundaries are returned in response.. [optional]
            include_geometry (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Demographics
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_demographics_basic_endpoint.call_with_http_info(**kwargs)

    def get_demographics_by_address(
        self,
        address,
        **kwargs
    ):
        """Demographics By Address.  # noqa: E501

        Provides the demographic details around a specified address. GeoLife 'byaddress' service accepts address as an input to return a specific population segment's age group, ethnicity, income, purchasing behaviour, commuter patterns and more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_demographics_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): The address to be searched.

        Keyword Args:
            country (str): 3 letter ISO code of the country to be searched.Allowed values USA,CAN,GBR,AUS.. [optional]
            profile (str): Retrieves the sorted demographic data on the basis of pre-defined profiles that can display the top 3 or top 5 results (by location) either in ascending or descending order.Allowed values Top5Ascending,Top5Descending,Top3Ascending,Top3Descending. [optional]
            filter (str): The 'filter' parameter retrieves the demographic data based upon specified input themes.. [optional]
            value_format (str): The 'valueFormat' parameter is applicable for few ranged variables where percent & count both are available and filter response based on the input value.. [optional]
            variable_level (str): The 'variableLevel' retrieves demographic facts in response based on the input value. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Demographics
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_demographics_by_address_endpoint.call_with_http_info(**kwargs)

    def get_demographics_by_boundary_ids(
        self,
        **kwargs
    ):
        """Demographics By Boundaryids.  # noqa: E501

        This endpoint will allow the user to request demographics details by census boundary id. Multiple comma separated boundary ids will be accepted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_demographics_by_boundary_ids(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            boundary_ids (str): Accepts comma separated multiple boundary ids.. [optional]
            profile (str): Applicable on ranged variables. Returns top sorted result based on the input value.. [optional]
            filter (str): Accept the comma separated theme names and filter response based on value. Maximum 10 can be provided.. [optional]
            value_format (str): Applicable for few ranged variables where percent & count both are available and filter response based on the input value.. [optional]
            variable_level (str): Retrieves demographic facts in response based on the input value.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Demographics
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_demographics_by_boundary_ids_endpoint.call_with_http_info(**kwargs)

    def get_demographics_by_location(
        self,
        **kwargs
    ):
        """Demographics By Location.  # noqa: E501

        Provides the demographic details around a specified location. GeoLife 'bylocation' service accepts longitude and latitude as an input to return a specific population segment's age group, ethnicity, income, purchasing behaviour, commuter patterns and more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_demographics_by_location(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            longitude (str): Longitude of the location.. [optional]
            latitude (str): Latitude of the location.. [optional]
            profile (str): Retrieves the sorted demographic data on the basis of pre-defined profiles that can display the top 3 or top 5 results (by location) either in ascending or descending order.Allowed values Top5Ascending,Top5Descending,Top3Ascending,Top3Descending. [optional]
            filter (str): The 'filter' parameter retrieves the demographic data based upon specified input themes.. [optional]
            value_format (str): The 'valueFormat' parameter is applicable for few ranged variables where percent & count both are available and filter response based on the input value.. [optional]
            variable_level (str): The 'variableLevel' retrieves demographic facts in response based on the input value. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Demographics
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_demographics_by_location_endpoint.call_with_http_info(**kwargs)

    def get_segmentation_by_address(
        self,
        address,
        **kwargs
    ):
        """Segmentation By Address.  # noqa: E501

        Provides the segmentation details around a specified address. GeoLife 'Segmentation by Address' service accepts address as an input to return the lifestyle characteristics of households in terms of their family status, children characteristics, income behaviors, financial preferences and interests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_segmentation_by_address(address, async_req=True)
        >>> result = thread.get()

        Args:
            address (str): The address to be searched.

        Keyword Args:
            country (str): 3 letter ISO code of the country to be searched.Allowed values USA,CAN,GBR,FRA,ITA,AUS,DEU.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Segmentation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['address'] = \
            address
        return self.get_segmentation_by_address_endpoint.call_with_http_info(**kwargs)

    def get_segmentation_by_location(
        self,
        longitude,
        latitude,
        **kwargs
    ):
        """Segmentation By Location.  # noqa: E501

        Provides the segmentation details around a specified location. GeoLife 'segmentation bylocation' service accepts longitude and latitude as an input to return the lifestyle characteristics of households in terms of their family status, children characteristics, income behaviors, financial preferences and interests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_segmentation_by_location(longitude, latitude, async_req=True)
        >>> result = thread.get()

        Args:
            longitude (str): Longitude of the location.
            latitude (str): Latitude of the location.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Segmentation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['longitude'] = \
            longitude
        kwargs['latitude'] = \
            latitude
        return self.get_segmentation_by_location_endpoint.call_with_http_info(**kwargs)

