![Precisely](/precisely_logo_purple.jpg)

# Precisely APIs

### Description
[Precisely APIs ](https://developer.precisely.com/) Enrich your data, and enhance your applications, business processes and workflows with dozens of powerful location & identity APIs.

### Precisely APIs:

* [Geocode](https://developer.precisely.com/apis/geocode): Accurate Geocoding. Convert individual or batch collections of addresses to latitude & longitude coordinates and vice versa. Useful for enhancing & enriching your customer addresses.


* [Address Autocomplete](https://developer.precisely.com/apis/typeahead): Address Autocomplete. Build Address Autocomplete into your websites. The Address Autocomplete API returns an autocompleted list of addresses based on the input of a partial address. Useful for any local search, checkout, shipping, or billing experiences on your website. Increase e-commerce conversion by 3-6%!


* [Maps](https://developer.precisely.com/apis/maps): Beautiful Visualization. Add your data and/or Precisely data atop beautiful maps for visualizations. Choose from three map styles - Bronze, Iron, and Steel.


* [Zones](https://developer.precisely.com/apis/zones): Smart Zones. The Zones API returns geographic zones by Radius, Drive Distance, Drive Time and highly localized geofence zones with the input of Location Coordinates or Addresses. Useful for anyone wanting to create smarter geofence zones for Local Engagement and Analysis.


* [Routing](https://developer.precisely.com/apis/routing): Accurate Routing. The Routing API returns Point-to-Point and Multi-Point Travel Directions by Various Travel Modes. Critical for any Simple or Complex Routing Requirement.


* [Streets](https://developer.precisely.com/apis/streets): Global Street Information. Enrich your applications, business processes, and workflows with global street information including nearest intersections and speed limits. The Streets API accepts an address or location and returns nearest intersection information. The speed limit method accepts a series of locations and returns speed limits along a street segment.


* [Places](https://developer.precisely.com/apis/places) : Global Place Data. Enrich your applications, business processes, and workflows with over 180 million of global retail businesses and landmark points-of-interest. The Places API accepts multiple powerful inputs & filtering options and returns thousands of records in a single API request. The Places API also supports global typeahead place search. Useful for enriching your data and/or analytics processes with rich commercial business information and place names.


* [Risks](https://developer.precisely.com/apis/risks): Risks Insights. Capture Crime, Earthquake, Flood, Fire, Fire Station and Distance-to-Flood-Hazard risk data for Analysis, Planning, Claims, and Mitigation. The Risks API returns risk intelligence with the input of Location Coordinates or Addresses. Critical for any impact analysis involving threats to lives or property.


* [911/PSAP](https://developer.precisely.com/apis/911): Emergency call handling. Integrate Public Safety Answering Point (PSAP) administrative call routing information plus Authority Having Jurisdiction (AHJ) phone numbers into your emergency services products and services. The 911/PSAP API retrieves 10-digit phone numbers and local contact info with the input of a location coordinate. Useful for emergency services administrators, call handlers, and dispatchers.


* [Demographics](https://developer.precisely.com/apis/demographics) : Audience Enrichment. Add local demographics and lifestyle segmentation to your people profiles. The Demographics & Lifestyle API returns household demographics and lifestyle characteristics with the input of an address or location coordinate. Know more about your customers and their customers.


* [Local Tax](https://developer.precisely.com/apis/localtax): Local Tax. Add hyperlocal tax rates to your applications, business processes, and workflows. The Local Tax API returns local tax rates with the input of location coordinates or addresses. Critical for any billing, commerce, payment, or payroll application or service.


* [Telecomm Info](https://developer.precisely.com/apis/telecomm): Service Provider Intelligence. Identify Local Exchange Carrier presence, area codes, exchanges, and more within a Rate Center area. The Telecomm Info API retrieves Incumbent Local Exchange Carrier (ILEC) doing-business-as names along with NPA/NXX, LATA, and phone number ranges with the input of an address or location coordinates. Useful for local telecommunications competitive intelligence, partnerships, and provisioning subscribers.


* [Time Zone](https://developer.precisely.com/apis/timezone): Local time. The Time Zone API returns time zones and UTC offsets with the input of a location coordinate or address. Useful for do-not-call, logistics, and customer engagement applications, business processes and workflows.


* [Geolocation](https://developer.precisely.com/apis/geolocation): Device Location. The Geolocation API returns location coordinates based on the input of an IP Address or Wi-Fi Access point MAC address. Useful for a variety of applications, business processes and workflows in eCommerce, Fraud Detection, Physical-Digital interactions, Field Service and more.


* [Schools](https://developer.precisely.com/apis/schools): School Listings. Gather local multiple school listings, types, districts and education levels for your applications. The Schools API accepts multiple powerful inputs & geographic filtering options and returns nearby school listings and additional data a single API request. Useful for enriching your applications and websites.


* [Neighborhoods](https://developer.precisely.com/apis/neighborhoods): Neighborhood Insights. Integrate global neighborhood names and classification information into your applications and enrich other data. The Neighborhood API accepts latitude & longitude coordinates and returns the corresponding neighborhood name & type. Useful for a wide range of data enrichment use cases.


* [Property Information](https://developer.precisely.com/apis/property): Property Insights. Integrate extensive residential & commercial property information into your applications. The Property Information API returns key property attributes for millions of US properties with the input of Location Coordinates or Addresses. Useful for Real Estate use cases or those involving risk assessments.


* [Address Verification](https://developer.precisely.com/apis/addressverification): Real, accurate and complete address. Eliminate errors in address data, improve customer experience. The Address Verification API makes communication easier, faster and effortless by enriching customer details, keeping it up-to-date and maintaining its accuracy and consistency. It eliminates redundancy in reaching out to customers and makes it easy for distinct functional areas to work seamlessly in improving customer relationship.


* [Email Verification](https://developer.precisely.com/apis/emailverification): Email address validation and protection. The Email Verification API corrects and validates your email addresses to protect your database from invalid, toxic and undesirable email addresses. We help you avoid a damaged sender reputations by flagging those bouncing emails, spam trap hits, honeypots, stale lists and do-not-contact list before you have a chance to use them.


* [Addresses](https://developer.precisely.com/apis/addresses): Gather multiple Addresses if you don’t have them and use these to query all other Precisely APIs. The Addresses API accepts names of a boundary such as zip code, neighborhood, county, and city—as well as your custom geographic boundaries or drivetimes & drive distances—and returns all known & valid Addresses associated with these names, or Addresses contained with the supplied or chosen geographic boundary.


* [Phone Verification](https://developer.precisely.com/apis/phoneverification): The Phone Verification API accepts any phone number as input and returns verification information, Service Provider name, and more. Useful to verify if phone numbers exist to reduce fraud and improve communications.

The following platforms are supported by Precisely SDKs:
*	[Android](https://docs.precisely.com/docs/sftw/precisely-apis/main/en-us/webhelp/apis/Android%20SDK/android_intro.html)
*	[NodeJS](https://docs.precisely.com/docs/sftw/precisely-apis/main/en-us/webhelp/apis/NodeJS/node.js_sdk.html) 
*	[iOS](https://docs.precisely.com/docs/sftw/precisely-apis/main/en-us/webhelp/apis/iOS%20SDK/ios_intro.html)
*	[Java](https://docs.precisely.com/docs/sftw/precisely-apis/main/en-us/webhelp/apis/Java%20SDK/java_intro.html)
*	[C#](https://docs.precisely.com/docs/sftw/precisely-apis/main/en-us/webhelp/apis/C_sdk/java_intro.html)
*   [Python ](https://docs.precisely.com/docs/sftw/precisely-apis/main/en-us/webhelp/apis/Python%20SDK/PythonSdk.html)


[Click here](https://docs.precisely.com/docs/sftw/precisely-apis/main/en-us/webhelp/apis/About%20Document/about_this_doc.html) for detailed Documentation on Precisely APIs 
# PreciselyAPIsPythonSDK
Enhance & enrich your data, applications, business processes, and workflows with rich location, information, and identify APIs.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 12.0.1
- Package version: 12.0.1

- Build package: org.openapitools.codegen.languages.PythonClientCodegen

For more information, please visit [https://support.precisely.com](https://support.precisely.com)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install com.precisely.apis
```

Then import the package:
```python
import com.precisely.apis
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import com.precisely.apis
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from com.precisely.apis.api.address_autocomplete_service_api import AddressAutocompleteServiceApi
from com.precisely.apis.exceptions import ApiException


def addressAutocompleteExample():
    api = AddressAutocompleteServiceApi()
    api.api_client.oAuthApiKey = "PUT_YOUR_KEY_HERE"
    api.api_client.oAuthSecret = "PUT_YOUR_SECRET_HERE"
    api.api_client.generateAndSetToken()
    try:
        response = api.search_v2("times sq", country="usa")
        print(response)
    except ApiException as e:
        print(e.body)


if __name__ == "__main__":
    addressAutocompleteExample()

```

## Documentation for API Endpoints

All URIs are relative to *https://api.precisely.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AddressAutocompleteServiceApi* | [**search_v2**](docs/AddressAutocompleteServiceApi.md#search_v2) | **GET** /typeahead/v1/locations | Address Autocomplete Search
*AddressVerificationServiceApi* | [**get_city_state_province**](docs/AddressVerificationServiceApi.md#get_city_state_province) | **POST** /addressverification/v1/getcitystateprovince/results.json | GetCityStateProvince
*AddressVerificationServiceApi* | [**get_postal_codes**](docs/AddressVerificationServiceApi.md#get_postal_codes) | **POST** /addressverification/v1/getpostalcodes/results.json | GetPostalCodes
*AddressVerificationServiceApi* | [**validate_mailing_address**](docs/AddressVerificationServiceApi.md#validate_mailing_address) | **POST** /addressverification/v1/validatemailingaddress/results.json | ValidateMailingAddress
*AddressVerificationServiceApi* | [**validate_mailing_address_premium**](docs/AddressVerificationServiceApi.md#validate_mailing_address_premium) | **POST** /addressverification/v1/validatemailingaddresspremium/results.json | ValidateMailingAddressPremium
*AddressVerificationServiceApi* | [**validate_mailing_address_pro**](docs/AddressVerificationServiceApi.md#validate_mailing_address_pro) | **POST** /addressverification/v1/validatemailingaddresspro/results.json | ValidateMailingAddressPro
*AddressVerificationServiceApi* | [**validate_mailing_address_uscan**](docs/AddressVerificationServiceApi.md#validate_mailing_address_uscan) | **POST** /addressverification/v1/validatemailingaddressuscan/results.json | ValidateMailingAddressUSCAN
*AddressesServiceApi* | [**get_addresses_count_by_boundary_name**](docs/AddressesServiceApi.md#get_addresses_count_by_boundary_name) | **GET** /addresses/v1/addresscount/byboundaryname | Addresses Count by Boundary Name.
*AddressesServiceApi* | [**get_addresses_countby_boundary**](docs/AddressesServiceApi.md#get_addresses_countby_boundary) | **POST** /addresses/v1/addresscount/byboundary | Addresses count by Boundary.
*AddressesServiceApi* | [**get_addressesby_boundary**](docs/AddressesServiceApi.md#get_addressesby_boundary) | **POST** /addresses/v1/address/byboundary | Addresses by Boundary.
*AddressesServiceApi* | [**get_addressesby_boundary_name**](docs/AddressesServiceApi.md#get_addressesby_boundary_name) | **GET** /addresses/v1/address/byboundaryname | Addresses by Boundary Name.
*DemographicsServiceApi* | [**get_demographics_advanced**](docs/DemographicsServiceApi.md#get_demographics_advanced) | **POST** /demographics-segmentation/v1/advanced/demographics | Demographics Advanced Endpoint
*DemographicsServiceApi* | [**get_demographics_basic**](docs/DemographicsServiceApi.md#get_demographics_basic) | **GET** /demographics-segmentation/v1/basic/demographics | Demographics Basic
*DemographicsServiceApi* | [**get_demographics_by_address**](docs/DemographicsServiceApi.md#get_demographics_by_address) | **GET** /demographics-segmentation/v1/demographics/byaddress | Demographics By Address.
*DemographicsServiceApi* | [**get_demographics_by_boundary_ids**](docs/DemographicsServiceApi.md#get_demographics_by_boundary_ids) | **GET** /demographics-segmentation/v1/demographics/byboundaryids | Demographics By Boundaryids.
*DemographicsServiceApi* | [**get_demographics_by_location**](docs/DemographicsServiceApi.md#get_demographics_by_location) | **GET** /demographics-segmentation/v1/demographics/bylocation | Demographics By Location.
*DemographicsServiceApi* | [**get_segmentation_by_address**](docs/DemographicsServiceApi.md#get_segmentation_by_address) | **GET** /demographics-segmentation/v1/segmentation/byaddress | Segmentation By Address.
*DemographicsServiceApi* | [**get_segmentation_by_location**](docs/DemographicsServiceApi.md#get_segmentation_by_location) | **GET** /demographics-segmentation/v1/segmentation/bylocation | Segmentation By Location.
*EmailVerificationServiceApi* | [**validate_email_address**](docs/EmailVerificationServiceApi.md#validate_email_address) | **POST** /emailverification/v1/validateemailaddress/results.json | ValidateEmailAddress
*GeocodeServiceApi* | [**geocode**](docs/GeocodeServiceApi.md#geocode) | **GET** /geocode/v1/{datapackBundle}/geocode | Get Forward Geocode(Basic/Premium/Advanced)
*GeocodeServiceApi* | [**geocode_batch**](docs/GeocodeServiceApi.md#geocode_batch) | **POST** /geocode/v1/{datapackBundle}/geocode | Post Forward Geocode
*GeocodeServiceApi* | [**get_pb_key**](docs/GeocodeServiceApi.md#get_pb_key) | **GET** /geocode/v1/key/byaddress | Get PreciselyID By Address
*GeocodeServiceApi* | [**get_pb_keys**](docs/GeocodeServiceApi.md#get_pb_keys) | **POST** /geocode/v1/key/byaddress | Post PreciselyID By Address
*GeocodeServiceApi* | [**key_lookup**](docs/GeocodeServiceApi.md#key_lookup) | **GET** /geocode/v1/keylookup | Get Key Lookup
*GeocodeServiceApi* | [**key_lookup_batch**](docs/GeocodeServiceApi.md#key_lookup_batch) | **POST** /geocode/v1/keylookup | Post Key Lookup
*GeocodeServiceApi* | [**reverse_geocod_batch**](docs/GeocodeServiceApi.md#reverse_geocod_batch) | **POST** /geocode/v1/{datapackBundle}/reverseGeocode | Post Reverse Geocode
*GeocodeServiceApi* | [**reverse_geocode**](docs/GeocodeServiceApi.md#reverse_geocode) | **GET** /geocode/v1/{datapackBundle}/reverseGeocode | Get Reverse Geocode(Basic/Premium/Advanced)
*GeolocationServiceApi* | [**get_location_by_ip_address**](docs/GeolocationServiceApi.md#get_location_by_ip_address) | **GET** /geolocation/v1/location/byipaddress | Location By IP Address.
*GeolocationServiceApi* | [**get_location_by_wi_fi_access_point**](docs/GeolocationServiceApi.md#get_location_by_wi_fi_access_point) | **GET** /geolocation/v1/location/byaccesspoint | Location by WiFi Access Point.
*LocalTaxServiceApi* | [**get_batch_tax_by_address**](docs/LocalTaxServiceApi.md#get_batch_tax_by_address) | **POST** /localtax/v1/tax/{taxRateTypeId}/byaddress | Post Tax By Address
*LocalTaxServiceApi* | [**get_batch_tax_by_location**](docs/LocalTaxServiceApi.md#get_batch_tax_by_location) | **POST** /localtax/v1/tax/{taxRateTypeId}/bylocation | Post Tax By Location
*LocalTaxServiceApi* | [**get_batch_tax_rate_by_address**](docs/LocalTaxServiceApi.md#get_batch_tax_rate_by_address) | **POST** /localtax/v1/taxrate/{taxRateTypeId}/byaddress | Post Taxrate By Address
*LocalTaxServiceApi* | [**get_batch_tax_rate_by_location**](docs/LocalTaxServiceApi.md#get_batch_tax_rate_by_location) | **POST** /localtax/v1/taxrate/{taxRateTypeId}/bylocation | Post Taxrate By Location
*LocalTaxServiceApi* | [**get_ipd_tax_by_address**](docs/LocalTaxServiceApi.md#get_ipd_tax_by_address) | **GET** /localtax/v1/taxdistrict/ipd/byaddress | Get IPD Tax by Address
*LocalTaxServiceApi* | [**get_ipd_tax_by_address_batch**](docs/LocalTaxServiceApi.md#get_ipd_tax_by_address_batch) | **POST** /localtax/v1/taxdistrict/ipd/byaddress | Get IPD Tax for batch requests.
*LocalTaxServiceApi* | [**get_specific_tax_by_address**](docs/LocalTaxServiceApi.md#get_specific_tax_by_address) | **GET** /localtax/v1/tax/{taxRateTypeId}/byaddress | Get Tax By Address
*LocalTaxServiceApi* | [**get_specific_tax_by_location**](docs/LocalTaxServiceApi.md#get_specific_tax_by_location) | **GET** /localtax/v1/tax/{taxRateTypeId}/bylocation | Get Tax By Location
*LocalTaxServiceApi* | [**get_specific_tax_rate_by_address**](docs/LocalTaxServiceApi.md#get_specific_tax_rate_by_address) | **GET** /localtax/v1/taxrate/{taxRateTypeId}/byaddress | Get Taxrate By Address
*LocalTaxServiceApi* | [**get_specific_tax_rate_by_location**](docs/LocalTaxServiceApi.md#get_specific_tax_rate_by_location) | **GET** /localtax/v1/taxrate/{taxRateTypeId}/bylocation | Get Taxrate By Location
*NeighborhoodsServiceApi* | [**get_place_by_location**](docs/NeighborhoodsServiceApi.md#get_place_by_location) | **GET** /neighborhoods/v1/place/bylocation | Place By Location.
*PSAP911ServiceApi* | [**get_ahj_plus_psapby_address**](docs/PSAP911ServiceApi.md#get_ahj_plus_psapby_address) | **GET** /911/v1/ahj-psap/byaddress | AHJ &amp; PSAP By Address.
*PSAP911ServiceApi* | [**get_ahj_plus_psapby_location**](docs/PSAP911ServiceApi.md#get_ahj_plus_psapby_location) | **GET** /911/v1/ahj-psap/bylocation | AHJ &amp; PSAP By Location
*PSAP911ServiceApi* | [**get_psapby_address**](docs/PSAP911ServiceApi.md#get_psapby_address) | **GET** /911/v1/psap/byaddress | PSAP By Address.
*PSAP911ServiceApi* | [**get_psapby_location**](docs/PSAP911ServiceApi.md#get_psapby_location) | **GET** /911/v1/psap/bylocation | PSAP By Location.
*PhoneVerificationServiceApi* | [**phone_verification**](docs/PhoneVerificationServiceApi.md#phone_verification) | **GET** /phoneverification/v1/phoneverification | Phone verification.
*PlacesServiceApi* | [**get_category_code_metadata**](docs/PlacesServiceApi.md#get_category_code_metadata) | **GET** /places/v1/metadata/category | Category Code Metadata.
*PlacesServiceApi* | [**get_poiby_id**](docs/PlacesServiceApi.md#get_poiby_id) | **GET** /places/v1/poi/{id} | Points Of Interest Details By Id
*PlacesServiceApi* | [**get_pois_by_address**](docs/PlacesServiceApi.md#get_pois_by_address) | **GET** /places/v1/poi/byaddress | Get POIs By Address.
*PlacesServiceApi* | [**get_pois_by_area**](docs/PlacesServiceApi.md#get_pois_by_area) | **GET** /places/v1/poi/byarea | GET Points Of Interest By Area.
*PlacesServiceApi* | [**get_pois_by_geometry**](docs/PlacesServiceApi.md#get_pois_by_geometry) | **POST** /places/v1/poi/byboundary | Points Of Interest By Boundary
*PlacesServiceApi* | [**get_pois_by_location**](docs/PlacesServiceApi.md#get_pois_by_location) | **GET** /places/v1/poi/bylocation | Get POIs By Location.
*PlacesServiceApi* | [**get_pois_count**](docs/PlacesServiceApi.md#get_pois_count) | **POST** /places/v1/poicount | Points Of Interest Count
*PlacesServiceApi* | [**get_sic_metadata**](docs/PlacesServiceApi.md#get_sic_metadata) | **GET** /places/v1/metadata/sic | Get SIC Metadata
*PlacesServiceApi* | [**pois_autocomplete**](docs/PlacesServiceApi.md#pois_autocomplete) | **GET** /places/v1/poi/autocomplete | Points Of Interest Autocomplete
*PropertyInformationServiceApi* | [**get_property_attributes_by_address**](docs/PropertyInformationServiceApi.md#get_property_attributes_by_address) | **GET** /property/v2/attributes/byaddress | PropertyV2 Attributes By Address.
*PropertyInformationServiceApi* | [**get_property_attributes_by_address_batch**](docs/PropertyInformationServiceApi.md#get_property_attributes_by_address_batch) | **POST** /property/v2/attributes/byaddress | PropertyV2 Attributes By Address Batch.
*RisksServiceApi* | [**get_crime_risk_by_address**](docs/RisksServiceApi.md#get_crime_risk_by_address) | **GET** /risks/v1/crime/byaddress | Get Crime Risk By Address
*RisksServiceApi* | [**get_crime_risk_by_address_batch**](docs/RisksServiceApi.md#get_crime_risk_by_address_batch) | **POST** /risks/v1/crime/byaddress | Post Crime Risk By Address
*RisksServiceApi* | [**get_crime_risk_by_location**](docs/RisksServiceApi.md#get_crime_risk_by_location) | **GET** /risks/v1/crime/bylocation | Get Crime Risk By  Location
*RisksServiceApi* | [**get_crime_risk_by_location_batch**](docs/RisksServiceApi.md#get_crime_risk_by_location_batch) | **POST** /risks/v1/crime/bylocation | Post Crime Risk By Location
*RisksServiceApi* | [**get_distance_to_coast_by_address**](docs/RisksServiceApi.md#get_distance_to_coast_by_address) | **GET** /risks/v1/shoreline/distancetofloodhazard/byaddress | Get Distance To Flood Hazard By Address
*RisksServiceApi* | [**get_distance_to_coast_by_address_batch**](docs/RisksServiceApi.md#get_distance_to_coast_by_address_batch) | **POST** /risks/v1/shoreline/distancetofloodhazard/byaddress | Post Distance To Flood Hazard By Address
*RisksServiceApi* | [**get_distance_to_coast_by_location**](docs/RisksServiceApi.md#get_distance_to_coast_by_location) | **GET** /risks/v1/shoreline/distancetofloodhazard/bylocation | Get Distance To Flood Hazard By Location
*RisksServiceApi* | [**get_distance_to_coast_by_location_batch**](docs/RisksServiceApi.md#get_distance_to_coast_by_location_batch) | **POST** /risks/v1/shoreline/distancetofloodhazard/bylocation | Post Distance To Flood Hazard By Location
*RisksServiceApi* | [**get_earthquake_history**](docs/RisksServiceApi.md#get_earthquake_history) | **GET** /risks/v1/earthquakehistory | Earthquake History
*RisksServiceApi* | [**get_earthquake_risk_by_address**](docs/RisksServiceApi.md#get_earthquake_risk_by_address) | **GET** /risks/v1/earthquake/byaddress | Get Earthquake Risk By Address
*RisksServiceApi* | [**get_earthquake_risk_by_address_batch**](docs/RisksServiceApi.md#get_earthquake_risk_by_address_batch) | **POST** /risks/v1/earthquake/byaddress | Post Earthquake Risk By Address
*RisksServiceApi* | [**get_earthquake_risk_by_location**](docs/RisksServiceApi.md#get_earthquake_risk_by_location) | **GET** /risks/v1/earthquake/bylocation | Get Earthquake Risk By Location
*RisksServiceApi* | [**get_earthquake_risk_by_location_batch**](docs/RisksServiceApi.md#get_earthquake_risk_by_location_batch) | **POST** /risks/v1/earthquake/bylocation | Post Earthquake Risk By Location
*RisksServiceApi* | [**get_fire_history**](docs/RisksServiceApi.md#get_fire_history) | **GET** /risks/v1/firehistory | Get Fire History
*RisksServiceApi* | [**get_fire_risk_by_address**](docs/RisksServiceApi.md#get_fire_risk_by_address) | **GET** /risks/v1/fire/byaddress | Get Fire Risk By Address
*RisksServiceApi* | [**get_fire_risk_by_address_batch**](docs/RisksServiceApi.md#get_fire_risk_by_address_batch) | **POST** /risks/v1/fire/byaddress | Post Fire Risk By Address
*RisksServiceApi* | [**get_fire_risk_by_location**](docs/RisksServiceApi.md#get_fire_risk_by_location) | **GET** /risks/v1/fire/bylocation | Get Fire Risk By Location
*RisksServiceApi* | [**get_fire_risk_by_location_batch**](docs/RisksServiceApi.md#get_fire_risk_by_location_batch) | **POST** /risks/v1/fire/bylocation | Post Fire Risk By Location
*RisksServiceApi* | [**get_fire_station_by_address**](docs/RisksServiceApi.md#get_fire_station_by_address) | **GET** /risks/v1/firestation/byaddress | Get Fire Station By Address
*RisksServiceApi* | [**get_fire_station_by_location**](docs/RisksServiceApi.md#get_fire_station_by_location) | **GET** /risks/v1/firestation/bylocation | Get Fire Station By Location
*RisksServiceApi* | [**get_flood_risk_by_address**](docs/RisksServiceApi.md#get_flood_risk_by_address) | **GET** /risks/v1/flood/byaddress | Get Flood Risk By Address
*RisksServiceApi* | [**get_flood_risk_by_address_batch**](docs/RisksServiceApi.md#get_flood_risk_by_address_batch) | **POST** /risks/v1/flood/byaddress | Post Flood Risk By Address
*RisksServiceApi* | [**get_flood_risk_by_location**](docs/RisksServiceApi.md#get_flood_risk_by_location) | **GET** /risks/v1/flood/bylocation | Get Flood Risk By Location
*RisksServiceApi* | [**get_flood_risk_by_location_batch**](docs/RisksServiceApi.md#get_flood_risk_by_location_batch) | **POST** /risks/v1/flood/bylocation | Post Flood Risk By Location
*RoutingServiceApi* | [**get_route_by_address**](docs/RoutingServiceApi.md#get_route_by_address) | **GET** /routing/v1/route/byaddress | Gets Route By Address.
*RoutingServiceApi* | [**get_route_by_location**](docs/RoutingServiceApi.md#get_route_by_location) | **GET** /routing/v1/route/bylocation | Gets Route By Location.
*RoutingServiceApi* | [**get_travel_cost_matrix_by_address**](docs/RoutingServiceApi.md#get_travel_cost_matrix_by_address) | **GET** /routing/v1/travelcostmatrix/byaddress | Get Cost Matrix By Address.
*RoutingServiceApi* | [**get_travel_cost_matrix_by_location**](docs/RoutingServiceApi.md#get_travel_cost_matrix_by_location) | **GET** /routing/v1/travelcostmatrix/bylocation | Get Cost Matrix By Location.
*SchoolsServiceApi* | [**get_schools_by_address**](docs/SchoolsServiceApi.md#get_schools_by_address) | **GET** /schools/v1/school/byaddress | Search Nearby Schools by Address
*StreetsServiceApi* | [**get_intersection_by_address**](docs/StreetsServiceApi.md#get_intersection_by_address) | **GET** /streets/v1/intersection/byaddress | Nearest Intesection By Address.
*StreetsServiceApi* | [**get_intersection_by_location**](docs/StreetsServiceApi.md#get_intersection_by_location) | **GET** /streets/v1/intersection/bylocation | Nearest Intesection By Location.
*StreetsServiceApi* | [**get_nearest_speed_limit**](docs/StreetsServiceApi.md#get_nearest_speed_limit) | **GET** /streets/v1/speedlimit | Nearest Speedlimit.
*TelecommInfoServiceApi* | [**get_rate_center_by_address**](docs/TelecommInfoServiceApi.md#get_rate_center_by_address) | **GET** /telecomm/v1/ratecenter/byaddress | Rate Center By Address.
*TelecommInfoServiceApi* | [**get_rate_center_by_location**](docs/TelecommInfoServiceApi.md#get_rate_center_by_location) | **GET** /telecomm/v1/ratecenter/bylocation | Rate Center By Location.
*TimeZoneServiceApi* | [**get_batch_timezone_by_location**](docs/TimeZoneServiceApi.md#get_batch_timezone_by_location) | **POST** /timezone/v1/timezone/bylocation | Timezone Batch by Location.
*TimeZoneServiceApi* | [**get_timezone_by_address**](docs/TimeZoneServiceApi.md#get_timezone_by_address) | **GET** /timezone/v1/timezone/byaddress | Timezone By Address.
*TimeZoneServiceApi* | [**get_timezone_by_address_batch**](docs/TimeZoneServiceApi.md#get_timezone_by_address_batch) | **POST** /timezone/v1/timezone/byaddress | Timezone Batch by Address.
*TimeZoneServiceApi* | [**get_timezone_by_location**](docs/TimeZoneServiceApi.md#get_timezone_by_location) | **GET** /timezone/v1/timezone/bylocation | Timezone By Location.
*ZonesServiceApi* | [**get_basic_boundary_by_address**](docs/ZonesServiceApi.md#get_basic_boundary_by_address) | **GET** /zones/v1/basicboundary/byaddress | Gets Basic Boundary by Address.
*ZonesServiceApi* | [**get_basic_boundary_by_location**](docs/ZonesServiceApi.md#get_basic_boundary_by_location) | **GET** /zones/v1/basicboundary/bylocation | Gets Basic Boundary by Location.
*ZonesServiceApi* | [**get_poi_boundary_by_address**](docs/ZonesServiceApi.md#get_poi_boundary_by_address) | **GET** /zones/v1/poiboundary/byaddress | Gets Point of Interests Boundary by Address.
*ZonesServiceApi* | [**get_poi_boundary_by_address_batch**](docs/ZonesServiceApi.md#get_poi_boundary_by_address_batch) | **POST** /zones/v1/poiboundary/byaddress | Batch method for getting Point of Interests Boundary by Address.
*ZonesServiceApi* | [**get_poi_boundary_by_location**](docs/ZonesServiceApi.md#get_poi_boundary_by_location) | **GET** /zones/v1/poiboundary/bylocation | Get Point of Interests Boundary by Location.
*ZonesServiceApi* | [**get_poi_boundary_by_location_batch**](docs/ZonesServiceApi.md#get_poi_boundary_by_location_batch) | **POST** /zones/v1/poiboundary/bylocation | Batch method for getting Point of Interests Boundary by Location.
*ZonesServiceApi* | [**get_travel_boundary_by_distance**](docs/ZonesServiceApi.md#get_travel_boundary_by_distance) | **GET** /zones/v1/travelboundary/bydistance | Get TravelBoundary By Distance.
*ZonesServiceApi* | [**get_travel_boundary_by_time**](docs/ZonesServiceApi.md#get_travel_boundary_by_time) | **GET** /zones/v1/travelboundary/bytime | Get TravelBoundary By Time.


## Documentation For Models

 - [AHJ](docs/AHJ.md)
 - [AHJList](docs/AHJList.md)
 - [AHJPlusPSAPResponse](docs/AHJPlusPSAPResponse.md)
 - [AHJmailingAddress](docs/AHJmailingAddress.md)
 - [AbsenteeOwner](docs/AbsenteeOwner.md)
 - [Accuracy](docs/Accuracy.md)
 - [Address](docs/Address.md)
 - [AddressTime](docs/AddressTime.md)
 - [AddressType](docs/AddressType.md)
 - [AddressesByBoundaryRequest](docs/AddressesByBoundaryRequest.md)
 - [AddressesCount](docs/AddressesCount.md)
 - [AddressesDTO](docs/AddressesDTO.md)
 - [AddressesPreferences](docs/AddressesPreferences.md)
 - [AddressesResponse](docs/AddressesResponse.md)
 - [Amenities](docs/Amenities.md)
 - [Area](docs/Area.md)
 - [AreaCodeInfo](docs/AreaCodeInfo.md)
 - [AssetsAndWealthTheme](docs/AssetsAndWealthTheme.md)
 - [BaseFloodElevation](docs/BaseFloodElevation.md)
 - [BasementType](docs/BasementType.md)
 - [BasicBoundary](docs/BasicBoundary.md)
 - [Boundaries](docs/Boundaries.md)
 - [Boundary](docs/Boundary.md)
 - [BoundaryBuffer](docs/BoundaryBuffer.md)
 - [BoundaryPoint](docs/BoundaryPoint.md)
 - [BufferRelation](docs/BufferRelation.md)
 - [BuildgClass](docs/BuildgClass.md)
 - [BuildgCondition](docs/BuildgCondition.md)
 - [BuildgFeaturesSqft](docs/BuildgFeaturesSqft.md)
 - [BuildgImprovArea](docs/BuildgImprovArea.md)
 - [BuildgImproveType](docs/BuildgImproveType.md)
 - [BuildgQuality](docs/BuildgQuality.md)
 - [BuildgStyle](docs/BuildgStyle.md)
 - [BuildgType](docs/BuildgType.md)
 - [BuildgView](docs/BuildgView.md)
 - [BuildingSqftSource](docs/BuildingSqftSource.md)
 - [BusinessId](docs/BusinessId.md)
 - [CaExemptions](docs/CaExemptions.md)
 - [Candidate](docs/Candidate.md)
 - [CandidateRange](docs/CandidateRange.md)
 - [CandidateRangeUnit](docs/CandidateRangeUnit.md)
 - [Carrier](docs/Carrier.md)
 - [Category](docs/Category.md)
 - [CategoryMetadata](docs/CategoryMetadata.md)
 - [Cbsa](docs/Cbsa.md)
 - [Census](docs/Census.md)
 - [Center](docs/Center.md)
 - [City](docs/City.md)
 - [CommonGeometry](docs/CommonGeometry.md)
 - [Community](docs/Community.md)
 - [ConsistencyCode](docs/ConsistencyCode.md)
 - [Construction](docs/Construction.md)
 - [ContactDetails](docs/ContactDetails.md)
 - [ContactPerson](docs/ContactPerson.md)
 - [CoolingType](docs/CoolingType.md)
 - [Cost](docs/Cost.md)
 - [County](docs/County.md)
 - [Coverage](docs/Coverage.md)
 - [CrimeBoundary](docs/CrimeBoundary.md)
 - [CrimeIndexTheme](docs/CrimeIndexTheme.md)
 - [CrimeRiskByAddressBatchRequest](docs/CrimeRiskByAddressBatchRequest.md)
 - [CrimeRiskByLocationBatchRequest](docs/CrimeRiskByLocationBatchRequest.md)
 - [CrimeRiskPreferences](docs/CrimeRiskPreferences.md)
 - [CrimeRiskResponse](docs/CrimeRiskResponse.md)
 - [CrimeRiskResponseList](docs/CrimeRiskResponseList.md)
 - [Crs](docs/Crs.md)
 - [Demographics](docs/Demographics.md)
 - [DemographicsAdvancedPreferences](docs/DemographicsAdvancedPreferences.md)
 - [DemographicsAdvancedRequest](docs/DemographicsAdvancedRequest.md)
 - [DemographicsGeometry](docs/DemographicsGeometry.md)
 - [DemographicsGeometryCRC](docs/DemographicsGeometryCRC.md)
 - [DemographicsThemesV2](docs/DemographicsThemesV2.md)
 - [Depth](docs/Depth.md)
 - [DeviceStatusNetwork](docs/DeviceStatusNetwork.md)
 - [DirectionGeometry](docs/DirectionGeometry.md)
 - [Distance](docs/Distance.md)
 - [DistanceToBorder](docs/DistanceToBorder.md)
 - [DistanceToFloodHazardAddressRequest](docs/DistanceToFloodHazardAddressRequest.md)
 - [DistanceToFloodHazardLocationRequest](docs/DistanceToFloodHazardLocationRequest.md)
 - [DistanceToFloodHazardResponse](docs/DistanceToFloodHazardResponse.md)
 - [DistrictType](docs/DistrictType.md)
 - [DomesticUltimateBusiness](docs/DomesticUltimateBusiness.md)
 - [EarthquakeDateTime](docs/EarthquakeDateTime.md)
 - [EarthquakeEvent](docs/EarthquakeEvent.md)
 - [EarthquakeEventsResponse](docs/EarthquakeEventsResponse.md)
 - [EarthquakeHistory](docs/EarthquakeHistory.md)
 - [EarthquakeLocation](docs/EarthquakeLocation.md)
 - [EarthquakeRiskByAddressRequest](docs/EarthquakeRiskByAddressRequest.md)
 - [EarthquakeRiskByLocationRequest](docs/EarthquakeRiskByLocationRequest.md)
 - [EarthquakeRiskResponse](docs/EarthquakeRiskResponse.md)
 - [EarthquakeRiskResponseList](docs/EarthquakeRiskResponseList.md)
 - [EducationTheme](docs/EducationTheme.md)
 - [EmployeeCount](docs/EmployeeCount.md)
 - [EmploymentTheme](docs/EmploymentTheme.md)
 - [EnergyType](docs/EnergyType.md)
 - [ErrorCode](docs/ErrorCode.md)
 - [ErrorInfo](docs/ErrorInfo.md)
 - [EventsCount](docs/EventsCount.md)
 - [ExpenditureTheme](docs/ExpenditureTheme.md)
 - [ExteriorWalls](docs/ExteriorWalls.md)
 - [ExtraFeatureSqft](docs/ExtraFeatureSqft.md)
 - [Field](docs/Field.md)
 - [FieldsMatching](docs/FieldsMatching.md)
 - [FireDepartment](docs/FireDepartment.md)
 - [FireEvent](docs/FireEvent.md)
 - [FireEventsResponse](docs/FireEventsResponse.md)
 - [FireHistory](docs/FireHistory.md)
 - [FireRiskByAddressRequest](docs/FireRiskByAddressRequest.md)
 - [FireRiskByLocationRequest](docs/FireRiskByLocationRequest.md)
 - [FireRiskResponse](docs/FireRiskResponse.md)
 - [FireRiskResponseList](docs/FireRiskResponseList.md)
 - [FireShed](docs/FireShed.md)
 - [FireStation](docs/FireStation.md)
 - [FireStationContactDetails](docs/FireStationContactDetails.md)
 - [FireStations](docs/FireStations.md)
 - [FireplaceType](docs/FireplaceType.md)
 - [FloodHazardPreferences](docs/FloodHazardPreferences.md)
 - [FloodRiskByAddressRequest](docs/FloodRiskByAddressRequest.md)
 - [FloodRiskByLocationRequest](docs/FloodRiskByLocationRequest.md)
 - [FloodRiskPreferences](docs/FloodRiskPreferences.md)
 - [FloodRiskResponse](docs/FloodRiskResponse.md)
 - [FloodRiskResponseList](docs/FloodRiskResponseList.md)
 - [FloodZone](docs/FloodZone.md)
 - [FloorType](docs/FloorType.md)
 - [FormattedTaxAddress](docs/FormattedTaxAddress.md)
 - [Foundation](docs/Foundation.md)
 - [FreeOrReducedPriceLunches](docs/FreeOrReducedPriceLunches.md)
 - [FuelType](docs/FuelType.md)
 - [GarageType](docs/GarageType.md)
 - [GeoLocationAccessPoint](docs/GeoLocationAccessPoint.md)
 - [GeoLocationCountry](docs/GeoLocationCountry.md)
 - [GeoLocationFixedLineCountry](docs/GeoLocationFixedLineCountry.md)
 - [GeoLocationIpAddr](docs/GeoLocationIpAddr.md)
 - [GeoLocationPlace](docs/GeoLocationPlace.md)
 - [GeoLocationState](docs/GeoLocationState.md)
 - [GeoPos](docs/GeoPos.md)
 - [GeocodeAddress](docs/GeocodeAddress.md)
 - [GeocodePreferences](docs/GeocodePreferences.md)
 - [GeocodeRequest](docs/GeocodeRequest.md)
 - [GeocodeServiceResponse](docs/GeocodeServiceResponse.md)
 - [GeocodeServiceResponseList](docs/GeocodeServiceResponseList.md)
 - [GeolocationGeometry](docs/GeolocationGeometry.md)
 - [Geometry](docs/Geometry.md)
 - [GeometryCRC](docs/GeometryCRC.md)
 - [GeometryProperties](docs/GeometryProperties.md)
 - [GetCityStateProvinceAPIInput](docs/GetCityStateProvinceAPIInput.md)
 - [GetCityStateProvinceAPIInputRow](docs/GetCityStateProvinceAPIInputRow.md)
 - [GetCityStateProvinceAPIOptions](docs/GetCityStateProvinceAPIOptions.md)
 - [GetCityStateProvinceAPIOutput](docs/GetCityStateProvinceAPIOutput.md)
 - [GetCityStateProvinceAPIRequest](docs/GetCityStateProvinceAPIRequest.md)
 - [GetCityStateProvinceAPIResponse](docs/GetCityStateProvinceAPIResponse.md)
 - [GetPostalCodesAPIInput](docs/GetPostalCodesAPIInput.md)
 - [GetPostalCodesAPIInputRow](docs/GetPostalCodesAPIInputRow.md)
 - [GetPostalCodesAPIOptions](docs/GetPostalCodesAPIOptions.md)
 - [GetPostalCodesAPIOutput](docs/GetPostalCodesAPIOutput.md)
 - [GetPostalCodesAPIOutputUserFields](docs/GetPostalCodesAPIOutputUserFields.md)
 - [GetPostalCodesAPIRequest](docs/GetPostalCodesAPIRequest.md)
 - [GetPostalCodesAPIResponse](docs/GetPostalCodesAPIResponse.md)
 - [GlobalUltimateBusiness](docs/GlobalUltimateBusiness.md)
 - [GradeLevelsTaught](docs/GradeLevelsTaught.md)
 - [Greatschools](docs/Greatschools.md)
 - [Grid](docs/Grid.md)
 - [HealthTheme](docs/HealthTheme.md)
 - [HeatingType](docs/HeatingType.md)
 - [HouseholdsTheme](docs/HouseholdsTheme.md)
 - [HousingTheme](docs/HousingTheme.md)
 - [IPDTaxByAddressBatchRequest](docs/IPDTaxByAddressBatchRequest.md)
 - [IPDTaxJurisdiction](docs/IPDTaxJurisdiction.md)
 - [IncomeTheme](docs/IncomeTheme.md)
 - [IndexVariable](docs/IndexVariable.md)
 - [IndividualValueVariable](docs/IndividualValueVariable.md)
 - [InteriorWall](docs/InteriorWall.md)
 - [IntermediatePoints](docs/IntermediatePoints.md)
 - [Intersection](docs/Intersection.md)
 - [IntersectionResponse](docs/IntersectionResponse.md)
 - [IpInfo](docs/IpInfo.md)
 - [Ipd](docs/Ipd.md)
 - [KeyLookupRequest](docs/KeyLookupRequest.md)
 - [Keys](docs/Keys.md)
 - [LandUse](docs/LandUse.md)
 - [LatLongFields](docs/LatLongFields.md)
 - [LifeStyleTheme](docs/LifeStyleTheme.md)
 - [LocCode](docs/LocCode.md)
 - [LocalTaxGeometry](docs/LocalTaxGeometry.md)
 - [LocalTaxPreferences](docs/LocalTaxPreferences.md)
 - [Location](docs/Location.md)
 - [LocationTime](docs/LocationTime.md)
 - [Magnitude](docs/Magnitude.md)
 - [Match](docs/Match.md)
 - [MatchedAddress](docs/MatchedAddress.md)
 - [Matrix](docs/Matrix.md)
 - [Mcd](docs/Mcd.md)
 - [MetadataResponse](docs/MetadataResponse.md)
 - [Name](docs/Name.md)
 - [NeighborhoodsResponse](docs/NeighborhoodsResponse.md)
 - [Network](docs/Network.md)
 - [OrganizationType](docs/OrganizationType.md)
 - [OtherRooms](docs/OtherRooms.md)
 - [OwnerVestType](docs/OwnerVestType.md)
 - [Owners](docs/Owners.md)
 - [PBKeyAddressRequest](docs/PBKeyAddressRequest.md)
 - [PBKeyResponse](docs/PBKeyResponse.md)
 - [PBKeyResponseList](docs/PBKeyResponseList.md)
 - [POIBoundaryAddressRequest](docs/POIBoundaryAddressRequest.md)
 - [POIBoundaryLocationRequest](docs/POIBoundaryLocationRequest.md)
 - [POIBoundaryLocations](docs/POIBoundaryLocations.md)
 - [POIBoundaryPreferences](docs/POIBoundaryPreferences.md)
 - [POIBoundaryResponse](docs/POIBoundaryResponse.md)
 - [POIByGeometryRequest](docs/POIByGeometryRequest.md)
 - [PSAPResponse](docs/PSAPResponse.md)
 - [ParentBusiness](docs/ParentBusiness.md)
 - [Pbkey](docs/Pbkey.md)
 - [PhoneVerification](docs/PhoneVerification.md)
 - [Place](docs/Place.md)
 - [PlacesResponse](docs/PlacesResponse.md)
 - [Poi](docs/Poi.md)
 - [PoiBoundary](docs/PoiBoundary.md)
 - [PoiClassification](docs/PoiClassification.md)
 - [PoiCount](docs/PoiCount.md)
 - [PoiCountRequest](docs/PoiCountRequest.md)
 - [Points](docs/Points.md)
 - [PoolType](docs/PoolType.md)
 - [PopulationTheme](docs/PopulationTheme.md)
 - [PreferencTimeZone](docs/PreferencTimeZone.md)
 - [PrimaryZone](docs/PrimaryZone.md)
 - [PriorSaleCode](docs/PriorSaleCode.md)
 - [PropSiteInfluene](docs/PropSiteInfluene.md)
 - [Properties](docs/Properties.md)
 - [PropertyAttributes](docs/PropertyAttributes.md)
 - [PropertyGeometry](docs/PropertyGeometry.md)
 - [PropertyInfoAddressRequest](docs/PropertyInfoAddressRequest.md)
 - [PropertyInfoPreferences](docs/PropertyInfoPreferences.md)
 - [PropertyInfoResponse](docs/PropertyInfoResponse.md)
 - [PropertyInfoResponses](docs/PropertyInfoResponses.md)
 - [Proxy](docs/Proxy.md)
 - [RaceAndEthnicityTheme](docs/RaceAndEthnicityTheme.md)
 - [RangeVariable](docs/RangeVariable.md)
 - [Rate](docs/Rate.md)
 - [RateCenterResponse](docs/RateCenterResponse.md)
 - [ReturnFieldsDescriptor](docs/ReturnFieldsDescriptor.md)
 - [ReverseGeocodeRequest](docs/ReverseGeocodeRequest.md)
 - [Risk](docs/Risk.md)
 - [RiskAddress](docs/RiskAddress.md)
 - [RiskGeometry](docs/RiskGeometry.md)
 - [RiskLocations](docs/RiskLocations.md)
 - [RiskPreferences](docs/RiskPreferences.md)
 - [RisksBoundaries](docs/RisksBoundaries.md)
 - [RisksCrimeTheme](docs/RisksCrimeTheme.md)
 - [RisksGeometryCRC](docs/RisksGeometryCRC.md)
 - [Road](docs/Road.md)
 - [RoofCoverType](docs/RoofCoverType.md)
 - [RoofFrameType](docs/RoofFrameType.md)
 - [RoofShapeType](docs/RoofShapeType.md)
 - [RouteDirection](docs/RouteDirection.md)
 - [RouteGeometry](docs/RouteGeometry.md)
 - [RouteResponse](docs/RouteResponse.md)
 - [SalesTax](docs/SalesTax.md)
 - [SalesVolume](docs/SalesVolume.md)
 - [School](docs/School.md)
 - [SchoolDistrict](docs/SchoolDistrict.md)
 - [SchoolProfile](docs/SchoolProfile.md)
 - [SchoolRanking](docs/SchoolRanking.md)
 - [SchoolsNearByResponse](docs/SchoolsNearByResponse.md)
 - [Segmentation](docs/Segmentation.md)
 - [SegmentationThemes](docs/SegmentationThemes.md)
 - [ShoreLineDistance](docs/ShoreLineDistance.md)
 - [Sic](docs/Sic.md)
 - [SicMetadata](docs/SicMetadata.md)
 - [SiteDetails](docs/SiteDetails.md)
 - [SitusAddress](docs/SitusAddress.md)
 - [SpecialPurposeDistrict](docs/SpecialPurposeDistrict.md)
 - [SpecialPurposeDistrictTax](docs/SpecialPurposeDistrictTax.md)
 - [SpeedLimit](docs/SpeedLimit.md)
 - [StartEndPoint](docs/StartEndPoint.md)
 - [State](docs/State.md)
 - [Status](docs/Status.md)
 - [Stories](docs/Stories.md)
 - [StudentEthnicity](docs/StudentEthnicity.md)
 - [SupplyAndDemandTheme](docs/SupplyAndDemandTheme.md)
 - [TaxAddress](docs/TaxAddress.md)
 - [TaxAddressRequest](docs/TaxAddressRequest.md)
 - [TaxCounty](docs/TaxCounty.md)
 - [TaxDistrictResponse](docs/TaxDistrictResponse.md)
 - [TaxDistrictResponseList](docs/TaxDistrictResponseList.md)
 - [TaxDocType](docs/TaxDocType.md)
 - [TaxExemption](docs/TaxExemption.md)
 - [TaxGeometry](docs/TaxGeometry.md)
 - [TaxJurisdiction](docs/TaxJurisdiction.md)
 - [TaxLocationRequest](docs/TaxLocationRequest.md)
 - [TaxLocations](docs/TaxLocations.md)
 - [TaxPlace](docs/TaxPlace.md)
 - [TaxRateAddress](docs/TaxRateAddress.md)
 - [TaxRateAddressRequest](docs/TaxRateAddressRequest.md)
 - [TaxRateLocationRequest](docs/TaxRateLocationRequest.md)
 - [TaxRateMatchedAddress](docs/TaxRateMatchedAddress.md)
 - [TaxRateResponse](docs/TaxRateResponse.md)
 - [TaxResponses](docs/TaxResponses.md)
 - [TaxSalesPriceCode](docs/TaxSalesPriceCode.md)
 - [TaxState](docs/TaxState.md)
 - [Time](docs/Time.md)
 - [TimezoneAddressRequest](docs/TimezoneAddressRequest.md)
 - [TimezoneGeometry](docs/TimezoneGeometry.md)
 - [TimezoneLocationRequest](docs/TimezoneLocationRequest.md)
 - [TimezoneResponse](docs/TimezoneResponse.md)
 - [TimezoneResponseList](docs/TimezoneResponseList.md)
 - [TravelBoundaries](docs/TravelBoundaries.md)
 - [TravelBoundary](docs/TravelBoundary.md)
 - [TravelCostMatrixResponse](docs/TravelCostMatrixResponse.md)
 - [Type](docs/Type.md)
 - [TypeaheadLocation](docs/TypeaheadLocation.md)
 - [TypeaheadLocations](docs/TypeaheadLocations.md)
 - [TypeaheadRange](docs/TypeaheadRange.md)
 - [TypeaheadUnit](docs/TypeaheadUnit.md)
 - [Unit](docs/Unit.md)
 - [UseTax](docs/UseTax.md)
 - [Vacancy](docs/Vacancy.md)
 - [ValidateEmailAddressAPIRequest](docs/ValidateEmailAddressAPIRequest.md)
 - [ValidateEmailAddressAPIResponse](docs/ValidateEmailAddressAPIResponse.md)
 - [ValidateEmailAddressInput](docs/ValidateEmailAddressInput.md)
 - [ValidateEmailAddressInputRow](docs/ValidateEmailAddressInputRow.md)
 - [ValidateEmailAddressOutput](docs/ValidateEmailAddressOutput.md)
 - [ValidateMailingAddressInput](docs/ValidateMailingAddressInput.md)
 - [ValidateMailingAddressInputRow](docs/ValidateMailingAddressInputRow.md)
 - [ValidateMailingAddressOptions](docs/ValidateMailingAddressOptions.md)
 - [ValidateMailingAddressOutput](docs/ValidateMailingAddressOutput.md)
 - [ValidateMailingAddressPremiumInput](docs/ValidateMailingAddressPremiumInput.md)
 - [ValidateMailingAddressPremiumInputRow](docs/ValidateMailingAddressPremiumInputRow.md)
 - [ValidateMailingAddressPremiumOptions](docs/ValidateMailingAddressPremiumOptions.md)
 - [ValidateMailingAddressPremiumOutput](docs/ValidateMailingAddressPremiumOutput.md)
 - [ValidateMailingAddressPremiumRequest](docs/ValidateMailingAddressPremiumRequest.md)
 - [ValidateMailingAddressPremiumResponse](docs/ValidateMailingAddressPremiumResponse.md)
 - [ValidateMailingAddressProInput](docs/ValidateMailingAddressProInput.md)
 - [ValidateMailingAddressProInputRow](docs/ValidateMailingAddressProInputRow.md)
 - [ValidateMailingAddressProOptions](docs/ValidateMailingAddressProOptions.md)
 - [ValidateMailingAddressProOutput](docs/ValidateMailingAddressProOutput.md)
 - [ValidateMailingAddressProRequest](docs/ValidateMailingAddressProRequest.md)
 - [ValidateMailingAddressProResponse](docs/ValidateMailingAddressProResponse.md)
 - [ValidateMailingAddressRequest](docs/ValidateMailingAddressRequest.md)
 - [ValidateMailingAddressResponse](docs/ValidateMailingAddressResponse.md)
 - [ValidateMailingAddressUSCANAPIInput](docs/ValidateMailingAddressUSCANAPIInput.md)
 - [ValidateMailingAddressUSCANAPIInputRow](docs/ValidateMailingAddressUSCANAPIInputRow.md)
 - [ValidateMailingAddressUSCANAPIOptions](docs/ValidateMailingAddressUSCANAPIOptions.md)
 - [ValidateMailingAddressUSCANAPIOutput](docs/ValidateMailingAddressUSCANAPIOutput.md)
 - [ValidateMailingAddressUSCANAPIRequest](docs/ValidateMailingAddressUSCANAPIRequest.md)
 - [ValidateMailingAddressUSCANAPIResponse](docs/ValidateMailingAddressUSCANAPIResponse.md)
 - [WaterBody](docs/WaterBody.md)
 - [WaterBodyResponse](docs/WaterBodyResponse.md)
 - [ZonesAddress](docs/ZonesAddress.md)
 - [ZonesBoundaryGeometry](docs/ZonesBoundaryGeometry.md)
 - [ZonesContactDetails](docs/ZonesContactDetails.md)
 - [ZonesGeometry](docs/ZonesGeometry.md)
 - [ZonesParentBusiness](docs/ZonesParentBusiness.md)
 - [ZonesPoi](docs/ZonesPoi.md)
 - [ZonesPoiClassification](docs/ZonesPoiClassification.md)
 - [ZonesPoiGeometry](docs/ZonesPoiGeometry.md)
 - [ZonesSic](docs/ZonesSic.md)


## Documentation For Authorization


## oAuth2Password

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://api.precisely.com/oauth/token
- **Scopes**: 
 - **bearer token**: put your bearer token here.


## Author