"""
Created on December 12, 2018

@author: Alejandro Molina
"""

from itertools import repeat
from multiprocessing import Pool

import mpmath
import numpy
import statsmodels.api as sm
import statsmodels.formula.api as smf
from networkx.algorithms.components.connected import connected_components
from networkx.convert_matrix import from_numpy_matrix
from pandas.core.frame import DataFrame
from scipy import NINF
from scipy.stats._continuous_distns import chi2

from spn.algorithms.splitting.Base import split_data_by_clusters
from spn.structure.leaves.parametric.Parametric import Poisson
import logging

logger = logging.getLogger(__name__)
beta = numpy.asarray(
    [
        -0.0648467,
        -0.15305667,
        -0.23071675,
        -0.29247661,
        -0.35706588,
        -0.40514715,
        -0.45248386,
        -0.50458517,
        -0.55009159,
        -0.60241623,
        -0.64308746,
        -0.68833676,
        -0.73136161,
        -0.78078198,
        -0.82894221,
        -0.88430133,
        -0.9499265,
        -0.98828874,
        -1.04892713,
        -1.11527783,
        -1.14992644,
        -1.24010871,
        -1.38522113,
        -1.48296473,
        -1.78738608,
        -0.03933112,
        -0.14650989,
        -0.28765583,
        -0.35528752,
        -0.49538961,
        -0.58780544,
        -0.66900489,
        -0.77825803,
        -0.87260977,
        -0.96782445,
        -1.07358977,
        -1.12531079,
        -1.16041007,
        -1.2975797,
        -1.36743697,
        -1.43012785,
        -1.53311747,
        -1.65273586,
        -1.79350728,
        -1.9117747,
        -2.02659329,
        -2.18499383,
        -2.3765858,
        -2.51267262,
        -3.05559851,
        -0.1250856,
        -0.27323021,
        -0.43148524,
        -0.48172245,
        -0.6898932,
        -0.7928579,
        -0.85066146,
        -1.06133796,
        -1.11977435,
        -1.20203015,
        -1.28736105,
        -1.45874969,
        -1.60889159,
        -1.64346161,
        -1.68334797,
        -1.81974576,
        -2.02648892,
        -2.04820499,
        -2.3230492,
        -2.59516448,
        -2.79776102,
        -3.03865047,
        -3.31299004,
        -3.65667229,
        -4.09174097,
        -0.40798205,
        -0.58214849,
        -0.67464799,
        -0.85920669,
        -0.99797889,
        -1.10019761,
        -1.24048639,
        -1.44519417,
        -1.43104108,
        -1.52887344,
        -1.66695722,
        -1.79016819,
        -1.91159633,
        -1.93474222,
        -1.94039709,
        -2.14388035,
        -2.34856811,
        -2.52186324,
        -2.81381108,
        -3.02543477,
        -3.3338615,
        -3.70012182,
        -4.08017759,
        -4.47426188,
        -5.32601074,
        -0.11619422,
        -0.46546717,
        -0.74391826,
        -1.02744491,
        -1.26392205,
        -1.42145334,
        -1.65407989,
        -1.81536469,
        -2.02334533,
        -2.09938834,
        -2.20567987,
        -2.44943836,
        -2.63257362,
        -2.81161264,
        -2.98179286,
        -3.13342287,
        -3.30649507,
        -3.4646422,
        -3.54117909,
        -3.53272742,
        -3.80907119,
        -4.20676069,
        -4.84259892,
        -5.47685207,
        -6.39138173,
        -0.0687869,
        -0.33471313,
        -0.58645046,
        -0.84305517,
        -1.17255237,
        -1.46491217,
        -1.55238215,
        -1.79236992,
        -1.78127768,
        -2.21251422,
        -2.47288843,
        -2.61217463,
        -2.93562547,
        -3.34428329,
        -3.48448133,
        -3.64732289,
        -3.79479594,
        -4.04745714,
        -4.13484904,
        -4.27469148,
        -4.61491387,
        -4.91271109,
        -5.37456783,
        -6.01333062,
        -7.08021496,
        -0.53689878,
        -0.58562073,
        -0.95896123,
        -1.31359234,
        -1.55985878,
        -1.74442449,
        -2.0175967,
        -2.20599731,
        -2.25783227,
        -2.53419037,
        -2.83535247,
        -2.94857734,
        -3.23125462,
        -3.35534682,
        -3.46151576,
        -3.87863069,
        -4.23908351,
        -4.4191379,
        -4.82113958,
        -4.95712189,
        -5.33535348,
        -5.94327236,
        -6.2144914,
        -6.95870114,
        -8.48837563,
        -0.06587378,
        -0.58124366,
        -0.53482076,
        -0.70899479,
        -1.07383099,
        -1.05381577,
        -1.27585106,
        -1.68931537,
        -2.18809932,
        -2.50101866,
        -2.85948167,
        -3.35512723,
        -3.65167655,
        -4.01035186,
        -4.24709439,
        -4.50345226,
        -4.9099655,
        -5.36063931,
        -5.73370206,
        -6.09245707,
        -6.46768896,
        -6.84622409,
        -7.23578885,
        -7.80794405,
        -9.19862689,
        -0.8377844,
        -1.18727357,
        -1.67892814,
        -2.13655356,
        -2.40733753,
        -2.37013442,
        -2.49480314,
        -2.82625963,
        -3.17119868,
        -3.5636537,
        -3.88321378,
        -4.0313254,
        -4.38155427,
        -4.50039414,
        -4.87091786,
        -5.1383982,
        -5.39812039,
        -5.43335672,
        -6.18441355,
        -6.60044603,
        -7.11669991,
        -7.46755944,
        -8.07312922,
        -8.86841479,
        -10.22371148,
        -0.12732608,
        -0.77782321,
        -1.24808905,
        -1.76904345,
        -2.09486459,
        -2.30685545,
        -2.70509677,
        -2.92069286,
        -3.1997618,
        -3.6337934,
        -4.01274834,
        -4.50166071,
        -4.97277337,
        -5.21536918,
        -5.65195302,
        -6.06457328,
        -6.0595936,
        -6.46819929,
        -6.87347962,
        -7.25454462,
        -7.76257167,
        -8.18205476,
        -8.84260296,
        -9.55384281,
        -11.00985153,
        -0.28687631,
        -1.01453484,
        -1.7401651,
        -2.14079218,
        -2.50789978,
        -2.62260858,
        -2.8870498,
        -3.25691388,
        -3.77111395,
        -4.02040298,
        -4.21877289,
        -4.20809405,
        -4.62395981,
        -5.28744427,
        -5.60464823,
        -6.19483467,
        -6.56252902,
        -6.7891765,
        -6.97852808,
        -7.81007221,
        -8.50886767,
        -9.01689388,
        -9.55606731,
        -10.47717098,
        -11.89998388,
        -0.20697609,
        -1.25560706,
        -1.38547294,
        -1.87046797,
        -2.32172961,
        -2.77530991,
        -3.42319608,
        -3.9141916,
        -3.98123284,
        -4.27776907,
        -4.10943673,
        -4.62176712,
        -5.31805601,
        -5.801638,
        -6.31362677,
        -6.83561824,
        -7.27842657,
        -7.79706943,
        -8.24233569,
        -8.7511904,
        -9.26781892,
        -9.85615645,
        -10.35040195,
        -11.37537184,
        -12.87922864,
        -0.96032292,
        -1.78562028,
        -1.97966067,
        -2.42158333,
        -2.48856717,
        -3.28051437,
        -3.78503843,
        -4.14403801,
        -4.43321221,
        -4.69094902,
        -5.06109662,
        -5.7273341,
        -5.795782,
        -6.50909126,
        -6.60160327,
        -6.91561016,
        -7.54515073,
        -7.93078073,
        -8.41010623,
        -8.86495369,
        -9.52126643,
        -10.30207235,
        -11.06975833,
        -12.15664045,
        -13.88493811,
        -0.5305789,
        -0.80812173,
        -1.59572361,
        -2.19031473,
        -2.39824582,
        -2.75800734,
        -3.49182845,
        -4.05510978,
        -4.45062227,
        -4.75937805,
        -5.16988136,
        -5.77217189,
        -5.9007907,
        -6.28750433,
        -6.66785584,
        -7.29857891,
        -7.96433421,
        -8.54188927,
        -8.94534315,
        -9.35262892,
        -9.73355542,
        -10.52623971,
        -11.51719761,
        -12.35480897,
        -14.61237001,
        -0.6739616,
        -1.03059879,
        -1.04906844,
        -1.25236282,
        -1.64262441,
        -1.54300336,
        -2.4826069,
        -3.10322952,
        -3.81410781,
        -4.42629192,
        -5.3093647,
        -5.73487329,
        -6.59234495,
        -6.77170123,
        -7.5786476,
        -8.08212767,
        -8.54406816,
        -9.05194333,
        -9.3590013,
        -9.73494274,
        -10.57869777,
        -11.42062974,
        -12.44191891,
        -13.69538964,
        -15.485313,
        -0.0913465,
        -1.04378984,
        -1.96856694,
        -2.55693634,
        -3.48268362,
        -3.98503866,
        -4.68248535,
        -4.79433839,
        -5.22778799,
        -5.61157139,
        -5.77881057,
        -6.24269823,
        -7.00486744,
        -7.5911674,
        -8.17764741,
        -8.21284923,
        -8.56768956,
        -9.1302657,
        -9.38913624,
        -10.30386897,
        -11.01233954,
        -11.70690938,
        -12.26629045,
        -13.95205351,
        -16.33802631,
        -1.19451064,
        -0.61304263,
        -1.78139109,
        -1.74865854,
        -2.95068847,
        -3.9464868,
        -4.11204387,
        -5.01078513,
        -5.30560447,
        -5.99452544,
        -6.35254017,
        -6.84941244,
        -7.22864758,
        -8.40745421,
        -8.73700419,
        -9.42296398,
        -9.91701341,
        -10.45110576,
        -10.81712311,
        -11.30777705,
        -11.96527304,
        -12.76105449,
        -13.73171703,
        -15.05430428,
        -17.20018832,
        -0.57901589,
        -0.61566409,
        -1.94156883,
        -2.62055985,
        -2.7790414,
        -3.57177154,
        -4.42213185,
        -5.10532787,
        -5.46108672,
        -6.46824055,
        -6.35209946,
        -7.1942972,
        -7.76122523,
        -8.09612319,
        -8.86934521,
        -9.24340158,
        -9.82676851,
        -10.6299845,
        -11.27685859,
        -12.03859451,
        -12.73477308,
        -13.40440195,
        -14.15023958,
        -15.6500136,
        -18.0989596,
        -1.32304249,
        -2.79621128,
        -3.56766199,
        -4.05795479,
        -4.89711879,
        -5.92841321,
        -6.39059643,
        -7.0876829,
        -7.53083,
        -8.01208734,
        -8.70797744,
        -9.44730653,
        -9.83731797,
        -10.010367,
        -10.64602144,
        -11.18554702,
        -11.63296397,
        -12.1370488,
        -12.5235392,
        -13.0082886,
        -13.5821605,
        -14.17176731,
        -14.94024433,
        -16.01544412,
        -18.18744736,
        -0.93767346,
        -1.39743879,
        -2.78023901,
        -3.13333051,
        -3.6981945,
        -4.63133758,
        -5.05468994,
        -5.93983376,
        -6.51943117,
        -7.34041405,
        -7.87705422,
        -8.34525685,
        -8.8688471,
        -9.5207757,
        -10.19551877,
        -10.86984218,
        -11.59017802,
        -12.13536344,
        -12.88553549,
        -13.70987004,
        -14.26661135,
        -15.21057964,
        -16.08902791,
        -17.11358176,
        -18.99297261,
        -1.91882482,
        -2.50977144,
        -1.64637756,
        -2.92698693,
        -4.07208251,
        -5.13694912,
        -5.4194589,
        -5.70365743,
        -6.25263884,
        -6.36733605,
        -7.06329052,
        -7.98139299,
        -8.76118074,
        -9.60618958,
        -10.49489334,
        -11.2774052,
        -11.93420729,
        -12.57665664,
        -13.32753376,
        -14.07700093,
        -14.91429075,
        -15.75739961,
        -16.8692775,
        -18.19943522,
        -20.3546376,
        -1.0168543,
        -2.60495567,
        -2.86000663,
        -2.68675011,
        -1.94661764,
        -3.48454706,
        -3.992952,
        -4.97105555,
        -4.5575301,
        -5.45965609,
        -6.56098097,
        -8.3868022,
        -8.62176424,
        -10.1431575,
        -11.04032773,
        -11.45645206,
        -12.11371089,
        -12.76806289,
        -13.177768,
        -13.99800348,
        -14.80089189,
        -15.89462589,
        -17.22077668,
        -18.72943574,
        -21.25689814,
        0.94096473,
        -1.22725053,
        -1.75872846,
        -3.9575768,
        -4.94110206,
        -5.7742865,
        -6.08848061,
        -6.58259851,
        -5.48128544,
        -6.79236566,
        -7.53943946,
        -8.34133308,
        -8.1735607,
        -9.41939055,
        -10.44472371,
        -10.87498349,
        -12.41061954,
        -13.05498712,
        -13.07771005,
        -13.99905583,
        -15.10380703,
        -16.40762679,
        -18.05996121,
        -19.76683028,
        -22.31185721,
        1.08326391,
        0.76051631,
        2.07027863,
        -2.1057565,
        -3.78479942,
        -5.13505669,
        -6.06385571,
        -6.79994277,
        -8.01575875,
        -9.0065242,
        -9.39541502,
        -10.37808952,
        -11.16653768,
        -11.82597991,
        -12.53712013,
        -13.31498065,
        -13.92159257,
        -14.51359909,
        -15.40003703,
        -16.13707217,
        -16.63866207,
        -17.60771953,
        -18.6663428,
        -19.83568951,
        -22.51568418,
        -2.11162974,
        -3.35339899,
        -3.72841764,
        -4.91865235,
        -5.10718347,
        -5.34523901,
        -6.49950328,
        -6.56823372,
        -7.53743525,
        -8.23573648,
        -8.27526709,
        -9.42134551,
        -10.64615787,
        -11.30236859,
        -12.11073251,
        -12.6848716,
        -12.9766545,
        -14.16209122,
        -15.60464973,
        -16.44342921,
        -17.13809253,
        -17.81256047,
        -19.05804694,
        -20.65856043,
        -23.41820502,
        -0.05998747,
        -0.58564982,
        -1.39278332,
        -3.37780497,
        -5.80306991,
        -6.30431193,
        -6.6490522,
        -7.72028924,
        -9.77306301,
        -9.46699714,
        -10.44746836,
        -11.53549458,
        -11.5145561,
        -12.21245714,
        -13.33619262,
        -13.93937444,
        -14.13636162,
        -15.13548602,
        -15.12544755,
        -16.01073023,
        -17.45954163,
        -18.52209521,
        -19.96891259,
        -21.77962654,
        -24.37165652,
        0.14408865,
        -1.68824341,
        -2.80529427,
        -3.84471906,
        -5.27514707,
        -6.30987093,
        -6.75814771,
        -6.67078231,
        -7.90742503,
        -9.48244344,
        -9.80080117,
        -10.70348941,
        -11.94969029,
        -12.95847838,
        -13.52794048,
        -14.23377404,
        -15.1851375,
        -15.8924598,
        -16.23689422,
        -17.15303179,
        -18.17974307,
        -19.3172696,
        -20.83059788,
        -22.53758651,
        -25.1817373,
        0.79939887,
        0.03205666,
        -0.89955233,
        -1.4857033,
        -0.82383039,
        0.5324532,
        0.08803781,
        -2.32772158,
        -3.26635598,
        -4.51747286,
        -6.03001976,
        -8.83424437,
        -10.45716586,
        -12.24748808,
        -13.51362312,
        -14.47395149,
        -15.43533936,
        -15.82692606,
        -16.48073364,
        -17.34560575,
        -18.4974839,
        -20.28612607,
        -21.45173389,
        -23.0525819,
        -25.86459932,
        -0.97451814,
        -3.31523561,
        -3.44181996,
        -4.06057325,
        -5.50043111,
        -5.90874636,
        -7.37484097,
        -8.0686921,
        -9.19980094,
        -9.97292626,
        -11.3341333,
        -11.13943081,
        -11.51670322,
        -12.8736633,
        -13.55604421,
        -14.91348471,
        -15.87673684,
        -16.80606996,
        -17.25885348,
        -17.9129516,
        -19.27876378,
        -20.33252371,
        -21.67046167,
        -23.45241774,
        -26.34713744,
        -0.45185348,
        -1.34552529,
        -4.10601015,
        -4.06956204,
        -4.37163956,
        -4.96136749,
        -6.09612958,
        -6.79175933,
        -7.92402706,
        -8.25906871,
        -9.38202152,
        -10.4807904,
        -11.51038877,
        -12.33853757,
        -13.30312119,
        -14.60679957,
        -15.90242413,
        -17.06116511,
        -18.47835054,
        -19.48334693,
        -20.3503361,
        -21.68959354,
        -22.91384536,
        -24.54026411,
        -27.29732409,
        -3.09939971,
        -3.32474971,
        -3.46755751,
        -3.41597684,
        -5.52680707,
        -6.65007406,
        -6.9115191,
        -8.55718448,
        -9.46056864,
        -10.0463213,
        -11.40239801,
        -12.74841191,
        -13.83627077,
        -13.7513071,
        -14.62859882,
        -15.42622988,
        -16.4459132,
        -17.15730455,
        -18.08342986,
        -19.34110938,
        -20.84497913,
        -22.05578685,
        -23.14341564,
        -25.17992235,
        -27.92675759,
        0.9228326,
        -1.52070251,
        -4.79973408,
        -6.35231225,
        -7.66478177,
        -7.45406139,
        -7.96374777,
        -7.52809014,
        -9.48652501,
        -10.49223067,
        -10.93823367,
        -13.34914328,
        -14.40618037,
        -15.55996409,
        -16.73233927,
        -17.54459512,
        -18.37462368,
        -19.11400543,
        -19.85087871,
        -20.80840349,
        -21.58905123,
        -22.53427553,
        -23.6610257,
        -25.55743038,
        -28.6593938,
        -0.67127137,
        -2.35176782,
        -2.56288229,
        -5.0251296,
        -6.11785288,
        -7.97165633,
        -8.82467279,
        -8.56206391,
        -9.42732063,
        -11.28328634,
        -12.13419009,
        -11.99889194,
        -12.58860695,
        -14.51453528,
        -16.01651486,
        -17.04491345,
        -18.106229,
        -19.28255657,
        -20.38447451,
        -21.2043418,
        -22.28587689,
        -23.41422487,
        -24.64959031,
        -26.10948832,
        -28.82959083,
        1.39267822,
        2.73909431,
        -0.30852069,
        -0.49191557,
        -1.06900899,
        -4.80174038,
        -7.74429261,
        -8.57210051,
        -10.15214971,
        -11.15102586,
        -13.64298575,
        -14.48247672,
        -15.35212309,
        -16.11005408,
        -16.94107167,
        -17.64203321,
        -17.96105135,
        -18.79888981,
        -19.76444493,
        -21.25567826,
        -22.65736046,
        -23.78512985,
        -24.86149506,
        -26.88880413,
        -30.13194652,
        -3.4018918,
        -4.52188036,
        -5.97907586,
        -5.9471244,
        -6.29309233,
        -6.71089295,
        -8.38691622,
        -10.43531078,
        -11.30985554,
        -12.80509172,
        -12.96840994,
        -14.91752468,
        -15.7804277,
        -16.2310254,
        -16.57411667,
        -17.80722296,
        -18.56432089,
        -20.09211544,
        -21.15486984,
        -22.02891632,
        -23.25526587,
        -24.65449898,
        -25.87767407,
        -27.53979094,
        -30.01082046,
        -2.18411218,
        -3.42768338,
        -2.88898683,
        -5.03434617,
        -7.14143228,
        -6.44365876,
        -7.33644084,
        -7.81222962,
        -8.62497252,
        -9.09990075,
        -10.5800447,
        -14.26595287,
        -15.34887785,
        -16.54588899,
        -17.21897182,
        -17.95794773,
        -19.51533257,
        -21.06924324,
        -22.11906531,
        -23.30316044,
        -24.1346444,
        -25.2320325,
        -26.80940751,
        -28.70564311,
        -32.02058598,
        4.96237545,
        -0.88879878,
        -2.35069382,
        -4.46357858,
        -5.13472407,
        -6.3847125,
        -7.85452304,
        -10.21404555,
        -11.36819028,
        -12.54093227,
        -13.80958526,
        -15.33641873,
        -16.15654992,
        -17.31366457,
        -18.27791676,
        -18.79767265,
        -19.18523508,
        -19.99538342,
        -21.37968612,
        -22.18429164,
        -23.38539326,
        -25.29878169,
        -26.80995112,
        -28.92403945,
        -31.7785054,
        1.33123401,
        -1.02249003,
        -2.6059089,
        -5.03386748,
        -4.84022598,
        -5.71008884,
        -4.23324978,
        -5.43305024,
        -9.38670501,
        -12.35863658,
        -14.76322339,
        -15.92483383,
        -16.79956316,
        -18.35682673,
        -19.29588663,
        -20.45545504,
        -21.45765423,
        -22.56577441,
        -23.31772778,
        -24.27986692,
        -25.38170576,
        -26.59632792,
        -28.01733427,
        -29.564567,
        -32.7086858,
        5.15430037,
        3.20382719,
        2.265794,
        1.70478095,
        -0.81045339,
        -1.0908993,
        -7.75566411,
        -8.63732929,
        -7.28411605,
        -9.1182173,
        -10.74836959,
        -12.43301415,
        -12.68311992,
        -14.60913215,
        -15.59191441,
        -14.73154944,
        -16.53048259,
        -19.4591197,
        -20.612641,
        -22.83687863,
        -23.63057252,
        -24.48836498,
        -26.50792922,
        -30.20153782,
        -33.61395119,
        -3.35130854,
        -3.36891886,
        -4.26561375,
        -6.54543163,
        -8.81898894,
        -10.19461991,
        -10.90426574,
        -11.95264669,
        -12.34848756,
        -13.59064154,
        -14.57419256,
        -14.96507795,
        -14.17737602,
        -17.57479064,
        -18.43607852,
        -20.28106993,
        -21.12463625,
        -21.6498765,
        -23.45913736,
        -25.28117062,
        -26.44477551,
        -27.54322022,
        -29.23967429,
        -31.24787883,
        -34.24072356,
        0.99671156,
        0.96757645,
        0.95825013,
        0.95715782,
        0.95237505,
        0.96055795,
        0.95810999,
        0.96149538,
        0.96684273,
        0.96518399,
        0.97354902,
        0.97829106,
        0.9820687,
        0.99475319,
        1.00023473,
        1.00162529,
        1.00384268,
        1.01604712,
        1.02570939,
        1.03526033,
        1.06643436,
        1.06929468,
        1.06808543,
        1.1283969,
        1.17220925,
        0.99525784,
        0.9938654,
        0.98139359,
        0.9942739,
        0.96923268,
        0.97339124,
        0.97444133,
        0.96678414,
        0.97626434,
        0.97636983,
        0.97407744,
        0.99897105,
        1.01629918,
        1.015268,
        1.03004743,
        1.05139461,
        1.05280599,
        1.05932633,
        1.04936541,
        1.0588459,
        1.07200268,
        1.08674781,
        1.11342895,
        1.15305027,
        1.17629253,
        0.98151496,
        0.98324873,
        0.98336371,
        1.00450689,
        0.99692978,
        1.00417536,
        1.01852003,
        1.00719185,
        1.03046019,
        1.03885443,
        1.04597379,
        1.03549948,
        1.03374376,
        1.06767681,
        1.09676432,
        1.10216977,
        1.0962988,
        1.13491785,
        1.12030935,
        1.09122076,
        1.09109337,
        1.09037434,
        1.10476754,
        1.13355758,
        1.21034051,
        0.90528031,
        0.91505724,
        0.9364688,
        0.93433918,
        0.9411933,
        0.95132377,
        0.96334287,
        0.96603109,
        1.00890357,
        1.02148881,
        1.02616925,
        1.03765517,
        1.04392701,
        1.071198,
        1.10122554,
        1.09891616,
        1.10457466,
        1.10727065,
        1.10513873,
        1.12012324,
        1.12405358,
        1.12268437,
        1.14201041,
        1.17607899,
        1.21390643,
        1.02457601,
        1.01129094,
        1.00172704,
        0.9890919,
        0.98620432,
        0.9972466,
        0.99253425,
        1.0044353,
        1.00046922,
        1.01518764,
        1.02275886,
        1.02127435,
        1.01887636,
        1.02006744,
        1.0305527,
        1.0446574,
        1.05369295,
        1.06781143,
        1.10989892,
        1.15870693,
        1.17183781,
        1.17153767,
        1.14601974,
        1.15819167,
        1.17642784,
        1.03775792,
        1.03320405,
        1.03391895,
        1.03864019,
        1.02620388,
        1.01747206,
        1.02887917,
        1.02880434,
        1.06533575,
        1.04598986,
        1.04669836,
        1.05733536,
        1.04956126,
        1.03025578,
        1.04393869,
        1.05837582,
        1.07938759,
        1.08339951,
        1.11380916,
        1.13359417,
        1.14810477,
        1.18479646,
        1.1930588,
        1.22140239,
        1.25536339,
        0.95219603,
        0.98400121,
        0.97640322,
        0.97126847,
        0.97651275,
        0.99363695,
        0.99545856,
        1.00681619,
        1.03037828,
        1.02237747,
        1.01736263,
        1.03701081,
        1.04527054,
        1.07043687,
        1.08475765,
        1.07699402,
        1.07739268,
        1.10217153,
        1.10489462,
        1.14759912,
        1.15489501,
        1.14993703,
        1.2117616,
        1.21291275,
        1.16895303,
        1.00259864,
        0.98811229,
        1.02737978,
        1.03875734,
        1.03945526,
        1.0784185,
        1.10005486,
        1.09777938,
        1.08874332,
        1.08718514,
        1.08365161,
        1.06078274,
        1.06322641,
        1.06373417,
        1.07465019,
        1.09341658,
        1.08551877,
        1.07646817,
        1.07605364,
        1.07280436,
        1.0801085,
        1.09621271,
        1.12575792,
        1.15036691,
        1.17118238,
        0.93113614,
        0.93903334,
        0.93065103,
        0.92934556,
        0.94488795,
        0.97862192,
        0.99988795,
        0.99845236,
        0.99862288,
        0.99017086,
        0.9946165,
        1.01955132,
        1.01232498,
        1.03871207,
        1.03085863,
        1.03917618,
        1.05170079,
        1.10431373,
        1.06499129,
        1.07700965,
        1.0808924,
        1.09541073,
        1.1095527,
        1.11196659,
        1.13939491,
        1.01972827,
        0.9982764,
        0.9999548,
        0.98955787,
        0.99858018,
        1.01743721,
        1.02589592,
        1.04951504,
        1.06492822,
        1.05272485,
        1.05200434,
        1.03350523,
        1.01177319,
        1.03214392,
        1.01761463,
        1.01623184,
        1.06276209,
        1.060171,
        1.06428574,
        1.07640874,
        1.07583608,
        1.09754669,
        1.10727034,
        1.13929623,
        1.1430948,
        0.98957614,
        0.96835936,
        0.95855704,
        0.97100936,
        0.968586,
        0.99972676,
        1.00826291,
        1.0112365,
        1.00174976,
        1.01270387,
        1.02263415,
        1.06043526,
        1.0533287,
        1.0334176,
        1.04034926,
        1.01589606,
        1.01908267,
        1.03551668,
        1.06079144,
        1.01892107,
        0.9994589,
        1.01879789,
        1.06131659,
        1.06036243,
        1.11053955,
        0.993185,
        0.95738412,
        0.98877323,
        0.99752949,
        1.00261042,
        1.00830993,
        0.99496327,
        0.99569457,
        1.0326676,
        1.03969503,
        1.08139639,
        1.06960628,
        1.05319163,
        1.04781506,
        1.03917077,
        1.03283667,
        1.0342274,
        1.023434,
        1.02377082,
        1.01203272,
        1.03507954,
        1.04416615,
        1.09166954,
        1.0585826,
        1.06208248,
        0.96782155,
        0.94350733,
        0.96963899,
        0.9754331,
        1.00870226,
        0.98402078,
        0.99298565,
        1.00465319,
        1.01579244,
        1.02854159,
        1.03493729,
        1.01128328,
        1.04440256,
        1.01770567,
        1.05548531,
        1.06849333,
        1.06249592,
        1.0699571,
        1.08030302,
        1.10123141,
        1.09017381,
        1.07135898,
        1.07145152,
        1.07848089,
        1.09269398,
        0.98368009,
        1.01109688,
        1.00005397,
        0.99792404,
        1.03020888,
        1.03961272,
        1.01938528,
        1.01959643,
        1.03128162,
        1.04463912,
        1.04163329,
        1.02954537,
        1.05276183,
        1.06353614,
        1.07798238,
        1.06357005,
        1.05648117,
        1.04729101,
        1.07352566,
        1.08488023,
        1.11384048,
        1.10944281,
        1.11004154,
        1.15898291,
        1.15307761,
        0.9675877,
        0.98646992,
        1.01868047,
        1.04215207,
        1.05467658,
        1.09638126,
        1.08329937,
        1.081832,
        1.08601992,
        1.08458304,
        1.06292778,
        1.06520085,
        1.04157247,
        1.06366213,
        1.03613103,
        1.04059581,
        1.04916238,
        1.05477016,
        1.08401132,
        1.10730545,
        1.09893801,
        1.09102591,
        1.07604096,
        1.06057172,
        1.03827923,
        1.00135334,
        0.98376663,
        0.97066665,
        0.97587169,
        0.96434741,
        0.97076823,
        0.96454779,
        0.99366441,
        1.01098551,
        1.01795115,
        1.04350812,
        1.05369725,
        1.04041905,
        1.04728599,
        1.03465732,
        1.06781106,
        1.08294771,
        1.08679108,
        1.12271764,
        1.10369615,
        1.12282902,
        1.14842385,
        1.19537226,
        1.17989802,
        1.14691263,
        0.96213021,
        1.02910449,
        1.00688152,
        1.0464476,
        1.01743683,
        1.00624209,
        1.03555902,
        1.01746947,
        1.04014327,
        1.02756756,
        1.0444662,
        1.04282184,
        1.05195602,
        1.00952605,
        1.0360307,
        1.0298249,
        1.04509046,
        1.04570811,
        1.07909554,
        1.0980248,
        1.10697097,
        1.11400431,
        1.14524902,
        1.14911289,
        1.1544346,
        0.98622919,
        1.02219984,
        1.00123632,
        1.00211368,
        1.03422849,
        1.02910203,
        1.02211869,
        1.01642223,
        1.03819744,
        1.01047248,
        1.05135326,
        1.03651021,
        1.03574401,
        1.05605009,
        1.03830396,
        1.06235959,
        1.06441205,
        1.05028481,
        1.06503994,
        1.0618399,
        1.07685809,
        1.10629121,
        1.1442555,
        1.15140506,
        1.17029897,
        0.95832919,
        0.933535,
        0.93210709,
        0.94709624,
        0.93567098,
        0.91165966,
        0.91773957,
        0.91252457,
        0.9218757,
        0.92170289,
        0.90225855,
        0.88036159,
        0.88884871,
        0.92151941,
        0.90818127,
        0.89770414,
        0.90139634,
        0.90008482,
        0.91853667,
        0.92199325,
        0.92194461,
        0.94080557,
        0.96868608,
        1.0159258,
        1.04257134,
        0.97989282,
        1.00526196,
        0.97254899,
        0.9992625,
        1.00898788,
        0.99712304,
        1.01308178,
        0.99844861,
        1.00599883,
        0.98818312,
        0.99043401,
        0.99739582,
        0.9968266,
        1.00334801,
        0.99669217,
        0.99308869,
        0.97738919,
        0.97206863,
        0.98125679,
        0.95151093,
        0.99125929,
        0.96736269,
        0.98651967,
        1.00653595,
        1.02028684,
        0.94842852,
        0.96036523,
        1.03641684,
        1.02109845,
        1.01005923,
        0.99259316,
        1.01412676,
        1.03833275,
        1.04479951,
        1.07123783,
        1.07312362,
        1.07450508,
        1.0701454,
        1.05749547,
        1.04481273,
        1.03815847,
        1.03827458,
        1.03475703,
        1.04014114,
        1.04739527,
        1.05478624,
        1.06251211,
        1.05837778,
        1.05806746,
        1.02487475,
        0.96688912,
        0.93597836,
        0.9601954,
        1.0102506,
        1.07707279,
        1.04456257,
        1.06079869,
        1.06472509,
        1.12659794,
        1.12532202,
        1.11340021,
        1.06099678,
        1.0947578,
        1.05136043,
        1.04140032,
        1.0705856,
        1.07310397,
        1.0706844,
        1.08979475,
        1.10274996,
        1.10858659,
        1.10743573,
        1.10225224,
        1.09611546,
        1.13102626,
        1.07372683,
        1.02744152,
        1.05225294,
        1.00304141,
        0.99181473,
        0.9966397,
        1.02262192,
        1.03086116,
        1.11650316,
        1.09244046,
        1.10004847,
        1.10349604,
        1.14793429,
        1.12552664,
        1.11384156,
        1.13660786,
        1.07982337,
        1.09274429,
        1.15828445,
        1.15348295,
        1.1621882,
        1.14845028,
        1.12716807,
        1.0931102,
        1.08834724,
        1.05535733,
        1.08055869,
        1.15420882,
        1.05432766,
        1.02970587,
        1.01490791,
        1.01432448,
        1.01889057,
        1.00144128,
        0.9884367,
        1.00254099,
        0.9849643,
        0.97871428,
        0.97385725,
        0.97153821,
        0.96309439,
        0.96883525,
        0.97639956,
        0.96160022,
        0.94646595,
        0.98793255,
        0.96687106,
        1.00976894,
        1.07633872,
        1.09637139,
        0.93794913,
        0.93395086,
        0.96199485,
        0.94112157,
        0.97222478,
        0.99615092,
        0.98202759,
        1.0164916,
        1.02132776,
        1.02538744,
        1.06566549,
        1.04595452,
        1.02650382,
        1.03758,
        1.03321785,
        1.0502919,
        1.0846636,
        1.04603251,
        0.99794254,
        0.99847821,
        1.03848496,
        1.08470064,
        1.0641286,
        1.08638148,
        1.06165219,
        1.02982801,
        1.04961528,
        1.06454206,
        1.04012063,
        0.98378317,
        1.00124407,
        1.01380307,
        1.02020813,
        0.95922771,
        1.01904485,
        1.00004575,
        0.98170567,
        1.01813519,
        1.01828881,
        0.99253144,
        1.00632148,
        1.0372487,
        1.02542669,
        1.09007722,
        1.10591548,
        1.07588936,
        1.09174638,
        1.09508217,
        1.06854561,
        1.05183879,
        1.01068622,
        0.98929663,
        0.98710321,
        0.98918892,
        0.97141833,
        0.97040265,
        0.99510374,
        1.03907408,
        1.02529341,
        0.98724672,
        1.01516838,
        1.01679016,
        0.99541567,
        0.98964061,
        1.00202774,
        1.01739432,
        1.00810225,
        1.00825698,
        1.05540668,
        1.07131004,
        1.07062455,
        1.06937314,
        1.05641563,
        1.05115003,
        1.04145774,
        1.05529572,
        1.05739119,
        1.06602683,
        1.09069306,
        1.14737169,
        1.21407944,
        1.2335615,
        1.20863128,
        1.21820913,
        1.21063524,
        1.18925759,
        1.12225802,
        1.09052552,
        1.05516616,
        1.02900233,
        1.02306775,
        1.01004287,
        1.04043642,
        1.05566763,
        1.07072731,
        1.07548152,
        1.01471198,
        1.04802042,
        1.04579565,
        1.00620908,
        1.00251973,
        0.96215578,
        0.99687847,
        1.00256689,
        0.99230352,
        1.01123305,
        0.99460204,
        1.00890208,
        0.99060666,
        1.00048743,
        0.98179803,
        1.03315987,
        1.05219197,
        1.04309359,
        1.053441,
        1.0193217,
        1.01992618,
        0.99185982,
        1.0367618,
        1.04274235,
        1.01724776,
        1.06093825,
        1.04904433,
        1.02967967,
        1.05793273,
        1.01930905,
        1.03045829,
        0.97016447,
        0.99953822,
        1.02498848,
        1.04738273,
        1.04529594,
        1.0536344,
        1.05651914,
        1.07606786,
        1.07325257,
        1.06712586,
        1.07061948,
        1.08004765,
        1.08076894,
        1.06716915,
        1.04707974,
        1.02912412,
        1.00851672,
        1.01907055,
        1.02885912,
        1.00697161,
        1.0390513,
        1.04178393,
        1.03127677,
        0.94450854,
        0.98336716,
        1.01384784,
        1.04100008,
        1.0094129,
        1.0147673,
        1.0386017,
        1.01869204,
        1.03020995,
        1.04674799,
        1.03515373,
        1.02136329,
        1.01042408,
        1.06808974,
        1.06540949,
        1.07090333,
        1.06245678,
        1.06704407,
        1.07219353,
        1.05514805,
        1.01634816,
        1.02356982,
        1.07932881,
        1.06481382,
        1.03279542,
        1.03819509,
        1.01562128,
        0.95981872,
        0.94668742,
        0.93519189,
        0.98490061,
        1.00178787,
        1.0541654,
        1.02695236,
        1.03229473,
        1.04524242,
        0.98612341,
        0.97546849,
        0.9546071,
        0.92318283,
        0.91990624,
        0.90977204,
        0.90749857,
        0.9168134,
        0.9042071,
        0.90653965,
        0.94378133,
        1.0293784,
        0.99195482,
        1.04026978,
        0.99575825,
        0.99428102,
        1.02614781,
        0.99281512,
        0.99467136,
        0.96826751,
        0.98460369,
        1.03538692,
        1.04021534,
        1.01030721,
        1.01871061,
        1.06627775,
        1.07757568,
        1.0441522,
        1.0133829,
        1.00778531,
        0.99955707,
        0.98157477,
        0.96440457,
        0.97925864,
        0.97032645,
        0.96065258,
        0.95483837,
        0.94969826,
        0.97151376,
        1.06370058,
        1.12756675,
        1.09131542,
        1.11653083,
        1.13066921,
        1.06728655,
        1.01914747,
        1.02604818,
        1.01737407,
        1.01099325,
        0.95574297,
        0.95189612,
        0.94566483,
        0.95928391,
        0.96591946,
        0.97511416,
        1.01770827,
        1.04307385,
        1.04704203,
        0.99817277,
        0.9816989,
        0.99354694,
        1.05134906,
        1.0670398,
        1.03332063,
        0.92713346,
        0.93703071,
        0.93890567,
        0.97727174,
        1.00636112,
        1.03283419,
        1.02082077,
        0.9808383,
        0.9945486,
        0.97458461,
        1.01144058,
        0.97258099,
        0.97385944,
        1.00675003,
        1.02867372,
        1.00387999,
        1.01357688,
        0.97796504,
        0.977507,
        0.9827151,
        0.99321682,
        0.94535835,
        0.97442736,
        0.95282744,
        0.91685692,
        0.97764025,
        0.98643182,
        1.033447,
        1.01504602,
        0.98884827,
        1.05228443,
        1.06273693,
        1.09281793,
        1.11031113,
        1.13092416,
        1.12097086,
        1.02527598,
        1.02626485,
        1.02936518,
        1.04844837,
        1.06766552,
        1.03629324,
        1.00404695,
        0.99724967,
        0.99065045,
        1.01810829,
        1.04075799,
        1.0198155,
        1.04320299,
        1.04570116,
        1.13500821,
        1.04122648,
        1.03883689,
        1.02482957,
        1.05482149,
        1.05946609,
        1.05512345,
        1.01870031,
        1.01898786,
        1.01635998,
        1.00364988,
        0.99259816,
        0.98898087,
        0.97321427,
        0.96357086,
        1.00241461,
        1.04936796,
        1.06233004,
        1.0307873,
        1.06323292,
        1.05755696,
        1.02954167,
        1.05544122,
        1.02417637,
        0.95805763,
        1.04574971,
        1.03081935,
        1.02960286,
        1.00662318,
        1.05826122,
        1.07393922,
        1.14228276,
        1.1417163,
        1.07417889,
        1.01975609,
        0.97448773,
        0.97857736,
        0.98478833,
        0.96142387,
        0.95928468,
        0.93437183,
        0.9244452,
        0.88706333,
        0.9266293,
        0.91481091,
        0.93972718,
        0.92517634,
        0.96703695,
        0.9161296,
        0.9385061,
        1.11132411,
        1.11505569,
        1.12976198,
        1.15960051,
        1.1456843,
        1.17497088,
        1.05526701,
        1.06811547,
        1.13474373,
        1.1230698,
        1.11574095,
        1.09709216,
        1.12345786,
        1.10825333,
        1.10990426,
        1.18937861,
        1.16832551,
        1.10764914,
        1.11904904,
        1.07512997,
        1.11501763,
        1.17656691,
        1.18124701,
        1.09323998,
        1.0020602,
        0.9405836,
        0.97357345,
        0.9846081,
        0.95855119,
        0.92581528,
        0.921272,
        0.93679164,
        0.93808197,
        0.96444992,
        0.96161791,
        0.96936248,
        1.01149428,
        1.07379663,
        0.99973403,
        1.01689985,
        0.98492061,
        1.00251086,
        1.05087814,
        1.00568101,
        0.96363276,
        0.98893741,
        1.00339074,
        0.97820963,
        0.98529795,
        0.97134889,
        1.2573241,
        1.43651315,
        1.56531261,
        1.68851898,
        1.77889686,
        1.89761322,
        1.98370422,
        2.07086519,
        2.17244338,
        2.23509053,
        2.33722161,
        2.42776524,
        2.50833918,
        2.6209551,
        2.70286643,
        2.77835798,
        2.84325795,
        2.96752918,
        3.08442682,
        3.19770394,
        3.44739573,
        3.54993605,
        3.61667211,
        4.07202473,
        4.4726701,
        2.44239332,
        2.78837829,
        2.93724618,
        3.18187129,
        3.19484388,
        3.32763253,
        3.44170617,
        3.48652761,
        3.61709836,
        3.6779502,
        3.71945379,
        3.95114475,
        4.14932643,
        4.17103882,
        4.3223804,
        4.53836755,
        4.61175851,
        4.69340428,
        4.68380985,
        4.8073354,
        4.97772701,
        5.14231666,
        5.40268693,
        5.88573096,
        6.11067794,
        3.43036267,
        3.83943122,
        4.07662685,
        4.44796533,
        4.49665381,
        4.69772537,
        4.95584784,
        4.90812703,
        5.20741484,
        5.3693925,
        5.52416853,
        5.4888527,
        5.50958245,
        5.89426861,
        6.23634969,
        6.34122715,
        6.29077373,
        6.75208304,
        6.59886028,
        6.32294425,
        6.35576003,
        6.37212114,
        6.5282289,
        6.84167661,
        7.79013953,
        3.93318971,
        4.41094611,
        4.85980413,
        5.01958587,
        5.22477986,
        5.46557096,
        5.6723934,
        5.73132847,
        6.29613628,
        6.51227891,
        6.63448592,
        6.82686641,
        6.95318158,
        7.36997641,
        7.82328663,
        7.83079173,
        7.89044965,
        7.95561422,
        7.90116455,
        8.08624226,
        8.08884313,
        8.00223819,
        8.18314656,
        8.60611855,
        8.90496643,
        5.80252297,
        6.12710758,
        6.30619245,
        6.35729244,
        6.4591257,
        6.71491425,
        6.740473,
        6.95402735,
        6.98677984,
        7.27464455,
        7.47265174,
        7.46129265,
        7.46907351,
        7.52690766,
        7.67224919,
        7.90265755,
        8.05397638,
        8.27206632,
        8.90945304,
        9.72776829,
        9.91294592,
        9.84654688,
        9.30420469,
        9.30236461,
        9.41930982,
        7.09045346,
        7.62520471,
        7.96566986,
        8.22807265,
        8.19864669,
        8.192869,
        8.53383279,
        8.59456107,
        9.2685801,
        8.91322396,
        8.92953537,
        9.17320934,
        9.00301305,
        8.63825734,
        8.87565157,
        9.13002628,
        9.47650111,
        9.51466537,
        10.08288929,
        10.47680321,
        10.64305003,
        11.1806159,
        11.24873153,
        11.55114952,
        11.84388128,
        7.1028369,
        8.16310859,
        8.31297248,
        8.39458871,
        8.6116192,
        8.97007085,
        9.05632019,
        9.31295267,
        9.83449349,
        9.74010484,
        9.65255439,
        10.0582618,
        10.13194554,
        10.59763704,
        10.91888223,
        10.68834341,
        10.59992445,
        11.01503763,
        10.94912199,
        11.72034341,
        11.78096338,
        11.48022849,
        12.57656495,
        12.41746897,
        11.0568314,
        9.00416324,
        9.29588314,
        10.38413127,
        10.86726887,
        10.98596388,
        11.87560902,
        12.3098159,
        12.24252384,
        12.00013658,
        11.97891812,
        11.88283066,
        11.38799144,
        11.38822596,
        11.32180872,
        11.50213594,
        11.80959613,
        11.57319597,
        11.25922919,
        11.18469963,
        11.07807286,
        11.14611701,
        11.40693419,
        11.92603449,
        12.32590546,
        12.18766263,
        8.5883869,
        9.24954183,
        9.29685978,
        9.33656379,
        9.70552238,
        10.57272004,
        11.11202863,
        11.11899557,
        11.12620845,
        10.91577546,
        10.95270011,
        11.46852117,
        11.27876602,
        11.86056231,
        11.63335876,
        11.78048327,
        11.99793995,
        13.09302596,
        12.01561699,
        12.12034223,
        12.02669094,
        12.30726854,
        12.39994474,
        12.21815495,
        12.28861527,
        11.23288885,
        11.39255875,
        11.66130981,
        11.58597271,
        11.87831304,
        12.36966797,
        12.51217351,
        13.04128558,
        13.38535841,
        13.0950741,
        13.0322117,
        12.57591029,
        12.03313903,
        12.43310006,
        12.01632623,
        11.88077482,
        12.97932137,
        12.81597962,
        12.80920657,
        12.97479282,
        12.81308974,
        13.20385908,
        13.19094338,
        13.69566019,
        13.27442097,
        11.83783861,
        11.90975793,
        11.79102043,
        12.15587054,
        12.2538371,
        13.05242107,
        13.33554168,
        13.40020219,
        13.1144629,
        13.37818178,
        13.67803712,
        14.67639243,
        14.43892816,
        13.74971322,
        13.84817867,
        13.11638006,
        13.1067846,
        13.48939975,
        14.12219368,
        12.80828328,
        12.06993783,
        12.34966736,
        13.1328694,
        12.77710316,
        13.39248273,
        13.02526679,
        12.6143028,
        13.70117093,
        13.97922155,
        14.15156668,
        14.27368705,
        13.84539441,
        13.77323571,
        14.75121929,
        14.92183058,
        16.20106765,
        15.83163865,
        15.14323043,
        14.88197405,
        14.50509125,
        14.18372982,
        14.07860787,
        13.63889444,
        13.53052355,
        13.11206506,
        13.44530299,
        13.45292064,
        14.47635207,
        13.31219885,
        12.83248868,
        12.96494958,
        12.91224967,
        13.91086002,
        14.20571032,
        15.25854613,
        14.52667154,
        14.63233359,
        14.90420398,
        15.22639182,
        15.56571593,
        15.68524541,
        14.90697688,
        15.81532942,
        14.89617531,
        15.88779531,
        16.18754384,
        15.76113514,
        15.86478742,
        15.98357275,
        16.3712948,
        15.84531873,
        15.05116768,
        14.77495506,
        14.4865294,
        14.09406033,
        14.62946881,
        16.00894877,
        15.88694739,
        15.9368477,
        16.90193781,
        17.24362728,
        16.59438834,
        16.46717786,
        16.72458913,
        17.05600286,
        16.95591334,
        16.46927443,
        17.16009456,
        17.3761859,
        17.64938382,
        17.05375164,
        16.58128765,
        16.11546709,
        16.69846699,
        16.94832682,
        17.67968688,
        17.23924469,
        16.80463243,
        17.87674562,
        16.55755233,
        15.25728555,
        16.45491413,
        17.87873686,
        18.83215491,
        19.31397857,
        20.79452208,
        20.1242591,
        19.95277639,
        19.81833633,
        19.5873885,
        18.63729564,
        18.66118103,
        17.61777071,
        18.31681133,
        17.20167832,
        17.15999253,
        17.25797283,
        17.22576198,
        18.02889558,
        18.63943558,
        18.01695357,
        17.44317122,
        16.55885361,
        15.52893606,
        14.10625561,
        17.44844463,
        17.48342087,
        17.18307302,
        17.39099592,
        16.83961037,
        17.00297254,
        16.65995197,
        17.63287496,
        18.04404405,
        18.19984089,
        19.01734887,
        19.19847986,
        18.47770031,
        18.4445317,
        17.88295181,
        19.0430438,
        19.44003984,
        19.32503948,
        20.40520153,
        19.39385495,
        19.6306348,
        20.12473257,
        21.43391832,
        20.06497381,
        17.84014338,
        16.67034331,
        19.84900333,
        19.19472094,
        20.80901562,
        19.63995018,
        18.96154153,
        19.97354223,
        19.14389422,
        19.86179186,
        19.27339377,
        19.73926209,
        19.60762015,
        19.8183546,
        17.93825819,
        18.62634828,
        18.16414262,
        18.43859768,
        18.25837821,
        19.20599318,
        19.644922,
        19.68717938,
        19.57373518,
        20.089278,
        19.6215689,
        18.79900119,
        18.77173073,
        20.85053838,
        20.04023678,
        20.13829144,
        21.37945116,
        21.06068346,
        20.57597229,
        20.2400462,
        20.90280333,
        19.60643024,
        21.18669406,
        20.37872334,
        20.15817732,
        20.75737492,
        19.85238989,
        20.52349087,
        20.37023029,
        19.53064308,
        19.7225017,
        19.27746128,
        19.45448463,
        20.15939105,
        21.17276423,
        20.6386709,
        19.96762244,
        18.48023306,
        17.84287279,
        17.94912876,
        18.54127463,
        18.06100574,
        16.9966338,
        17.17688227,
        16.79805798,
        17.0357087,
        16.92467236,
        16.08050151,
        15.10697972,
        15.27001414,
        16.36094134,
        15.66802961,
        15.17074312,
        15.16459209,
        14.94170023,
        15.46218201,
        15.45235636,
        15.24901053,
        15.66519855,
        16.27646089,
        17.37790692,
        17.17560191,
        20.31537415,
        21.8728502,
        20.71574061,
        21.81622923,
        22.17948485,
        21.55110669,
        22.10566166,
        21.32350727,
        21.4437838,
        20.55047206,
        20.49316663,
        20.64475672,
        20.46923537,
        20.41596695,
        19.90054772,
        19.50959355,
        18.67196064,
        18.31406331,
        18.25001052,
        16.87702723,
        17.99806101,
        16.73489655,
        17.0176133,
        17.31938288,
        16.98233441,
        19.69796548,
        20.79858948,
        24.52136264,
        23.70330544,
        22.99022226,
        22.07384199,
        22.93456068,
        23.84581621,
        24.00468583,
        25.09882342,
        24.91325266,
        24.4965961,
        23.99932504,
        23.20433673,
        22.31128884,
        21.72831161,
        21.47099142,
        21.09789423,
        20.94560832,
        20.85908102,
        20.7263403,
        20.63366713,
        19.95358696,
        19.32667266,
        17.11170102,
        21.98022025,
        21.11569491,
        22.45634101,
        24.78566589,
        28.08627208,
        26.32270605,
        26.87255509,
        26.57416348,
        29.37877651,
        28.93237653,
        27.95718271,
        24.99109955,
        26.22161836,
        23.77527362,
        22.94742809,
        23.90537726,
        23.73157476,
        23.38510717,
        24.05711488,
        24.14490565,
        24.029918,
        23.42573753,
        22.54046335,
        21.56661458,
        21.5551957,
        27.6196046,
        25.92215252,
        27.17649901,
        24.50457048,
        23.92842835,
        23.87169872,
        24.91962948,
        25.20980936,
        29.48574396,
        27.91271614,
        27.88603637,
        27.67781945,
        29.72018995,
        28.20998253,
        27.22012433,
        28.01731654,
        24.98332759,
        25.19280476,
        27.94298491,
        27.34964066,
        27.09040491,
        25.86970847,
        24.09159783,
        21.90394123,
        20.36172534,
        28.30769774,
        30.3539556,
        34.90167248,
        28.84155289,
        27.21974833,
        26.1134807,
        25.77710031,
        25.75182208,
        24.53316419,
        23.5834862,
        24.1201497,
        23.00476986,
        22.39967565,
        21.99126271,
        21.57474142,
        20.9046617,
        20.89528342,
        20.94992826,
        19.95839186,
        19.07445895,
        20.53590146,
        19.26301167,
        20.40514584,
        22.56413126,
        21.91256097,
        23.1874666,
        23.36705501,
        24.83937269,
        23.85012631,
        25.33396746,
        26.4977394,
        25.48747225,
        27.08610064,
        26.83965099,
        26.75434581,
        28.54918733,
        27.20979632,
        25.73918928,
        25.93585014,
        25.3703246,
        25.85223952,
        27.24720391,
        25.04274427,
        22.25921046,
        21.88312221,
        23.18507078,
        24.85988352,
        23.44248595,
        23.5273219,
        20.98144312,
        28.61811868,
        30.38532975,
        31.22928765,
        29.47389384,
        26.04907108,
        26.78760532,
        27.46293864,
        27.18313342,
        23.59814373,
        26.43272948,
        25.25913836,
        23.98255449,
        25.70945692,
        25.46270057,
        23.80580119,
        24.16639428,
        25.56131431,
        24.51652034,
        27.47962222,
        27.72250043,
        25.62288587,
        25.77408883,
        25.13280835,
        23.03450007,
        20.98754102,
        29.4132895,
        28.64307647,
        28.60200288,
        28.5553145,
        27.31581548,
        26.90660641,
        27.92165873,
        30.11445362,
        28.96859473,
        26.51269125,
        27.68474829,
        27.33180829,
        25.71194011,
        24.9425481,
        25.25357115,
        25.58876661,
        24.69139239,
        24.39537925,
        26.40052685,
        26.61769943,
        26.07177997,
        25.45104495,
        24.04909301,
        22.91751863,
        21.06003005,
        32.44262828,
        33.53896381,
        34.12554601,
        35.37929165,
        38.84664089,
        43.34230761,
        44.36915131,
        41.77712842,
        41.88401734,
        40.93437115,
        39.19255188,
        34.41082052,
        32.03370191,
        29.37133975,
        27.5035569,
        26.76722426,
        25.71096559,
        26.95265845,
        27.40397458,
        27.65472138,
        27.22321787,
        23.42269307,
        24.32037996,
        23.41133954,
        20.07803846,
        30.17147365,
        28.27740352,
        30.48576952,
        31.01252468,
        30.03585883,
        31.00502132,
        29.5914922,
        30.02967848,
        28.77440772,
        28.8741381,
        27.27530692,
        29.98111389,
        30.81037166,
        29.57903806,
        29.74943841,
        27.46045464,
        26.96048751,
        25.28187726,
        27.19758151,
        27.27002912,
        25.31003597,
        26.73307797,
        25.51049744,
        23.64576459,
        23.30933223,
        32.24298561,
        33.55893116,
        29.93683335,
        31.94397783,
        33.39057344,
        34.38432014,
        33.86332566,
        34.10720497,
        33.70380373,
        34.67231546,
        33.98238317,
        33.1674725,
        32.75282944,
        32.82218166,
        32.34345098,
        30.97875574,
        29.29035507,
        27.79346636,
        25.96976442,
        25.90274685,
        25.98118906,
        24.22686892,
        25.12327539,
        24.45407358,
        22.45845735,
        28.18134982,
        31.00119845,
        33.16681411,
        35.20436783,
        32.79414011,
        32.62129883,
        33.9688576,
        32.1815323,
        32.35862413,
        32.97207244,
        31.67172039,
        30.27777146,
        29.19032293,
        32.22681722,
        31.70409664,
        31.64229513,
        30.73299914,
        30.67325888,
        30.494215,
        28.98065367,
        26.22758107,
        25.91832218,
        28.10877448,
        26.25824622,
        23.2424173,
        36.33563342,
        35.00865489,
        30.96474837,
        29.87536642,
        28.92933845,
        31.79056039,
        32.62128335,
        35.81015699,
        33.36834684,
        33.13463429,
        33.75914644,
        29.37050071,
        28.29855728,
        26.6970793,
        24.55288366,
        24.01960086,
        23.14149189,
        22.6915029,
        22.81736136,
        21.71806053,
        21.53250374,
        22.87046348,
        26.48362131,
        23.58169052,
        24.15683659,
        34.35222758,
        34.49659693,
        36.7621526,
        34.047806,
        33.86945457,
        31.69911484,
        32.21002835,
        35.22055765,
        35.17987817,
        32.5679444,
        32.61863328,
        35.3602398,
        35.75917151,
        32.86082315,
        30.41571859,
        29.60724743,
        28.62030614,
        27.0429925,
        25.62314147,
        25.99263787,
        24.99138617,
        23.93896797,
        23.05197415,
        22.11034185,
        21.72303575,
        39.90446451,
        45.68828229,
        42.67755711,
        44.62849429,
        45.58526881,
        40.08783397,
        35.86004532,
        35.96295502,
        34.64116979,
        33.8928035,
        29.48121395,
        28.96091018,
        28.25161906,
        28.58397967,
        28.48883403,
        28.6779086,
        30.82973139,
        31.66576275,
        31.40922243,
        28.04338494,
        26.36161115,
        26.39511257,
        28.91348082,
        28.5724726,
        24.94855681,
        31.05989534,
        32.0987241,
        31.96003363,
        34.53299133,
        36.25124788,
        37.75210182,
        36.28591385,
        33.13256438,
        33.50225784,
        31.65142746,
        33.6994541,
        30.50220157,
        30.16328051,
        31.77616051,
        32.92383975,
        31.00427739,
        31.19720032,
        28.3937874,
        27.79854046,
        27.67808123,
        27.51721336,
        24.25229057,
        25.1864937,
        23.2051115,
        20.03361673,
        35.24512733,
        36.26056059,
        40.03169209,
        38.19765183,
        35.87719583,
        40.15835641,
        40.47798496,
        42.06777372,
        42.75113028,
        43.82742713,
        42.48676913,
        34.87158717,
        34.32553895,
        33.81086542,
        34.54260171,
        35.27984344,
        32.67133541,
        29.96124787,
        29.08920579,
        28.07370235,
        29.19048928,
        29.87748229,
        27.88621124,
        28.11622613,
        26.3369738,
        49.55454,
        42.12503438,
        41.96813093,
        40.36943102,
        41.97208403,
        41.78295272,
        40.87328962,
        37.53836098,
        37.0580762,
        36.3181685,
        35.00099651,
        33.49444177,
        32.97912,
        31.54195411,
        30.54263397,
        32.4639633,
        34.96423991,
        35.30122987,
        32.81051601,
        34.2480093,
        33.31852137,
        30.54026938,
        31.16023116,
        28.22207761,
        22.96722251,
        43.56838471,
        42.69352553,
        42.46199624,
        40.13577025,
        43.60195097,
        44.31867174,
        49.78316782,
        49.31508406,
        42.83811659,
        37.80317367,
        33.73800017,
        33.3105174,
        33.22630913,
        31.0087731,
        30.40865036,
        28.43881209,
        27.36609083,
        24.70344261,
        26.52354799,
        25.40327003,
        26.17521882,
        24.73857869,
        26.30494308,
        22.70128478,
        22.09463252,
        51.04502521,
        51.51111157,
        52.75284351,
        54.81194369,
        52.72699034,
        54.75851856,
        43.23767907,
        43.70178295,
        49.02252976,
        47.24876375,
        45.87483121,
        43.85072076,
        45.48505425,
        43.38004215,
        42.99786887,
        48.64036596,
        46.29534543,
        40.66886396,
        40.73416978,
        36.69682239,
        38.72599395,
        42.01843505,
        41.09368797,
        33.38471226,
        26.05468053,
        36.52606302,
        39.86827031,
        40.82288701,
        38.41130665,
        35.46730729,
        34.64407264,
        35.37145682,
        35.02176249,
        36.58297963,
        35.76037366,
        35.72233032,
        38.09322964,
        42.6585412,
        35.92893612,
        36.47374756,
        33.43948378,
        34.04884608,
        36.6796924,
        32.92837796,
        29.29840746,
        30.12086854,
        30.44677077,
        28.0043309,
        27.28218372,
        24.79985495,
    ]
).reshape((1000, 3), order="F")


def chi2cdf(x, k):
    x, k = mpmath.mpf(x), mpmath.mpf(k)
    # logger.info(x,k)
    return mpmath.gammainc(k / 2.0, 0.0, x / 2.0, regularized=True)


def logchi2sf(x, k):
    res = chi2.logsf(x, k)
    for ix in numpy.where(res == NINF)[0]:
        res[ix] = float(mpmath.log(1.0 - chi2cdf(x[ix], k[ix])))
    # logger.info(res)
    # if res == NINF:
    #    res = float(mpmath.log(1.0-chi2cdf(x,k)))

    return res


def supLM(x, k, lambda_):
    # logger.info(x, k, lambda_)
    nb = beta.shape[1] - 1

    tau = lambda_
    if lambda_ >= 1.0:
        tau = 1.0 / (1.0 + numpy.sqrt(lambda_))

    beta_ = beta[range(((k - 1) * 25), (k * 25)), :]

    dummy = numpy.inner(beta_[:, 0:nb], numpy.power(x, numpy.arange(0, nb)))

    dummy = dummy * (dummy > 0)

    # pp = chi2.logsf(dummy, beta_[:,nb])
    pp = logchi2sf(dummy, beta_[:, nb])
    # logger.info(pp)

    if tau == 0.5:
        p = numpy.log(1 - chi2.cdf(x, k))
    elif tau <= 0.01:
        p = pp[24]
    elif tau >= 0.49:
        p = numpy.log(
            (numpy.exp(numpy.log(0.5 - tau) + pp[0]) + numpy.exp(numpy.log(tau - 0.49) + logchi2sf(x, k))) * 100
        )
    else:
        taua = (0.51 - tau) * 50
        tau1 = numpy.floor(taua)
        p = numpy.log(
            numpy.exp(numpy.log(tau1 + 1 - taua) + pp[int(tau1) - 1])
            + numpy.exp(numpy.log(taua - tau1) + pp[int(tau1)])
        )
    return p


def bonferroniCorrection(pvals):
    sumnonan = float(sum(~numpy.isnan(pvals)))
    pval1 = numpy.minimum(1, sumnonan * pvals)
    pval2 = 1.0 - numpy.power(1.0 - pvals, sumnonan)

    return numpy.where(numpy.logical_and(~numpy.isnan(pvals), (pvals > 0.001)), pval2, pval1)


def computeEstabilityTest(df, yv):
    g = smf.glm(formula=df.columns[yv] + "~1", data=df, family=sm.families.Poisson()).fit()

    process = numpy.asarray(g.resid_response)

    k = 1
    n = len(process)

    process = process / numpy.sqrt(n)

    meat = numpy.inner(process, process)

    J12 = numpy.sqrt(1 / meat)

    process = J12 * process

    # logger.info(sum(abs(process)))

    from_ = numpy.ceil(n * 0.1)
    from_ = int(max(from_, 10))

    to = int(n - from_)

    lambda_ = ((n - from_) * to) / (from_ * (n - to))
    tt = (numpy.arange(from_, to + 1)) / n
    ttt = tt * (1.0 - tt)

    pvals = numpy.zeros((df.shape[1]))
    pvals[yv] = numpy.NaN

    if from_ >= to:
        return pvals

    for zv in range(df.shape[1]):

        if zv == yv:
            continue

        zi = df[df.columns[zv]]

        oi = numpy.argsort(zi, kind="mergesort")

        proci = process[oi]

        proci = numpy.cumsum(proci)

        xx = proci ** 2
        xx = xx[from_ - 1 : to]
        stati = numpy.max(xx / ttt)

        # logger.info(stati, k, lambda_)
        pvals[zv] = supLM(stati, k, lambda_)
        # logger.info(pvals[zv])

    # logger.info(pvals)

    return numpy.exp(pvals)


def computePvals(df, yv):
    try:
        pvals = bonferroniCorrection(computeEstabilityTest(df, yv))
    except:
        pvals = numpy.zeros((df.shape[1]))

    return pvals


def getIndependentGroupsStabilityTestPoisson(data, alpha=0.001, n_jobs=-2):
    df = DataFrame(data, columns=["V" + str(i) for i in range(1, data.shape[1] + 1)])

    # pvals = bonferroniCorrection(computeEstabilityTest(df, 0))

    # compute stability test
    with Pool(processes=n_jobs) as pool:
        pvals = pool.starmap(computePvals, zip(repeat(df), range(df.shape[1])))

    pvals = numpy.asarray(pvals)

    for i, j in zip(*numpy.tril_indices(pvals.shape[1])):
        pvals[i, j] = pvals[j, i] = min(pvals[i, j], pvals[j, i])

    pvals[numpy.diag_indices_from(pvals)] = 1

    pvals[pvals > alpha] = 0

    result = numpy.zeros(df.shape[1])
    for i, c in enumerate(connected_components(from_numpy_matrix(pvals))):
        result[list(c)] = i + 1

    return result


def get_split_cols_poisson_py(alpha=0.3, n_jobs=-2):
    def split_cols_poisson_py(local_data, ds_context, scope):
        parametric_types = ds_context.get_parametric_types_by_scope(scope)

        for p in parametric_types:
            assert p == Poisson

        clusters = getIndependentGroupsStabilityTestPoisson(local_data, alpha=alpha, n_jobs=n_jobs)

        return split_data_by_clusters(local_data, clusters, scope, rows=False)

    return split_cols_poisson_py
