"""Parameters of the IOCs of the AP discipline."""
from copy import deepcopy as _dcopy

_off = 0
_on = 1


def get_dict():
    """Return configuration type dictionary."""
    module_name = __name__.split('.')[-1]
    _dict = {
        'config_type_name': module_name,
        'value': _dcopy(_template_dict),
        'check': False,
    }
    return _dict


# When using this type of configuration to set the machine,
# the list of PVs should be processed in the same order they are stored
# in the configuration. The second numeric parameter in the pair is the
# delay [s] the client should wait before setting the next PV.

_tb_sofb = [
    ['TB-Glob:AP-SOFB:BPMXEnblList-SP', [0, ]*30, 0.0],
    ['TB-Glob:AP-SOFB:BPMYEnblList-SP', [0, ]*30, 0.0],
    ['TB-Glob:AP-SOFB:CHEnblList-SP', [0, ]*5, 0.0],
    ['TB-Glob:AP-SOFB:CVEnblList-SP', [0, ]*6, 0.0],
    ['TB-Glob:AP-SOFB:ManCorrGainCH-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:ManCorrGainCV-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:KickAcqRate-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:MaxDeltaKickCH-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:MaxDeltaKickCV-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:MaxKickCH-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:MaxKickCV-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:MeasRespMatKickCH-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:MeasRespMatKickCV-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:MeasRespMatWait-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:OfflineOrbX-SP', [0.0, ]*30, 0.0],
    ['TB-Glob:AP-SOFB:OfflineOrbY-SP', [0.0, ]*30, 0.0],
    ['TB-Glob:AP-SOFB:OrbAcqRate-SP', 0.0, 0.0],
    ['TB-Glob:AP-SOFB:RefOrbX-SP', [0.0, ]*30, 0.0],
    ['TB-Glob:AP-SOFB:RefOrbY-SP', [0.0, ]*30, 0.0],
    ['TB-Glob:AP-SOFB:RespMat-SP', [0.0, ]*660, 0.0],
    ['TB-Glob:AP-SOFB:RespMatMode-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:SOFBMode-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:SPassAvgNrTurns-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:SPassMaskSplBeg-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:SPassMaskSplEnd-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:SPassMethod-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:SPassUseBg-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:SmoothMethod-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:SmoothNrPts-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigAcqChan-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigAcqCtrl-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigAcqRepeat-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigAcqTrigger-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigDataChan-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigDataHyst-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigDataPol-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigDataSel-Sel', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigDataThres-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigNrSamplesPost-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigNrSamplesPre-SP', 0, 0.0],
    ['TB-Glob:AP-SOFB:TrigNrShots-SP', 0, 0.0],
]

_bo_sofb = [
    ['BO-Glob:AP-SOFB:BPMXEnblList-SP', [0, ]*250, 0.0],
    ['BO-Glob:AP-SOFB:BPMYEnblList-SP', [0, ]*250, 0.0],
    ['BO-Glob:AP-SOFB:CHEnblList-SP', [0, ]*25, 0.0],
    ['BO-Glob:AP-SOFB:CVEnblList-SP', [0, ]*25, 0.0],
    ['BO-Glob:AP-SOFB:LoopFreq-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:CorrSync-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:ManCorrGainCH-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:ManCorrGainCV-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:KickAcqRate-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:MTurnDownSample-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:MTurnIdx-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:MTurnMaskSplBeg-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:MTurnMaskSplEnd-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:MTurnSyncTim-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:MTurnUseMask-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:MaxDeltaKickCH-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:MaxDeltaKickCV-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:MaxKickCH-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:MaxKickCV-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:MeasRespMatKickCH-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:MeasRespMatKickCV-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:MeasRespMatWait-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:OfflineOrbX-SP', [0.0, ]*250, 0.0],
    ['BO-Glob:AP-SOFB:OfflineOrbY-SP', [0.0, ]*250, 0.0],
    ['BO-Glob:AP-SOFB:OrbAcqRate-SP', 0.0, 0.0],
    ['BO-Glob:AP-SOFB:RFEnbl-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:RefOrbX-SP', [0.0, ]*250, 0.0],
    ['BO-Glob:AP-SOFB:RefOrbY-SP', [0.0, ]*250, 0.0],
    ['BO-Glob:AP-SOFB:RespMat-SP', [0.0, ]*25500, 0.0],
    ['BO-Glob:AP-SOFB:RespMatMode-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:RingSize-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:SOFBMode-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:SPassAvgNrTurns-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:SPassMaskSplBeg-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:SPassMaskSplEnd-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:SPassMethod-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:SPassUseBg-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:SmoothMethod-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:SmoothNrPts-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigAcqChan-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigAcqCtrl-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigAcqRepeat-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigAcqTrigger-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigDataChan-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigDataHyst-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigDataPol-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigDataSel-Sel', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigDataThres-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigNrSamplesPost-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigNrSamplesPre-SP', 0, 0.0],
    ['BO-Glob:AP-SOFB:TrigNrShots-SP', 0, 0.0],
]

_ts_sofb = [
    ['TS-Glob:AP-SOFB:BPMXEnblList-SP', [0, ]*25, 0.0],
    ['TS-Glob:AP-SOFB:BPMYEnblList-SP', [0, ]*25, 0.0],
    ['TS-Glob:AP-SOFB:CHEnblList-SP', [0, ]*4, 0.0],
    ['TS-Glob:AP-SOFB:CVEnblList-SP', [0, ]*6, 0.0],
    ['TS-Glob:AP-SOFB:ManCorrGainCH-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:ManCorrGainCV-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:KickAcqRate-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:MaxDeltaKickCH-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:MaxDeltaKickCV-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:MaxKickCH-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:MaxKickCV-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:MeasRespMatKickCH-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:MeasRespMatKickCV-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:MeasRespMatWait-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:OfflineOrbX-SP', [0.0, ]*25, 0.0],
    ['TS-Glob:AP-SOFB:OfflineOrbY-SP', [0.0, ]*25, 0.0],
    ['TS-Glob:AP-SOFB:OrbAcqRate-SP', 0.0, 0.0],
    ['TS-Glob:AP-SOFB:RefOrbX-SP', [0.0, ]*25, 0.0],
    ['TS-Glob:AP-SOFB:RefOrbY-SP', [0.0, ]*25, 0.0],
    ['TS-Glob:AP-SOFB:RespMat-SP', [0.0, ]*500, 0.0],
    ['TS-Glob:AP-SOFB:RespMatMode-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:SOFBMode-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:SPassAvgNrTurns-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:SPassMaskSplBeg-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:SPassMaskSplEnd-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:SPassMethod-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:SPassUseBg-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:SmoothMethod-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:SmoothNrPts-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigAcqChan-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigAcqCtrl-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigAcqRepeat-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigAcqTrigger-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigDataChan-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigDataHyst-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigDataPol-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigDataSel-Sel', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigDataThres-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigNrSamplesPost-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigNrSamplesPre-SP', 0, 0.0],
    ['TS-Glob:AP-SOFB:TrigNrShots-SP', 0, 0.0],
]

_si_sofb = [
    ['SI-Glob:AP-SOFB:BPMXEnblList-SP', [0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:BPMYEnblList-SP', [0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:CHEnblList-SP', [0, ]*120, 0.0],
    ['SI-Glob:AP-SOFB:CVEnblList-SP', [0, ]*160, 0.0],
    ['SI-Glob:AP-SOFB:LoopFreq-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:CorrSync-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:ManCorrGainCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:ManCorrGainCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:ManCorrGainRF-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:KickAcqRate-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MTurnDownSample-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:MTurnIdx-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:MTurnMaskSplBeg-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:MTurnMaskSplEnd-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:MTurnSyncTim-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:MTurnUseMask-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:MaxDeltaKickCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxDeltaKickCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxDeltaKickRF-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxKickCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxKickCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MeasRespMatKickCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MeasRespMatKickCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MeasRespMatKickRF-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MeasRespMatWait-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:OfflineOrbX-SP', [0.0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:OfflineOrbY-SP', [0.0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:OrbAcqRate-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:RFEnbl-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:RefOrbX-SP', [0.0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:RefOrbY-SP', [0.0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:RespMat-SP', [0.0, ]*449600, 0.0],
    ['SI-Glob:AP-SOFB:RespMatMode-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:RingSize-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:SOFBMode-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:SPassAvgNrTurns-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:SPassMaskSplBeg-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:SPassMaskSplEnd-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:SPassMethod-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:SPassUseBg-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:SmoothMethod-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:SmoothNrPts-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigAcqChan-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigAcqCtrl-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigAcqRepeat-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigAcqTrigger-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigDataChan-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigDataHyst-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigDataPol-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigDataSel-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigDataThres-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigNrSamplesPost-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigNrSamplesPre-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:TrigNrShots-SP', 0, 0.0],
]

_sofb = _tb_sofb + _bo_sofb + _ts_sofb + _si_sofb

_template_dict = {'pvs': _sofb}
