

db2start;

--CREATE DATABASE {{ db_name }}  AUTOMATIC STORAGE YES ON {{ dft_db_path }} DBPATH ON {{ dft_db_path }} USING CODESET UTF-8 TERRITORY US PAGESIZE 32 K;
CHANGE DATABASE {{ db_name }} COMMENT WITH 'Db2 on Cloud';
CATALOG DATABASE {{ db_name }} AS METADB ON {{ dft_db_path}};
ACTIVATE DATABASE {{ db_name }};
CONNECT TO {{ db_name }};

-- AUTOCONFIGURE
AUTOCONFIGURE USING MEM_PERCENT 90 WORKLOAD_TYPE SIMPLE APPLY DB AND DBM;

-- DBM CFG
UPDATE DBM CFG USING DIAGPATH {{ db2_diag_path }};
UPDATE DBM CFG USING DIAGSIZE {{ db2_diag_size }};
UPDATE DBM CFG USING SYSADM_GROUP {{ db2_sysadm_group }};
UPDATE DBM CFG USING SYSCTRL_GROUP {{ db2_sysctrl_group }};
UPDATE DBM CFG USING SYSMAINT_GROUP {{ db2_sysmaint_group }};
UPDATE DBM CFG USING SYSMON_GROUP {{ db2_sysmon_group }};
UPDATE DBM CFG USING AUTHENTICATION SERVER_ENCRYPT;
UPDATE DBM CFG USING DISCOVER_INST DISABLE;
UPDATE DBM CFG USING SSL_SVR_KEYDB {{ db2_ssl_svr_keydb }};
UPDATE DBM CFG USING SSL_SVR_STASH {{ db2_ssl_svr_stash }};
UPDATE DBM CFG USING SSL_SVR_LABEL {{ db2_ssl_svr_label }};
UPDATE DBM CFG USING SSL_SVCENAME {{ db2_ssl_svcename }};
UPDATE DBM CFG USING KEYSTORE_LOCATION {{ db2_keystore_loc }};
UPDATE DBM CFG USING KEYSTORE_TYPE pkcs12;
UPDATE DBM CFG USING INTRA_PARALLEL YES;
-- UPDATE DBM CFG USING INSTANCE_MEMORY AUTOMATIC;
UPDATE DBM CFG USING INSTANCE_MEMORY {{ db2_instance_mem }};
-- UPDATE DBM CFG USING INSTANCE_USAGE DASHDB;
UPDATE DBM CFG USING NUMDB 32;
UPDATE DBM CFG USING MON_HEAP_SZ AUTOMATIC;
UPDATE DBM CFG USING SSL_VERSIONS TLSV12;
UPDATE DBM CFG USING FEDERATED YES;

-- STOP AND START
db2stop force;
db2start;
CONNECT TO {{ db_name }};
-- archive logs

-- UPDATE DATABASE CONFIGURATION FOR {{ db_name }} USING LOGARCHMETH1 {{ db2_s3_archloc }} IMMEDIATE;
-- UPDATE DATABASE CONFIGURATION FOR {{ db_name }} USING LOGARCHOPT1 {{ db2_s3_arcopts }} IMMEDIATE;

-- dbcfg
UPDATE DB CFG FOR {{ db_name }} USING TRACKMOD YES;
UPDATE DB CFG FOR {{ db_name }} USING AUTO_DEL_REC_OBJ ON;
UPDATE DB CFG FOR {{ db_name }} USING NUM_DB_BACKUPS 14;
UPDATE DB CFG FOR {{ db_name }} USING AUTO_DEL_REC_OBJ ON;
UPDATE DB CFG FOR {{ db_name }} USING REC_HIS_RETENTN 14;
UPDATE DB CFG FOR {{ db_name }} USING LOGFILSIZ 50000;
UPDATE DB CFG FOR {{ db_name }} USING DFT_DEGREE 1;
UPDATE DB CFG FOR {{ db_name }} USING DFT_TABLE_ORG ROW;
UPDATE DB CFG FOR {{ db_name }} USING SHEAPTHRES_SHR AUTOMATIC;
UPDATE DB CFG FOR {{ db_name }} USING SORTHEAP AUTOMATIC;
UPDATE DB CFG FOR {{ db_name }} USING LOGPRIMARY 20 LOGSECOND 30;
UPDATE DB CFG FOR {{ db_name }} USING DATABASE_MEMORY AUTOMATIC;
UPDATE DB CFG FOR {{ db_name }} USING LOGARCHCOMPR1 ON;
UPDATE DB CFG FOR {{ db_name }} USING INDEXREC ACCESS;
UPDATE DB CFG FOR {{ db_name }} USING NCHAR_MAPPING CHAR_CU32;
UPDATE DB CFG FOR {{ db_name }} USING AUTO_REORG ON;
UPDATE DB CFG FOR {{ db_name }} USING BLOCKNONLOGGED YES;
UPDATE DB CFG FOR {{ db_name }} USING LOCKTIMEOUT 240;
UPDATE DB CFG FOR {{ db_name }} USING LOGARCHMETH1 disk:/mnt/blumeta0/db2/archive_log;

-- deactivate activate
DEACTIVATE DB {{ db_name }};
BACKUP DB {{ db_name }} TO /dev/null;
ACTIVATE DB {{ db_name }};

-- catalog storage accesss
-- {{ db2_s3_load_alias }};

-- {{ db2_s3_bar_alias }};

CONNECT RESET;
DEACTIVATE DB {{ db_name }};
ACTIVATE DB {{ db_name }};



-- DDL Statements for Roles
------------------------------------------------

CREATE ROLE "DASHDB_ENTERPRISE_USER";

CREATE ROLE "BLU_CONNECT_NORMAL";

CREATE ROLE "BLU_CONNECT_TRUSTED";

CREATE ROLE "DASHDB_ENTERPRISE_ADMIN";


--------------------------------------------
-- Authorization Statements on Tables/Views
--------------------------------------------


GRANT SELECT ON TABLE "SYSIBMADM"."AUTHORIZATIONIDS" TO GROUP "BLUADMIN" ;

GRANT SELECT ON TABLE "SYSIBMADM"."AUTHORIZATIONIDS" TO GROUP "BLUUSERS" ;

GRANT SELECT ON TABLE "SYSIBMADM"."OBJECTOWNERS" TO GROUP "BLUADMIN" ;

GRANT SELECT ON TABLE "SYSIBMADM"."OBJECTOWNERS" TO GROUP "BLUUSERS" ;

GRANT SELECT ON TABLE "SYSIBMADM"."PRIVILEGES" TO GROUP "BLUADMIN" ;

GRANT SELECT ON TABLE "SYSIBMADM"."PRIVILEGES" TO GROUP "BLUUSERS" ;

----------------------------------------
-- Authorization Statements on Database
----------------------------------------


GRANT DBADM WITHOUT DATAACCESS WITHOUT ACCESSCTRL ON DATABASE  TO GROUP "BLUADMIN" ;

GRANT IMPLICIT_SCHEMA ON DATABASE  TO GROUP "BLUADMIN" ;

GRANT SECADM ON DATABASE  TO GROUP "BLUADMIN" ;

GRANT DATAACCESS ON DATABASE  TO GROUP "BLUADMIN" ;

GRANT ACCESSCTRL ON DATABASE  TO GROUP "BLUADMIN" ;

GRANT CREATETAB ON DATABASE  TO GROUP "BLUUSERS" ;

GRANT BINDADD ON DATABASE  TO GROUP "BLUUSERS" ;

GRANT IMPLICIT_SCHEMA ON DATABASE  TO GROUP "BLUUSERS" ;

GRANT LOAD ON DATABASE  TO GROUP "BLUUSERS" ;

GRANT CONNECT ON DATABASE  TO ROLE "BLU_CONNECT_NORMAL" ;

GRANT CONNECT ON DATABASE  TO ROLE "BLU_CONNECT_TRUSTED" ;

GRANT DBADM WITHOUT DATAACCESS WITHOUT ACCESSCTRL ON DATABASE  TO ROLE "DASHDB_ENTERPRISE_ADMIN" ;

GRANT IMPLICIT_SCHEMA ON DATABASE  TO ROLE "DASHDB_ENTERPRISE_ADMIN" ;

GRANT SECADM ON DATABASE  TO ROLE "DASHDB_ENTERPRISE_ADMIN" ;

GRANT DATAACCESS ON DATABASE  TO ROLE "DASHDB_ENTERPRISE_ADMIN" ;

GRANT ACCESSCTRL ON DATABASE  TO ROLE "DASHDB_ENTERPRISE_ADMIN" ;


---------------------------------------
-- Authorization statement on table space
---------------------------------------


GRANT USE OF TABLESPACE "USERSPACE1" TO GROUP "BLUADMIN" ;

GRANT USE OF TABLESPACE "USERSPACE1" TO GROUP "BLUUSERS" ;

GRANT USE OF TABLESPACE "USERSPACE1" TO ROLE
"DASHDB_ENTERPRISE_ADMIN" ;

GRANT USE OF TABLESPACE "IDAX_USERTEMPSPACE" TO ROLE
"IDAX_USER" ;

GRANT USE OF TABLESPACE "SYSTOOLSTMPSPACE" TO  PUBLIC
;

---------------------------------------
-- Authorization Statements for Roles
---------------------------------------


GRANT   ROLE "BLUDEMOUSER" TO USER "BLUADMIN" ;

GRANT   ROLE "BLUDEMOUSER" TO USER "BLUUSER " ;

GRANT   ROLE "DASHDB_ENTERPRISE_ADMIN" TO USER "BLUADMIN" ;

COMMIT WORK;

CONNECT RESET;

TERMINATE;



