--<ScriptOptions statementTerminator=";"/>

--CONNECT TO BLUDB;

CREATE OR REPLACE FUNCTION SYNOPSIS_TABLE_DEFINER(SYNOPSIS_SCHEMA VARCHAR(128),
                                                  SYNOPSIS_NAME VARCHAR(128))
SECURED DETERMINISTIC NO EXTERNAL ACTION
RETURNS VARCHAR(128) 
BEGIN ATOMIC
 RETURN (SELECT T.DEFINER FROM SYSIBM.SYSTABLES T, SYSIBM.SYSVIEWDEP V
          WHERE V.DTYPE = '7' AND
                V.DCREATOR = SYNOPSIS_SCHEMA AND V.DNAME = SYNOPSIS_NAME AND
                V.BCREATOR = T.CREATOR AND V.BNAME = T.NAME);--
END;

--

ALTER TABLE SYSIBM.SYSATTRIBUTES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSATTRIBUTES_PERM ON SYSIBM.SYSATTRIBUTES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.TYPENAME AND B.SCHEMA = A.TYPESCHEMA AND (B.TYPEMODULEID = A.TYPEMODULEID OR (B.TYPEMODULEID IS NULL AND A.TYPEMODULEID IS NULL))) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.TYPENAME AND B.SCHEMA = A.TYPESCHEMA AND (B.TYPEMODULEID = A.TYPEMODULEID OR (B.TYPEMODULEID IS NULL AND A.TYPEMODULEID IS NULL))) in (SESSION_USER, 'DB2INST1')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCHECKS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCHECKS_PERM ON SYSIBM.SYSCHECKS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCODEPROPERTIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCODEPROPERTIES_PERM ON SYSIBM.SYSCODEPROPERTIES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.OBJECT_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.OBJECT_ID) in (SESSION_USER, 'DB2INST1')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLAUTH_PERM ON SYSIBM.SYSCOLAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TNAME AND B.CREATOR = A.CREATOR) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TNAME LIKE 'SYN%' AND A.CREATOR = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TNAME AND B.CREATOR = A.CREATOR) LIKE 'SYS%') OR
 (A.TNAME LIKE 'SYN%' AND A.CREATOR = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.CREATOR, A.TNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLCHECKS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLCHECKS_PERM ON SYSIBM.SYSCOLCHECKS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TBNAME LIKE 'SYN%' AND A.TBCREATOR = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) LIKE 'SYS%') OR
 (A.TBNAME LIKE 'SYN%' AND A.TBCREATOR = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.TBCREATOR, A.TBNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLDEPENDENCIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLDEPENDENCIES_PERM ON SYSIBM.SYSCOLDEPENDENCIES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.BNAME AND B.CREATOR = A.BSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.BNAME LIKE 'SYN%' AND A.BSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.BNAME AND B.CREATOR = A.BSCHEMA) LIKE 'SYS%') OR
 (A.BNAME LIKE 'SYN%' AND A.BSCHEMA = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.BSCHEMA, A.BNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLDIST ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLDIST_PERM ON SYSIBM.SYSCOLDIST A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.SCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TBNAME LIKE 'SYN%' AND A.SCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.SCHEMA) LIKE 'SYS%') OR
 (A.TBNAME LIKE 'SYN%' AND A.SCHEMA = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.SCHEMA, A.TBNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLGROUPDIST ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLGROUPDIST_PERM ON SYSIBM.SYSCOLGROUPDIST A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B, SYSIBM.SYSCOLGROUPSCOLS C WHERE
  B.NAME = C.TABNAME AND B.CREATOR = C.TABSCHEMA AND C.COLGROUPID = A.COLGROUPID AND C.ORDINAL = 1) in (SESSION_USER, 'DB2INST1') OR
 (NOT ((SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) LIKE 'SYN%' AND
       (SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B, SYSIBM.SYSCOLGROUPSCOLS C WHERE
   B.NAME = C.TABNAME AND B.CREATOR = C.TABSCHEMA AND C.COLGROUPID = A.COLGROUPID AND C.ORDINAL = 1) LIKE 'SYS%') OR
 ((SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) LIKE 'SYN%' AND
  (SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) = 'SYSIBM' AND
   SYNOPSIS_TABLE_DEFINER((SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1),
                          (SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1)) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLGROUPDISTCOUNTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLGROUPDISTCOUNTS_PERM ON SYSIBM.SYSCOLGROUPDISTCOUNTS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B, SYSIBM.SYSCOLGROUPSCOLS C WHERE
  B.NAME = C.TABNAME AND B.CREATOR = C.TABSCHEMA AND C.COLGROUPID = A.COLGROUPID AND C.ORDINAL = 1) in (SESSION_USER, 'DB2INST1') OR
 (NOT ((SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) LIKE 'SYN%' AND
       (SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B, SYSIBM.SYSCOLGROUPSCOLS C WHERE
   B.NAME = C.TABNAME AND B.CREATOR = C.TABSCHEMA AND C.COLGROUPID = A.COLGROUPID AND C.ORDINAL = 1) LIKE 'SYS%') OR
 ((SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) LIKE 'SYN%' AND
  (SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) = 'SYSIBM' AND
   SYNOPSIS_TABLE_DEFINER((SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1),
                          (SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1)) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLGROUPS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLGROUPS_PERM ON SYSIBM.SYSCOLGROUPS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B, SYSIBM.SYSCOLGROUPSCOLS C WHERE
  B.NAME = C.TABNAME AND B.CREATOR = C.TABSCHEMA AND C.COLGROUPID = A.COLGROUPID AND C.ORDINAL = 1) in (SESSION_USER, 'DB2INST1')  OR
 (NOT ((SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) LIKE 'SYN%' AND
       (SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B, SYSIBM.SYSCOLGROUPSCOLS C WHERE
   B.NAME = C.TABNAME AND B.CREATOR = C.TABSCHEMA AND C.COLGROUPID = A.COLGROUPID AND C.ORDINAL = 1) LIKE 'SYS%') OR
 ((SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) LIKE 'SYN%' AND
  (SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1) = 'SYSIBM' AND
   SYNOPSIS_TABLE_DEFINER((SELECT X.TABSCHEMA FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1),
                          (SELECT X.TABNAME FROM SYSIBM.SYSCOLGROUPSCOLS X WHERE X.COLGROUPID = A.COLGROUPID AND X.ORDINAL = 1)) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLGROUPSCOLS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLGROUPSCOLS_PERM ON SYSIBM.SYSCOLGROUPSCOLS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLLATIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLLATIONS_PERM ON SYSIBM.SYSCOLLATIONS A FOR ROWS WHERE
 OWNER LIKE 'SYS%' OR OWNER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLOPTIONS_PERM ON SYSIBM.SYSCOLOPTIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLPROPERTIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLPROPERTIES_PERM ON SYSIBM.SYSCOLPROPERTIES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLUMNS ACTIVATE ROW ACCESS CONTROL;
 
CREATE PERMISSION SYSCOLUMNS_PERM ON SYSIBM.SYSCOLUMNS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) in (SESSION_USER, 'DB2INST1')
 OR ((SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) LIKE 'SYS%' AND NOT A.TBNAME LIKE 'SYN%')
 OR (A.TBCREATOR = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.TBCREATOR, A.TBNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOLUSE ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOLUSE_PERM ON SYSIBM.SYSCOLUSE A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCOMMENTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCOMMENTS_PERM ON SYSIBM.SYSCOMMENTS A FOR ROWS WHERE
 -- SYSAUDITPOLICIES
 OBJECTTYPE = 'j' OR
 -- SYSCONTEXTS
 OBJECTTYPE = 'x' OR
 -- SYSHISTOGRAMTEMPLATES
 OBJECTTYPE = 'h' OR
 -- SYSROLES
 OBJECTTYPE = 'r' OR
 -- SYSSECURITYLABELCOMPONENTS
 OBJECTTYPE = 'd' OR
 -- SYSSECURITYLABELS
 OBJECTTYPE = 'l' OR
 -- SYSSECURITYPOLICIES
 OBJECTTYPE = 'p' OR
 -- SYSSERVICECLASSES
 OBJECTTYPE = 'b' OR
 -- SYSSTOGROUPS
 OBJECTTYPE = 't' OR
 -- SYSTHRESHOLDS
 OBJECTTYPE = 'f' OR
 -- SYSWORKACTIONSETS
 OBJECTTYPE = 'a' OR
 -- SYSWORKCLASSSETS
 OBJECTTYPE = 'e' OR
 -- SYSWORKLOADS
 OBJECTTYPE = 'w' OR
 (CASE
  WHEN OBJECTTYPE = 'c' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSCOLLATIONS B WHERE B.OBJECTID = A.OBJECTID)
  WHEN OBJECTTYPE = 'v' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSVARIABLES B WHERE B.VARID = A.OBJECTID)
  WHEN (OBJECTTYPE = 'y' OR OBJECTTYPE = '2') THEN
   (SELECT B.OWNER FROM SYSIBM.SYSCONTROLS B WHERE B.CONTROLID = A.OBJECTID)
  WHEN OBJECTTYPE = 'm' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSMODULES B WHERE B.MODULEID = A.OBJECTID)
  WHEN OBJECTTYPE = 'Q' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSSEQUENCES B WHERE B.SEQID = A.OBJECTID)
  WHEN OBJECTTYPE = '3' THEN
   (SELECT 
     (CASE WHEN B.OBJECTTYPE = 'I' THEN
       (SELECT C.DEFINER FROM SYSIBM.SYSINDEXES C WHERE C.NAME = B.OBJECTNAME AND C.CREATOR = B.OBJECTSCHEMA)
      WHEN B.OBJECTTYPE = 'T' AND NOT (B.OBJECTSCHEMA = 'SYSIBM' AND B.OBJECTNAME LIKE 'SYN%') THEN
       (SELECT C.DEFINER FROM SYSIBM.SYSTABLES C WHERE C.NAME = B.OBJECTNAME AND C.CREATOR = B.OBJECTSCHEMA) END)
    FROM SYSIBM.SYSUSAGELISTS B WHERE B.USAGELISTID = A.OBJECTID)
  WHEN OBJECTTYPE = 'Z' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.OBJECTID)
  END) LIKE 'SYS%' OR
 (CASE
  WHEN OBJECTTYPE = 'c' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSCOLLATIONS B WHERE B.OBJECTID = A.OBJECTID)
  WHEN OBJECTTYPE = 'v' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSVARIABLES B WHERE B.VARID = A.OBJECTID)
  WHEN (OBJECTTYPE = 'y' OR OBJECTTYPE = '2') THEN
   (SELECT B.OWNER FROM SYSIBM.SYSCONTROLS B WHERE B.CONTROLID = A.OBJECTID)
  WHEN OBJECTTYPE = 'm' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSMODULES B WHERE B.MODULEID = A.OBJECTID)
  WHEN OBJECTTYPE = 'Q' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSSEQUENCES B WHERE B.SEQID = A.OBJECTID)
  WHEN OBJECTTYPE = '3' THEN
   (SELECT 
     (CASE WHEN OBJECTTYPE = 'I' THEN
       (SELECT C.DEFINER FROM SYSIBM.SYSINDEXES C WHERE C.NAME = B.OBJECTNAME AND C.CREATOR = B.OBJECTSCHEMA)
      WHEN OBJECTTYPE = 'T' THEN
       (SELECT C.DEFINER FROM SYSIBM.SYSTABLES C WHERE C.NAME = B.OBJECTNAME AND C.CREATOR = B.OBJECTSCHEMA) END)
    FROM SYSIBM.SYSUSAGELISTS B WHERE B.USAGELISTID = A.OBJECTID)
  WHEN OBJECTTYPE = 'Z' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.OBJECTID)
  END) in (SESSION_USER, 'DB2INST1') OR
 (OBJECTTYPE = '3' AND 
  (SELECT SYNOPSIS_TABLE_DEFINER(B.OBJECTSCHEMA, B.OBJECTNAME) FROM SYSIBM.SYSUSAGELISTS B
                  WHERE B.OBJECTTYPE = 'T' AND B.USAGELISTID = A.OBJECTID AND B.OBJECTSCHEMA = 'SYSIBM' AND
                        B.OBJECTNAME LIKE 'SYN%') in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCONSTDEP ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCONSTDEP_PERM ON SYSIBM.SYSCONSTDEP A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.DTBNAME AND B.CREATOR = A.DTBCREATOR) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.DTBNAME LIKE 'SYN%' AND A.DTBCREATOR = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.DTBNAME AND B.CREATOR = A.DTBCREATOR) LIKE 'SYS%') OR
 (A.DTBNAME LIKE 'SYN%' AND A.DTBCREATOR = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.DTBCREATOR, A.DTBNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCONTROLS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCONTROLS_PERM ON SYSIBM.SYSCONTROLS A FOR ROWS WHERE
 OWNER LIKE 'SYS%' OR OWNER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSDATAPARTITIONEXPRESSION ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSDATAPARTITIONEXPRESSION_PERM ON SYSIBM.SYSDATAPARTITIONEXPRESSION A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSDATAPARTITIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSDATAPARTITIONS_PERM ON SYSIBM.SYSDATAPARTITIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSDATATYPES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSDATATYPES_PERM ON SYSIBM.SYSDATATYPES A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSDEPENDENCIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSDEPENDENCIES_PERM ON SYSIBM.SYSDEPENDENCIES A FOR ROWS WHERE
 DOWNER LIKE 'SYS%' OR DOWNER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSEVENTMONITORS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSEVENTMONITORS_PERM ON SYSIBM.SYSEVENTMONITORS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSEVENTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSEVENTS_PERM ON SYSIBM.SYSEVENTS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSEVENTMONITORS B WHERE B.NAME = A.NAME) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSEVENTMONITORS B WHERE B.NAME = A.NAME) in (SESSION_USER, 'DB2INST1')  
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSEVENTTABLES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSEVENTTABLES_PERM ON SYSIBM.SYSEVENTTABLES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSEVENTMONITORS B WHERE B.NAME = A.EVMONNAME) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSEVENTMONITORS B WHERE B.NAME = A.EVMONNAME) in (SESSION_USER, 'DB2INST1')  
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSFUNCMAPOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSFUNCMAPOPTIONS_PERM ON SYSIBM.SYSFUNCMAPOPTIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSFUNCMAPPINGS B WHERE B.FUNCTION_MAPPING = A.FUNCTION_MAPPING) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSFUNCMAPPINGS B WHERE B.FUNCTION_MAPPING = A.FUNCTION_MAPPING) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSFUNCMAPPARMOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSFUNCMAPPARMOPTIONS_PERM ON SYSIBM.SYSFUNCMAPPARMOPTIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSFUNCMAPPINGS B WHERE B.FUNCTION_MAPPING = A.FUNCTION_MAPPING) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSFUNCMAPPINGS B WHERE B.FUNCTION_MAPPING = A.FUNCTION_MAPPING) in (SESSION_USER, 'DB2INST1')  
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSFUNCMAPPINGS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSFUNCMAPPINGS_PERM ON SYSIBM.SYSFUNCMAPPINGS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSHIERARCHIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSHIERARCHIES_PERM ON SYSIBM.SYSHIERARCHIES A FOR ROWS WHERE
 (CASE WHEN METATYPE = 'R' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.ROOT_NAME AND B.SCHEMA = A.ROOT_SCHEMA AND B.TYPEMODULEID IS NULL)
  WHEN (METATYPE = 'U' OR METATYPE = 'W') THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.ROOT_NAME AND B.CREATOR = A.ROOT_SCHEMA) END) LIKE 'SYS%' OR
 (CASE WHEN METATYPE = 'R' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.ROOT_NAME AND B.SCHEMA = A.ROOT_SCHEMA AND B.TYPEMODULEID IS NULL)
  WHEN (METATYPE = 'U' OR METATYPE = 'W') THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.ROOT_NAME AND B.CREATOR = A.ROOT_SCHEMA) END) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXAUTH_PERM ON SYSIBM.SYSINDEXAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.NAME AND B.CREATOR = A.CREATOR) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.NAME AND B.CREATOR = A.CREATOR) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXCOLUSE ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXCOLUSE_PERM ON SYSIBM.SYSINDEXCOLUSE A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXES_PERM ON SYSIBM.SYSINDEXES A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXEXPLOITRULES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXEXPLOITRULES_PERM ON SYSIBM.SYSINDEXEXPLOITRULES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXEXTENSIONS B WHERE B.IENAME = A.IENAME AND B.IESCHEMA = A.IESCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXEXTENSIONS B WHERE B.IENAME = A.IENAME AND B.IESCHEMA = A.IESCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXEXTENSIONMETHODS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXEXTENSIONMETHODS_PERM ON SYSIBM.SYSINDEXEXTENSIONMETHODS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXEXTENSIONS B WHERE B.IENAME = A.IENAME AND B.IESCHEMA = A.IESCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXEXTENSIONS B WHERE B.IENAME = A.IENAME AND B.IESCHEMA = A.IESCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXEXTENSIONPARMS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXEXTENSIONPARMS_PERM ON SYSIBM.SYSINDEXEXTENSIONPARMS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXEXTENSIONS B WHERE B.IENAME = A.IENAME AND B.IESCHEMA = A.IESCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXEXTENSIONS B WHERE B.IENAME = A.IENAME AND B.IESCHEMA = A.IESCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXEXTENSIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXEXTENSIONS_PERM ON SYSIBM.SYSINDEXEXTENSIONS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXOPTIONS_PERM ON SYSIBM.SYSINDEXOPTIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXPARTITIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXPARTITIONS_PERM ON SYSIBM.SYSINDEXPARTITIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINDEXXMLPATTERNS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINDEXXMLPATTERNS_PERM ON SYSIBM.SYSINDEXXMLPATTERNS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.INDNAME AND B.CREATOR = A.INDSCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSINVALIDOBJECTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSINVALIDOBJECTS_PERM ON SYSIBM.SYSINVALIDOBJECTS A FOR ROWS WHERE
 (CASE
  WHEN OBJECTTYPE = 'B' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSTRIGGERS B WHERE B.NAME = A.OBJECTNAME AND B.SCHEMA = A.OBJECTSCHEMA)
  WHEN OBJECTTYPE = 'F' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.SPECIFICNAME = A.OBJECTNAME AND B.ROUTINESCHEMA = A.OBJECTSCHEMA AND (B.ROUTINEMODULEID = A.OBJECTMODULEID OR (B.ROUTINEMODULEID IS NULL AND A.OBJECTMODULEID IS NULL)))
  WHEN OBJECTTYPE = 'R' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.OBJECTNAME AND B.SCHEMA = A.OBJECTSCHEMA AND (B.TYPEMODULEID = A.OBJECTMODULEID OR (B.TYPEMODULEID IS NULL AND A.OBJECTMODULEID IS NULL)))
  WHEN OBJECTTYPE = 'V' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.OBJECTNAME AND B.CREATOR = A.OBJECTSCHEMA)
  WHEN OBJECTTYPE = 'v' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSVARIABLES B WHERE B.VARNAME = A.OBJECTNAME AND B.VARSCHEMA = A.OBJECTSCHEMA AND (B.VARMODULEID = A.OBJECTMODULEID OR (B.VARMODULEID IS NULL AND A.OBJECTMODULEID IS NULL)))
  WHEN (OBJECTTYPE = 'y' OR OBJECTTYPE = '2') THEN
   (SELECT B.OWNER FROM SYSIBM.SYSCONTROLS B WHERE B.CONTROLNAME = A.OBJECTNAME AND B.CONTROLSCHEMA = A.OBJECTSCHEMA)
  WHEN OBJECTTYPE = '3' THEN
   (SELECT 
    (CASE WHEN C.OBJECTTYPE = 'I' THEN
      (SELECT D.DEFINER FROM SYSIBM.SYSINDEXES D WHERE D.NAME = C.OBJECTNAME AND D.CREATOR = C.OBJECTSCHEMA)
     WHEN C.OBJECTTYPE = 'T' THEN
      (SELECT D.DEFINER FROM SYSIBM.SYSTABLES D WHERE D.NAME = C.OBJECTNAME AND D.CREATOR = C.OBJECTSCHEMA) END)
    FROM SYSIBM.SYSUSAGELISTS C WHERE C.USAGELISTNAME = A.OBJECTNAME AND C.USAGELISTSCHEMA = A.OBJECTSCHEMA)
  END) LIKE 'SYS' OR
 (CASE
  WHEN OBJECTTYPE = 'B' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSTRIGGERS B WHERE B.NAME = A.OBJECTNAME AND B.SCHEMA = A.OBJECTSCHEMA)
  WHEN OBJECTTYPE = 'F' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.SPECIFICNAME = A.OBJECTNAME AND B.ROUTINESCHEMA = A.OBJECTSCHEMA AND (B.ROUTINEMODULEID = A.OBJECTMODULEID OR (B.ROUTINEMODULEID IS NULL AND A.OBJECTMODULEID IS NULL)))
  WHEN OBJECTTYPE = 'R' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.OBJECTNAME AND B.SCHEMA = A.OBJECTSCHEMA AND (B.TYPEMODULEID = A.OBJECTMODULEID OR (B.TYPEMODULEID IS NULL AND A.OBJECTMODULEID IS NULL)))
  WHEN OBJECTTYPE = 'V' THEN
   (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.OBJECTNAME AND B.CREATOR = A.OBJECTSCHEMA)
  WHEN OBJECTTYPE = 'v' THEN
   (SELECT B.OWNER FROM SYSIBM.SYSVARIABLES B WHERE B.VARNAME = A.OBJECTNAME AND B.VARSCHEMA = A.OBJECTSCHEMA AND (B.VARMODULEID = A.OBJECTMODULEID OR (B.VARMODULEID IS NULL AND A.OBJECTMODULEID IS NULL)))
  WHEN (OBJECTTYPE = 'y' OR OBJECTTYPE = '2') THEN
   (SELECT B.OWNER FROM SYSIBM.SYSCONTROLS B WHERE B.CONTROLNAME = A.OBJECTNAME AND B.CONTROLSCHEMA = A.OBJECTSCHEMA)
  WHEN OBJECTTYPE = '3' THEN
   (SELECT 
    (CASE WHEN C.OBJECTTYPE = 'I' THEN
      (SELECT D.DEFINER FROM SYSIBM.SYSINDEXES D WHERE D.NAME = C.OBJECTNAME AND D.CREATOR = C.OBJECTSCHEMA)
     WHEN C.OBJECTTYPE = 'T' THEN
      (SELECT D.DEFINER FROM SYSIBM.SYSTABLES D WHERE D.NAME = C.OBJECTNAME AND D.CREATOR = C.OBJECTSCHEMA) END)
    FROM SYSIBM.SYSUSAGELISTS C WHERE C.USAGELISTNAME = A.OBJECTNAME AND C.USAGELISTSCHEMA = A.OBJECTSCHEMA)
  END) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSJARCONTENTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSJARCONTENTS_PERM ON SYSIBM.SYSJARCONTENTS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSJAROBJECTS B WHERE B.JAR_ID = A.JAR_ID AND B.JARSCHEMA = A.JARSCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSJAROBJECTS B WHERE B.JAR_ID = A.JAR_ID AND B.JARSCHEMA = A.JARSCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSJAROBJECTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSJAROBJECTS_PERM ON SYSIBM.SYSJAROBJECTS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSJOBS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSJOBS_PERM ON SYSIBM.SYSJOBS A FOR ROWS WHERE
 OWNER LIKE 'SYS%' OR OWNER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSKEYCOLUSE ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSKEYCOLUSE_PERM ON SYSIBM.SYSKEYCOLUSE A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TBNAME LIKE 'SYN%' AND A.TBCREATOR = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) LIKE 'SYS%') OR
 (A.TBNAME LIKE 'SYN%' AND A.TBCREATOR = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.TBCREATOR, A.TBNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSLIBRARIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSLIBRARIES_PERM ON SYSIBM.SYSLIBRARIES A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSLIBRARYAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSLIBRARYAUTH_PERM ON SYSIBM.SYSLIBRARYAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSLIBRARIES B WHERE B.LIBNAME = A.LIBNAME AND B.LIBSCHEMA = A.LIBSCHEMA) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSLIBRARIES B WHERE B.LIBNAME = A.LIBNAME AND B.LIBSCHEMA = A.LIBSCHEMA) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSLIBRARYBINDFILES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSLIBRARYBINDFILES_PERM ON SYSIBM.SYSLIBRARYBINDFILES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSLIBRARIES B WHERE B.LIB_ID = A.LIB_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSLIBRARIES B WHERE B.LIB_ID = A.LIB_ID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSLIBRARYVERSIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSLIBRARYVERSIONS_PERM ON SYSIBM.SYSLIBRARYVERSIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSLIBRARIES B WHERE B.LIB_ID = A.LIB_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSLIBRARIES B WHERE B.LIB_ID = A.LIB_ID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSMODULEAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSMODULEAUTH_PERM ON SYSIBM.SYSMODULEAUTH A FOR ROWS WHERE
 (SELECT B.OWNER FROM SYSIBM.SYSMODULES B WHERE B.MODULEID = A.MODULEID) LIKE 'SYS%' OR
 (SELECT B.OWNER FROM SYSIBM.SYSMODULES B WHERE B.MODULEID = A.MODULEID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSMODULES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSMODULES_PERM ON SYSIBM.SYSMODULES A FOR ROWS WHERE
 OWNER LIKE 'SYS%' OR OWNER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSNAMEMAPPINGS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSNAMEMAPPINGS_PERM ON SYSIBM.SYSNAMEMAPPINGS A FOR ROWS WHERE
 (CASE WHEN TYPE = 'I' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.IMPL_NAME AND B.CREATOR = A.IMPL_SCHEMA)
  WHEN (TYPE = 'C' OR TYPE = 'U') THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.IMPL_NAME AND B.CREATOR = A.IMPL_SCHEMA) END) LIKE 'SYS%' OR
 (CASE WHEN TYPE = 'I' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.IMPL_NAME AND B.CREATOR = A.IMPL_SCHEMA)
  WHEN (TYPE = 'C' OR TYPE = 'U') THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.IMPL_NAME AND B.CREATOR = A.IMPL_SCHEMA) END) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSPERIODS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSPERIODS_PERM ON SYSIBM.SYSPERIODS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1')  OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSPLAN ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSPLAN_PERM ON SYSIBM.SYSPLAN A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSPLANAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSPLANAUTH_PERM ON SYSIBM.SYSPLANAUTH A FOR ROWS WHERE
 (SELECT MAX(B.DEFINER) FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.NAME AND B.CREATOR = A.CREATOR) LIKE 'SYS%' OR
 (SELECT MAX(B.DEFINER) FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.NAME AND B.CREATOR = A.CREATOR) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSPLANDEP ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSPLANDEP_PERM ON SYSIBM.SYSPLANDEP A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.DNAME AND B.CREATOR = A.DCREATOR AND B.UNIQUE_ID = DUNIQUE_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.DNAME AND B.CREATOR = A.DCREATOR AND B.UNIQUE_ID = DUNIQUE_ID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSPREDICATESPECS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSPREDICATESPECS_PERM ON SYSIBM.SYSPREDICATESPECS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.FUNCID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.FUNCID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSRELS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSRELS_PERM ON SYSIBM.SYSRELS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROUTINEAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROUTINEAUTH_PERM ON SYSIBM.SYSROUTINEAUTH A FOR ROWS WHERE
 (CASE WHEN ROUTINETYPE = 'M' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.TYPENAME AND B.SCHEMA = A.TYPESCHEMA AND B.TYPEMODULEID IS NULL)
  WHEN (ROUTINETYPE = 'F' OR ROUTINETYPE = 'P') THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.SPECIFICNAME = A.SPECIFICNAME AND B.ROUTINESCHEMA = A.SCHEMA AND B.ROUTINEMODULEID IS NULL) END) LIKE 'SYS%' OR
 (CASE WHEN ROUTINETYPE = 'M' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.NAME = A.TYPENAME AND B.SCHEMA = A.TYPESCHEMA AND B.TYPEMODULEID IS NULL)
  WHEN (ROUTINETYPE = 'F' OR ROUTINETYPE = 'P') THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.SPECIFICNAME = A.SPECIFICNAME AND B.ROUTINESCHEMA = A.SCHEMA AND B.ROUTINEMODULEID IS NULL) END) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROUTINEOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROUTINEOPTIONS_PERM ON SYSIBM.SYSROUTINEOPTIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINEID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINEID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROUTINEPARMOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROUTINEPARMOPTIONS_PERM ON SYSIBM.SYSROUTINEPARMOPTIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINEID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINEID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROUTINEPARMS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROUTINEPARMS_PERM ON SYSIBM.SYSROUTINEPARMS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINE_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINE_ID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROUTINEPROPERTIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROUTINEPROPERTIES_PERM ON SYSIBM.SYSROUTINEPROPERTIES A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINE_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSROUTINES B WHERE B.ROUTINE_ID = A.ROUTINE_ID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROUTINES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROUTINES_PERM ON SYSIBM.SYSROUTINES A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSCHEMAAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSCHEMAAUTH_PERM ON SYSIBM.SYSSCHEMAAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSSCHEMATA B WHERE B.NAME = A.SCHEMANAME) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSSCHEMATA B WHERE B.NAME = A.SCHEMANAME) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSCHEMATA ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSCHEMATA_PERM ON SYSIBM.SYSSCHEMATA A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECTION ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECTION_PERM ON SYSIBM.SYSSECTION A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.PLNAME AND B.CREATOR = A.PLCREATOR AND B.UNIQUE_ID = A.UNIQUE_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.PLNAME AND B.CREATOR = A.PLCREATOR AND B.UNIQUE_ID = A.UNIQUE_ID) in (SESSION_USER, 'DB2INST1')  
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSEQUENCEAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSEQUENCEAUTH_PERM ON SYSIBM.SYSSEQUENCEAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSSEQUENCES B WHERE B.SEQID = A.SEQID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSSEQUENCES B WHERE B.SEQID = A.SEQID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSEQUENCES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSEQUENCES_PERM ON SYSIBM.SYSSEQUENCES A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSTMT ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSTMT_PERM ON SYSIBM.SYSSTMT A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.PLNAME AND B.CREATOR = A.PLCREATOR AND B.UNIQUE_ID = A.UNIQUE_ID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSPLAN B WHERE B.NAME = A.PLNAME AND B.CREATOR = A.PLCREATOR AND B.UNIQUE_ID = A.UNIQUE_ID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTABAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTABAUTH_PERM ON SYSIBM.SYSTABAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TTNAME AND B.CREATOR = A.TCREATOR) in (SESSION_USER, 'DB2INST1')  OR
 (NOT (A.TTNAME LIKE 'SYN%' AND A.TCREATOR = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TTNAME AND B.CREATOR = A.TCREATOR) LIKE 'SYS%') OR
 (A.TTNAME LIKE 'SYN%' AND A.TCREATOR = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.TCREATOR, A.TTNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTABCONST ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTABCONST_PERM ON SYSIBM.SYSTABCONST A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) in (SESSION_USER, 'DB2INST1')  OR
 (NOT (A.TBNAME LIKE 'SYN%' AND A.TBCREATOR = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TBNAME AND B.CREATOR = A.TBCREATOR) LIKE 'SYS%') OR
 (A.TBNAME LIKE 'SYN%' AND A.TBCREATOR = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.TBCREATOR, A.TBNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTABLES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTABLES_PERM ON SYSIBM.SYSTABLES A FOR ROWS WHERE
 (DEFINER in (SESSION_USER) AND CREATOR in (SESSION_USER)) OR
 (DEFINER = 'DB2INST1' AND (CREATOR LIKE 'GOSALES%' OR CREATOR = 'SAMPLES' OR CREATOR = 'SYSTOOLS')) OR
 (DEFINER LIKE 'SYS%' AND NOT NAME LIKE 'SYN%') OR
 (DEFINER = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.CREATOR, A.NAME) in (SESSION_USER))
ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTABLESPACES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTABLESPACES_PERM ON SYSIBM.SYSTABLESPACES A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTABOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTABOPTIONS_PERM ON SYSIBM.SYSTABOPTIONS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1')  OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND  SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTBSPACEAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTBSPACEAUTH_PERM ON SYSIBM.SYSTBSPACEAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLESPACES B WHERE B.TBSPACEID = A.TBSPACEID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLESPACES B WHERE B.TBSPACEID = A.TBSPACEID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTRANSFORMS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTRANSFORMS_PERM ON SYSIBM.SYSTRANSFORMS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.TYPEID = A.TYPEID) LIKE 'SYS%' OR
 (SELECT B.DEFINER FROM SYSIBM.SYSDATATYPES B WHERE B.TYPEID = A.TYPEID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTRIGGERS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTRIGGERS_PERM ON SYSIBM.SYSTRIGGERS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTYPEMAPPINGS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTYPEMAPPINGS_PERM ON SYSIBM.SYSTYPEMAPPINGS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSUSAGELISTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSUSAGELISTS_PERM ON SYSIBM.SYSUSAGELISTS A FOR ROWS WHERE
 (CASE WHEN A.OBJECTTYPE = 'I' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.OBJECTNAME AND B.CREATOR = A.OBJECTSCHEMA)
  WHEN A.OBJECTTYPE = 'T' AND NOT (A.OBJECTSCHEMA = 'SYSIBM' AND A.OBJECTNAME LIKE 'SYN%') THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.OBJECTNAME AND B.CREATOR = A.OBJECTSCHEMA) END) LIKE 'SYS%' OR
 (CASE WHEN A.OBJECTTYPE = 'I' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSINDEXES B WHERE B.NAME = A.OBJECTNAME AND B.CREATOR = A.OBJECTSCHEMA)
  WHEN A.OBJECTTYPE = 'T' THEN
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.OBJECTNAME AND B.CREATOR = A.OBJECTSCHEMA) END) in (SESSION_USER, 'DB2INST1')  OR
 (A.OBJECTTYPE = 'T' AND A.OBJECTSCHEMA = 'SYSIBM' AND A.OBJECTNAME LIKE 'SYS%' AND
  SYNOPSIS_TABLE_DEFINER(A.OBJECTSCHEMA, A.OBJECTNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSUSERAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSUSERAUTH_PERM ON SYSIBM.SYSUSERAUTH A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) in (SESSION_USER, 'DB2INST1') OR
 (NOT (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.TABNAME AND B.CREATOR = A.TABSCHEMA) LIKE 'SYS%') OR
 (A.TABNAME LIKE 'SYN%' AND A.TABSCHEMA = 'SYSIBM' AND SYNOPSIS_TABLE_DEFINER(A.TABSCHEMA, A.TABNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;
 
--

ALTER TABLE SYSIBM.SYSVARIABLEAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSVARIABLEAUTH_PERM ON SYSIBM.SYSVARIABLEAUTH A FOR ROWS WHERE
 (SELECT B.OWNER FROM SYSIBM.SYSVARIABLES B WHERE B.VARID = A.VARID) LIKE 'SYS%' OR
 (SELECT B.OWNER FROM SYSIBM.SYSVARIABLES B WHERE B.VARID = A.VARID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSVARIABLES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSVARIABLES_PERM ON SYSIBM.SYSVARIABLES A FOR ROWS WHERE
 OWNER LIKE 'SYS%' OR OWNER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSVIEWDEP ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSVIEWDEP_PERM ON SYSIBM.SYSVIEWDEP A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.DNAME AND B.CREATOR = A.DCREATOR) in (SESSION_USER, 'DB2INST1') OR
 (NOT(A.DCREATOR = 'SYSIBM' AND A.DNAME LIKE 'SYN%') AND
  (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE B.NAME = A.DNAME AND B.CREATOR = A.DCREATOR) LIKE 'SYS%') OR
 (A.DCREATOR = 'SYSIBM' AND A.DNAME LIKE 'SYN%' AND  SYNOPSIS_TABLE_DEFINER(A.DCREATOR, A.DNAME) in (SESSION_USER, 'DB2INST1'))
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSVIEWS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSVIEWS_PERM ON SYSIBM.SYSVIEWS A FOR ROWS WHERE
 DEFINER LIKE 'SYS%' OR DEFINER in (SESSION_USER, 'DB2INST1') ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSXDBMAPGRAPHS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSXDBMAPGRAPHS_PERM ON SYSIBM.SYSXDBMAPGRAPHS A FOR ROWS WHERE
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) LIKE 'SYS%' OR
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSXDBMAPSHREDTREES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSXDBMAPSHREDTREES_PERM ON SYSIBM.SYSXDBMAPSHREDTREES A FOR ROWS WHERE
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) LIKE 'SYS%' OR
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSXSROBJECTAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSXSROBJECTAUTH_PERM ON SYSIBM.SYSXSROBJECTAUTH A FOR ROWS WHERE
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) LIKE 'SYS%' OR
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSXSROBJECTCOMPONENTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSXSROBJECTCOMPONENTS_PERM ON SYSIBM.SYSXSROBJECTCOMPONENTS A FOR ROWS WHERE
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = (SELECT C.XSROBJECTID FROM SYSIBM.SYSXSROBJECTHIERARCHIES C WHERE C.XSRCOMPONENTID = A.XSRCOMPONENTID)) LIKE 'SYS%' OR
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = (SELECT C.XSROBJECTID FROM SYSIBM.SYSXSROBJECTHIERARCHIES C WHERE C.XSRCOMPONENTID = A.XSRCOMPONENTID)) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSXSROBJECTHIERARCHIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSXSROBJECTHIERARCHIES_PERM ON SYSIBM.SYSXSROBJECTHIERARCHIES A FOR ROWS WHERE
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) LIKE 'SYS%' OR
 (SELECT B.OWNER FROM SYSIBM.SYSXSROBJECTS B WHERE B.XSROBJECTID = A.XSROBJECTID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSXSROBJECTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSXSROBJECTS_PERM ON SYSIBM.SYSXSROBJECTS A FOR ROWS WHERE
 OWNER LIKE 'SYS%' OR OWNER in (SESSION_USER, 'DB2INST1')  ENFORCED FOR ALL ACCESS ENABLE;

--

-----------------------------------
-- PERMISSIONS ADDED POST REVIEW --
-----------------------------------

CREATE OR REPLACE FUNCTION USER_HAS_AUTH (USERID VARCHAR(128), AUTHID VARCHAR(128))
 SECURED DETERMINISTIC NO EXTERNAL ACTION
 RETURNS INT
BEGIN ATOMIC
 DECLARE V1 INT DEFAULT 0;--
 SET V1 = (SELECT 1 FROM SYSIBM.SYSDUMMY1 WHERE AUTHID IN
           (SELECT AUTHORITY FROM TABLE (AUTH_LIST_AUTHORITIES_FOR_AUTHID(USERID, 'U'))
            WHERE D_USER='Y' OR D_GROUP='Y' OR D_PUBLIC='Y' OR ROLE_PUBLIC='Y' OR ROLE_USER='Y'));--
 RETURN V1;--
END;

--

ALTER TABLE SYSIBM.SYSAUDITEXCEPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSAUDITEXCEPTIONS_PERM ON SYSIBM.SYSAUDITEXCEPTIONS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSAUDITPOLICIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSAUDITPOLICIES_PERM ON SYSIBM.SYSAUDITPOLICIES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSAUDITUSE ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSAUDITUSE_PERM ON SYSIBM.SYSAUDITUSE A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSBUFFERPOOLNODES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSBUFFERPOOLNODES_PERM ON SYSIBM.SYSBUFFERPOOLNODES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSCTRL')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSBUFFERPOOLS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSBUFFERPOOLS_PERM ON SYSIBM.SYSBUFFERPOOLS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSCTRL')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCONTEXTATTRIBUTES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCONTEXTATTRIBUTES_PERM ON SYSIBM.SYSCONTEXTATTRIBUTES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSCONTEXTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSCONTEXTS_PERM ON SYSIBM.SYSCONTEXTS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

-----------------------------------------------------------------------
-- BASED ON GRANT (DATABASE AUTHORITIES) REQUIRING ACCESSCTRL OR SECADM
-----------------------------------------------------------------------

ALTER TABLE SYSIBM.SYSDBAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSDBAUTH_PERM ON SYSIBM.SYSDBAUTH A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'ACCESSCTRL') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSHISTOGRAMTEMPLATEBINS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSHISTOGRAMTEMPLATEBINS_PERM ON SYSIBM.SYSHISTOGRAMTEMPLATEBINS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSHISTOGRAMTEMPLATES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSHISTOGRAMTEMPLATES_PERM ON SYSIBM.SYSHISTOGRAMTEMPLATES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSHISTOGRAMTEMPLATEUSE ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSHISTOGRAMTEMPLATEUSE_PERM ON SYSIBM.SYSHISTOGRAMTEMPLATEUSE A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSMEMBERSUBSETATTRS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSMEMBERSUBSETATTRS_PERM ON SYSIBM.SYSMEMBERSUBSETATTRS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSMEMBERSUBSETMEMBERS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSMEMBERSUBSETMEMBERS_PERM ON SYSIBM.SYSMEMBERSUBSETMEMBERS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSMEMBERSUBSETS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSMEMBERSUBSETS_PERM ON SYSIBM.SYSMEMBERSUBSETS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSNODEGROUPDEF ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSNODEGROUPDEF_PERM ON SYSIBM.SYSNODEGROUPDEF A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSCTRL')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSNODEGROUPS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSNODEGROUPS_PERM ON SYSIBM.SYSNODEGROUPS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSCTRL')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSPARTITIONMAPS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSPARTITIONMAPS_PERM ON SYSIBM.SYSPARTITIONMAPS A FOR ROWS WHERE
 A.PMAP_ID = -2 OR
 'SYSIBM' IN (SELECT B.DEFINER FROM SYSIBM.SYSNODEGROUPS B WHERE B.PMAP_ID = A.PMAP_ID) OR
 SESSION_USER IN (SELECT C.DEFINER FROM SYSIBM.SYSTABLES C WHERE C.PMAP_ID = A.PMAP_ID)
 ENFORCED FOR ALL ACCESS ENABLE;

--

--------------------------------------------------------------------
-- BASED ON GRANT (SERVER PRIVILEGES) REQUIRING ACCESSCTRL OR SECADM
--------------------------------------------------------------------

ALTER TABLE SYSIBM.SYSPASSTHRUAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSPASSTHRUAUTH_PERM ON SYSIBM.SYSPASSTHRUAUTH A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'ACCESSCTRL') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROLEAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROLEAUTH_PERM ON SYSIBM.SYSROLEAUTH A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM') OR
 A.GRANTEE=SESSION_USER
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSROLES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSROLES_PERM ON SYSIBM.SYSROLES A FOR ROWS WHERE
1 = USER_HAS_AUTH(SESSION_USER, 'SECADM') OR
(ROUTINE_SCHEMA = 'SYSIBMADM' AND ROUTINE_MODULE = 'IDAX')
ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSCPREFTBSPACES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSCPREFTBSPACES_PERM ON SYSIBM.SYSSCPREFTBSPACES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECURITYLABELACCESS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECURITYLABELACCESS_PERM ON SYSIBM.SYSSECURITYLABELACCESS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECURITYLABELCOMPONENTELEMENTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECURITYLABELCOMPONENTELEMENTS_PERM ON SYSIBM.SYSSECURITYLABELCOMPONENTELEMENTS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECURITYLABELCOMPONENTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECURITYLABELCOMPONENTS_PERM ON SYSIBM.SYSSECURITYLABELCOMPONENTS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECURITYLABELS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECURITYLABELS_PERM ON SYSIBM.SYSSECURITYLABELS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECURITYPOLICIES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECURITYPOLICIES_PERM ON SYSIBM.SYSSECURITYPOLICIES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECURITYPOLICYCOMPONENTRULES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECURITYPOLICYCOMPONENTRULES_PERM ON SYSIBM.SYSSECURITYPOLICYCOMPONENTRULES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSECURITYPOLICYEXEMPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSECURITYPOLICYEXEMPTIONS_PERM ON SYSIBM.SYSSECURITYPOLICYEXEMPTIONS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSERVEROPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSERVEROPTIONS_PERM ON SYSIBM.SYSSERVEROPTIONS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSERVERS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSERVERS_PERM ON SYSIBM.SYSSERVERS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSERVICECLASSES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSERVICECLASSES_PERM ON SYSIBM.SYSSERVICECLASSES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSTATEMENTTEXTS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSTATEMENTTEXTS_PERM ON SYSIBM.SYSSTATEMENTTEXTS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSSTOGROUPS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSTOGROUPS_PERM ON SYSIBM.SYSSTOGROUPS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSCTRL')
 ENFORCED FOR ALL ACCESS ENABLE;

--

-------------------------------------------------------------
-- BASED ON GRANT (SETSESSIONUSER PRIVILEGE) REQUIRING SECADM
-------------------------------------------------------------

ALTER TABLE SYSIBM.SYSSURROGATEAUTHIDS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSSURROGATEAUTHIDS_PERM ON SYSIBM.SYSSURROGATEAUTHIDS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SECADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTASKS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTASKS_PERM ON SYSIBM.SYSTASKS A FOR ROWS WHERE
 (SELECT B.DEFINER FROM SYSIBM.SYSTABLES B WHERE A.OBJECTTYPE = 0 AND B.FID = A.OBJECTID AND B.TID = A.TBSPACEID) in (SESSION_USER, 'DB2INST1') 
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTHRESHOLDS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTHRESHOLDS_PERM ON SYSIBM.SYSTHRESHOLDS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSTUNINGINFO ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSTUNINGINFO_PERM ON SYSIBM.SYSTUNINGINFO A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSCTRL') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSMAINT')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSUPGRADERUNSTATSTASKS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSUPGRADERUNSTATSTASKS_PERM ON SYSIBM.SYSUPGRADERUNSTATSTASKS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'SYSADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSUSEROPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSUSEROPTIONS_PERM ON SYSIBM.SYSUSEROPTIONS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSVERSIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSVERSIONS_PERM ON SYSIBM.SYSVERSIONS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKACTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKACTIONS_PERM ON SYSIBM.SYSWORKACTIONS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKACTIONSETS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKACTIONSETS_PERM ON SYSIBM.SYSWORKACTIONSETS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKCLASSATTRIBUTES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKCLASSATTRIBUTES_PERM ON SYSIBM.SYSWORKCLASSATTRIBUTES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKCLASSES ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKCLASSES_PERM ON SYSIBM.SYSWORKCLASSES A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKCLASSSETS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKCLASSSETS_PERM ON SYSIBM.SYSWORKCLASSSETS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKLOADAUTH ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKLOADAUTH_PERM ON SYSIBM.SYSWORKLOADAUTH A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKLOADCONNATTR ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKLOADCONNATTR_PERM ON SYSIBM.SYSWORKLOADCONNATTR A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWORKLOADS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWORKLOADS_PERM ON SYSIBM.SYSWORKLOADS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM') OR
 1 = USER_HAS_AUTH(SESSION_USER, 'WLMADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWRAPOPTIONS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWRAPOPTIONS_PERM ON SYSIBM.SYSWRAPOPTIONS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM')
 ENFORCED FOR ALL ACCESS ENABLE;

--

ALTER TABLE SYSIBM.SYSWRAPPERS ACTIVATE ROW ACCESS CONTROL;

CREATE PERMISSION SYSWRAPPERS_PERM ON SYSIBM.SYSWRAPPERS A FOR ROWS WHERE
 1 = USER_HAS_AUTH(SESSION_USER, 'DBADM')
 ENFORCED FOR ALL ACCESS ENABLE;


--REVOKE CREATE_EXTERNAL_ROUTINE ON DATABASE FROM GROUP BLUUSERS;
--REVOKE ALL ON SYSIBMADM.ADMINTABINFO FROM GROUP BLUUSERS;
--REVOKE EXECUTE ON FUNCTION SYSPROC.ADMIN_GET_TAB_INFO_V97 FROM GROUP BLUUSERS RESTRICT;
REVOKE SELECT ON SYSIBMADM.ADMINTABINFO FROM PUBLIC;
REVOKE EXECUTE ON FUNCTION SYSPROC.ADMIN_GET_TAB_INFO_V97 FROM PUBLIC RESTRICT;


-- Revoke createin for the applicable schemas
REVOKE CREATEIN ON SCHEMA DB2INST1 FROM PUBLIC;


CONNECT RESET;
TERMINATE;
