#!/bin/bash

bs_db2u_root_entrypoint() {
    echo "||| Running db2u root entrypoint |||"
    time sudo sh -c "/db2u/db2u_root_entrypoint.sh"
    if [ $? -ne 0 ]; then
        echo "db2u root entrypoint failure"
        exit 1
    fi
}

bs_db2u_restore_morph() {
    echo "||| Running Restore Morph |||"
    time sudo su - db2inst1 -c "/db2u/db2u_restore_morph.sh"
    if [ $? -ne 0 ]; then
        echo "db2u restore morph failure"
        exit 1
    fi
}

bs_db2set() {
    echo "||| Running Db2 set |||"
    time sudo su - db2inst1 -c "/conf/db2oc/db2set.sh"
    if [ $? -ne 0 ]; then
        echo "compose-db2 db2set failure"
        exit 1
    fi
}

bs_db2initsql() {
    echo "||| Running Db2 Init SQL |||"
    time sudo su - db2inst1 -c "db2 -tvf /conf/db2oc/init.sql"
    # activate db returns 6 for some reason on success
    if [[ $? -ne 0 && $? -ne 6 ]]; then
        echo "compose-db2 init.sql failure"
        exit 1
    fi
}

bs_db2hadrsetup() {
    echo "||| Running Db2 HADR setup |||"
    time sudo su - db2inst1 -c "/db2u/db2oc-neb-hasetup/db2_setup_hadr.sh"
    if [[ $? -ne 0 && $? -ne 6 ]]; then
        echo "compose-db2 init.sql failure"
        exit 1
    fi
}

bs_db2usertables() {
    echo "||| Creating User Tables |||"
    time sudo su - db2inst1 -c 'db2 connect to bludb;\
    db2 "CREATE TABLE DB2INST1.USER_TABLE (USERNAME varchar(20),GROUP varchar(20),EMAIL varchar(200),LOCKED boolean with default false,IBMID varchar(500),POLICYNAME varchar(500));";\
    db2 terminate;
    '
}

bs_db2policytables() {
    echo "||| Creating Policy Tables |||"
    time sudo su - db2inst1 -c 'db2 connect to bludb;\
    db2 "CREATE TABLE DB2INST1.POLICY (POLICYNAME varchar(500),NUMRETRY int with default 5,PASSWORDLENGTH int with default 15);";\
    db2 terminate;
    '
}

bs_harden_dbaccess() {
    echo "||| Running Security SQL for User Access |||"
    if [ -e '/db2u/db2oc-neb-hasetup/init.sql' ]; then
        time sudo su - db2inst1 -c "db2 -tvf /db2u/db2oc-neb-hasetup/init.sql"
        if [[ $? -ne 0 ]]; then
            echo "compose-db2 init.sql failure"
            exit 1
        fi
    else
        echo "||| /db2u/db2oc-neb-hasetup/init.sql not found |||"
    fi
}

bs_configure_db2audit() {
    echo "||| configuring db2 audit"
    time sudo -u db2inst1 -i db2audit configure datapath /mnt/blumeta0/db2/audit archivepath /mnt/blumeta0/db2/audit >/dev/null
    if [[ $? -ne 0 ]]; then
        echo "failed to configure db2audit"
    else
        echo "configuring db2aduit is successful"
    fi
}

bs_setup_db2audit() {
    echo "||| Running db2audit object and setup|||"
    if [ -e '/db2u/db2oc-neb-hasetup/setupaudit.clp' ]; then
        bs_configure_db2audit
        time sudo su - db2inst1 -c "db2 -v connect to bludb; db2 -td@ -vf /db2u/db2oc-neb-hasetup/setupaudit.clp; db2 -v connect reset"
        if [[ $? -ne 0 ]]; then
            echo "setupaudit.clp setup failure"
        fi
    else
        echo "||| /db2u/db2oc-neb-hasetup/setupaudit.clp doesn't exist skipping audit setup"
    fi
}

if [ $# -eq 0 ]; then
    echo "Usage: "
    echo "-i | --initialize Initailize boostrap with all script commands"
    echo "-o | --option (-i required) will run one specific option [ entry | restore_morph | db2set | initsql ]"
    echo "-h | --hadr will run HADR setup script generated by configuration"
fi

for arg in "$@"; do
    case $arg in
    -i | --initialize)
        if [ $# -gt 1 ]; then
            echo "Initialization with options"
            INITIALIZE=1
        else
            echo "Full initialization requested"
            bs_db2u_root_entrypoint
            bs_db2u_restore_morph
            bs_configure_db2audit
            # move all of these table creations to db2u preinit
            #bs_db2usertables
            #bs_db2policytables
            #bs_harden_dbaccess
            #bs_setup_db2audit
        fi
        shift
        ;;
    -o | --option)
        if [ $INITIALIZE -eq 1 ]; then
            if [ "$2" == "entry" ]; then
                bs_db2u_root_entrypoint
            elif [ "$2" == "restore_morph" ]; then
                bs_db2u_restore_morph
            else
                echo "Argument not recognized"
            fi
        fi
        break
        ;;
    -h | --hadrsetup)
        bs_db2hadrsetup
        break
        ;;
    esac
done
