
# 💙 Contributing


Contributions are welcome, and they are greatly appreciated! Every little bit helps, and credit will always be given.

You can contribute in many ways:
# Types of Contributions
### Report Bugs

Report bugs at https://github.com/file-validator/file-validator/issues

If you are reporting a bug, please include:

* Your operating system name and version.
* Any details about your local setup that might be helpful in troubleshooting.
* Detailed steps to reproduce the bug.

### Fix Bugs

Look through the GitHub issues for bugs. Anything tagged with “bug” and “help wanted” is open to whoever wants to implement it.

### Implement Features

Look through the GitHub issues for features. Anything tagged with “enhancement” and “help wanted” is open to whoever wants to implement it.

### Write Documentation

File Validator could always use more documentation, whether as part of the official File Validator docs, in docstrings, or even on the web in blog posts, articles, and such.

### Submit Feedback

The best way to send feedback is to file an issue at https://github.com/file-validator/file-validator/issues

If you are proposing a feature:

* Explain in detail how it would work.
* Keep the scope as narrow as possible, to make it easier to implement.
* Remember that this is a volunteer-driven project, and that contributions are welcome :)

### Pull Request Guidelines

Before you submit a pull request, check that it meets these guidelines:

1. The pull request should include tests.
2. If the pull request adds functionality, the docs should be updated. Put your new functionality into a function with a docstring, and add the feature to the list in README.rst.
3. The pull request should work for Python 3.8, 3.9 and 3.10, and for PyPy.
4. Run the tests before the Pull Request and must be successfully executed and accepted until the Pull Request, and this proves that there is no problem for the codes that are already running.
5. Check your code with Pylint to meet the standards, [Pylint](https://pylint.readthedocs.io/en/latest/) analyses your code without actually running it. It checks for errors, enforces a coding standard, looks for code smells, and can make suggestions about how the code could be refactored.
6. You can also use [Black](https://github.com/psf/black) to format your code
7. also check code with [pre-commit](https://pre-commit.com/) before release
