<img src="https://raw.githubusercontent.com/jepegit/cellpy/master/docs/_static/cellpy-icon-long.svg" height="100" alt="cellpy-icon">

# **cellpy** - *a library for assisting in analysing batteries and cells*


[![cellpy](https://img.shields.io/pypi/v/cellpy.svg)](https://pypi.python.org/pypi/cellpy)
[![cellpy](https://readthedocs.org/projects/cellpy/badge/?version=latest)](https://cellpy.readthedocs.io/en/latest/?badge=latest)
[![cellpy](https://static.pepy.tech/badge/cellpy)](https://pepy.tech/project/cellpy)

This Python Package was developed to help the
researchers at IFE, Norway, in their cumbersome task of
interpreting and handling data from cycling tests of batteries and cells.

## Features

* Convert testing data into a common format
* Summarize and compare data
* Filter out the steps of interest
* Process and plot the data
* Do simple and advanced analysis on single datasets as well as collections of datasets
* And more!

## Documentation

The documentation for ``cellpy`` is hosted on [Read the Docs](https://cellpy.readthedocs.io).

## Installation and dependencies

The easiest way to install ``cellpy`` is to install with conda or pip.

With conda:

```
conda install -c conda-forge cellpy
```

Or if you prefer installing using pip:

```
python -m pip install cellpy
```

Have a look at the documentation for more detailed installation procedures, especially
with respect to "difficult" dependencies when installing with pip.

## License

``cellpy`` is free software made available under the MIT License.

## Citing cellpy

If you use ``cellpy`` in your work, please cite our paper:

> Wind J., Ulvestad A., Abdelhamid M., Mæhlen J.P. (2024). Cellpy – an open-source library for processing and analysis of battery testing data. _Journal of Open Source Software, 9(97), 6236_.

[![DOI](https://joss.theoj.org/papers/10.21105/joss.06236/status.svg)](https://doi.org/10.21105/joss.06236)

## Contributing

Contributions are welcome, and they are greatly appreciated! Every
little bit helps, and credit will always be given. If you want to contribute,
please have a look at [Contributing Guidelines](CONTRIBUTING.md).
