#!/usr/bin/env node
"use strict";
// ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
Object.defineProperty(exports, "__esModule", { value: true });
const os = require("os");
const process_1 = require("process");
const client_sfn_1 = require("@aws-sdk/client-sfn");
const transliterator_ecstask_1 = require("./transliterator.ecstask");
const sfn = new client_sfn_1.SFNClient({});
const taskToken = process_1.env.SFN_TASK_TOKEN;
delete process_1.env.SFN_TASK_TOKEN;
function sendHeartbeat() {
    sfn.send(new client_sfn_1.SendTaskHeartbeatCommand({ taskToken })).then(() => console.log('Successfully sent task heartbeat!'), (reason) => {
        console.error('Failed to send task heartbeat:', reason);
        if (reason.code === 'TaskTimedOut') {
            process_1.exit(-(os.constants.errno.ETIMEDOUT || 1));
        }
    });
}
sendHeartbeat();
const heartbeat = setInterval(sendHeartbeat, 60000);
async function main() {
    var _a, _b;
    try {
        const input = process_1.argv.slice(2).map((text) => JSON.parse(text));
        const result = await transliterator_ecstask_1.handler(...input);
        console.log('Task result:', result);
        await sfn.send(new client_sfn_1.SendTaskSuccessCommand({ output: JSON.stringify(result), taskToken }));
    }
    catch (err) {
        console.log('Task failed:', err);
        process.exitCode = 1;
        await sfn.send(new client_sfn_1.SendTaskFailureCommand({
            cause: JSON.stringify(err),
            error: (_b = (_a = err.name) !== null && _a !== void 0 ? _a : err.constructor.name) !== null && _b !== void 0 ? _b : 'Error',
            taskToken,
        }));
    }
    finally {
        clearInterval(heartbeat);
    }
}
main().catch((cause) => {
    console.log('Unexpected error:', cause);
    process_1.exit(-1);
});
//# sourceMappingURL=data:application/json;base64,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