import { GatewayVpcEndpoint, InterfaceVpcEndpoint, SubnetSelection } from '@aws-cdk/aws-ec2';
import { ContainerDefinition, ICluster } from '@aws-cdk/aws-ecs';
import { ILogGroup, RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { TaskStateBaseProps } from '@aws-cdk/aws-stepfunctions';
import { EcsRunTask } from '@aws-cdk/aws-stepfunctions-tasks';
import { Construct } from '@aws-cdk/core';
import { Repository } from '../../codeartifact/repository';
import { Monitoring } from '../../monitoring';
export interface TransliteratorProps {
    /**
     * The bucket in which to source assemblies to transliterate.
     */
    readonly bucket: IBucket;
    /**
     * The CodeArtifact registry to use for regular operations.
     */
    readonly codeArtifact?: Repository;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * VPC endpoints to use for interacting with CodeArtifact and S3.
     */
    readonly vpcEndpoints?: TransliteratorVpcEndpoints;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
export interface TransliteratorVpcEndpoints {
    /**
     * The VPC endpoint for the CloudWatch Logs API.
     */
    readonly cloudWatchLogs: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the CodeArtifact API (service: 'codeartifact.api')
     */
    readonly codeArtifactApi: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the CodeArtifact repositories (service: 'codeartifact.repositories')
     */
    readonly codeArtifact: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint to interact with ECR.
     */
    readonly ecrApi: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint to interact with ECR.
     */
    readonly ecr: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the S3
     */
    readonly s3: GatewayVpcEndpoint;
    /**
     * The VPC endpoint for StepFunctions.
     */
    readonly stepFunctions: InterfaceVpcEndpoint;
}
/**
 * Transliterates jsii assemblies to various other languages.
 */
export declare class Transliterator extends Construct {
    readonly containerDefinition: ContainerDefinition;
    readonly logGroup: ILogGroup;
    get taskDefinition(): import("@aws-cdk/aws-ecs").TaskDefinition;
    constructor(scope: Construct, id: string, props: TransliteratorProps);
    createEcsRunTask(scope: Construct, id: string, opts: CreateEcsRunTaskOpts): EcsRunTask;
}
export interface CreateEcsRunTaskOpts extends TaskStateBaseProps {
    /**
     * The ECS cluster to use for running the task (must support Fargate)
     */
    readonly cluster: ICluster;
    /**
     * The input path to the transliterator input object, presented as an array
     * containing a single JSON-encoded object.
     *
     * This is due to the lack of an ability to "cleanly" model an API where the
     * `createEcsRunTask` method could do the input processing properly...
     */
    readonly inputPath: string;
    /**
     * VPC Subnet placement options, if relevant.
     */
    readonly vpcSubnets?: SubnetSelection;
}
