% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{run_umap}
\alias{run_umap}
\title{Run UMAP on the MOFA factors}
\usage{
run_umap(object, factors = "all", groups = "all", ...)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{factors}{character vector with the factor names, or numeric vector with the indices of the factors to use, or "all" to plot all factors.}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{...}{arguments passed to \code{\link{umap}}}
}
\value{
Returns a \code{\link{MOFA}} object with the dim_red slot filled with the UMAP output
}
\description{
Run UMAP on the MOFA factors
}
\details{
use set.seed before the function call to get reproducible results.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Run UMAP
\dontrun{ model <- run_umap(model) }

# Change hyperparameters passed to umap
\dontrun{ model <- run_umap(model, min_dist = 0.01, n_neighbors = 10) }

}
