% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{plot_dimred}
\alias{plot_dimred}
\title{Plot dimensionality reduction based on MOFA factors}
\usage{
plot_dimred(
  object,
  method = c("UMAP", "TSNE"),
  groups = "all",
  show_missing = TRUE,
  color_by = NULL,
  shape_by = NULL,
  color_name = NULL,
  shape_name = NULL,
  label = FALSE,
  dot_size = 1.5,
  stroke = NULL,
  alpha_missing = 1,
  legend = TRUE,
  rasterize = FALSE,
  return_data = FALSE,
  ...
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{method}{string indicating which method has been used for non-linear dimensionality reduction (either 'umap' or 'tsne')}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{show_missing}{logical indicating whether to include samples for which \code{shape_by} or \code{color_by} is missing}

\item{color_by}{specifies groups or values used to color the samples. This can be either:
(1) a character giving the name of a feature present in the training data.
(2) a character giving the same of a column present in the sample metadata.
(3) a vector of the same length as the number of samples specifying discrete groups or continuous numeric values.}

\item{shape_by}{specifies groups or values used to shape the samples. This can be either:
(1) a character giving the name of a feature present in the training data, 
(2) a character giving the same of a column present in the sample metadata.
(3) a vector of the same length as the number of samples specifying discrete groups.}

\item{color_name}{name for color legend.}

\item{shape_name}{name for shape legend.}

\item{label}{logical indicating whether to label the medians of the clusters. Only if color_by is specified}

\item{dot_size}{numeric indicating dot size.}

\item{stroke}{numeric indicating the stroke size (the black border around the dots, default is NULL, infered automatically).}

\item{alpha_missing}{numeric indicating dot transparency of missing data.}

\item{legend}{logical indicating whether to add legend.}

\item{rasterize}{logical indicating whether to rasterize plot}

\item{return_data}{logical indicating whether to return the long data frame to plot instead of plotting}

\item{...}{extra arguments passed to \code{\link{run_umap}} or \code{\link{run_tsne}}.}
}
\value{
Returns a \code{ggplot2} object or a long data.frame (if return_data is TRUE)
}
\description{
Plot dimensionality reduction based on MOFA factors
}
\details{
This function plots dimensionality reduction projections that are stored in the \code{dim_red} slot.
Typically this contains UMAP or t-SNE projections computed using \code{\link{run_tsne}} or \code{\link{run_umap}}, respectively.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Run UMAP
model <- run_umap(model)

# Plot UMAP
plot_dimred(model, method = "UMAP")

# Plot UMAP, colour by Factor 1 values
plot_dimred(model, method = "UMAP", color_by = "Factor1")

# Plot UMAP, colour by the values of a specific feature
plot_dimred(model, method = "UMAP", color_by = "feature_0_view_0")

}
