% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_example_data.R
\name{make_example_data}
\alias{make_example_data}
\title{Simulate a data set using the generative model of MOFA}
\usage{
make_example_data(
  n_views = 3,
  n_features = 100,
  n_samples = 50,
  n_groups = 1,
  n_factors = 5,
  likelihood = "gaussian"
)
}
\arguments{
\item{n_views}{number of views}

\item{n_features}{number of features in each view}

\item{n_samples}{number of samples in each group}

\item{n_groups}{number of groups}

\item{n_factors}{number of factors}

\item{likelihood}{likelihood for each view, one of "gaussian" (default), "bernoulli", "poisson",
or a character vector of length n_views}
}
\value{
Returns an untrained \code{\link{MOFA}} object containing simulated data as training data.
}
\description{
Function to simulate an example multi-view multi-group data set according to the generative model of MOFA2.
}
\examples{
# Generate a simulated data set
MOFAexample <- make_example_data()
}
