% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_model.R
\name{load_model}
\alias{load_model}
\title{Load a trained MOFA}
\usage{
load_model(
  file,
  sort_factors = TRUE,
  on_disk = FALSE,
  load_data = TRUE,
  remove_outliers = FALSE,
  remove_inactive_factors = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{file}{an hdf5 file saved by the mofa Python framework}

\item{sort_factors}{logical indicating whether factors should be sorted by variance explained (default is TRUE)}

\item{on_disk}{logical indicating whether to work from memory (FALSE) or disk (TRUE). \cr
This should be set to TRUE when the training data is so big that cannot fit into memory. \cr
On-disk operations are performed using the \code{\link{HDF5Array}} and \code{\link{DelayedArray}} framework.}

\item{load_data}{logical indicating whether to load the training data (default is TRUE, it can be memory expensive)}

\item{remove_outliers}{logical indicating whether to mask outlier values.}

\item{remove_inactive_factors}{logical indicating whether to remove inactive factors from the model.}

\item{verbose}{logical indicating whether to print verbose output (default is FALSE)}
}
\value{
a \code{\link{MOFA}} model
}
\description{
Method to load a trained MOFA \cr
The training of mofa is done using a Python framework, and the model output is saved as an .hdf5 file, which has to be loaded in the R package.
}
\examples{
#' # Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
}
