% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MOFA}
\alias{MOFA}
\alias{MOFA-class}
\title{Class to store a mofa model}
\description{
The \code{MOFA} is an S4 class used to store all relevant data to analyse a MOFA model
}
\section{Slots}{

\describe{
\item{\code{data}}{The input data}

\item{\code{intercepts}}{Feature intercepts}

\item{\code{samples_metadata}}{Samples metadata}

\item{\code{features_metadata}}{Features metadata.}

\item{\code{imputed_data}}{The imputed data.}

\item{\code{expectations}}{expected values of the factors and the loadings.}

\item{\code{dim_red}}{non-linear dimensionality reduction manifolds.}

\item{\code{training_stats}}{model training statistics.}

\item{\code{data_options}}{Data processing options.}

\item{\code{training_options}}{Model training options.}

\item{\code{stochastic_options}}{Stochastic variational inference options.}

\item{\code{model_options}}{Model options.}

\item{\code{dimensions}}{Dimensionalities of the model: 
M for the number of views, 
G for the number of groups, 
N for the number of samples (per group), 
D for the number of features (per view),
K for the number of factors.}

\item{\code{on_disk}}{Logical indicating whether data is loaded from disk.}

\item{\code{cache}}{Cache.}

\item{\code{status}}{Auxiliary variable indicating whether the model has been trained.}
}}

