# data set for imm0008
# map of select
sex_map={
    "Female": "1: Female",
    "Male": "2: Male"
}
eye_color={
    "Black": "1: 01",
    "Blue": "2: 02",
    "Brown": "3: 03",
    "Green": "4: 04",
    "Grey": "5: 06",
    "Hazel": "6: 05",
    "Other": "7: 09",
    "Pink": "8: 07",
    "Sea Green": "9: 08"
}
english_french_map={
        "English":"1: 01",
        "French":"2: 02"
}

all_languages={
    "Ada": "089",
    "Adama": "501",
    "Afar": "228",
    "Afghan": "004",
    "Afrikaans": "203",
    "Agbor": "502",
    "Aka": "053",
    "Akan": "165",
    "Akim": "503",
    "Aklanon": "003",
    "Akra": "095",
    "Akwapim": "504",
    "Albanian": "119",
    "Albanian, Greece": "505",
    "Albanian, Italy": "506",
    "American Sign Lang.": "217",
    "Amharic": "254",
    "Arabic": "250",
    "Arabic Standard": "507",
    "Arabic, Algeria": "508",
    "Arabic, Chad": "509",
    "Arabic, Egypt": "510",
    "Arabic, Irak": "511",
    "Arabic, Lebanon, Levantine": "512",
    "Arabic, Libya": "513",
    "Arabic, Morocco": "514",
    "Arabic, Sudan": "515",
    "Arabic, Syria": "516",
    "Arabic, Tunisia": "517",
    "Arabic, Yemen, Judeo-Yemeni": "518",
    "Aranese": "005",
    "Armenian": "102",
    "Armenian, West": "519",
    "Armenian, Western": "520",
    "Ashanti": "171",
    "Assyrian": "255",
    "Atwot": "521",
    "Azerbaijani, North": "522",
    "Azerbaijani, South": "523",
    "Azeri": "085",
    "Bajuni": "524",
    "Balochi East Pak": "525",
    "Balochi South Pak": "526",
    "Balochi West Pak": "527",
    "Baluchi": "528",
    "Bambara": "008",
    "Bamileke": "529",
    "Bantu": "202",
    "Baoule": "260",
    "Barawa": "530",
    "Barbawa": "531",
    "Bassa": "532",
    "Belarusian": "739",
    "Belen": "006",
    "Bemba": "160",
    "Bengali": "322",
    "Bengali Sylhetti": "533",
    "Beni": "169",
    "Benin": "231",
    "Berber": "010",
    "Bikol": "009",
    "Bini": "212",
    "Bissa": "180",
    "Boguni": "534",
    "Bontok": "011",
    "Bosnian": "535",
    "Brava": "536",
    "Breton": "152",
    "British Sign Language": "537",
    "Brong": "538",
    "Buganda": "539",
    "Bulgarian": "107",
    "Burmese": "308",
    "Busan": "132",
    "Cambodian": "540",
    "Cantonese": "300",
    "Capizeno": "541",
    "Catalan": "121",
    "Cebuano": "183",
    "Chadian Sign Language": "542",
    "Chakma": "216",
    "Chaldean": "256",
    "Changle": "543",
    "Chaocho": "211",
    "Chavacano": "015",
    "Chechen": "544",
    "Chichewa": "222",
    "Chinese": "299",
    "Chinese, Min Nan": "545",
    "Chinese, Yue": "546",
    "Chinese, Yuh": "547",
    "Chowchau": "126",
    "Chung Shan": "548",
    "Comorian": "549",
    "Concani": "012",
    "Creole": "400",
    "Creole, Haiti": "550",
    "Croatian": "098",
    "Czech": "113",
    "Dangbe": "551",
    "Danish": "142",
    "Dari": "195",
    "Dari, Peve": "552",
    "Dari/Farsi, Eastern": "553",
    "Deaf-mute": "090",
    "Dendi": "554",
    "Dhopadhola": "555",
    "Diakanke": "556",
    "Dinka, Northeastern": "557",
    "Dinka, Northwestern": "558",
    "Dinka, South Central": "559",
    "Dinka, Southern": "560",
    "Dinka, Southwestern, Twi, Tuic": "561",
    "Dioula": "135",
    "Divehi": "562",
    "Divehi, Maldivian": "563",
    "Dogri": "564",
    "Dutch": "117",
    "Eastern Armenian": "565",
    "Edo": "210",
    "Edo, Kailo, Ledo": "566",
    "Efik": "177",
    "English": "001",
    "Enping": "567",
    "Eritrean": "568",
    "Esan": "178",
    "Estonian": "103",
    "Ewe": "166",
    "Facilitator/Articulator": "192",
    "Fang": "232",
    "Fanti": "167",
    "Farsi": "223",
    "Farsi, Western": "569",
    "Fiji": "570",
    "Findhi": "571",
    "Finnish": "141",
    "Flemish": "118",
    "Fon": "572",
    "Foochow": "017",
    "Foullah": "023",
    "Frafra": "573",
    "Frafra, Gurenne": "574",
    "French": "002",
    "Fujian": "575",
    "Fukien": "181",
    "Fulani": "170",
    "Fuqing": "091",
    "Futa": "576",
    "Ga": "168",
    "Ga, Adangme-Krobo": "577",
    "Gaelic": "151",
    "Georgian": "578",
    "German": "116",
    "Gio": "579",
    "Gio, Gio-Dan": "580",
    "Greek": "130",
    "Guerze": "138",
    "Gujarati": "330",
    "Gurage": "581",
    "Gurage, East": "582",
    "Gurage, North": "583",
    "Gurage, West": "584",
    "Guyanese": "585",
    "Guyroti": "586",
    "Gypsy": "587",
    "Hadiyya": "741",
    "Hainanese": "020",
    "Hakka": "298",
    "Harara": "018",
    "Harary": "019",
    "Hargar": "215",
    "Hasanya": "029",
    "Hausa": "200",
    "Hebrew": "253",
    "Hebrew, Yemen": "588",
    "Henan/Jinyu": "589",
    "Hiligaynon": "021",
    "Hindi": "321",
    "Hindi Dogri": "590",
    "Hindi, Fijian": "591",
    "Hindi, Hin, Nyaheun": "592",
    "Hindko": "073",
    "Hindko, Northern": "593",
    "Hindko, Southern": "594",
    "Hindu, Hindi, Caribbean": "595",
    "Hokkien": "182",
    "Hubei": "596",
    "Huizhou/Yanzhou": "597",
    "Hunan/Xiang": "598",
    "Hungarian": "112",
    "Ibibio": "022",
    "Icelandic": "335",
    "Igbo": "205",
    "Igorot": "024",
    "Iiongo": "184",
    "Ika": "599",
    "Ilican": "025",
    "Ilocano": "600",
    "Indonesian": "304",
    "Interp. Not Required": "601",
    "Ishen": "602",
    "Isoko": "603",
    "Italian": "123",
    "Itshekiri": "604",
    "Izi": "225",
    "Jadgali, Pakistan": "605",
    "Jamaican": "606",
    "Japanese": "303",
    "Javanese": "030",
    "Jianxi": "607",
    "Jolay": "040",
    "Kabyle": "608",
    "Kacchi": "900",
    "Kaiping": "609",
    "Kakwa": "026",
    "Kandahari": "185",
    "Kangri, India": "610",
    "Kangri, Kanjari": "611",
    "Kankani": "174",
    "Kannada": "612",
    "Kaonde, Dari": "613",
    "Kashmiri": "027",
    "Kazakh": "740",
    "Kepelle": "614",
    "Khmer": "311",
    "Kiboma": "615",
    "Kihavu": "186",
    "Kikongo": "129",
    "Kikuyu": "616",
    "Kikuyu, Gikuyu": "617",
    "Kinaraya": "618",
    "Kinyarwanda": "191",
    "Kinyarwanda, Rwanda": "619",
    "Kirundi": "031",
    "Kirundi, Rundi": "620",
    "Kiswahili": "213",
    "Konkani": "028",
    "Korean": "305",
    "Krio": "042",
    "Krobo": "621",
    "Kru, Klao": "622",
    "Kru, Krumen, Tepo": "623",
    "Kurdish": "252",
    "Kurdish Bandinani, Behdini": "624",
    "Kurdish-Central, Kurdi, Sorani": "625",
    "Kurdish-Northern, Kurmanji,": "626",
    "Kwale, Nigeria": "627",
    "Kwale, Papua": "628",
    "Laotian": "312",
    "Lateh": "629",
    "Latvian": "104",
    "Lebanese": "124",
    "Lengie": "032",
    "Limba": "630",
    "Lingala": "044",
    "Linyawanda": "631",
    "Lithuanian": "105",
    "Lowma": "139",
    "Luba-Kasai": "632",
    "Luganda": "033",
    "Lugisu": "034",
    "Luo": "633",
    "Lutoro": "035",
    "Macedonian": "111",
    "Macena": "036",
    "Maghreb": "634",
    "Mahou": "137",
    "Makonde": "037",
    "Makua": "226",
    "Malagasy": "046",
    "Malay": "310",
    "Malayalam": "323",
    "Malgache, Malagasy": "635",
    "Maligo": "136",
    "Malinke, Jula": "636",
    "Maltese": "188",
    "Mandarin": "301",
    "Mandiga, Mandinga": "637",
    "Mandingo": "172",
    "Mandingo, Maninka": "638",
    "Mandingo, Manya": "639",
    "Maninka": "224",
    "Mano": "640",
    "Marakha": "641",
    "Marathi": "332",
    "Masaba": "500",
    "Mashi": "642",
    "Maymay, Somalia": "643",
    "Mende": "050",
    "Meru": "644",
    "Mina": "133",
    "Mina, Gen-Gbe": "645",
    "Mirpuri": "646",
    "Mizo": "038",
    "Moldovan": "647",
    "Moldovan, Romanian": "648",
    "Mongolian": "403",
    "Mongolian, Halh": "649",
    "Moor, Bimoba": "650",
    "Moore": "134",
    "Moore, Burkina": "651",
    "Moore, Waropen": "652",
    "Morisyen": "653",
    "Nahuatl, Classical": "655",
    "Navajo": "656",
    "Ndebele": "654",
    "Ndebele, South Africa": "657",
    "Ndebele, Zimbabwe": "658",
    "Ndjamena": "659",
    "Nepali": "320",
    "Nigerian, Pidgin": "660",
    "Nigerien": "661",
    "Nobiin": "662",
    "Norwegian": "143",
    "Nuer": "663",
    "Nyanja": "664",
    "Nzema": "051",
    "Okpe": "233",
    "Ora": "665",
    "Oriya": "333",
    "Oromo": "218",
    "Oromo, Borana-Arsi-Gujii": "666",
    "Oromo, Qotu": "667",
    "Oromo, Qotu, West Central": "668",
    "Osal": "039",
    "Other": "499",
    "Ouighour": "669",
    "Pahari": "041",
    "Pampango": "043",
    "Pangasinan": "670",
    "Pashto": "326",
    "Pashto, Central": "671",
    "Pashto, Southern": "672",
    "Persian": "251",
    "Peul": "219",
    "Peul, Benin-Togo": "673",
    "Peul, Bororro": "674",
    "Peul, Fulfulde, Adamawa": "675",
    "Peul, Fulfulde, Jelgoore": "676",
    "Phuockien": "045",
    "Pidgin": "083",
    "Pidgin English": "677",
    "Piugon": "678",
    "Polish": "115",
    "Portuguese": "122",
    "Portuguese, Angola": "679",
    "Portuguese, Brazil": "680",
    "Portuguese, Guinea-Bissau": "681",
    "Poular": "087",
    "Punjabi": "324",
    "Pushta": "682",
    "Pushta, Pushto": "683",
    "Pu-Xian": "684",
    "Quechua": "685",
    "Rindre": "686",
    "Rohingya": "901",
    "Romani, Campathian": "687",
    "Romani, Carpathian": "688",
    "Romani, Cigaly": "689",
    "Romani, Cigany": "690",
    "Romani, Vlach": "691",
    "Romani, Vlach, Gypsy": "692",
    "Romanian": "108",
    "Ronga": "693",
    "Rukiga": "047",
    "Runyankole": "048",
    "Russian": "101",
    "Samoan": "402",
    "Samoli": "694",
    "Sango": "695",
    "Santi": "696",
    "Sarahuley": "697",
    "Saraiki": "698",
    "Scoula": "061",
    "Sechuan": "196",
    "Sefwi": "699",
    "Serbian": "099",
    "Serbo-Croatian": "109",
    "Sesotho": "052",
    "Seswi": "179",
    "Setswana": "738",
    "Seychelles": "088",
    "Seychelles,Creole Fre.,Seselwa": "700",
    "Shai": "701",
    "Shan": "057",
    "Shan Dong": "702",
    "Shan Tao": "703",
    "Shanghainese": "214",
    "Shansai": "013",
    "Shanxi": "704",
    "Shona": "705",
    "Sichuan/Szechuan": "706",
    "Sign Language French": "707",
    "Sindhi": "128",
    "Sinhala": "328",
    "Siyap": "708",
    "Slovak": "114",
    "Slovenian": "110",
    "Somali": "209",
    "Somba": "709",
    "Soninke": "175",
    "Soninke, Marakha": "710",
    "Sotho": "055",
    "Sotho, Northern": "711",
    "Sotho, Southern": "712",
    "Spanish": "120",
    "Suesue": "190",
    "Sukuma": "056",
    "Susu": "065",
    "Swahili": "201",
    "Swahili/Congo": "713",
    "Swahili/Kenya": "714",
    "Swati": "715",
    "Swatow": "716",
    "Swedish": "140",
    "Tagalog": "309",
    "Taichew": "059",
    "Taishanese": "062",
    "Taiwanese": "717",
    "Tajiki": "718",
    "Tamil": "327",
    "Tari": "194",
    "Tatar": "719",
    "Tatshanese": "189",
    "Telugu": "334",
    "Temne": "720",
    "Teochew": "060",
    "Thai": "307",
    "Tibetan": "297",
    "Tichiew": "054",
    "Tigre": "721",
    "Tigrea, Tigre": "722",
    "Tigrinya": "162",
    "Timini": "176",
    "Tiv": "082",
    "Tooro": "049",
    "Tshiluba": "220",
    "Turkish": "131",
    "Turkmen": "723",
    "Turkoman": "724",
    "Twi": "125",
    "Uhrobo": "234",
    "Uigrigma": "161",
    "Ukrainian": "106",
    "Ukwuani, Ukwuani-Aboh": "725",
    "Umbundu": "063",
    "Unama": "064",
    "Urdu": "325",
    "Uzbek": "257",
    "Vietnamese": "306",
    "Visayan": "066",
    "Waray-Waray": "067",
    "Welsh": "150",
    "Wenzhou": "726",
    "Wolof": "173",
    "Xangawe": "727",
    "Xhosa": "206",
    "Xin Hui": "728",
    "Xitswa": "729",
    "Xitswa, Twsa": "730",
    "Yacooba": "731",
    "Yao": "221",
    "Yemenite": "732",
    "Yiboe": "197",
    "Yiddish": "100",
    "Yinping": "733",
    "Yoruba": "207",
    "Yue Yang": "734",
    "Yugoslavian": "735",
    "Zaza": "736",
    "Zaza, Kirmanjki": "737",
    "Zshiluba": "068",
    "Zuganda": "069",
    "Zulu": "208"
}

interpreter_map={
    "Yes": "1: true",
    "No": "2: false"
}

province_map={
    "AB": "09",
    "BC": "11",
    "MB": "07",
    "NB": "04",
    "NL": "01",
    "NS": "03",
    "NT": "10",
    "NU": "64",
    "ON": "06",
    "PE": "02",
    "QC": "05",
    "SK": "08",
    "YT": "12"
}

city_map={
    "AB":{
        "Acme": "7004",
        "Aden": "7005",
        "Aetna": "7751",
        "Airdrie": "7006",
        "Alberta Beach": "7008",
        "Alder Flats": "7007",
        "Alexander, AB": "7009",
        "Alhambra, AB": "7011",
        "Alix": "7010",
        "Alliance": "7012",
        "Amisk": "7014",
        "Andrew": "7016",
        "Anzac": "7019",
        "Ardmore": "7017",
        "Ardrossan": "7015",
        "Argentia Beach": "7018",
        "Arrowwood": "7020",
        "Ashmont": "7021",
        "Athabasca": "7022",
        "Balac": "7024",
        "Balzac": "7135",
        "Banff": "7023",
        "Barnwell": "7028",
        "Barons": "7030",
        "Barrhead": "7032",
        "Barrons": "7033",
        "Bashaw": "7034",
        "Bassano": "7036",
        "Bawlf": "7038",
        "Beaumont": "7039",
        "Beaver Lodge": "7040",
        "Beiseker": "7042",
        "Bellevue": "7044",
        "Bentley": "7046",
        "Bertula Beach": "7050",
        "Berwyn": "7048",
        "Big Valley": "7052",
        "Bitternlake": "7054",
        "Black Diamond": "7056",
        "Blackfalds": "7058",
        "Blackie": "7060",
        "Blacktoct": "7061",
        "Blairmore": "7062",
        "Blufftir": "7063",
        "Bluffton": "7055",
        "Bon Accord": "7064",
        "Bonnyville": "7066",
        "Bonnyville Beach": "7068",
        "Botha": "7070",
        "Bow Island": "7072",
        "Bowden": "7074",
        "Boyle": "7076",
        "Bragg Creek": "7077",
        "Breton": "7078",
        "Brooks": "7080",
        "Bruderheim": "7082",
        "Buck Lake": "7083",
        "Burdett": "7084",
        "Busby": "7086",
        "Calgary": "7090",
        "Calmar": "7100",
        "Camrose": "7102",
        "Canmore": "7104",
        "Carbon": "7106",
        "Carbondale": "9101",
        "Cardiff": "9100",
        "Cardston": "7108",
        "Carmangay": "7110",
        "Caroline": "7112",
        "Carstairs": "7114",
        "Carvel": "7025",
        "Castle Island": "7116",
        "Castor": "7118",
        "Cayley": "7120",
        "Cereal": "7122",
        "Cessford": "7123",
        "Champion": "7124",
        "Chateh": "7103",
        "Chauvin": "7126",
        "Cherhill": "7125",
        "Chestermere": "7752",
        "Chief Mountain": "7129",
        "Chinook": "7127",
        "Chipman, AB": "7128",
        "Clairmont, AB": "7131",
        "Claresholm": "7130",
        "Clive": "7132",
        "Cluny": "7134",
        "Clyde": "7136",
        "Coaldale": "7398",
        "Coalhurst": "7137",
        "Cochrane, AB": "7138",
        "Cold Lake": "7140",
        "Coleman": "7142",
        "College Heights": "7143",
        "Consort": "7144",
        "Coronation": "7146",
        "Coutts": "7148",
        "Cowley": "7150",
        "Craigmyle": "7152",
        "Cremona": "7154",
        "Crossfield": "7156",
        "Crystal Srpings": "7158",
        "Czar": "7159",
        "Daysland": "7160",
        "De Winton": "7169",
        "Debolt": "7026",
        "Del Bonita Falls": "7161",
        "Delacour": "7027",
        "Delburne": "7162",
        "Delia": "7164",
        "Derwent": "7166",
        "Devon": "7200",
        "Dewberry": "7170",
        "Diamond City": "7171",
        "Didsbury": "7172",
        "Donalda": "7174",
        "Donnelly": "7176",
        "Drayton Valley": "7178",
        "Drumheller": "7180",
        "Duchess": "7182",
        "Dunmore": "7139",
        "Eaglesham": "7190",
        "Eckville": "7192",
        "Edberg": "7194",
        "Edgerton": "7196",
        "Edmonton": "7198",
        "Edmonton Beach": "7204",
        "Edson": "7222",
        "Elk Point": "7224",
        "Elnora": "7226",
        "Empress": "7228",
        "Enchant": "7229",
        "Entwistle": "7230",
        "Erskine": "7029",
        "Evansburg": "7232",
        "Fairview": "7234",
        "Falher": "7236",
        "Faust": "7205",
        "Ferintosh": "7238",
        "Foremost": "7240",
        "Forest Lawn": "7243",
        "Forestburg": "7242",
        "Fort Assiniboine": "7244",
        "Fort Chipewyan": "7245",
        "Fort Macleod": "7246",
        "Fort Mcmurray": "7248",
        "Fort Saskatchewan": "7206",
        "Fort Vermillion": "7207",
        "Fox Creek": "7252",
        "Frank": "7254",
        "Gadsby": "7260",
        "Galahad": "7262",
        "Ghost Lake": "7264",
        "Gibbons, AB": "7266",
        "Giroux": "7267",
        "Girouxville, AB": "7268",
        "Gleichen": "7270",
        "Glendon": "7272",
        "Glenevis": "7209",
        "Glenwood, AB": "7274",
        "Golden Days": "7276",
        "Good Fish Lake": "7277",
        "Goodfare": "7035",
        "Grand Centre": "7278",
        "Grande Cache": "7280",
        "Grande Prairie": "7282",
        "Grandview, AB": "7284",
        "Granum": "7286",
        "Grassland": "7287",
        "Grassy Lake": "7288",
        "Grimshaw": "7290",
        "Gull Lake, AB": "7292",
        "Hairy Hill": "7300",
        "Halkirk": "7302",
        "Hanna": "7304",
        "Hardisty": "7306",
        "Hay Lakes": "7308",
        "Hays": "7307",
        "Hayter": "7309",
        "Heisler": "7310",
        "High Level": "7312",
        "High Prairie": "7314",
        "High River": "7316",
        "Hilda": "7317",
        "Hill Spring": "7318",
        "Hilliard": "7031",
        "Hines Creek": "7319",
        "Hinton": "7320",
        "Hobbema": "7321",
        "Holden": "7322",
        "Hughenden": "7324",
        "Huies Creek": "7326",
        "Hussar": "7328",
        "Hythe": "7330",
        "Innisfail": "7340",
        "Innisfield": "7753",
        "Innisfree": "7342",
        "Irma": "7344",
        "Iron River": "7347",
        "Iron Springs": "7037",
        "Irricana": "7346",
        "Irvine": "7348",
        "Island Lake, AB": "7350",
        "Itaska Beach": "7352",
        "Janvier": "7211",
        "Jasper": "7356",
        "Kapasiwin": "7360",
        "Keoma": "7515",
        "Killam": "7362",
        "Kinuso": "7364",
        "Kipp": "7365",
        "Kitscoty": "7366",
        "La Crête": "7141",
        "La Glace": "7145",
        "Lac la Biche": "7380",
        "Lacombe": "7382",
        "Lake Louise": "7383",
        "Lakeview": "7384",
        "Lamont": "7386",
        "Langdon": "7013",
        "Lavoy": "7390",
        "Leduc": "7208",
        "Legal": "7394",
        "Leslieville": "7395",
        "Lethbridge": "7396",
        "Linden": "7408",
        "Little Smoky": "7409",
        "Lloydminster, AB": "7410",
        "Lodgepole": "7411",
        "Lomond": "7412",
        "Longview": "7414",
        "Lougheed": "7416",
        "Ma Me O Beach": "7420",
        "Magrath": "7422",
        "Mallaig": "7153",
        "Manning": "7426",
        "Mannville": "7428",
        "Markerville": "7429",
        "Marsden": "7430",
        "Marwayne": "7434",
        "Mayerthorpe": "7436",
        "McLennan": "7438",
        "Medicine Hat": "7440",
        "Medley": "7441",
        "Meeting Creek": "7443",
        "Midnapore": "7448",
        "Milk River": "7450",
        "Millarville": "7041",
        "Millet": "7452",
        "Milo": "7454",
        "Minburn": "7456",
        "Mirror": "7458",
        "Monarch": "7459",
        "Morinville": "7460",
        "Morrin": "7462",
        "Mundare": "7464",
        "Munson": "7466",
        "Musidora": "7043",
        "Myrnam": "7468",
        "Nakamun Park": "7480",
        "Nampa": "7482",
        "Nanton": "7484",
        "Neerlandia": "7485",
        "New Dayton": "7487",
        "New Norway": "7488",
        "New Sarepta": "7490",
        "Nisku": "7491",
        "Nito Junction": "7495",
        "Nobleford": "7492",
        "Nordegg": "7147",
        "Norglenwood": "7494",
        "North Star": "7045",
        "Nythe": "7496",
        "Okotoks": "7094",
        "Olds": "7502",
        "Onoway": "7504",
        "Other": "7999",
        "Oyen": "7506",
        "Paradise Valley": "7512",
        "Patricia": "7513",
        "Peace River": "7514",
        "Peers": "7361",
        "Penhold": "7516",
        "Pickard Ville": "7517",
        "Picture Butte": "7518",
        "Pincher Creek": "7520",
        "Plamondon": "7522",
        "Point Alison": "7524",
        "Ponoka": "7526",
        "Poplar Bay": "7528",
        "Priddis": "7529",
        "Prosperity": "7532",
        "Provost": "7530",
        "Purple Springs": "7536",
        "Radway": "7540",
        "Rainbow Lake": "7542",
        "Rainier": "7543",
        "Ralston": "7151",
        "Raymond": "7544",
        "Red Deer": "7546",
        "Red Deer County": "7047",
        "Red Earth Creek": "7213",
        "Redcliff": "7442",
        "Redwater": "7550",
        "Redwood Meadows": "7049",
        "Rimbey": "7552",
        "Rochester": "7553",
        "Rochfort Bridge": "7555",
        "Rochon Sands": "7554",
        "Rocky Mountain Ho": "7556",
        "Rocky View": "7096",
        "Rockyford": "7560",
        "Rolling Hills": "7561",
        "Rosalind": "7562",
        "Rosedale Station": "7149",
        "Rosemary": "7564",
        "Ross Haven": "7566",
        "Rumsey": "7568",
        "Rycroft": "7570",
        "Ryley": "7572",
        "Saint-Isidore": "7597",
        "Saint-Lina": "7599",
        "Saint-Michael": "7601",
        "Sandy Beach, AB": "7580",
        "Sanguda Silver Sa": "7582",
        "Scandia": "7583",
        "Seba Beach": "7584",
        "Sedgewick": "7586",
        "Sexsmith": "7588",
        "Shaughnessy": "7589",
        "Sherwood Park, AB": "7210",
        "Siksika": "7215",
        "Silver Beach": "7590",
        "Slave Lake": "7592",
        "Smoky Lake": "7594",
        "South View": "7596",
        "Spirit River": "7598",
        "Spring Lake": "7051",
        "Spruce Grove": "7212",
        "Spruceview": "7603",
        "St Albert": "7214",
        "St. Paul": "7600",
        "St-Albert Falls": "7595",
        "Standard": "7604",
        "Stavely": "7606",
        "Stettler": "7608",
        "Stirling, AB": "7610",
        "Stony Plain": "7216",
        "Strathcona": "7218",
        "Strathmore": "7616",
        "Strome": "7618",
        "Sturgeon": "7619",
        "Suffield": "7621",
        "Sundance Beach": "7620",
        "Sundre": "7622",
        "Sunset House": "7623",
        "Sunset Point": "7624",
        "Swan Hills": "7626",
        "Sylvan Lake": "7628",
        "Taber": "7640",
        "Tangent": "7754",
        "Thorhild": "7642",
        "Thorsby": "7644",
        "Three Hills": "7646",
        "Tilley": "7648",
        "Tofield": "7650",
        "Tomahaw": "7651",
        "Torrington": "7652",
        "Trochu": "7654",
        "Turin": "7655",
        "Turner Valley": "7656",
        "Two Hills": "7658",
        "Val Quentin": "7670",
        "Valleyview": "7672",
        "Vauxhall": "7674",
        "Vegreville": "7676",
        "Vermillion": "7678",
        "Veteran": "7680",
        "Viking": "7682",
        "Vilna": "7684",
        "Vimy": "7053",
        "Vulcan": "7686",
        "Wabamun": "7688",
        "Wabas-Desmar": "7689",
        "Wainwright": "7690",
        "Wanham": "7692",
        "Warburg": "7694",
        "Warner": "7696",
        "Warspite": "7698",
        "Wasca": "7700",
        "Waskatenau": "7702",
        "Water Valley": "7057",
        "Waterton": "7699",
        "Waterton Lakes": "7701",
        "Watino": "7703",
        "Welling": "7059",
        "Wembly": "7704",
        "West Cove": "7706",
        "Westerose": "7065",
        "Westlock": "7708",
        "Wetaskiwin": "7710",
        "Whitecourt": "7712",
        "Whitelaw": "7755",
        "Wild Horse": "7713",
        "Wildwood": "7714",
        "Willingdon": "7716",
        "Winfield, AB": "7718",
        "Winterburn": "7720",
        "Woking": "7725",
        "Yellowstone": "7730",
        "Youngstown": "7732",
        "Zama": "7750"
    },
    "BC":{
        "100 Mile House": "8720",
        "108 Mile Ranch": "8317",
        "150 Mile House": "8200",
        "70 Mile House": "8201",
        "Abbotsford": "8210",
        "Agassiz": "8202",
        "Alberni": "8203",
        "Albion": "8204",
        "Aldergrove": "8211",
        "Alert Bay": "8212",
        "Alexis Creek": "8740",
        "Alvin": "8205",
        "Anahim Lk.": "8209",
        "Anglemont": "8206",
        "Anmore, BC": "8268",
        "Argenta": "8213",
        "Armstrong, BC": "8214",
        "Arras": "8341",
        "Ashcroft": "8216",
        "Atlin": "8207",
        "Baldonnel": "8219",
        "Balfour": "8343",
        "Bamfield": "8732",
        "Barnston Isl": "8215",
        "Barriere": "8220",
        "Beach Grove": "8217",
        "Beaver Creek": "8221",
        "Beaverdell": "8344",
        "Belcarra": "8218",
        "Bella Bella": "8223",
        "Bella Coola": "8225",
        "Big Creek": "8637",
        "Big Lake": "8208",
        "Black Creek": "8226",
        "Blind Bay": "8227",
        "Blue River": "8228",
        "Boston Bar": "8229",
        "Boswell, BC": "8279",
        "Boundry Bay": "8722",
        "Bowen Island": "8723",
        "Bowser": "8724",
        "Brackendale": "8725",
        "Brentwood Bay": "8726",
        "Bridesville": "8639",
        "Bridge Lake": "8727",
        "Brisco": "8641",
        "Britannia Beach": "8345",
        "Bubble Hill": "8728",
        "Buffalo Creek": "8361",
        "Buick": "8643",
        "Bull River": "8729",
        "Burnaby": "8636",
        "Burns Lake": "8222",
        "Burrard Inlet": "8224",
        "Burton": "8730",
        "Cache Creek": "8230",
        "Campbell River": "8233",
        "Canal Flats": "8297",
        "Canim Lake": "8363",
        "Canoe": "8364",
        "Canyon": "8235",
        "Capiland": "8231",
        "Caribou": "8239",
        "Carson": "8243",
        "Cascade": "8244",
        "Cassiar": "8245",
        "Cassidy": "8247",
        "Castlegar": "8232",
        "Cawston": "8249",
        "Cecil Lake": "8366",
        "Cedar": "8251",
        "Celista": "8252",
        "Central Saanich": "8676",
        "Charlie Lake": "8253",
        "Chase": "8234",
        "Chemainus": "8254",
        "Chetwynd": "8236",
        "Chilanko Forks": "8255",
        "Chilcotin": "8257",
        "Chilko Lake": "8258",
        "Chilliwack": "8238",
        "Chopaka": "8259",
        "Christina Lake": "8367",
        "Clearbrook": "8260",
        "Clearwater, BC": "8261",
        "Clements": "8731",
        "Clinton, BC": "8240",
        "Cloverdale": "8241",
        "Coal Harbour": "8465",
        "Cobble Hill": "8262",
        "Coldstream": "8299",
        "Columbia Gardens": "8263",
        "Colwood": "8368",
        "Comox": "8242",
        "Coombs": "8264",
        "Coquitlam": "8638",
        "Cortes Island": "8265",
        "Courtenay": "8246",
        "Cowichan Bay": "8371",
        "Cranbrook": "8248",
        "Crawford Bay": "8382",
        "Crescent Beach": "8266",
        "Creston, BC": "8250",
        "Crofton, BC": "8267",
        "Cultus Lake": "8384",
        "Cumberland, BC": "8256",
        "D'Arcy": "8385",
        "Dawson Creek, BC": "8270",
        "Dease Lake": "8386",
        "Deep Bay": "8271",
        "Delta": "8272",
        "Denman Island": "8277",
        "Deroche": "8273",
        "Dewdeny": "8275",
        "Douglas": "8276",
        "Duncan": "8274",
        "Dunster": "8278",
        "Eagle Bay, BC": "8280",
        "Eagle Creek": "8401",
        "East Pine": "8284",
        "Ebrune": "8286",
        "Edgewater": "8287",
        "Edgewood": "8403",
        "Elkford": "8288",
        "Elko": "8404",
        "Endako": "8289",
        "Enderby": "8290",
        "Erickson, BC": "8292",
        "Erikson": "8294",
        "Errington": "8293",
        "Esquimalt": "8678",
        "Fair. Hot Springs": "8405",
        "Falkland": "8296",
        "Fanny Bay": "8407",
        "Fauquier": "8409",
        "Femberton": "8298",
        "Fernie": "8300",
        "Forest Grove, BC": "8281",
        "Fort Fraser": "8302",
        "Fort Langley": "8301",
        "Fort Nelson": "8310",
        "Fort St James": "8314",
        "Fort St John": "8316",
        "Fort Steele": "8410",
        "Francois Lake": "8466",
        "Fraser Lake": "8320",
        "Fraser Mills": "8318",
        "Fraser Valley": "8321",
        "Fruitvale": "8322",
        "Fulford Harbor": "8323",
        "Furry Creek": "8291",
        "Gabriola": "8329",
        "Galiano Island": "8324",
        "Ganges": "8325",
        "Gar. Highlands": "8411",
        "Garden Bay": "8333",
        "Garibaldi": "8326",
        "Genelle": "8327",
        "Gibbons, BC": "8328",
        "Gibsons": "8330",
        "Gillies Bay": "8331",
        "Gold River": "8332",
        "Golden": "8334",
        "Goodlow": "8304",
        "Gr Birch": "8733",
        "Grand Forks": "8336",
        "Granisle": "8319",
        "Grasmere": "8335",
        "Gray Creek": "8337",
        "Greenwood, BC": "8338",
        "Grindrod": "8412",
        "Hagensborg": "8340",
        "Halfmoon Bay": "8342",
        "Hammond": "8346",
        "Hanceville": "8467",
        "Haney": "8339",
        "Harrison Hot Spri": "8350",
        "Harrison Mills": "8348",
        "Hazelton": "8352",
        "Hedley": "8413",
        "Heffley Creek": "8347",
        "Heriot Bay, BC": "8349",
        "Highlands": "8351",
        "Hixon": "8353",
        "Holberg": "8419",
        "Hope": "8354",
        "Hornby Island": "8355",
        "Horsefly": "8356",
        "Horseshoe Bay": "8468",
        "Houston": "8357",
        "Huds Hop": "8734",
        "Huntingdon, BC": "8358",
        "Invermere": "8360",
        "Inverness, BC": "8359",
        "Island Highway": "8362",
        "Jaffray": "8365",
        "Kalendan": "8369",
        "Kamloops": "8370",
        "Kaslo": "8372",
        "Katzie": "8373",
        "Kelowna": "8374",
        "Keremeos": "8376",
        "Kimberley": "8378",
        "Kingsgate": "8375",
        "Kinnaird": "8380",
        "Kitimat": "8379",
        "Kitwanga": "8377",
        "Kleena Kleene": "8431",
        "Kootenay Bay": "8433",
        "La Hache": "8735",
        "Ladner": "8381",
        "Ladysmith": "8390",
        "Lake Country": "8435",
        "Lake Cowichan": "8392",
        "Langley": "8640",
        "Lantzville": "8393",
        "Lasqueti Island": "8391",
        "Latham": "8388",
        "Laurier": "8394",
        "Lazo": "8389",
        "Lehman": "8395",
        "Lillooet": "8396",
        "Lindell Beach": "8305",
        "Lion's Bay": "8398",
        "Lister": "8387",
        "Little Fort": "8397",
        "Logan Lake": "8400",
        "Lone Butte": "8402",
        "Lower Nicola": "8306",
        "Lumby": "8406",
        "Lund": "8436",
        "Lytton": "8408",
        "Mackenzie": "8414",
        "Madeira Park": "8415",
        "Malahat": "8437",
        "Malakwa": "8438",
        "Mansos Landing": "8416",
        "Maple Ridge": "8642",
        "Mara": "8418",
        "Marysville, BC": "8420",
        "Masset": "8422",
        "Matsqui": "8421",
        "Mayne Lake": "8439",
        "Mc Millian Isl": "8425",
        "McBride": "8424",
        "Mcleese Lake": "8440",
        "Meadow Creek": "8441",
        "Merritt": "8426",
        "Merville": "8427",
        "Midway": "8428",
        "Milhouse": "8429",
        "Mill Bay": "8430",
        "Mission": "8644",
        "Moberly Lake": "8442",
        "Montney": "8443",
        "Montrose": "8432",
        "Moyle Lake": "8434",
        "Nakusp": "8450",
        "Nanaimo": "8452",
        "Nanoose Bay": "8451",
        "Naramata": "8453",
        "Nelson, BC": "8454",
        "Nelway": "8455",
        "New Aiyansh": "8458",
        "New Denver": "8456",
        "New Hazelton": "8460",
        "New Westminster": "8646",
        "Nig Creek": "8739",
        "Nimpo": "8462",
        "North Delta": "8295",
        "North Pine": "8464",
        "North Saanich": "8680",
        "North Vancouver": "8648",
        "Oak Bay, BC": "8682",
        "Ocean Falls": "8472",
        "Okanagan": "8476",
        "Okanagan Falls": "8474",
        "Oliver": "8480",
        "Osoyoos": "8482",
        "Other": "8999",
        "Oyama": "8484",
        "Panorama": "8307",
        "Parksville": "8500",
        "Paterson": "8498",
        "Peachland": "8499",
        "Pemberton": "8502",
        "Pender Island": "8501",
        "Penticton": "8504",
        "Pink Mountain": "8444",
        "Pitt Meadows": "8650",
        "Pleasant Camp": "8503",
        "Point Roberts": "8505",
        "Port Alberni": "8508",
        "Port Alice": "8510",
        "Port Clements": "8512",
        "Port Coquitlam": "8652",
        "Port Edward": "8514",
        "Port Hardy": "8654",
        "Port Hawksbury": "8515",
        "Port Mcneill": "8516",
        "Port Moody": "8518",
        "Pouce Coupe": "8520",
        "Powell River": "8522",
        "Prince George": "8524",
        "Prince Rupert": "8526",
        "Princeton, BC": "8528",
        "Pritchard": "8445",
        "Proctor": "8530",
        "Quadra Island": "8446",
        "Qualicum Beach": "8540",
        "Quathiaski Cove": "8536",
        "Quatsino": "8538",
        "Queen Charlotte": "8541",
        "Quesnel": "8542",
        "Quilchena": "8544",
        "Radium Hot Springs": "8546",
        "Revelstoke": "8550",
        "Richmond, BC": "8656",
        "Robert C": "8737",
        "Robson": "8551",
        "Rock Creek": "8548",
        "Roosville": "8552",
        "Rosedale": "8553",
        "Rossland": "8554",
        "Royston": "8308",
        "Ruskin": "8556",
        "Rykerts": "8558",
        "Saanich": "8684",
        "Saanichton": "8560",
        "Salmo": "8570",
        "Salmon Arm": "8564",
        "Salt Spring Isl.": "8566",
        "Sandpit": "8568",
        "Sardis": "8569",
        "Saturna Island": "8571",
        "Savona": "8469",
        "Sayward": "8572",
        "Seal Cove, BC": "8573",
        "Sechelt": "8574",
        "Semiahmoo": "8575",
        "Sewell Inlet": "8579",
        "Shawnigan Lake": "8576",
        "Shuswap": "8577",
        "Sicamous": "8686",
        "Sidney": "8688",
        "Silverton": "8578",
        "Skidegate": "8447",
        "Skookumchuck": "8448",
        "Slocan": "8580",
        "Smithers": "8582",
        "Sointula": "8738",
        "Sooke": "8583",
        "Sorrento": "8567",
        "South Fort George": "8584",
        "Sparwood": "8585",
        "Spences Bridge": "8589",
        "Squamish": "8586",
        "Stave Falls": "8587",
        "Stewart": "8588",
        "Stikine": "8590",
        "Sullivan Bay": "8592",
        "Summerland": "8594",
        "Sun Peaks": "8309",
        "Surge Narrows": "8596",
        "Surrento": "8598",
        "Surrey, BC": "8658",
        "Ta Ta Creek": "8599",
        "Tahsis": "8600",
        "Tappen": "8690",
        "Tasu": "8692",
        "Tatla Lake": "8694",
        "Taylor": "8602",
        "Telegraph Creek": "8741",
        "Telkwa": "8604",
        "Terrace": "8605",
        "Tête Jaune Cache": "8603",
        "Thetis Island": "8282",
        "Thompson, BC": "8696",
        "T'Kumlups": "8742",
        "Tlell": "8470",
        "Tofino": "8606",
        "Trail": "8608",
        "Tsawwassen": "8607",
        "Tsay Keh": "8743",
        "Tumbler": "8698",
        "Tumbler Ridge": "8699",
        "Ucluelet": "8620",
        "Union Bay": "8622",
        "Valemount": "8630",
        "Vananda": "8632",
        "Vancouver": "8634",
        "Vanderhoof": "8670",
        "Vavenby": "8633",
        "Vernon": "8672",
        "Victoria, BC": "8674",
        "Waglisla, BC": "8283",
        "Waneta": "8701",
        "Warfield": "8700",
        "Wasa Lake": "8703",
        "Webster's Corner": "8706",
        "Wells": "8707",
        "West Vancouver": "8660",
        "Westbank": "8708",
        "Westbridge": "8312",
        "Westminister": "8709",
        "Westwold": "8449",
        "Whaletown": "8711",
        "Whistler": "8712",
        "White Rock": "8702",
        "Whonnock": "8635",
        "Williams Lake": "8704",
        "Willow River": "8714",
        "Windermere": "8715",
        "Winfield, BC": "8716",
        "Winlaw": "8717",
        "Wonowon": "8457",
        "Woss": "8315",
        "Wyndel": "8718",
        "Yahk": "8459",
        "Yale": "8461",
        "Yarrow": "8719",
        "Ymir": "8463",
        "Youbou": "8721",
        "Zeballos": "8710"
    },
    "MB":{
        "Alexander, MB": "5011",
        "Altona": "5010",
        "Anola, MB": "5013",
        "Arborg": "5012",
        "Arden": "5014",
        "Arnaud": "5016",
        "Arnes": "5018",
        "Ashern": "5107",
        "Ashville": "5020",
        "Austin": "5022",
        "Bagot": "5108",
        "Baldur": "5029",
        "Balmoral": "5109",
        "Barrows": "5028",
        "Beausejour": "5030",
        "Belmont, MB": "5031",
        "Benito": "5032",
        "Binscarth": "5034",
        "Birtle": "5036",
        "Bloodvein River": "5037",
        "Blumenort": "5039",
        "Boissevain": "5038",
        "Bowsman": "5040",
        "Brandon": "5042",
        "Brunkild": "5110",
        "Bruxelles": "5111",
        "Carberry": "5060",
        "Carman": "5062",
        "Cartier": "5112",
        "Cartwright": "5064",
        "Churchill": "5065",
        "Clandeboye": "5407",
        "Coulter": "5067",
        "Cross Lake": "5113",
        "Crystal City": "5066",
        "Dauphin": "5080",
        "Decker": "5081",
        "Deloraine": "5082",
        "Dominion City": "5083",
        "Dufresne": "5033",
        "Dugald, MB": "5015",
        "Dunnottar": "5084",
        "Durban": "5088",
        "East Kildonan": "5380",
        "East Landmark": "5092",
        "East St Paul": "5381",
        "Elgin, MB": "5099",
        "Elie": "5098",
        "Elkhorn": "5100",
        "Elma": "5101",
        "Elmer": "5103",
        "Emerson": "5102",
        "Erickson, MB": "5104",
        "Eriksdale": "5105",
        "Ethelbert": "5106",
        "Fisher Branch": "5118",
        "Flin Flon": "5120",
        "Gardenhill": "5114",
        "Garson, MB": "5130",
        "Gilbert Plains": "5132",
        "Gillam": "5133",
        "Gimli": "5134",
        "Gladstone": "5136",
        "Glenboro": "5138",
        "Goodlands": "5139",
        "Grand Rapids": "5141",
        "Grande Pointe": "5097",
        "Grandview, MB": "5140",
        "Graysville": "5115",
        "Great Falls": "5142",
        "Gretna": "5144",
        "Grosse Isle": "5116",
        "Grunthal": "5146",
        "Gypsumville": "5117",
        "Hadashville": "5147",
        "Hamilton, MB": "5158",
        "Hamiota": "5160",
        "Hartney": "5162",
        "Haywood": "5163",
        "Headingley": "5164",
        "Hilbre": "5161",
        "Holland": "5148",
        "Horndean": "5165",
        "Hudgson": "5166",
        "Île-des-Chênes": "5171",
        "Island Lake, MB": "5150",
        "Kelwood": "5151",
        "Kenton": "5167",
        "Kenville, MB": "5168",
        "Killarney": "5170",
        "Kirkella": "5408",
        "Kleefeld": "5169",
        "Kola": "5086",
        "Komarno": "5178",
        "La Broquerie, MB": "5192",
        "La Salle, MB": "5090",
        "Lac du Bonnet": "5190",
        "Landmark": "5189",
        "La-Riviere": "5191",
        "Leaf Rapids": "5193",
        "Lena": "5194",
        "Libau": "5188",
        "Lindenwoods": "5198",
        "Lockport": "5152",
        "Lorette, MB": "5094",
        "Lowe Farm": "5195",
        "Lundar": "5409",
        "Lyleton": "5196",
        "Lynn Lake": "5197",
        "MacGregor": "5200",
        "Manitou": "5204",
        "Manson, MB": "5017",
        "Marchand": "5044",
        "Marquette": "5173",
        "Matlock": "5153",
        "McAuley": "5019",
        "McCreary": "5206",
        "Melita": "5208",
        "Miami": "5410",
        "Middlebro": "5209",
        "Miniolta": "5211",
        "Minitonas": "5210",
        "Minnedosa": "5212",
        "Minto, MB": "5215",
        "Mitchell, MB": "5096",
        "Moar Lake": "5213",
        "Morden": "5214",
        "Morris": "5216",
        "Napinka": "5230",
        "Neepawa": "5232",
        "New Bothwell": "5122",
        "Newdale": "5231",
        "Ninette": "5154",
        "Niverville": "5234",
        "North Kildonan": "5174",
        "Norway House": "5235",
        "Notre Dame de Lou": "5236",
        "Oak Lake": "5244",
        "Oakbank, MB": "5021",
        "Onanole": "5155",
        "Other": "5799",
        "Otterburne, MB": "5246",
        "Pierson": "5257",
        "Pilot Mound": "5260",
        "Pinawa": "5259",
        "Pine Falls": "5411",
        "Pine River": "5048",
        "Piney": "5261",
        "Pipestone": "5258",
        "Plum Coulee": "5262",
        "Plumas": "5156",
        "Poplar Point": "5263",
        "Poplarfield": "5175",
        "Portage la Prairi": "5264",
        "Powerview": "5266",
        "Prawda": "5157",
        "Randolf": "5277",
        "Rapid City": "5280",
        "Red Sucker Lake": "5278",
        "Reinfeld": "5026",
        "Reston": "5283",
        "Richer": "5279",
        "Ritchot": "5281",
        "Rivers": "5282",
        "Riverton": "5284",
        "Roblin": "5286",
        "Roland": "5285",
        "Rorketon": "5287",
        "Roseisle": "5293",
        "Rosenfeld": "5289",
        "Rosenort": "5292",
        "Rossburn": "5288",
        "Rossendale": "5291",
        "Russell, MB": "5290",
        "Saint Adolphe": "5412",
        "Saint Claude": "5310",
        "Saint François Xavier": "5383",
        "Saint Martin": "5315",
        "Sandy Hook": "5295",
        "Sarto": "5159",
        "Schanzenfeld": "5035",
        "Selkirk": "5300",
        "Shamattawa": "5296",
        "Shilo": "5301",
        "Shoal Lake": "5302",
        "Shortdale": "5297",
        "Snow Lake": "5303",
        "Snowflake": "5305",
        "Somerset": "5304",
        "Souris, MB": "5306",
        "South Junction": "5308",
        "Sprague": "5309",
        "Springfield, MB": "5307",
        "St Andrews, MB": "5124",
        "St Boniface, MB": "5382",
        "St Germain": "5311",
        "St Laurent, MB": "5312",
        "St Vital": "5386",
        "St. James-Assiniboia": "5384",
        "St. Jean": "5046",
        "St. Malo": "5317",
        "St.-Pierre-Jolys": "5313",
        "Starbuck": "5404",
        "Ste Agatha, MB": "5318",
        "Ste Anne": "5320",
        "Ste Rose du Lac": "5321",
        "Steinbach": "5322",
        "St-Lazare": "5314",
        "Stonewall": "5324",
        "Stoney Mountain": "5406",
        "Strathclair": "5323",
        "Sundance": "5325",
        "Sundown": "5413",
        "Swan Lake": "5414",
        "Swan River": "5326",
        "Teulon": "5340",
        "The Pas": "5342",
        "Thicket Portage": "5176",
        "Thompson, MB": "5344",
        "Tolstol": "5345",
        "Tourand": "5346",
        "Transcona": "5388",
        "Treherne": "5348",
        "Tuxedo": "5390",
        "Tyndall": "5024",
        "Vermette": "5358",
        "Virden": "5360",
        "Vita": "5362",
        "Warren, MB": "5177",
        "Waskada": "5370",
        "Waterhen": "5368",
        "Wawanesa": "5372",
        "Waywayseecappo": "5068",
        "Wellwood": "5205",
        "West Kildonan": "5392",
        "West St Paul": "5393",
        "Whitemouth": "5373",
        "Windygate": "5375",
        "Winkler": "5376",
        "Winnipeg": "5378",
        "Winnipeg Beach": "5400",
        "Winnipegosis": "5402",
        "Woodlands": "5379",
        "Woodmore": "5172",
        "Zhoda, MB": "5023"
    },
    "NB":{
        "Acadieville": "0625",
        "Alma, NB": "0610",
        "Andover": "0611",
        "Aroostook": "0612",
        "Arthurette": "0613",
        "Atholville": "0614",
        "Back Bay": "0615",
        "Baie Sainte-Anne": "0618",
        "Bains Corner": "0623",
        "Baker Brook": "0620",
        "Barkers Point": "0622",
        "Bath, NB": "0624",
        "Bathurst": "0626",
        "Beaconsfield, NB": "0627",
        "Bedell": "0629",
        "Belledune": "0628",
        "Beresford": "0630",
        "Bertrand": "0632",
        "Berts Cove": "0953",
        "Blacks Harbour": "0633",
        "Blackville": "0634",
        "Bloomfield, NB": "0635",
        "Bouctouche": "0640",
        "Bridgedale": "0636",
        "Bristol": "0638",
        "Browns Flat": "0639",
        "Bulls Creek": "0667",
        "Cambridge Narrows": "0650",
        "Campbellton": "0652",
        "Campobello": "0653",
        "Canterbury": "0654",
        "Cap Pele": "0656",
        "Cape Tourmentine": "0657",
        "Caraquet": "0658",
        "Carlingford": "0712",
        "Centreville, NB": "0660",
        "Charlo": "0662",
        "Chartersville": "0664",
        "Chatham, NB": "0666",
        "Chipman, NB": "0668",
        "Clair": "0670",
        "Clairville": "0669",
        "Cocagne": "0673",
        "Codys": "0671",
        "Coles Island": "0954",
        "College Bridge": "0672",
        "Colpitts Settl.": "0621",
        "Connors": "0674",
        "Cummings Cove": "0687",
        "Dalhousie, NB": "0680",
        "Deer Island Point": "0681",
        "Dieppe": "0774",
        "Dipper Harbour": "9102",
        "Doaktown": "0682",
        "Dorchester, NB": "0684",
        "Douglastown": "0686",
        "Drummond": "0688",
        "East Riverside-Kingshurst": "0690",
        "East Shediac": "0692",
        "Edmundston": "0694",
        "Eel River Crossin": "0700",
        "Eng. Settlement": "0683",
        "Fairhaven": "0701",
        "Fairvale": "0852",
        "Florenceville": "0702",
        "Forest City": "0703",
        "Fosterville": "0705",
        "Four Falls": "0709",
        "Fredericton": "0704",
        "Fredericton Junct": "0710",
        "Gagetown": "0716",
        "Gaspereau Forks": "0713",
        "Gillespie": "0717",
        "Gondola Point": "0718",
        "Grand Falls, NB": "0722",
        "Grand Harbour": "0724",
        "Grand Manan": "0725",
        "Grande-Anse": "0720",
        "Green Point": "0727",
        "Gunningsville": "0726",
        "Hampton, NB": "0728",
        "Hanwell": "0631",
        "Harcourt": "0729",
        "Hartland": "0730",
        "Harvey": "0732",
        "Hillsborough": "0734",
        "Hopewell Cape": "0736",
        "Jacksontown": "0637",
        "Jacquet River": "0740",
        "Juniper": "0743",
        "Kedgewick": "0746",
        "Keswick Ridge": "0685",
        "Kouchibouguac": "0955",
        "Lac Baker": "0750",
        "Lakeville": "0751",
        "Lameque": "0752",
        "Lancaster, NB": "0854",
        "Lansdowne, NB": "0855",
        "Lewisville": "0776",
        "Lincoln Heights": "0753",
        "Little River": "0689",
        "Loch Lomond": "0755",
        "Loggieville": "0754",
        "Lower Brighton": "0642",
        "Lower Caraquet": "0756",
        "Ludlow": "0757",
        "Maisonnette": "0759",
        "Mars Hill Road": "0761",
        "Marysville, NB": "0706",
        "Maugerville": "0714",
        "McAdam": "0760",
        "Mckenna": "0651",
        "Meductic": "0762",
        "Memramcook": "0715",
        "Millerton": "0763",
        "Milltown, NB": "0764",
        "Millville": "0766",
        "Minto, NB": "0768",
        "Miramichi": "0770",
        "Miscou Centre": "0771",
        "Mohannes": "0691",
        "Moncton": "0772",
        "Nackawic": "0780",
        "Napan": "0719",
        "Nashwaaksis": "0708",
        "Neguac": "0782",
        "Nelson, NB": "0784",
        "New Denmark": "0787",
        "New Maryland": "0619",
        "Newcastle, NB": "0786",
        "Nigadoo": "0788",
        "North Head": "0790",
        "Northampton": "0655",
        "Norton": "0792",
        "Notre Dame, NB": "0794",
        "Oak Bay, NB": "0659",
        "Oakland, NB": "0693",
        "Oromocto": "0800",
        "Other": "0999",
        "Pamdenec": "0806",
        "Paquetville": "0808",
        "Peel": "0675",
        "Pennfield": "0956",
        "Perth, NB": "0809",
        "Perth-Andover": "0810",
        "Petit Rocher": "0812",
        "Petitcodiac": "0814",
        "Plaster Rock": "0816",
        "Pleasant Villa": "0661",
        "Pointe-du-Chêne": "0817",
        "Pointe-Verte": "0818",
        "Port Elgin, NB": "0820",
        "Prince William": "0823",
        "Quispamsis": "0826",
        "Red Bank": "0828",
        "Renforth": "0830",
        "Renous": "0829",
        "Rexton": "0832",
        "Richibucto": "0834",
        "River de Chute": "0835",
        "Riverbank": "0616",
        "Riverside-Albert": "0836",
        "Riverview": "0837",
        "Riverview Heights": "0778",
        "Riviere-Verte": "0838",
        "Robichaud": "0839",
        "Rogersville": "0840",
        "Rothesay": "0842",
        "Sackville, NB": "0848",
        "Saint Andrews": "0880",
        "Saint Hilaire": "0890",
        "Saint John, NB": "0850",
        "Saint-André": "0878",
        "Saint-Anselme": "0884",
        "Saint-Antoine": "0858",
        "Saint-Basile": "0696",
        "Saint-Charles": "0721",
        "Sainte-Anne-de-Kent": "0957",
        "Sainte-Anne-de-Madawaska": "0882",
        "Saint-Edouard-de-Kent": "0695",
        "Sainte-Marie-de-Kent": "0899",
        "Saint-François-de-Madawaska": "0886",
        "Saint-Jacques": "0892",
        "Saint-Joseph, NB": "0894",
        "Saint-Leonard, NB": "0896",
        "Saint-Louis-de-Kent": "0898",
        "Saint-Quentin": "0902",
        "Salisbury": "0860",
        "Scoudouc": "0641",
        "Sea Cove, NB": "0862",
        "Shediac": "0866",
        "Shippegan": "0868",
        "Silverwood": "0870",
        "St George, NB": "0888",
        "St Martins": "0900",
        "St Stephen": "0904",
        "Stanley": "0910",
        "Stickney": "0911",
        "Summerfield": "0676",
        "Surrey, NB": "0916",
        "Sussex": "0918",
        "Sussex Corner": "0831",
        "Taymouth": "0920",
        "Tide Head": "0924",
        "Tracadie": "0928",
        "Tracadie-Sheila": "0697",
        "Tracy, NB": "0930",
        "Upper Coverdale": "0678",
        "Upper Kent": "0958",
        "Upper Woodstock": "0677",
        "Wakefield, NB": "0663",
        "Waterville": "0698",
        "Welshpool": "0946",
        "Westfield": "0950",
        "Whitehead": "0707",
        "Wicklow": "0711",
        "Wilson's Beach": "0951",
        "Woodside": "0665",
        "Woodstock, NB": "0952",
        "Youngs Cove": "0679",
        "Zealand": "0970"
    },
    "NL":{
        "Aguathuna": "0009",
        "Badger": "0002",
        "Baie de Verde": "0004",
        "Baie Verte": "0006",
        "Bauline": "0067",
        "Bay L'Argent": "0011",
        "Bay Roberts": "0008",
        "Bell Island": "0013",
        "Belleoram": "0010",
        "Benoit's Cove": "0015",
        "Bishop's Falls": "0012",
        "Bonavista": "0014",
        "Botwood": "0016",
        "Brigus": "0018",
        "Buchans": "0054",
        "Burgeo": "0020",
        "Burin": "0022",
        "Burl.-Green Bay": "0017",
        "Cape Broyle": "0094",
        "Carbonear": "0024",
        "Carmanville": "0284",
        "Catalina": "0026",
        "Cavendish": "0055",
        "Change Islands": "0028",
        "Channel-Port aux Basques": "0030",
        "Chapel Cove": "0056",
        "Clarenville": "0032",
        "Clark's Beach": "0034",
        "Come By Chance": "0040",
        "Conception Bay": "0019",
        "Cormack": "0021",
        "Corner Brook": "0036",
        "Cow Head": "0023",
        "Creston, NL": "0068",
        "Cupids": "0038",
        "Deer Lake": "0042",
        "Doyles": "0025",
        "Dunnville, NL": "0044",
        "Durrell": "0057",
        "Eastport": "0058",
        "Elliston": "0050",
        "Englee": "0052",
        "Flowers Cove, NL": "0003",
        "Fogo": "0060",
        "Forteau": "0069",
        "Fortune": "0062",
        "Freshwater": "0064",
        "Gambo": "0027",
        "Gander": "0080",
        "Gaultois": "0082",
        "Gillams": "0029",
        "Glenwood, NL": "0084",
        "Glovertown": "0086",
        "Goose Bay": "0087",
        "Gould": "0281",
        "Grand Bank": "0088",
        "Grand Falls, NL": "0090",
        "Greenspond": "0092",
        "Hants Harbour": "0095",
        "Happy Valley": "0100",
        "Harbour Breton": "0102",
        "Harbour Grace": "0104",
        "Hare Bay": "0106",
        "Hawke's Bay": "0031",
        "Holyrood": "0108",
        "Hopedale": "0285",
        "Jackson's Arm": "0033",
        "Jerseyside": "0114",
        "Kelligrews": "0035",
        "Kilbride, NL": "0037",
        "Labrador City": "0120",
        "Lamaline": "0122",
        "Lawn": "0124",
        "Lewisporte": "0126",
        "Little Catalina": "0128",
        "Lourdes, NL": "0005",
        "Lumsden, NL": "0130",
        "Main Brook": "0140",
        "Makkovik": "0286",
        "Manuels": "0283",
        "Mary's Harbour": "0287",
        "Marystown": "0142",
        "Milltown, NL": "0039",
        "Mount Pearl": "0228",
        "Nain": "0288",
        "Natuashish": "0289",
        "Newtown": "0230",
        "Norris Arm": "0156",
        "Old Pelican": "0160",
        "O'Regans": "0041",
        "Other": "0299",
        "Outer Cove": "0059",
        "Paradise, NL": "0007",
        "Pasadena": "0170",
        "Placentia": "0172",
        "Point Leamington": "0174",
        "Port au Choix": "0066",
        "Port Rexton": "0096",
        "Port Saunders": "0045",
        "Port Union": "0176",
        "Port-au-Port": "0043",
        "Portugal Cove": "0046",
        "Pouch Cove": "0178",
        "Pound Cove": "0290",
        "Ramea": "0190",
        "Renews": "0047",
        "Rigolet": "0291",
        "Robert's Arm": "0192",
        "Rocky Harbour": "0292",
        "Roddickton": "0194",
        "South Brook": "0210",
        "South River, NL": "0212",
        "Spaniard's Bay": "0214",
        "Springdale": "0216",
        "St Alban's, NL": "0220",
        "St Anthony": "0222",
        "St George's, NL": "0224",
        "St John's, NL": "0226",
        "St Lawrence": "0236",
        "Stephenville": "0240",
        "Stephenville Cros": "0242",
        "Topsail": "0048",
        "Torbay": "0049",
        "Trepassey": "0250",
        "Trinity": "0282",
        "Triton": "0051",
        "Twillingate": "0252",
        "Upper Island Cove": "0260",
        "Wabana": "0270",
        "Wabush": "0272",
        "Wesleyville": "0274",
        "Western Bay": "0053",
        "Whitbourne": "0276",
        "Windsor, NL": "0278",
        "Winterton": "0280",
        "Witless Bay": "0070"
    },
    'NS':{
        "Amherst": "0410",
        "Annapolis Royal": "0412",
        "Antigonish": "0414",
        "Arcadia": "0409",
        "Armdale": "0411",
        "Aylesford": "0413",
        "Baddeck": "0415",
        "Bakers Settlement": "0405",
        "Barrington Pas.": "0416",
        "Beach Meadows": "0404",
        "Bear River": "0417",
        "Beaver Bank": "0403",
        "Bedford, NS": "0452",
        "Beechville": "0561",
        "Belmont, NS": "0402",
        "Berwick": "0418",
        "Bible Hill": "0419",
        "Black Point": "0591",
        "Blandford": "0420",
        "Blockhouse": "0421",
        "Bonico": "0590",
        "Bridgetown": "0422",
        "Bridgewater": "0424",
        "Brier Island": "0423",
        "Brockfield": "0425",
        "Brookfield": "0426",
        "Brookside": "0401",
        "Caledonia, NS": "0427",
        "Camperdown": "0400",
        "Canning": "0428",
        "Canso": "0430",
        "Cape Breton": "0429",
        "Centerville, NS": "0431",
        "Centreville": "0398",
        "Chester": "0433",
        "Chester Basin": "0434",
        "Cheticamp": "0435",
        "Church Point": "0436",
        "Clark's Harbour": "0432",
        "Clementsvale": "0437",
        "Cleveland": "0471",
        "Colchester": "0438",
        "Coldbrook": "0564",
        "Cole Harbour": "0511",
        "Cow Bay": "0387",
        "Cumberland, NS": "0439",
        "Dalhousie, NS": "0441",
        "Dartmouth": "0440",
        "Debert, NS": "0550",
        "Deep Brook": "0566",
        "Digby": "0442",
        "Dingwall": "0592",
        "Dominion": "0446",
        "East Bay": "0443",
        "East Lake Ainslie": "0396",
        "East Pennant": "0567",
        "Eastern Passage": "0478",
        "Economy": "0479",
        "Ellerhouse": "0444",
        "Elmsdale": "0569",
        "Enfield": "0559",
        "Englishtown": "0395",
        "Eskasoni": "0445",
        "Fall River": "0447",
        "Falmouth, NS": "0551",
        "Fletchers": "0394",
        "Freeport": "0448",
        "Gaetz Brook": "0582",
        "Gillis Point": "0593",
        "Glace Bay": "0532",
        "Glenwood, NS": "0449",
        "Grand Pre": "0451",
        "Grand River": "0487",
        "Granville": "0454",
        "Granville Ferry": "0453",
        "Greenwood, NS": "0455",
        "Guysborough": "0457",
        "Halifax": "0450",
        "Hammands Plains": "0573",
        "Hants County": "0489",
        "Hantsport": "0460",
        "Hatchet Lake": "0407",
        "Head Chezzetcook": "0563",
        "Head Of Jeddore": "0575",
        "Herring Cove": "0576",
        "Hillsburn": "0393",
        "Hubbards, NS": "0458",
        "Hubley": "0577",
        "Indian Brook": "0367",
        "Ingonish Beach": "0462",
        "Inverness, NS": "0459",
        "Irish Cove": "0461",
        "Jeddore Oyster Ponds": "0377",
        "Judique": "0392",
        "Karsdale": "0391",
        "Kempt": "0389",
        "Kentville, NS": "0464",
        "Kings City": "0463",
        "Kingston, NS": "0465",
        "Kingsville, NS": "0466",
        "La Have": "0467",
        "Lake Echo": "0397",
        "Lakeside": "0383",
        "Lantz": "0468",
        "Larry's River": "0523",
        "Lawrencetown": "0469",
        "Litchfield": "0384",
        "Liverpool": "0470",
        "Lockeport": "0472",
        "Louisbourg": "0474",
        "Lower L'Ardoise": "0473",
        "Lower Sackville": "0475",
        "Lucasville": "0406",
        "Lunenburg": "0476",
        "Lunnenburg County": "0477",
        "Mabou": "0531",
        "Mahone Bay": "0480",
        "Malagash": "0578",
        "Margaree Forks": "0533",
        "Margaretsville": "0579",
        "Marion Bridge": "0529",
        "Martins River": "0481",
        "Mavillette": "0385",
        "Merigomish, NS": "0553",
        "Meteghan River": "0483",
        "Middle Sackville": "0379",
        "Middleton": "0482",
        "Mill Village": "0537",
        "Millbrook, NS": "0366",
        "Minesville": "0485",
        "Moose River": "0557",
        "Mulgrave": "0484",
        "Musquodoboit": "0486",
        "New Germany": "0488",
        "New Glasgow, NS": "0490",
        "New Minas": "0491",
        "New Waterford": "0492",
        "Newport": "0380",
        "Noel": "0493",
        "North East Point": "0381",
        "North Sydney": "0496",
        "Northwest Cove": "0494",
        "Oakfield": "0565",
        "Other": "0599",
        "Oxford, NS": "0502",
        "Parrsboro": "0510",
        "Petit-de-Grat": "0497",
        "Petite Riviere": "0495",
        "Pictou": "0512",
        "Pleasant Bay": "0498",
        "Pleasant Valley": "0499",
        "Pleasantville": "0595",
        "Pomquet": "0500",
        "Port George": "0504",
        "Port Hawkesbury": "0514",
        "Port Hood": "0503",
        "Port Maitland": "0501",
        "Port Saxon": "0539",
        "Port Williams": "0505",
        "Porters Lake": "0506",
        "Potter's Lake": "0596",
        "Poulamon": "0507",
        "Prospect": "0597",
        "Pugwash": "0508",
        "River Denys": "0594",
        "River John": "0541",
        "Roberta": "0375",
        "Rose Bay": "0509",
        "Sackville, NS": "0456",
        "Salmon River": "0543",
        "Sandford": "0513",
        "Saulnierville": "0545",
        "Scotch Village": "0555",
        "Scotsburn": "0589",
        "Seabright": "0583",
        "Shad Bay": "0369",
        "Shag Harbour": "0515",
        "Shear Water": "0516",
        "Sheet Harbour": "0517",
        "Shelburne, NS": "0518",
        "Sherbrooke, NS": "0547",
        "Shubenacadie": "0519",
        "Shubewacad": "0521",
        "South Ohio": "0584",
        "Springfield": "0585",
        "Springhill": "0520",
        "St Margaret's Bay": "0525",
        "St. George's Channel": "0526",
        "St. Peter's": "0527",
        "Ste. Anne du Ruis": "0528",
        "Stellarton": "0522",
        "Stewiacke": "0524",
        "Stillwater Lake": "0586",
        "Sydney Mines": "0534",
        "Sydney, NS": "0530",
        "Tantallon, NS": "0536",
        "Tatamagouche": "0538",
        "Terence Bay": "0598",
        "Timberlea": "0535",
        "Trenton, NS": "0540",
        "Truro": "0542",
        "Tusket": "0544",
        "Upper Kennetcook": "0548",
        "Upper Stewiacke": "0546",
        "Upper Tantallon": "0370",
        "Walton, NS": "0552",
        "Waterville, NS": "0554",
        "Waverley": "0556",
        "Wedge Port": "0558",
        "Wellington, NS": "0549",
        "West Arichat": "0587",
        "West Bay": "0560",
        "West Dover": "0562",
        "Westville": "0570",
        "Weymouth": "0568",
        "Whites Lake": "0588",
        "Whycocomagh": "0408",
        "Wilmot, NS": "0571",
        "Windsor, NS": "0572",
        "Wolfville": "0574",
        "Woods Harbour": "0371",
        "Yarmouth": "0580"
    },
    "NT":{
    "Coleville Lk": "9029",
    "Deline": "9032",
    "Detah": "9038",
    "Enterprise": "9046",
    "Fort Liard": "9041",
    "Fort Rae": "8020",
    "Fort Simpson": "7249",
    "Fort Smith, NT": "8030",
    "Ft Good Hope": "9030",
    "Ft Providenc": "9044",
    "Ft Resolutio": "9047",
    "Ft.Mcpherson": "9027",
    "Hay River, NT": "8040",
    "Holman": "9024",
    "Iklavik": "9026",
    "Inuvik, NT": "8060",
    "Jeanmarie Ri": "9042",
    "Kakisa": "9045",
    "Lutselk'e": "9039",
    "Nahanni Butt": "9040",
    "Norman Wells": "9031",
    "Other": "8099",
    "Paulatuk": "9048",
    "Rae Lakes": "9035",
    "Sachs Harbou": "9023",
    "Snare Lakes": "9036",
    "Trout Lake": "9043",
    "Tsiligetchik": "9028",
    "Tuktoyaktuk": "9025",
    "Tulita": "9033",
    "Wrigley": "9034",
    "Yellowknife, NT": "8090"
},
    "NU":{
    "Arctic Bay": "7547",
    "Arviat": "9013",
    "Baker Lake": "9012",
    "Bathurst Inl": "9018",
    "Bay Chimo": "9019",
    "Broughton I.": "9000",
    "Cambridge Bay": "7101",
    "Cape Dorset": "9001",
    "Chesterfield": "9014",
    "Clyde River": "9002",
    "Coppermine": "7548",
    "Coral Harbou": "9015",
    "Frobisher Bay": "7256",
    "Gjoa Haven": "9020",
    "Grise Fjord": "9003",
    "Hall Beach": "9004",
    "Igloolik": "9005",
    "Iqaluit": "7345",
    "Kimminut": "9006",
    "Kugluktuk": "9021",
    "Nanisivik": "9007",
    "Other": "9099",
    "Pangnittung": "9008",
    "Pelly Bay": "9049",
    "Pond Inlet": "9009",
    "Rankin Inlet": "9051",
    "Repulse Bay": "9016",
    "Resolute": "9010",
    "Sanikiluaq": "9011",
    "Taloyoak": "9022",
    "Whale Cove": "9017"
},
    'ON':{
    "Aberfoyl": "3001",
    "Acton": "3002",
    "Agincourt": "3003",
    "Ailsa Craig": "3004",
    "Ajax": "3006",
    "Aldershot": "3007",
    "Alderwood": "3009",
    "Alexandria": "3008",
    "Alfred": "3010",
    "Algoma": "3011",
    "Algoma Mills": "3013",
    "Allenford": "3941",
    "Alliston": "3012",
    "Alma, ON": "3005",
    "Almonte": "3014",
    "Alton": "3015",
    "Alvinston": "3016",
    "Amherstburg": "3018",
    "Amherstview": "3995",
    "Ancaster": "3326",
    "Anderson": "3017",
    "Angus": "3019",
    "Annan": "3000",
    "Apple Hill": "3285",
    "Apsley": "3255",
    "Ariss": "3021",
    "Arkona": "3020",
    "Armitage": "3023",
    "Armstrong, ON": "3025",
    "Arnprior": "3022",
    "Arnstein": "3027",
    "Arthur": "3024",
    "Arva": "3287",
    "Ashburn": "3029",
    "Ashton": "3031",
    "Athens": "3026",
    "Atikokan": "3033",
    "Attawapiskat": "3288",
    "Atwood": "3943",
    "Auburn": "3944",
    "Aurora": "3028",
    "Avon": "3034",
    "Avonmore": "3942",
    "Aylmer, ON": "3030",
    "Ayr": "3032",
    "Azilda, ON": "3113",
    "Baden, ON": "3114",
    "Bailieboro": "3289",
    "Bainsville": "3035",
    "Bala": "3036",
    "Baldwin": "3037",
    "Ballantree": "3038",
    "Balmertown": "3039",
    "Baltimore": "3045",
    "Bamkanen": "3041",
    "Bancroft": "3040",
    "Bar Harbour": "3043",
    "Barrie": "3042",
    "Barry's Bay": "3044",
    "Basswood Lake": "3047",
    "Batawa": "3049",
    "Bath, ON": "3046",
    "Battersea": "3315",
    "Bayfield": "3048",
    "Baymouth": "3051",
    "Baysville": "3053",
    "Beachburg": "3050",
    "Beachville": "3052",
    "Beamsville": "3055",
    "Beardmore": "3057",
    "Beaverton": "3054",
    "Beeton": "3056",
    "Belfountain": "3059",
    "Bell Ewart": "3570",
    "Belle River": "3058",
    "Belleville": "3060",
    "Belmont, ON": "3062",
    "Belwood": "3105",
    "Berkeley": "3065",
    "Bethany": "3079",
    "Binbrook": "3067",
    "Blackburn Hamlet": "3063",
    "Blackstock": "3081",
    "Blenheim": "3064",
    "Blind River": "3066",
    "Bloomfield, ON": "3068",
    "Bloomingdale": "3571",
    "Bluevale": "3069",
    "Blyth": "3070",
    "Bobcaygeon": "3072",
    "Bob-Lo Island": "3073",
    "Bolton": "3074",
    "Bond Head": "3071",
    "Bonfield": "3076",
    "Borden, ON": "3077",
    "Bothwell": "3078",
    "Bourget, ON": "3115",
    "Bowmanville": "3080",
    "Bracebridge": "3082",
    "Bradford": "3084",
    "Braeside": "3086",
    "Bramalea": "3087",
    "Brampton": "3088",
    "Branchton": "3089",
    "Brantford": "3090",
    "Brechin": "3085",
    "Breslau": "3091",
    "Bridgenorth": "3535",
    "Bridgeport": "3092",
    "Brigden": "3572",
    "Bright": "3093",
    "Brighton": "3094",
    "Bright's Grove": "3095",
    "Britt": "3573",
    "Brockville": "3096",
    "Bronte": "3097",
    "Brooklin, ON": "3116",
    "Brownsville": "3075",
    "Bruce Mines": "3098",
    "Brunner": "3099",
    "Brussels": "3100",
    "Buckhorn": "3539",
    "Burford": "3103",
    "Burgessville": "3101",
    "Burk's Falls": "3102",
    "Burlington": "3104",
    "Burnt River": "3106",
    "Burritts Rapids": "3108",
    "Buttonville": "3110",
    "Cabden": "3118",
    "Cache Bay": "3120",
    "Caesarea": "3119",
    "Caistor Centre": "3121",
    "Caledon": "3123",
    "Caledon East": "3122",
    "Caledon Village": "3319",
    "Caledonia, ON": "3124",
    "Callander": "3127",
    "Cambridge": "3129",
    "Cambridge-Galt": "3126",
    "Cameron": "3574",
    "Camlachie": "3182",
    "Campbellcroft": "3131",
    "Campbellford": "3128",
    "Campbellville": "3133",
    "Canfield": "3183",
    "Cannington": "3130",
    "Capreol": "3132",
    "Caramat": "3135",
    "Cardinal": "3134",
    "Cardwal": "3137",
    "Carleton Place": "3136",
    "Carlisle": "3139",
    "Carlsbad Springs": "3321",
    "Carp": "3141",
    "Carrying Place": "3117",
    "Casselman": "3138",
    "Castleton": "3266",
    "Cavan": "3323",
    "Cayuga, ON": "3195",
    "Cedar Valley": "3143",
    "Central Elgin": "3568",
    "Centralia": "3145",
    "Chaffey's Lock": "3325",
    "Chalk River": "3140",
    "Chapleau": "3147",
    "Charing Cross": "3149",
    "Charlesbourg, ON": "3151",
    "Charlton": "3142",
    "Chatham, ON": "3144",
    "Chatsworth": "3146",
    "Chelmsford": "3153",
    "Cheltenham": "3155",
    "Chesley": "3148",
    "Chesterville, ON": "3150",
    "Churchill, ON": "3157",
    "Claremount, ON": "3159",
    "Clarendon": "3161",
    "Clarkson": "3541",
    "Clearwater, ON": "3163",
    "Clifford": "3152",
    "Clinton, ON": "3154",
    "Coatsworth": "3165",
    "Cobalt": "3156",
    "Cobden": "3158",
    "Cobourg": "3160",
    "Cochrane, ON": "3162",
    "Colborne": "3164",
    "Coldwater": "3166",
    "Colgan": "3167",
    "Collingwood": "3168",
    "Combermere": "3169",
    "Comlachie": "3171",
    "Concord": "3173",
    "Conestogo": "3245",
    "Coniston": "3170",
    "Conn": "3184",
    "Connaught": "3175",
    "Consecon": "3177",
    "Cookstown": "3172",
    "Copper Cliff": "3174",
    "Corbeil": "3555",
    "Cornwall, ON": "3176",
    "Corunna": "3185",
    "Cottam": "3179",
    "Courtice": "3107",
    "Courtland": "3189",
    "Courtright": "3178",
    "Creemore": "3180",
    "Crofton, ON": "3181",
    "Crysler": "3109",
    "Crystal Beach": "3111",
    "Cumberland, ON": "3186",
    "Curran": "3187",
    "Curve Lake": "3188",
    "Cutterville": "3112",
    "Dashwood": "3191",
    "Deep River": "3190",
    "Delaware": "3327",
    "Delhi": "3196",
    "Deloro": "3198",
    "Denfield": "3192",
    "Desbarats": "3197",
    "Deseronto": "3200",
    "Devlin": "3199",
    "Dinbrook": "3205",
    "Don Mills": "3201",
    "Dorchester, ON": "3212",
    "Downs": "3207",
    "Downsview": "3203",
    "Drayton": "3202",
    "Dresden": "3204",
    "Dryden": "3206",
    "Dublin": "3193",
    "Dufferin": "3211",
    "Dunchurch": "3559",
    "Dundalk": "3210",
    "Dundas": "3328",
    "Dunnville, ON": "3214",
    "Dunrobin": "3194",
    "Dunsford": "3575",
    "Dunvegan": "3219",
    "Durham, ON": "3216",
    "Dutton": "3218",
    "Dwight": "3213",
    "Dwyer Hill": "3215",
    "E Gwillimbury": "3217",
    "Eagle River": "3222",
    "Ear Falls": "3224",
    "East York": "3818",
    "Echo Bay": "3226",
    "Eden": "3228",
    "Eganville": "3230",
    "Elgin, ON": "3229",
    "Elizabethtown": "3329",
    "Elliot Lake": "3231",
    "Elmida": "3233",
    "Elmira": "3232",
    "Elmvale": "3234",
    "Elmwood": "3235",
    "Elora": "3236",
    "Embro": "3238",
    "Embrun": "3239",
    "Emo": "3237",
    "Englehart": "3240",
    "Enniskillen": "3243",
    "Ennismore": "3241",
    "Erie Beach": "3242",
    "Erieau": "3244",
    "Erin": "3246",
    "Espanola": "3248",
    "Essex": "3250",
    "Etobicoke": "3819",
    "Everett": "3254",
    "Exeter": "3256",
    "Fenelon Falls": "3270",
    "Fenwick, ON": "3220",
    "Fergus": "3272",
    "Finch": "3274",
    "Fisherville": "3273",
    "Fitzroy Harbour": "3271",
    "Flamborough": "3275",
    "Flesherton": "3276",
    "Floradale": "3277",
    "Florence": "3281",
    "Fonthill": "3279",
    "Forest": "3278",
    "Forks of the Credit": "3125",
    "Fort Albany": "3623",
    "Fort Erie": "3280",
    "Fort Frances": "3282",
    "Frankford": "3284",
    "Freelton": "3283",
    "Fruitland": "3286",
    "Fullarton": "3337",
    "Gananoque": "3290",
    "Garson, ON": "3292",
    "Georgetown, ON": "3294",
    "Georgian Bay": "3291",
    "Geraldton": "3296",
    "Gilford": "3297",
    "Girouxville, ON": "3317",
    "Glen Robertson": "3945",
    "Glen William": "3299",
    "Glencoe": "3298",
    "Gloucester": "3301",
    "Goderich": "3300",
    "Godfrey": "3303",
    "Golden Lake": "3338",
    "Goodwood": "3295",
    "Gore Bay": "3302",
    "Gores Landing": "3461",
    "Gormley": "3305",
    "Goulais": "3307",
    "Gowanstown": "3309",
    "Grafton": "3311",
    "Grand Bend": "3304",
    "Grand Valley": "3306",
    "Granton": "3293",
    "Grassie": "3313",
    "Grassy Narrows": "3576",
    "Gravenhurst": "3308",
    "Greely": "3314",
    "Griffith": "3316",
    "Grimsby": "3310",
    "Guelph": "3312",
    "Hagersville": "3320",
    "Haileybury": "3322",
    "Haliburton": "3333",
    "Halton Hills": "3334",
    "Hamilton, ON": "3324",
    "Hampton, ON": "3335",
    "Hanmer": "3339",
    "Hannon": "3336",
    "Hanover": "3340",
    "Harbour Crest": "3341",
    "Harley": "3343",
    "Harriston": "3342",
    "Harrow": "3344",
    "Harrowsmith": "3345",
    "Harwood": "3578",
    "Hastings": "3346",
    "Havelock": "3348",
    "Hawkesbury": "3350",
    "Hawkestone": "3349",
    "Hawkesville": "3351",
    "Hearst": "3352",
    "Heidelberg": "3560",
    "Hensall": "3354",
    "Hepworth": "3356",
    "Highgate": "3358",
    "Hillsburgh, ON": "3221",
    "Hillsdale": "3331",
    "Hilton Beach": "3360",
    "Holland Centre": "3347",
    "Holland Landing": "3361",
    "Holstein": "3363",
    "Honeywood": "3353",
    "Hornby, ON": "3364",
    "Hornepayne": "3366",
    "Horning Mills": "3359",
    "Huntsville": "3362",
    "Huron Park": "3367",
    "Hyde Park": "3368",
    "Ignace": "3372",
    "Ilderton": "3355",
    "Ingersoll": "3380",
    "Ingleside": "3374",
    "Inglewood": "3376",
    "Innerkip": "3378",
    "Innisfil": "3357",
    "Inverary": "3591",
    "Inwood": "3371",
    "Iona Station": "3365",
    "Iron Bridge": "3382",
    "Iroquois": "3384",
    "Iroquois Falls": "3386",
    "Islington": "3387",
    "Jackson's Point": "3388",
    "Janetville": "3593",
    "Jarvis": "3390",
    "Jerseyville": "3389",
    "Jordan": "3395",
    "Kagawong": "3391",
    "Kakabeka Falls": "3393",
    "Kaministiquia": "3392",
    "Kanata": "3394",
    "Kapuskasing": "3400",
    "Kars": "3369",
    "Kearney": "3402",
    "Keene": "3403",
    "Keewatin": "3404",
    "Kemble": "3405",
    "Kemptville": "3406",
    "Kenilworth": "3401",
    "Kenora": "3408",
    "Kent Bridge": "3409",
    "Kerwood": "3411",
    "Keswick": "3415",
    "Kettleby": "3417",
    "Kilbride, ON": "3373",
    "Killaloe": "3410",
    "Kinburn": "3407",
    "Kincardine": "3412",
    "Kincourt": "3419",
    "King": "3413",
    "King City": "3422",
    "Kingston, ON": "3414",
    "Kingsville, ON": "3416",
    "Kinmount": "3594",
    "Kippen": "3595",
    "Kirkland Lake": "3418",
    "Kitchener": "3420",
    "Kleinburg": "3424",
    "Komoka": "3426",
    "La Broquerie": "3430",
    "La Salette": "3431",
    "Ladner Lake": "3441",
    "Lake St. Peter": "3434",
    "Lakefield": "3442",
    "Lambeth": "3436",
    "Lanark": "3444",
    "Lancaster, ON": "3446",
    "Langton": "3438",
    "Lansdowne": "3447",
    "LaSalle, ON": "3433",
    "Latchford": "3448",
    "Leamington": "3450",
    "Leaside": "3451",
    "Leaskdale": "3453",
    "Lefaivre": "3432",
    "Lefroy": "3449",
    "Levack": "3452",
    "Limehouse": "3457",
    "Lincoln": "3454",
    "Lindsay": "3456",
    "Linwood": "3459",
    "Lion's Head": "3458",
    "Listowel": "3460",
    "Little Britain": "3375",
    "Little Current": "3462",
    "Lively": "3464",
    "Lombardy": "3465",
    "Londesborough": "3377",
    "London": "3466",
    "Long Branch": "3467",
    "Long Sault": "3469",
    "Longlac": "3379",
    "Lorette, ON": "3471",
    "L'Orignal": "3440",
    "Loring": "3946",
    "Lucan": "3468",
    "Lucknow": "3470",
    "Lynden": "3472",
    "Maberly": "3476",
    "Mactier": "3478",
    "Madoc": "3480",
    "Magnetawan": "3482",
    "Maidstone, ON": "3483",
    "Maitland": "3485",
    "Mallorytown, ON": "3223",
    "Malton": "3477",
    "Manitouwadge": "3487",
    "Manotick": "3489",
    "Mansfield": "3491",
    "Maple": "3493",
    "Marathon": "3479",
    "Markdale": "3484",
    "Markham": "3486",
    "Markstay": "3561",
    "Marmora": "3488",
    "Massey": "3490",
    "Mattawa": "3492",
    "Maxville": "3494",
    "Maynooth": "3481",
    "McGregor": "3495",
    "Mckellar": "3381",
    "Meaford": "3496",
    "Merlin": "3497",
    "Merrickville": "3498",
    "Metcalfe": "3383",
    "Midhurst": "3499",
    "Midland": "3500",
    "Mildmay": "3502",
    "Milford": "3385",
    "Millbank": "3268",
    "Millbrook": "3504",
    "Miller Lake": "9103",
    "Millgrove": "3264",
    "Milton": "3506",
    "Milverton": "3508",
    "Mimico": "3509",
    "Mindemoya": "3596",
    "Minden": "3507",
    "Minesing": "3396",
    "Missanabie": "3511",
    "Mississauga": "3510",
    "Mitchell, ON": "3512",
    "Moffat": "3397",
    "Monkton": "3503",
    "Monteith": "3996",
    "Moonbeam": "3505",
    "Moorefield": "3513",
    "Moose Factory": "3501",
    "Moosonee": "3515",
    "Morrisburg": "3514",
    "Morriston": "3597",
    "Mount Albert": "3518",
    "Mount Brydges": "3517",
    "Mount Elgin": "3949",
    "Mount Forest": "3516",
    "Mount Hope": "3330",
    "Mount Pleasant": "3519",
    "Mountain": "3520",
    "Muirkirk": "3521",
    "Murillo": "3950",
    "Nairn": "3522",
    "Nakina": "3524",
    "Nannon": "3525",
    "Nanticoke": "3526",
    "Napanee": "3530",
    "Navan": "3528",
    "Nepean": "3531",
    "Nestor Falls": "3529",
    "Neustadt": "3532",
    "New Dundee": "3533",
    "New Hamburg": "3534",
    "New Liskeard": "3536",
    "New Lowell": "3537",
    "Newboro": "3538",
    "Newburgh": "3540",
    "Newbury": "3542",
    "Newcastle, ON": "3544",
    "Newmarket": "3546",
    "Newtonville": "3547",
    "Niagara Falls": "3548",
    "Niagara-on-the-Lake": "3550",
    "Nipigon": "3543",
    "Nobel": "3598",
    "Nobleton": "3549",
    "North Augusta": "3551",
    "North Bay": "3552",
    "North Gower": "3545",
    "North York": "3827",
    "Norval": "3553",
    "Norwich": "3554",
    "Norwick": "3556",
    "Norwood": "3557",
    "Nottawa": "3527",
    "Novar": "3562",
    "Oakland": "3370",
    "Oakville": "3580",
    "Oil Springs": "3582",
    "Oldcastle": "3579",
    "Oliphant": "3581",
    "Omemee": "3584",
    "Ompah": "3583",
    "Orangeville": "3586",
    "Orillia": "3588",
    "Orleans": "3585",
    "Orono": "3258",
    "Orton": "3587",
    "Osgoode": "3589",
    "Oshawa": "3590",
    "Ospringe": "3592",
    "Other": "4999",
    "Ottawa": "3600",
    "Otterville, ON": "3606",
    "Owen Sound": "3610",
    "Oxford County": "3609",
    "Oxford Mills": "3608",
    "Oxford, ON": "3607",
    "Oxley": "3611",
    "Paisley": "3620",
    "Palgrave": "3621",
    "Palmerston": "3622",
    "Paris": "3624",
    "Parkdale, ON": "3625",
    "Parkhill": "3626",
    "Parry Sound": "3628",
    "Pass Lake": "3563",
    "Pefferlaw": "3629",
    "Pelham": "3630",
    "Pembroke": "3632",
    "Penetang": "3633",
    "Penetanguishene": "3634",
    "Perkinsfield": "3635",
    "Perrault Falls": "3463",
    "Perth Road": "3564",
    "Perth, ON": "3636",
    "Petawawa": "3638",
    "Peterborough": "3640",
    "Petersburg": "3641",
    "Petrolia": "3642",
    "Phelpston": "3398",
    "Pickering": "3644",
    "Picton, ON": "3646",
    "Pigeon Lake": "3947",
    "Plantagenet": "3648",
    "Plattsville": "3649",
    "Plevna": "3647",
    "Point Edward": "3650",
    "Pointe au Baril": "3643",
    "Pontypool": "3645",
    "Porcupine": "3651",
    "Port Burwell": "3652",
    "Port Cambton": "3655",
    "Port Carling": "3653",
    "Port Colborne": "3654",
    "Port Credit": "3656",
    "Port Dover": "3658",
    "Port Elgin, ON": "3660",
    "Port Franks": "3399",
    "Port Hope": "3662",
    "Port Lambton": "3663",
    "Port McNicoll": "3664",
    "Port Perry": "3666",
    "Port Rowan": "3668",
    "Port Severn": "3669",
    "Port Stanley": "3667",
    "Port Sydney": "3665",
    "Pottageville": "3421",
    "Powassan": "3670",
    "Prescott": "3672",
    "Princeton, ON": "3674",
    "Proton Station": "3675",
    "Puslinch": "3676",
    "Queenston": "3599",
    "Queensville": "3681",
    "Quibell": "3680",
    "Rainy River": "3690",
    "Ravenna": "3565",
    "Ravenswood": "3688",
    "Red Lake": "3689",
    "Red Rock": "3691",
    "Renfrew": "3692",
    "Rexdale": "3693",
    "Richards Landing": "3225",
    "Richmond Hill, ON": "3696",
    "Richmond, ON": "3694",
    "Ridgetown": "3698",
    "Ridgeville": "3699",
    "Ridgeway": "3701",
    "Ripley": "3700",
    "River Drive Park": "3423",
    "Rockcliffe Park": "3602",
    "Rockland": "3704",
    "Rockwood": "3703",
    "Rodney": "3706",
    "Roseneath": "3707",
    "Rossport": "3709",
    "Rousseau": "3708",
    "Russell, ON": "3710",
    "Ruthven": "3711",
    "Salford": "3713",
    "Saltfort": "3771",
    "Sarnia": "3714",
    "Sarsfield": "3566",
    "Sault Ste Marie": "3716",
    "Scarborough": "3829",
    "Schomberg": "3712",
    "Schreiber": "3715",
    "Schumacher": "3717",
    "Scotland": "3718",
    "Seaforth": "3720",
    "Seagrave": "3601",
    "Sebringville": "3773",
    "Seeleys Bay": "3719",
    "Selby": "3775",
    "Severn Bridge": "3721",
    "Shakespeare": "3737",
    "Shallow Lake": "3722",
    "Shanty Bay": "3776",
    "Sharon": "3723",
    "Sheguiandah": "3425",
    "Shelburne, ON": "3724",
    "Sherkston": "3725",
    "Simcoe": "3726",
    "Singhampton": "3473",
    "Sioux Lookout": "3728",
    "Sioux Narrows": "3727",
    "Sleeman": "3729",
    "Smiths Falls": "3730",
    "Smithville": "3731",
    "Smooth Rock Falls": "3732",
    "Sombra": "3756",
    "South Porcupine": "3733",
    "South Portage": "3735",
    "South River, ON": "3734",
    "South Wold": "3948",
    "South Woodslee": "3428",
    "Southampton": "3736",
    "Spencerville": "3777",
    "Spring Bay": "3778",
    "Springfield, ON": "3738",
    "St Catharines": "3740",
    "St Clair Beach": "3742",
    "St Davids": "3567",
    "St George": "3260",
    "St Mary's": "3746",
    "St Thomas": "3748",
    "St. Agatha": "3745",
    "St. Andrews West": "3429",
    "St. Ann's": "3739",
    "St. Bernardin": "3741",
    "St. Charles, ON": "3743",
    "St. Isidore": "3744",
    "St. Paul, ON": "3747",
    "St. Williams": "3749",
    "Staffa": "3751",
    "Stayner": "3750",
    "Stevensville": "3753",
    "Stirling, ON": "3752",
    "Stittsville": "3754",
    "Stoney Creek": "3332",
    "Stoney Point": "3755",
    "Stouffville": "3922",
    "Stratffordville": "3759",
    "Stratford, ON": "3758",
    "Strathroy": "3760",
    "Stratton": "3757",
    "Streetford": "3761",
    "Streetsville": "3762",
    "Stroud": "3763",
    "Strudberry": "3765",
    "Sturgeon Falls": "3764",
    "Sturgeon Lake": "3767",
    "Sturgeon Point": "3766",
    "Sudbury": "3768",
    "Sunderland": "3769",
    "Sundridge": "3770",
    "Sutton West": "3774",
    "Sutton, ON": "3772",
    "Tara": "3780",
    "Tavistock": "3782",
    "Tecumseh": "3784",
    "Teeswater": "3786",
    "Terra Cotta": "3785",
    "Terrace Bay": "3787",
    "Teviotdale": "3789",
    "Thamesford, ON": "3227",
    "Thamesville": "3788",
    "Thedford, ON": "3790",
    "Thessalon": "3792",
    "Thornbury": "3794",
    "Thorndale": "3795",
    "Thornhill": "3793",
    "Thornloe": "3796",
    "Thornton": "3791",
    "Thorold": "3798",
    "Thunder Bay": "3800",
    "Tilbury": "3802",
    "Tillsonburg": "3804",
    "Timmins": "3806",
    "Tiverton": "3808",
    "Tobermory": "3810",
    "Toledo": "3811",
    "Toronto": "3812",
    "Tottenham": "3842",
    "Trenton, ON": "3844",
    "Trout Creek": "3846",
    "Turkey Point": "3847",
    "Tweed": "3848",
    "Unionville": "3856",
    "Utopia": "3858",
    "Uxbridge": "3860",
    "Val Caron": "3866",
    "Vanessa": "3868",
    "Vanier, ON": "3870",
    "Vankleek Hill": "3872",
    "Vars": "3247",
    "Vaughan": "3874",
    "Vermillion Bay": "3875",
    "Victoria Harbour": "3876",
    "Vienna": "3878",
    "Vineland": "3880",
    "Virgil": "3882",
    "Virginiatown": "3884",
    "Vittoria": "3885",
    "Wahnapitae": "3435",
    "Wainfleet": "3886",
    "Waldhof": "3888",
    "Walkerton": "3890",
    "Wallaceburg": "3892",
    "Wallenstein": "3887",
    "Walsingham": "3889",
    "Walton, ON": "3891",
    "Wardsville": "3894",
    "Warkworth": "3603",
    "Warminster": "3895",
    "Warren, ON": "3893",
    "Warsaw": "3474",
    "Wasaga Beach": "3896",
    "Washago": "3897",
    "Waterdown": "3899",
    "Waterford": "3898",
    "Waterloo, ON": "3900",
    "Watertown": "3901",
    "Watford": "3902",
    "Waubaushene": "3437",
    "Wawa": "3904",
    "Webbwood": "3906",
    "Welland": "3908",
    "Wellandport": "3907",
    "Wellesley": "3910",
    "Wellington, ON": "3912",
    "Wendover": "3475",
    "West Lorne": "3914",
    "Westhill": "3913",
    "Westmeath": "3523",
    "Weston": "3915",
    "Westport": "3916",
    "Westwood": "3917",
    "Wheatley": "3918",
    "Whitby": "3920",
    "White Lake": "3909",
    "Whitefish": "3923",
    "Whitevale": "3262",
    "Wiarton": "3911",
    "Williamsford": "3919",
    "Williamstown": "3921",
    "Willow Beach": "3604",
    "Willowdale": "3925",
    "Wilno": "3443",
    "Wilsonville": "3927",
    "Winchester": "3926",
    "Windsor, ON": "3928",
    "Wingham": "3930",
    "Winona": "3931",
    "Woodbridge": "3933",
    "Woodham": "3903",
    "Woodlawn": "3445",
    "Woodstock, ON": "3932",
    "Woodville": "3934",
    "Worwood": "3558",
    "Wroxeter": "3929",
    "Wyebridge": "3937",
    "Wyevale": "3455",
    "Wyoming": "3936",
    "Yarker": "3938",
    "York": "3838",
    "York Mills": "3839",
    "Zephyr": "3939",
    "Zurich": "3940"
    },
    "PE":{
    "Albany, PE": "0301",
    "Alberton": "0302",
    "Belfast": "0303",
    "Birch Hill": "0313",
    "Bloomfield, PE": "0319",
    "Bonshaw": "0315",
    "Borden, PE": "0304",
    "Breadalbane": "0305",
    "Bunbury": "0306",
    "Cardigan": "0308",
    "Central Bedeque": "0310",
    "Charlottetown": "0312",
    "Cornwall, PE": "0320",
    "Crapaud": "0322",
    "French River": "0326",
    "Garfield": "0323",
    "Georgetown, PE": "0324",
    "Hampton": "0318",
    "Hunter River, PE": "0307",
    "Kensington": "0330",
    "Kinkora": "0336",
    "Miminigash": "0338",
    "Miscouche": "0340",
    "Montague": "0342",
    "Morell": "0344",
    "Mount Stewart": "0346",
    "Murray Harbour": "0348",
    "Murray River": "0350",
    "New Glasgow, PE": "0309",
    "North Rustico": "0354",
    "O'Leary": "0358",
    "Other": "0399",
    "Parkdale, PE": "0314",
    "Richmond, PE": "0355",
    "Rosebank": "0317",
    "Sherwood, PE": "0316",
    "Slemon Park": "0328",
    "Souris, PE": "0360",
    "South Port": "0361",
    "St Eleanor's": "0362",
    "St Louis, PE": "0364",
    "St. Peters Bay": "0368",
    "Stratford": "0311",
    "Summerside": "0374",
    "Tignish": "0376",
    "Tyne Valley": "0378",
    "Victoria, PE": "0382",
    "Wellington, PE": "0386",
    "Wilmot, PE": "0388",
    "Winsloe": "0390"
    },
    "QC":{
    "Abercorn": "1006",
    "Abitibi": "1027",
    "Actonvale": "1008",
    "Adamsville": "1010",
    "Adstock": "1021",
    "Ahuntsic": "1604",
    "Albanel": "1012",
    "Alma, QC": "1014",
    "A-Ma-Baie": "1602",
    "Amos": "1016",
    "Amqui": "1018",
    "Andreville": "1022",
    "Angers": "1028",
    "Anjou": "1029",
    "Annaville": "1030",
    "Armagh": "1032",
    "Arthabaska": "1034",
    "Arvida": "1036",
    "Asbestos": "1038",
    "Ascot Corner": "1039",
    "Aston Jonction": "1040",
    "Athelston": "1041",
    "Ayer's Cliff": "1042",
    "Aylmer, QC": "1044",
    "Bagotville": "1050",
    "Baie de Shawiniga": "1056",
    "Baie-Comeau": "1052",
    "Baie-des-Sables": "1054",
    "Baie-du-Febvre": "1057",
    "Baie-du-Poste": "1053",
    "Baie-d'Urfé": "1606",
    "Baie-Saint-Paul": "1058",
    "Baie-Trinite": "1060",
    "Baieville": "1062",
    "Barkmere": "1064",
    "Barraute": "1066",
    "Barville": "1068",
    "Beaconsfield, QC": "1608",
    "Beattyville": "1070",
    "Beauce": "1189",
    "Beauceville": "1072",
    "Beauharnois": "1074",
    "Beaulac": "1076",
    "Beaulieu": "1078",
    "Beauport": "2032",
    "Beaupre": "1082",
    "Beaurepaire": "1610",
    "Becancour": "1084",
    "Bedford, QC": "1086",
    "Beebe Plain": "1088",
    "Belair": "1090",
    "Bellefeuille": "1091",
    "Belleterre": "1092",
    "Beloeil": "1094",
    "Bernieres": "1095",
    "Bernierville": "1096",
    "Berthierville": "1098",
    "Bishopton": "1102",
    "Black Lake": "1104",
    "Blainville": "1106",
    "Boileau": "1597",
    "Boisbriand": "1107",
    "Boisbuard": "1105",
    "Boischatel": "1109",
    "Bois-des-Filion": "1108",
    "Bolton-Ouest": "1153",
    "Bonaventure": "1111",
    "Boucherville": "1110",
    "Brebeuf": "1043",
    "Brigham": "1119",
    "Brome": "1112",
    "Bromont": "1114",
    "Bromptonville": "1116",
    "Brossard": "1612",
    "Brownsburg": "1120",
    "Bryson": "1122",
    "Buckingham": "1124",
    "Cabano": "1130",
    "Cadillac, QC": "1132",
    "Calixa-Lavallee": "1045",
    "Calumet": "1134",
    "Campbell's Bay": "1136",
    "Candiac": "1616",
    "Cantley": "1138",
    "Cap-a-l'Aigle": "1140",
    "Cap-aux-Meules": "1142",
    "Cap-Chat": "1144",
    "Cap-de-la-Madeleine": "1146",
    "Caplan": "1046",
    "Cap-Rouge": "1147",
    "Cap-Santé": "1587",
    "Carignan": "1148",
    "Carillon": "1150",
    "Carleton": "1151",
    "Cartierville": "1618",
    "Causapscal": "1152",
    "Chambly": "1154",
    "Chambord": "1156",
    "Champlain": "1158",
    "Chandler": "1160",
    "Chapais": "1162",
    "Chapeau": "1164",
    "Charlemagne": "1118",
    "Charlesbourg, QC": "2034",
    "Charny": "1170",
    "Chateauguay": "1174",
    "Chateauguay Centre": "1176",
    "Chateau-Richer": "1172",
    "Chelsea": "1177",
    "Cheneville": "1178",
    "Chertsey, QC": "1007",
    "Chesterville, QC": "1180",
    "Chibougamau": "1182",
    "Chicoutimi": "1184",
    "Chicoutimi Nord": "1186",
    "Chisasibi": "1187",
    "Chomedy": "1622",
    "Chute-aux-Outardes": "1188",
    "Clarenceville": "1190",
    "Clermont": "1192",
    "Clova": "1193",
    "Coaticook": "1194",
    "Compton": "1196",
    "Contrecoeur": "1198",
    "Cookshire": "1200",
    "Coteau-du-Lac": "1202",
    "Coteau-Landing": "1204",
    "Cote-des-Neiges": "1025",
    "Côte-Sainte-Catherine": "1630",
    "Côte-Saint-Luc": "1628",
    "Courcelles": "1205",
    "Courville": "1206",
    "Cowansville": "1208",
    "Crabtree": "1210",
    "Dalesville": "1218",
    "Danville": "1220",
    "Daveluyville": "1222",
    "De Grasse": "1224",
    "Deauville": "1226",
    "Degelis": "1228",
    "Delson": "1634",
    "Desbiens": "1232",
    "Deschaillons": "1234",
    "Deschaillons-sur-Saint-Laurent": "1236",
    "Deschambault": "1238",
    "Deschenes": "1240",
    "Deux-Montagnes": "1242",
    "Disraeli": "1244",
    "Dixville": "1246",
    "Dolbeau": "1248",
    "Dollard-des-Ormeaux": "1636",
    "Donnaconna": "1252",
    "Dorion": "1254",
    "Dorval": "1638",
    "Dosquet": "1256",
    "Douville": "1258",
    "Drummondville": "1260",
    "Duberger": "1261",
    "Duclos": "1125",
    "Dunham": "1262",
    "Duparquet": "1264",
    "Durham South, QC": "1266",
    "Duvernay": "1640",
    "East Angus": "1270",
    "East Broughton St": "1272",
    "East Farnham": "1274",
    "East Hereford": "1275",
    "Eastman": "1276",
    "Esterel": "1278",
    "Evain": "1280",
    "Fabre": "1286",
    "Fabreville": "1288",
    "Farnham": "1290",
    "Ferme-Neuve": "1292",
    "Fermont": "1291",
    "Filford": "1293",
    "Fleurmont": "1295",
    "Forestville": "1294",
    "Fort-Coulonge": "1296",
    "Fortierville": "1298",
    "Fossambault-sur-le-Lac": "1300",
    "Foster": "1301",
    "Francoeur": "1302",
    "Franklin": "1303",
    "Frelighsburg": "1304",
    "Gagnon": "1310",
    "Gaspe": "1312",
    "Gatineau": "1314",
    "Gentilly": "1315",
    "Giffard": "1316",
    "Girardville": "1047",
    "Glenn Sutton": "1317",
    "Godbout": "1318",
    "Godmanchester": "1126",
    "Gracefield": "1320",
    "Granby": "1322",
    "Grande-Ile": "1323",
    "Grandes-Bergeronnes": "1326",
    "Grande-Vallée": "1325",
    "Grand-Mère": "1324",
    "Greece's Point": "1328",
    "Greenfield Park": "1646",
    "Grenville": "1330",
    "Ham Nord": "1336",
    "Hampstead": "1648",
    "Hatley": "1340",
    "Hauterive": "1342",
    "Hebertville Stati": "1344",
    "Hemmingford": "1346",
    "Henryville": "1348",
    "Howick": "1350",
    "Hudson": "1352",
    "Hudson Heights": "1353",
    "Hull": "1354",
    "Huntingdon, QC": "1356",
    "Iberville": "1360",
    "Île Charron": "1650",
    "Île Claude": "1652",
    "Île Dorval": "1658",
    "Île Laval": "1660",
    "Île-aux-Coudres": "1361",
    "Île-Bizard": "1364",
    "Île-Cadieux": "1362",
    "Île-de-la-Visitation": "1654",
    "Île-des-Soeurs": "1656",
    "Île-d'Orlea": "1363",
    "Île-Michon": "1365",
    "Île-Perrot": "1366",
    "Îles-de-la-Madeleine": "1367",
    "Îles-d'Entree": "1368",
    "Inverness, QC": "1370",
    "Jacques-Cartier": "1626",
    "Joliette": "1380",
    "Jonquière": "1382",
    "Joutel": "1384",
    "Kahnawake": "1620",
    "Kamouraska": "1386",
    "Kenogami": "1388",
    "Kingsbury": "1390",
    "Kingsey Falls": "1392",
    "Kinnear": "1387",
    "Kirkland": "1664",
    "Knowlton": "1393",
    "La Baie": "2497",
    "La Guadeloupe": "1408",
    "La Macaza": "1585",
    "La Malbaie": "1410",
    "La Patrie": "1412",
    "La Peche": "1049",
    "La Perade": "1414",
    "La Plaine": "1415",
    "La Pocatière": "1416",
    "La Prairie": "1670",
    "La Présentation": "1418",
    "La Providence": "1420",
    "La Reine": "1422",
    "La Sarre": "1424",
    "La Station du Cot": "1426",
    "La Tuque": "1428",
    "La Visitation": "1429",
    "Labelle": "1430",
    "L'Acadie": "1394",
    "Lac-à-la-Croix": "1432",
    "Lac-au-Saumon": "1434",
    "Lac-Beauport": "1435",
    "Lac-Bouchette": "1436",
    "Lac-Brome": "1438",
    "Lac-Carre": "1440",
    "Lac-Delage": "1442",
    "Lac-des-Écorces": "1444",
    "Lac-Etchemin": "1446",
    "Lachenaie": "1456",
    "Lachine": "1672",
    "Lachute": "1458",
    "Lac-Masson": "1447",
    "Lac-Megantic": "1448",
    "Lacolle": "1460",
    "Lac-Poulin": "1450",
    "Lac-Saint-Charles": "1451",
    "Lac-Sainte-Marie": "1051",
    "Lac-Saint-Jean": "1453",
    "Lac-Saint-Joseph": "1454",
    "Lac-Saint-Paul": "1455",
    "Lac-Sergent": "1452",
    "Lac-Supérieur": "1457",
    "Laflèche, QC": "1674",
    "Lafontaine": "1464",
    "Lambton": "1466",
    "L'Ancienne-Lorette": "1020",
    "L'Ange-Gardien": "1024",
    "Langeliers": "1026",
    "L'Annonciation": "1396",
    "L'Anse-Saint-Jean": "1048",
    "LaSalle": "1676",
    "Lasavanne": "1468",
    "L'Assomption": "1398",
    "Laterrière": "1470",
    "Laurentides": "1472",
    "Laurier Station": "1474",
    "Laurierville": "1476",
    "Lauzon": "1478",
    "Laval": "1678",
    "Laval-des-Rapides": "1480",
    "Lavaltrie": "1482",
    "L'Avenir": "1400",
    "Lawrenceville": "1484",
    "Le Bic": "1100",
    "Le Gardeur": "1489",
    "Lebel-sur-Quévillon": "1486",
    "Leclercville": "1488",
    "Lemieux": "1490",
    "Lemoyne": "1680",
    "Lennoxville": "1492",
    "L'Épiphanie": "1402",
    "Lery": "1494",
    "Les Becquets": "1496",
    "Les Cèdres": "1498",
    "Lévis": "1500",
    "Limoilou": "1501",
    "Liniere": "1502",
    "L'Isle Verte": "1406",
    "L'Islet": "1404",
    "Longue-Pointe": "1682",
    "Longueuil": "1684",
    "Loretteville": "2036",
    "Lorraine": "1506",
    "Lorrainville": "1508",
    "Lotbinière": "1510",
    "Louiseville": "1512",
    "Luceville": "1514",
    "Luskville": "1516",
    "Lyster": "1518",
    "Macamic": "1530",
    "Magog": "1532",
    "Malartic": "1534",
    "Malbaie": "1535",
    "Maniwaki": "1536",
    "Manseau": "1538",
    "Mansonville": "1539",
    "Maple Grove": "1540",
    "Marbleton": "1542",
    "Maria": "1055",
    "Marieville": "1544",
    "Marsoui": "1546",
    "Mascouche": "1548",
    "Maskinonge": "1550",
    "Masson": "1552",
    "Massueville": "1554",
    "Matagami": "1556",
    "Matane": "1558",
    "McMasterville": "1560",
    "Melbourne": "1562",
    "Melocheville": "1564",
    "Mercier": "1566",
    "Metabetchouan": "1567",
    "Métis-sur-Mer": "1568",
    "Mirabel": "1573",
    "Mistassini": "1570",
    "Moffet": "1569",
    "Mont Laurier": "1576",
    "Mont Saint-Pierre": "1580",
    "Mont-Apica": "1571",
    "Montauban": "1582",
    "Mont-Carmel": "1575",
    "Montcerf": "1583",
    "Montebello": "1584",
    "Mont-Gabriel": "1572",
    "Mont-Joli": "1574",
    "Montmagny": "1586",
    "Montmorency": "1588",
    "Montreal": "1694",
    "Montreal Centre-Nord": "1692",
    "Montreal Est": "1696",
    "Montreal Nord": "1698",
    "Montreal Nord-Est": "1700",
    "Montreal Nord-Ouest": "1702",
    "Montreal Ouest": "1708",
    "Montreal Sud-Est": "1710",
    "Mont-Rolland": "1577",
    "Mont-Royal": "1716",
    "Mont-Saint-Gregoire": "1579",
    "Mont-Saint-Hilaire": "1578",
    "Mont-Tremblant": "1581",
    "Morin-Heights": "1590",
    "Murdochville": "1908",
    "Napierville": "1928",
    "Neufchâtel": "1929",
    "Neuville": "1930",
    "New Carlisle": "2772",
    "New Glasgow, QC": "1932",
    "New Richmond": "1934",
    "Nicolet": "1936",
    "Nitro": "1937",
    "Nominingue": "1938",
    "Noranda": "1940",
    "Norbertville": "1942",
    "Normandin": "1944",
    "North Hatley": "1946",
    "Notre-Dame-de-Bon-Secours": "1718",
    "Notre-Dame-de-Grace": "1720",
    "Notre-Dame-de-Île-Perrot": "1719",
    "Notre-Dame-de-Pierreville": "1919",
    "Notre-Dame-des-Anges": "1922",
    "Notre-Dame-des-Laurentides": "2038",
    "Notre-Dame-des-Pins": "1721",
    "Notre-Dame-des-Prairies": "1923",
    "Notre-Dame-d'Hebertville": "1920",
    "Notre-Dame-du-Bon-Conseil": "1924",
    "Notre-Dame-du-Lac": "1926",
    "Notre-Dame-du-Sacré-Coeur": "1722",
    "Noyan": "1947",
    "Oka": "1948",
    "Omerville": "1952",
    "Orford": "1953",
    "Ormstown": "1954",
    "Orsainville": "2040",
    "Other": "2999",
    "Otterburn Park": "1958",
    "Outremont": "1730",
    "Packington": "1059",
    "Pagenteuil": "1736",
    "Papineauville": "1970",
    "Parent": "1972",
    "Pascalis": "1974",
    "Paspebiac": "1975",
    "Pentecote": "1737",
    "Percé": "1976",
    "Perkins": "1738",
    "Petite-Riviere-Saint-Francois": "1127",
    "Petit-Saguenay": "1598",
    "Philipsburg": "1978",
    "Piedmont": "1979",
    "Pierrefonds Est": "1740",
    "Pierrefonds Ouest": "1742",
    "Pierreville": "1980",
    "Pincourt": "1982",
    "Pintendre": "1743",
    "Plessisville": "1984",
    "Pohenegamook": "1061",
    "Point-au-Père": "1985",
    "Pointe-au-Pic": "1986",
    "Pointe-aux-Outardes": "1988",
    "Pointe-aux-Trembles": "1746",
    "Pointe-Calumet": "1992",
    "Pointe-Claire": "1748",
    "Pointe-des-Cascades": "1996",
    "Pointe-du-Moulin": "1998",
    "Pointe-Fortune": "2002",
    "Pointe-Gatineau": "2004",
    "Pointe-Lebel": "2006",
    "Pont-Rouge": "2008",
    "Pont-Viau": "1750",
    "Portage-du-Fort": "2014",
    "Port-Alfred": "2010",
    "Port-Cartier": "2012",
    "Portneuf": "2016",
    "Povungnituk": "2017",
    "Preissac": "1063",
    "Preville": "1754",
    "Prevost": "2018",
    "Price": "2020",
    "Princeville": "2022",
    "Proulxville": "2024",
    "Quebec City": "2030",
    "Quyon": "2060",
    "Radisson, QC": "2068",
    "Rawdon": "2070",
    "Repentigny": "2072",
    "Richelieu": "2074",
    "Richmond, QC": "2078",
    "Rigaud": "2080",
    "Rimouski": "2082",
    "Rimouski Est": "2084",
    "Ripon": "2086",
    "Rivière-Beaudette": "2088",
    "Rivière-des-Prairies": "1760",
    "Rivière-du-Loup": "2090",
    "Rivière-du-Moulin": "2092",
    "Riviere-Malbaie": "2093",
    "Robertsonville": "2094",
    "Roberval": "2096",
    "Rock Island": "2098",
    "Rock-Forest": "2097",
    "Rosemere": "2100",
    "Rosemont": "1128",
    "Rougemont": "2102",
    "Rouyn": "2104",
    "Roxboro": "1762",
    "Roxton Falls": "2108",
    "Roxton Pond": "1763",
    "S.Bernard-Lacolle": "1065",
    "Sabrevois": "2109",
    "Sacré-Coeur-de-Jesus": "2110",
    "Saguenay": "2112",
    "Saint-Adolphe-d'Howard": "1243",
    "Saint-Anaclet-de-Lessard": "1765",
    "Saint-Andre-Avellin": "2156",
    "Saint-Andre-d'Acton": "2157",
    "Saint-Andre-du-Lac-Saint-Jean": "2158",
    "Saint-Antoine-de-Tilly": "2163",
    "Saint-Basile-le-Grand": "2166",
    "Saint-Boniface-de-Shawinigan": "2172",
    "Saint-Bruno-de-Montarville": "2176",
    "Saint-Charles-Borromee": "1009",
    "Saint-Charles-des-Grondines": "2188",
    "Saint-Charles-sur-Richelieu": "2190",
    "Saint-Coeur-de-Marie": "2196",
    "Saint-Come": "1129",
    "Saint-David-de-L'Auberiviere": "2202",
    "Sainte-Anne-de-Beaupré": "2386",
    "Sainte-Anne-de-Bellevue": "1770",
    "Sainte-Cécile-de-Levrard": "2404",
    "Sainte-Cécile-de-Masham": "2405",
    "Sainte-Cécile-de-Milton": "2399",
    "Sainte-Claire": "1771",
    "Sainte-Dorothée": "2401",
    "Sainte-Emelie-de-L'Energie": "1019",
    "Sainte-Felicité": "2402",
    "Sainte-Foy": "2042",
    "Sainte-Genevieve": "1772",
    "Sainte-Genevieve-de-Batiscan": "1773",
    "Sainte-Hélène-de-Bagot": "2408",
    "Sainte-Jeanne-d'Arc": "2410",
    "Sainte-Julie": "2411",
    "Saint-Elie-d'Orford": "1774",
    "Sainte-Marcelline-de-Kildare": "1145",
    "Sainte-Marguerite-Esterel": "1137",
    "Sainte-Marie-Beauce": "1775",
    "Sainte-Marthe-sur-le-Lac": "2419",
    "Sainte-Mélanie": "2423",
    "Saint-Ephrem-De-Tring": "2212",
    "Sainte-Scholastique": "2426",
    "Sainte-Sophie": "1776",
    "Sainte-Sophie-de-Levrard": "2428",
    "Saint-Esprit": "1069",
    "Sainte-Thérèse Ouest": "2432",
    "Saint-Etienne-de-Lauzon": "1777",
    "Saint-Felix-de-Valois": "2218",
    "Saint-Ferreol-les-Neiges": "1011",
    "Saint-Gedeon": "2114",
    "Saint-Georges-de-Beauce": "2231",
    "Saint-Georges-de-Cacouna": "2232",
    "Saint-Georges-de-Windsor": "2234",
    "Saint-Georges-Ouest": "2236",
    "Saint-Germain-de-Grantham": "2240",
    "Saint-Gregoire": "2242",
    "Saint-Gregoire-de-Greenlay": "2244",
    "Saint-Herménégilde": "2250",
    "Saint-Hilarion": "1135",
    "Saint-Honoré": "2252",
    "Saint-Jean": "2264",
    "Saint-Jean-Baptiste-de-Nicolet": "2266",
    "Saint-Jean-Chrysostome": "2268",
    "Saint-Jean-de-Boischatel": "2270",
    "Saint-Jean-de-Dieu": "2771",
    "Saint-Jean-de-Matha": "2271",
    "Saint-Jean-Port-Joli": "1778",
    "Saint-Jean-sur-le-Richelieu": "2269",
    "Saint-Jean-Vianney": "2272",
    "Saint-Jerome": "2274",
    "Saint-Joseph, QC": "2278",
    "Saint-Joseph-de-Beauce": "2280",
    "Saint-Joseph-de-la-Rive": "2282",
    "Saint-Joseph-de-Levis": "2281",
    "Saint-Joseph-de-Sorel": "2284",
    "Saint-Joseph-du-Lac": "2283",
    "Saint-Lambert": "1766",
    "Saint-Lazare": "2115",
    "Saint-Léon": "2290",
    "Saint-Léonard, QC": "2292",
    "Saint-Léonard-d'Aston": "2294",
    "Saint-Lin": "1767",
    "Saint-Louis-du-Ha!-Ha!": "1081",
    "Saint-Luc-de-Vincennes": "2300",
    "Saint-Ludger": "2302",
    "Saint-Marc sur Richelieu": "1779",
    "Saint-Marc-des-Carrières": "2304",
    "Saint-Mathias": "2303",
    "Saint-Mathieu": "2119",
    "Saint-Mathieu-de-Beloeil": "2305",
    "Saint-Mathieu-du-Parc": "2301",
    "Saint-Michel-des-Saints": "1591",
    "Saint-Patrice-de-Beaurivage": "2318",
    "Saint-Paul": "1139",
    "Saint-Phillipe": "2117",
    "Saint-Pie-de-Bagot": "2323",
    "Saint-Pierre-les-Becquets": "1593",
    "Saint-Rock-sur-Richelieu": "2335",
    "Saint-Romuald, QC": "1015",
    "Saint-Romuald-d'Etchemin": "2340",
    "Saint-Sauveur-des-Monts": "2342",
    "Saint-Sebastien": "2344",
    "Saint-Sulpice": "2349",
    "Saint-Sylvère": "2350",
    "Saint-Théodore-d'Acton": "2353",
    "Saint-Thomas": "1141",
    "Saint-Timothée": "2358",
    "Saint-Urbain": "2365",
    "Saint-Valérien": "1594",
    "Saint-Vincent-de-Paul": "1768",
    "Saint-Zénon": "1595",
    "Salaberry-de-Valleyfield": "2484",
    "Saules": "2111",
    "Sault-au-Mouton": "2116",
    "Sawyerville": "2118",
    "Sayabec": "2120",
    "Schefferville": "2122",
    "Scotstown": "2124",
    "Senneterre": "2126",
    "Senneville": "1764",
    "Sept Iles": "2130",
    "Shawbridge": "2132",
    "Shawinigan": "2134",
    "Shawinigan Sud": "2136",
    "Shawinigan-Nord": "2135",
    "Shawville": "2138",
    "Shefford": "1131",
    "Sherbrooke, QC": "2140",
    "Sherrington": "2141",
    "Sillery": "2142",
    "Snowdon": "1133",
    "Sorel": "2144",
    "St-Adolphe-d'How": "2145",
    "St-Adrien de Ham": "2147",
    "St-Agapitville": "2146",
    "St-Alban": "2148",
    "St-Albert": "2149",
    "St-Alexandre": "2150",
    "St-Alexis": "2152",
    "St-Amable": "2153",
    "St-Ambroise": "2154",
    "Stanbridge East": "2375",
    "Stanbridge Stat": "2377",
    "St-Andre Est": "2160",
    "Stanhope": "2433",
    "St-Anicet": "2161",
    "St-Anselme": "2162",
    "Stanstead Plain": "2376",
    "St-Antoine": "2164",
    "St-Augustin": "2165",
    "St-Augustin-de-De": "2169",
    "St-Barthelemy": "2167",
    "St-Basile Sud": "2168",
    "St-Bernard": "2170",
    "St-Blaise": "2171",
    "St-Boniface": "2173",
    "St-Bruno": "2174",
    "St-Calixte": "2178",
    "St-Casimir": "2180",
    "St-Casimir Est": "2182",
    "St-Cesaire": "2184",
    "St-Charles": "2186",
    "St-Chrysostome": "2192",
    "St-Cleophas": "2193",
    "St-Clet": "2194",
    "St-Colomban": "2195",
    "St-Constant": "2113",
    "St-Cyprien": "2197",
    "St-Cyrille": "2198",
    "St-Damase": "2200",
    "St-Damien-de-Bra": "2201",
    "St-Denis": "2204",
    "St-Denis-de-Brom.": "1067",
    "St-Dominique": "2206",
    "St-Donat": "2203",
    "Ste-Adele": "2379",
    "Ste-Agathe": "2378",
    "Ste-Agathe Monts": "2380",
    "Ste-Agathe Sud": "2382",
    "Ste-Angele Merici": "2384",
    "Ste-Angele-de-Lav": "2383",
    "Ste-Anne du Lac": "2392",
    "Ste-Anne Monts": "2390",
    "Ste-Anne Plaines": "2397",
    "Ste-Anne-de-la-Pe": "2387",
    "Ste-Anne-de-la-Ro": "2388",
    "Ste-Anne-des-Lacs": "1143",
    "Ste-Anne-de-Sorel": "2389",
    "Ste-Brigit.-Laval": "1080",
    "Ste-Brigitte": "2403",
    "Ste-Christine": "2406",
    "Ste-Clothide Hort": "2398",
    "Ste-Croix": "2400",
    "St-Edmond": "2205",
    "St-Edouard": "2207",
    "Ste-Elizabeth": "2407",
    "Ste-Francoise Lac": "2222",
    "Ste-Gertrude": "2409",
    "Ste-Henedine": "2413",
    "Ste-Julienne": "2414",
    "St-Elzear": "2208",
    "Ste-Madeleine": "2412",
    "Ste-Mar.Lac-Mass.": "1083",
    "Ste-Marguerite": "2415",
    "Ste-Marguerite-de": "2421",
    "Ste-Marie": "2416",
    "Ste-Marthe": "2418",
    "Ste-Martine": "2417",
    "St-Emile": "2210",
    "Ste-Monique": "2420",
    "Ste-Prudentienne": "2422",
    "Ste-Rosalie": "2424",
    "Ste-Rose": "2425",
    "Ste-Rose-Watford": "1085",
    "Ste-Sabine": "2427",
    "Ste-Sophie-de-Meg": "2429",
    "Ste-Therese": "2430",
    "St-Eugene": "2213",
    "St-Eustache": "2214",
    "Ste-Veronique": "2431",
    "St-Felicien": "2216",
    "St-Ferdinand": "2219",
    "St-Flavien": "2220",
    "St-Fulgence": "2224",
    "St-Gabriel": "2226",
    "St-Gabriel-Brand.": "1071",
    "St-Georges": "2230",
    "St-Gerard": "2238",
    "St-Gregoire-de-Ni": "2245",
    "St-Guillaume": "2246",
    "St-Henri": "2248",
    "St-Hippolyte": "2259",
    "St-Hubert": "2254",
    "St-Hughes": "2256",
    "St-Hyacinthe": "2258",
    "St-Isidore": "2260",
    "St-Jacques": "2262",
    "St-Jacques de Mon": "2261",
    "St-Janvier": "2263",
    "St-Jean-Baptiste": "1600",
    "St-Jovite": "2286",
    "St-Julien": "2288",
    "St-Liboire": "2296",
    "St-Louis Terrebon": "2297",
    "St-Louis-de-Franc": "1013",
    "St-Luc": "2298",
    "St-Mathias-Riche.": "1073",
    "St-Michel": "2307",
    "St-Nicephore": "2309",
    "St-Nicholas": "2306",
    "St-Noel": "2308",
    "St-Norbert": "2311",
    "Stoke": "1592",
    "Stoneham": "2435",
    "St-Ours": "2310",
    "St-Pacome": "2312",
    "St-Pamphile": "2314",
    "St-Pascal": "2316",
    "St-Paulin": "2320",
    "St-Pie": "2322",
    "St-Pierre": "2324",
    "St-Pierre-Baptist": "1596",
    "St-Placide": "2326",
    "St-Polycarpe": "2328",
    "St-Prime": "2330",
    "St-Raphael": "2332",
    "Stratford, QC": "2437",
    "St-Raymond": "2334",
    "St-Redempteur": "2336",
    "St-Remi": "2338",
    "St-Robert": "2339",
    "St-Roch-Aulnaies": "1077",
    "St-Roch-de-L'Achi": "1075",
    "St-Romain": "2337",
    "St-Saurcur": "2341",
    "St-Sauveur": "2343",
    "St-Severin-de-Pro": "2345",
    "St-Simeon": "2346",
    "St-Simon-de-Bagot": "1031",
    "St-Stanislaus": "2348",
    "St-Sylvestre": "2352",
    "St-Thecle": "2354",
    "St-Theophile": "2356",
    "St-Tite": "2360",
    "St-Ubald": "2362",
    "Stukely-Sud": "2434",
    "St-Ulric": "2364",
    "St-Valerien-Milt.": "1079",
    "St-Vallier": "2366",
    "St-Victor": "2368",
    "St-Wendeslas": "2370",
    "St-Zacharie": "2372",
    "St-Zephirin": "2373",
    "St-Zotique": "2374",
    "Sutton, QC": "2436",
    "Tadoussac": "2440",
    "Temiscaming": "2442",
    "Templeton": "2444",
    "Terrasse-Vaudreuil": "2445",
    "Terrebonne": "2446",
    "Thetford Mines, QC": "2448",
    "Thurso": "2450",
    "Tingwick": "1121",
    "Tracy, QC": "2452",
    "Tring-Jonction": "2454",
    "Trois-Pistoles": "2456",
    "Trois-Rivières": "2458",
    "Upton": "2460",
    "Val-Barette": "2470",
    "Val-Belair": "1781",
    "Val-Brillant": "2472",
    "Valcartier": "2479",
    "Valcourt": "2480",
    "Val-David": "2476",
    "Val-des-Bois": "1087",
    "Val-des-Monts, QC": "1017",
    "Val-d'Or": "2474",
    "Vallée-Jonction": "2482",
    "Val-Morin": "2477",
    "Valois": "1780",
    "Val-Racine": "1089",
    "Val-Saint-Michel": "2478",
    "Vanier, QC": "2044",
    "Varennes": "2488",
    "Vaudreuil": "2490",
    "Vaudreuil-Dorion": "2489",
    "Vaudreuil-sur-la-Lac": "2491",
    "Vendée": "2493",
    "Venise-en-Québec": "2494",
    "Verchères": "2492",
    "Verdun": "1782",
    "Victoriaville, QC": "2496",
    "Ville de L'Île Perrot": "1786",
    "Ville Emard": "1155",
    "Ville LeMoyne": "2499",
    "Ville Saint-Laurent": "1790",
    "Ville Saint-Pierre": "1792",
    "Ville-Marie": "2498",
    "Villeneuve": "2500",
    "Vimont": "1800",
    "Wakefield, QC": "2510",
    "Warden": "2512",
    "Warwick": "2514",
    "Waterloo, QC": "2516",
    "Waterville, QC": "2518",
    "Weedon-Centre": "2520",
    "Wentworth-Nord": "1149",
    "Westmount": "1802",
    "Wickham": "2524",
    "Windmill Point": "1804",
    "Windsor, QC": "2526",
    "Wootenville": "2528",
    "Wotton": "2532",
    "Yamachiche": "2540",
    "Yamaska": "2542",
    "Yamaska-Est": "2544"
    },
    "SK":{
    "Abbey": "5802",
    "Aberdeen": "5804",
    "Abernethy": "5806",
    "Adanac": "5808",
    "Admiral": "5810",
    "Alameda": "5812",
    "Alida": "5814",
    "Allan": "5816",
    "Alsask": "5818",
    "Alvena": "5820",
    "Aneroid": "5822",
    "Annaheim": "5803",
    "Antler": "5824",
    "Arborfield": "5826",
    "Archerwill": "5828",
    "Arcola": "5830",
    "Ardath": "5832",
    "Ardili": "5834",
    "Arelee": "5836",
    "Arran": "5838",
    "Asquith": "5840",
    "Assiniboia": "5842",
    "Atwater": "5844",
    "Avonlea": "5846",
    "Aylesbury": "5848",
    "Aylsham": "5850",
    "Balcarres": "5862",
    "Balgonie": "5864",
    "Bangor": "5866",
    "Battleford": "5868",
    "Beatty": "5870",
    "Beauval": "5805",
    "Beechy": "5872",
    "Belle Plaine": "5874",
    "Bellegarde": "5807",
    "Bengough": "5876",
    "Benson": "5878",
    "Bethume": "5880",
    "Bienfait": "5882",
    "Big Beaver": "5883",
    "Big River": "5884",
    "Biggar": "5809",
    "Bigger": "5886",
    "Birch Hills": "5888",
    "Birsay": "5890",
    "Bjorkdale": "5892",
    "Bladworth": "5894",
    "Blaine Lake": "5896",
    "Borden, SK": "5898",
    "Bounty": "5900",
    "Bracken": "5902",
    "Bradwell": "5904",
    "Bredenbury": "5811",
    "Briercrest": "5908",
    "Broadview": "5910",
    "Brock": "5912",
    "Broderick": "5914",
    "Brownlee": "5916",
    "Bruno": "5918",
    "B-Say-Tah": "5860",
    "Buchanan": "5920",
    "Buena Vista": "5922",
    "Buffalo Narrows": "5923",
    "Bulyea": "5924",
    "Burstall": "5926",
    "Bushell Park": "5927",
    "Cabri": "5930",
    "Cadillac, SK": "5932",
    "Calder": "5934",
    "Cando": "5936",
    "Canora": "5938",
    "Canwood": "5940",
    "Carievale": "5942",
    "Carlyle": "5944",
    "Carlyle Lake Reso": "5946",
    "Carmichael": "5948",
    "Carnduff": "5950",
    "Caronport": "5951",
    "Carragana": "5952",
    "Carrot River": "5954",
    "Central Butte": "5956",
    "Ceylon": "5958",
    "Chamberlain": "5960",
    "Chaplin": "5962",
    "Choiceland": "5964",
    "Christopher Lake": "5963",
    "Churchbridge": "5966",
    "Clavet": "5817",
    "Climax": "5968",
    "Coderre": "5970",
    "Codette": "5972",
    "Coleville": "5974",
    "Colgate": "5976",
    "Colonsay": "5978",
    "Conquest": "5980",
    "Consul": "5982",
    "Corning": "5813",
    "Coronach": "5984",
    "Craik": "5986",
    "Craven": "5988",
    "Creelman": "5990",
    "Creighton": "5992",
    "Cudworth": "5994",
    "Cumberland House": "5995",
    "Cupar": "5996",
    "Cut Knife": "5998",
    "Dafoe": "6002",
    "Dalmeny": "6004",
    "Davidson": "6006",
    "Debden": "6008",
    "Delisle": "6010",
    "Denare Beach": "6011",
    "Denholm": "6012",
    "Denzil": "6014",
    "Dilke": "6016",
    "Dinsmore": "6018",
    "Disley": "6020",
    "Dodsland": "6022",
    "Dollard": "6024",
    "Domremy": "6026",
    "Drake": "6028",
    "Drinkwater": "6030",
    "Dubuc": "6032",
    "Duck Lake": "6034",
    "Duff": "6036",
    "Dunblane": "6038",
    "Dundurn": "6040",
    "Duval": "6042",
    "Dysart": "6044",
    "Earl Grey": "6050",
    "Eastend": "6052",
    "Eatonia": "6054",
    "Ebebezer": "6056",
    "Edam": "6058",
    "Edenwold": "6060",
    "Elbow": "6062",
    "Elfros": "6064",
    "Elrose": "6066",
    "Elstow": "6068",
    "Emerald Park": "6736",
    "Endeavour": "6070",
    "Englefeld": "6072",
    "Ernfold": "6074",
    "Esterhazy": "6076",
    "Estevan": "6078",
    "Eston": "6080",
    "Etters Beach": "6082",
    "Evesham": "6084",
    "Eyebrow": "6086",
    "Fairlight": "6090",
    "Fenwood": "6092",
    "Ferland": "6094",
    "Fielding": "6096",
    "Fife Lake": "6098",
    "Fillmore": "6100",
    "Findlater": "6102",
    "Fiske": "6103",
    "Flaxcombe": "6104",
    "Fleming": "6106",
    "Foam Lake": "6110",
    "Forget": "6112",
    "Fort Qu'appelle": "6114",
    "Fosston": "6116",
    "Fox Valley": "6118",
    "Francis": "6120",
    "Frobisher": "6122",
    "Frontier": "6124",
    "Gainsborough": "6130",
    "Gerald": "6132",
    "Girvin": "6134",
    "Gladmar": "6136",
    "Glaslyn": "6138",
    "Glen Ewen": "6140",
    "Glenavon": "6142",
    "Glenside": "6144",
    "Glentworth": "6146",
    "Glidden": "6148",
    "Golden Prairie": "6150",
    "Goodeve": "6152",
    "Goodsoil": "6154",
    "Goodwater": "6156",
    "Govan": "6158",
    "Grandora": "5821",
    "Grandview Beach S": "6160",
    "Gravelbourg": "6162",
    "Grayson": "6164",
    "Grenfell": "6166",
    "Guernsey": "6168",
    "Gull Lake, SK": "6170",
    "Hafford": "6174",
    "Hague": "6176",
    "Halbrite": "6178",
    "Handel": "6180",
    "Hanley": "6182",
    "Hardy": "6184",
    "Harris": "6186",
    "Hawarden": "6188",
    "Hazelwood No.94": "5819",
    "Hazenmore": "6190",
    "Hazlet": "6192",
    "Hepburn": "6194",
    "Herbert": "6196",
    "Herschel": "6198",
    "Heward": "6200",
    "Hodgeville": "6202",
    "Hold Fast": "6204",
    "Horizon": "6206",
    "Hubbard": "6208",
    "Hudson Bay": "6210",
    "Humboldt": "6212",
    "Hyas": "6214",
    "Île-à-la-Crosse": "6218",
    "Imperial": "6220",
    "Indian Head": "6222",
    "Insinger": "6224",
    "Invermay": "6226",
    "Ituna": "6228",
    "Jansen": "6230",
    "Jasmin": "6232",
    "Jedburgh": "6234",
    "Kamsack": "6240",
    "Kannata Valley": "6242",
    "Katepwa Beach": "6244",
    "Keeler": "6246",
    "Kelfield": "6250",
    "Kelliher": "6252",
    "Kelvington": "6254",
    "Kenaston": "6256",
    "Kendal": "6258",
    "Kennedy": "6260",
    "Kerrobert": "6248",
    "Khedive": "6262",
    "Killaly": "6264",
    "Kincaid": "6266",
    "Kindersley": "6268",
    "Kinistino": "6270",
    "Kinley": "6272",
    "Kipabiskau": "6274",
    "Kipling": "6276",
    "Kisbey": "6278",
    "Krydor": "6280",
    "Kyle": "6282",
    "La Loche": "5825",
    "La Ronge": "6312",
    "Lafleche, SK": "6290",
    "Laird": "6292",
    "Lake Alma": "6294",
    "Lake Lenore": "6296",
    "Lampman": "6298",
    "Lancer": "6300",
    "Landis": "6302",
    "Lang": "6304",
    "Langenburg": "6306",
    "Langham": "6308",
    "Lanigan": "6310",
    "Lashburn": "6313",
    "Lawson": "6314",
    "Leader": "6316",
    "Leask": "6318",
    "Lebret": "6320",
    "Leipzig": "6322",
    "Lemberg": "6324",
    "Leney": "6326",
    "Leoville": "6328",
    "Leross": "6330",
    "Leroy": "6332",
    "Leslie": "6334",
    "Lestock": "6336",
    "Liberty": "6338",
    "Liebanthal": "6339",
    "Limerick": "6340",
    "Lintlaw": "6342",
    "Lipton": "6344",
    "Lloydminster, SK": "6345",
    "Lockwood": "6346",
    "Loon Lake": "6348",
    "Loreburn": "6350",
    "Love": "6352",
    "Loverna": "6354",
    "Lucky Lake": "6356",
    "Lumsden Beac, SK": "6360",
    "Lumsden, SK": "6358",
    "Luseland": "6362",
    "MacDowall": "5827",
    "Macklin": "6368",
    "MacNutt": "6370",
    "Macoun": "6372",
    "Macrorie": "6374",
    "Madison": "6376",
    "Maidstone": "6377",
    "Main Centre": "6381",
    "Major": "6378",
    "Makwa": "6380",
    "Manitou Beach": "6382",
    "Mankota": "6384",
    "Manor": "6386",
    "Mantario": "6388",
    "Maple Creek": "6390",
    "Marcelin": "6392",
    "Marengo": "6394",
    "Margo": "6396",
    "Markinch": "6398",
    "Marquis": "6400",
    "Marshall": "6401",
    "Martensville": "6402",
    "Maryfield": "6404",
    "Maymont": "6406",
    "Mazenod": "6408",
    "McLean": "6410",
    "McMahon": "6411",
    "McTaggart": "6412",
    "Meacham": "6414",
    "Meadow Lake": "6416",
    "Meath Park": "6418",
    "Medstead": "6420",
    "Melfort": "6422",
    "Melville": "6424",
    "Mendham": "6426",
    "Meota": "6428",
    "Mervin": "6430",
    "Metinota": "6432",
    "Meyronne": "6434",
    "Midale": "6436",
    "Middle Lake": "6438",
    "Milden": "6440",
    "Milestone": "6442",
    "Minton": "6444",
    "Mistatim": "6446",
    "Monchy": "6447",
    "Montmartre": "6448",
    "Moose Jaw": "6450",
    "Moosomin": "6454",
    "Morse": "6456",
    "Mortlach": "6458",
    "Mossbank": "6460",
    "Muenster": "6462",
    "Naicam": "6468",
    "Neilburg, SK": "6469",
    "Netherhill": "6470",
    "Neudorf": "6472",
    "Neville": "6474",
    "Nipawin": "6476",
    "Nokomis": "6478",
    "Norquay": "6480",
    "North Battleford": "6482",
    "North Portal": "6484",
    "Northgate": "6483",
    "Odessa": "6488",
    "Ogema": "6490",
    "Osage": "6492",
    "Osler": "6494",
    "Other": "6999",
    "Oungre": "6495",
    "Outlook": "6496",
    "Oxbow": "6498",
    "Paddockwood": "6502",
    "Palmer": "6504",
    "Pangman": "6506",
    "Paradise Hill": "6509",
    "Parkside": "6508",
    "Paynton": "6510",
    "Peebles": "5829",
    "Pelly": "6512",
    "Pennant": "6514",
    "Pense": "6516",
    "Penzance": "6518",
    "Perdue": "6520",
    "Piapot": "6522",
    "Pilger": "6524",
    "Pilot Butte": "6526",
    "Plato": "6528",
    "Plenty": "6530",
    "Plunkett": "6532",
    "Ponteix": "6534",
    "Porcupine Plain": "6536",
    "Portreeve": "6538",
    "Preeceville": "6540",
    "Prelate": "6542",
    "Primate": "6544",
    "Prince Albert": "6546",
    "Prud'Homme": "6548",
    "Punnichy": "6550",
    "Qu'Appelle": "6552",
    "Quill Lake": "6554",
    "Quinton": "6556",
    "Rabbit Lake": "6560",
    "Radisson, SK": "6562",
    "Radville": "6564",
    "Rama": "6566",
    "Raymore": "6568",
    "Redvers": "6570",
    "Regina": "6572",
    "Regina Beach": "6574",
    "Regway": "6475",
    "Rhein": "6576",
    "Richard": "6578",
    "Richardson": "5815",
    "Richmond, SK": "6580",
    "Ridgedale": "6582",
    "Riverhurst": "6584",
    "Robsart": "6586",
    "Rocanville": "6588",
    "Roche Percee": "6590",
    "Rock Haven": "6592",
    "Rockglen": "6594",
    "Rose Valley": "6596",
    "Rosetown": "6598",
    "Rosthern": "6600",
    "Rouleau": "6602",
    "Ruddell": "6604",
    "Rush Lake": "6606",
    "Ruthilda": "6608",
    "Saint-Benedict": "6674",
    "Saint-Brieux": "6676",
    "Saint-Gregor": "6678",
    "Saint-Louis": "6680",
    "Saint-Victor": "6682",
    "Saint-Walburg": "7602",
    "Saltcoats": "6612",
    "Salvador": "6614",
    "Sandy Beach, SK": "6616",
    "Saskatchewan Beac": "6618",
    "Saskatoon": "6620",
    "Sceptre": "6622",
    "Scobey": "6623",
    "Scott": "6624",
    "Sedley": "6626",
    "Semans": "6628",
    "Senlac": "6630",
    "Shackleton": "6632",
    "Shamrock": "6634",
    "Shaunavon": "6636",
    "Shedo": "6638",
    "Shell Lake": "6640",
    "Shellbrook": "6642",
    "Silton": "6644",
    "Simmie": "6645",
    "Simpson": "6646",
    "Sintaluta": "6648",
    "Smeaton": "6650",
    "Smiley": "6652",
    "Southey": "6654",
    "Sovereign": "6656",
    "Spalding": "6658",
    "Speers": "6660",
    "Spirit Wood": "6662",
    "Spring Valley": "6666",
    "Spring Water": "6664",
    "Springside": "6668",
    "Spruce Lake": "6670",
    "Spy Hill": "6672",
    "Star City": "6684",
    "Steelman": "6685",
    "Stenen": "6686",
    "Stewart Valley": "6688",
    "Stockholm": "6690",
    "Stornoway": "6692",
    "Storthoaks": "6694",
    "Stoughton": "6696",
    "Stranraer": "6698",
    "Strasbourg": "6700",
    "Strongfield": "6702",
    "Sturgis": "6704",
    "Success": "6706",
    "Summerberry": "6708",
    "Swift Current": "6710",
    "Tantallon, SK": "6712",
    "Tessier": "6714",
    "Theodore": "6716",
    "Tisdale": "6718",
    "Togo": "6720",
    "Tompkins": "6722",
    "Torquay": "6724",
    "Tramping Lake": "6726",
    "Tribune": "6728",
    "Tugaske": "6730",
    "Turtleford": "6732",
    "Tuxford": "6734",
    "Unity": "6740",
    "Unwin": "6741",
    "Uranium City": "6742",
    "Usherville": "6743",
    "Val Marie": "6744",
    "Valparaiso": "6746",
    "Vanguard": "6748",
    "Vanscoy": "6750",
    "Vawn": "6752",
    "Veregin": "6754",
    "Vibank": "6756",
    "Viceroy": "6758",
    "Viscount": "6760",
    "Vonda": "6762",
    "Wadena": "6770",
    "Wakaw": "6772",
    "Wakaw Lake": "6774",
    "Waldeck": "6776",
    "Waldeim": "6778",
    "Waldron": "6780",
    "Wapella": "6782",
    "Warman": "6784",
    "Watrous": "6786",
    "Watson": "6788",
    "Wawota": "6790",
    "Webb": "6792",
    "Weekes": "6794",
    "Weirdale": "6796",
    "Weldon": "6798",
    "Welwyn": "6800",
    "West Bend": "6802",
    "West Poplar River": "6803",
    "Weyburn": "6804",
    "White City": "6806",
    "White Fox": "6808",
    "Whitewood": "6810",
    "Wilcox": "6812",
    "Wilkie": "6814",
    "Willow Bunch": "6816",
    "Willow Creek": "6819",
    "Willowbrook": "6818",
    "Windthorst": "6820",
    "Wiseton": "6822",
    "Wishart": "6824",
    "Wolseley": "6826",
    "Wood Mountain": "6828",
    "Woodrow": "6830",
    "Wroxton": "6832",
    "Wynyard": "6834",
    "Yarbo": "6840",
    "Yellow Creek": "6842",
    "Yellow Grass": "6844",
    "Yorkton": "6846",
    "Young": "6848",
    "Zealandia": "6852",
    "Zehner": "6853",
    "Zelma": "6854",
    "Zeneta": "6855",
    "Zenon Park": "6856",
    "Zumbro": "6864"
    },
    "YT":{
    "Carcross": "8237",
    "Carmacks": "8181",
    "Dawson City": "8150",
    "Faro": "8160",
    "Haines Junction": "8165",
    "Little Gold": "8399",
    "Mayo-Elsa": "8423",
    "Old Crow": "8478",
    "Other": "8199",
    "Ross River": "8182",
    "Swift River": "8170",
    "Tagish": "8151",
    "Watson Lake": "8705",
    "Whitehorse": "8180"
    }
}

immigration_status={
    "Citizen": "1: 01",
    "Permanent Resident": "2: 02",
    "Visitor": "3: 03",
    "Worker": "4: 04",
    "Student": "5: 05",
    "Other": "6: 06",
    "Refugess": "8: 08",
}
current_marital_status={
    "Annulled Marriage": "1: 09",
    "Common-Law": "2: 03",
    "Divorced": "3: 04",
    "Married": "4: 01",
    "Separated": "5: 05",
    "Single": "6: 02",
    "Unknown": "7: 00",
    "Widowed": "8: 06"
}
previous_marital_status={
    "Common-Law": "1: 03",
    "Married": "2: 01"
}
phone_type={
    "Select": "0: null",
    "residential": "1: 01",
    "cellular": "2: 02",
    "business": "3: 03"
}

education_level={
    "None": "00",
    "High school": "01",
    "Trade/Apprenticeship Certificate/Diploma": "02",
    "Diploma/Certificate": "03",
    "Associate": "04",
    "Bachelor": "05",
    "Post-graduate diploma": "06",
    "Master": "07",
    "Doctor": "08"
}

english_french={
    "Both": "04",
    "English": "01",
    "French": "02",
    "Neither": "03"
}

relationship_to_pa={
    "Select": "0: null",
    "Adopted Child": "1: 87",
    "Child": "2: 02",
    "Common-law partner": "3: 01",
    "Grandchild": "4: 04",
    # "Other": "5: 85",
    "Spouse": "6: 10",
    "Step-Child": "7: 03",
    "Step-Grandchild": "8: 100",
    "Parent": "9: 05",
    "Adoptive Parent": "10: 37"
}

dependant_type={
    "Select": "0: null",
    "Type A Dependant": "1: 01",
    "Type B Dependant": "2: 02",
    "Type C Dependant": "3: 03"
}