country_map = {
    "Canada": "Canada",
    "United States": "United States",
    "Afghanistan": "Afghanistan",
    "Åland Islands": "Aland Islands",
    "Albania": "Albania",
    "Algeria": "Algeria",
    "American Samoa": "American Samoa",
    "Andorra": "Andorra",
    "Angola": "Angola",
    "Anguilla": "Anguilla",
    "Antarctica": "Antarctica",
    "Antigua and Barbuda": "Antigua and Barbuda",
    "Argentina": "Argentina",
    "Armenia": "Armenia",
    "Aruba": "Aruba",
    "Australia": "Australia",
    "Austria": "Austria",
    "Azerbaijan": "Azerbaijan",
    "Bahamas": "Bahamas",
    "Bahrain": "Bahrain",
    "Bangladesh": "Bangladesh",
    "Barbados": "Barbados",
    "Belarus": "Belarus",
    "Belgium": "Belgium",
    "Belize": "Belize",
    "Benin": "Benin",
    "Bermuda": "Bermuda",
    "Bhutan": "Bhutan",
    "Bolivia, Plurinational State of": "Bolivia",
    "Bonaire, Sint Eustatius and Saba": "Bonaire",
    "Bosnia and Herzegovina": "Bosnia and Herzegowina",
    "Botswana": "Botswana",
    "Bouvet Island": "Bouvet Island",
    "Brazil": "Brazil",
    "British Indian Ocean Territory": "British Indian Ocean Territory",
    "Brunei Darussalam": "Brunei Darussalam",
    "Bulgaria": "Bulgaria",
    "Burkina Faso": "Burkina Faso",
    "Burundi": "Burundi",
    "Cambodia": "Cambodia",
    "Cameroon": "Cameroon",
    "Cape Verde": "Cape Verde",
    "Cayman Islands": "Cayman Islands",
    "Central African Republic": "Central African Republic",
    "Chad": "Chad",
    "Chile": "Chile",
    "China": "China",
    "Christmas Island": "Christmas Island",
    "Cocos (Keeling) Islands": "Cocos (Keeling) Islands",
    "Colombia": "Colombia",
    "Comoros": "Comoros",
    "Congo": "Congo",
    "Congo, the Democratic Republic of the": "Democratic Congo",
    "Cook Islands": "Cook Islands",
    "Costa Rica": "Costa Rica",
    "Côte d'Ivoire": "Cote D'Ivoire",
    "Croatia": "Croatia",
    "Cuba": "Cuba",
    "Curaçao": "Curacao",
    "Cyprus": "Cyprus",
    "Czech Republic": "Czech Republic",
    "Denmark": "Denmark",
    "Djibouti": "Djibouti",
    "Dominica": "Dominica",
    "Dominican Republic": "Dominican Republic",
    "Ecuador": "Ecuador",
    "Egypt": "Egypt",
    "El Salvador": "El Salvador",
    "Equatorial Guinea": "Equatorial Guinea",
    "Eritrea": "Eritrea",
    "Estonia": "Estonia",
    "Ethiopia": "Ethiopia",
    "Falkland Islands (Malvinas)": "Falkland Islands (Malvinas)",
    "Faroe Islands": "Faroe Islands",
    "Fiji": "Fiji",
    "Finland": "Finland",
    "France": "France",
    "French Guiana": "French Guiana",
    "French Polynesia": "French Polynesia",
    "French Southern Territories": "French Southern Territories",
    "Gabon": "Gabon",
    "Gambia": "Gambia",
    "Georgia": "Georgia",
    "Germany": "Germany",
    "Ghana": "Ghana",
    "Gibraltar": "Gibraltar",
    "Greece": "Greece",
    "Greenland": "Greenland",
    "Grenada": "Grenada",
    "Guadeloupe": "Guadeloupe",
    "Guam": "Guam",
    "Guatemala": "Guatemala",
    "Guernsey": "Guernsey",
    "Guinea": "Guinea",
    "Guinea-Bissau": "Guinea-bissau",
    "Guyana": "Guyana",
    "Haiti": "Haiti",
    "Heard Island and McDonald Islands": "Heard and Mc Donald Islands",
    "Holy See (Vatican City State)": "Vatican City State (Holy See)",
    "Honduras": "Honduras",
    "Hong Kong": "Hong Kong",
    "Hungary": "Hungary",
    "Iceland": "Iceland",
    "India": "India",
    "Indonesia": "Indonesia",
    "Iran, Islamic Republic of": "Iran",
    "Iraq": "Iraq",
    "Ireland": "Ireland",
    "Isle of Man": "Isle of Man",
    "Israel": "Israel",
    "Italy": "Italy",
    "Jamaica": "Jamaica",
    "Japan": "Japan",
    "Jersey": "Jersey",
    "Jordan": "Jordan",
    "Kazakhstan": "Kazakhstan",
    "Kenya": "Kenya",
    "Kiribati": "Kiribati",
    "Korea, Democratic People's Republic of": "Korea, North",
    "Korea, Republic of": "Korea, South",
    "Kosovo": "Kosovo",
    "Kuwait": "Kuwait",
    "Kyrgyzstan": "Kyrgyzstan",
    "Lao People's Democratic Republic": "Lao People's Democratic Republic",
    "Latvia": "Latvia",
    "Lebanon": "Lebanon",
    "Lesotho": "Lesotho",
    "Liberia": "Liberia",
    "Libya": "Libyan Arab Jamahiriya",
    "Liechtenstein": "Liechtenstein",
    "Lithuania": "Lithuania",
    "Luxembourg": "Luxembourg",
    "Macao": "Macau",
    "Macedonia, the former Yugoslav Republic of": "Macedonia, The Former Yugoslav Republic of",
    "Madagascar": "Madagascar",
    "Malawi": "Malawi",
    "Malaysia": "Malaysia",
    "Maldives": "Maldives",
    "Mali": "Mali",
    "Malta": "Malta",
    "Marshall Islands": "Marshall Islands",
    "Martinique": "Martinique",
    "Mauritania": "Mauritania",
    "Mauritius": "Mauritius",
    "Mayotte": "Mayotte",
    "Mexico": "Mexico",
    "Micronesia, Federated States of": "Micronesia, Federated States of",
    "Moldova, Republic of": "Moldova, Republic of",
    "Monaco": "Monaco",
    "Mongolia": "Mongolia",
    "Montenegro": "Montenegro",
    "Montserrat": "Montserrat",
    "Morocco": "Morocco",
    "Mozambique": "Mozambique",
    "Myanmar": "Myanmar",
    "Namibia": "Namibia",
    "Nauru": "Nauru",
    "Nepal": "Nepal",
    "Netherlands": "Netherlands",
    "New Caledonia": "New Caledonia",
    "New Zealand": "New Zealand",
    "Nicaragua": "Nicaragua",
    "Niger": "Niger",
    "Nigeria": "Nigeria",
    "Niue": "Niue",
    "Norfolk Island": "Norfolk Island",
    "Northern Mariana Islands": "Northern Mariana Islands",
    "Norway": "Norway",
    "Oman": "Oman",
    "Pakistan": "Pakistan",
    "Palau": "Palau",
    "Palestinian Territory, Occupied": "Palestine",
    "Panama": "Panama",
    "Papua New Guinea": "Papua New Guinea",
    "Paraguay": "Paraguay",
    "Peru": "Peru",
    "Philippines": "Philippines",
    "Pitcairn": "Pitcairn",
    "Poland": "Poland",
    "Portugal": "Portugal",
    "Puerto Rico": "Puerto Rico",
    "Qatar": "Qatar",
    "Réunion": "Reunion",
    "Romania": "Romania",
    "Russian Federation": "Russian Federation",
    "Rwanda": "Rwanda",
    "Saint Barthélemy": "Saint Barthelemy",
    "Saint Helena, Ascension and Tristan da Cunha": "St. Helena",
    "Saint Kitts and Nevis": "Saint Kitts and Nevis",
    "Saint Lucia": "Saint Lucia",
    "Saint Martin (French part)": "Saint Martin (French part)",
    "Saint Pierre and Miquelon": "St. Pierre and Miquelon",
    "Saint Vincent and the Grenadines": "Saint Vincent and the Grenadines",
    "Samoa": "Samoa",
    "San Marino": "San Marino",
    "Sao Tome and Principe": "Sao Tome and Principe",
    "Saudi Arabia": "Saudi Arabia",
    "Senegal": "Senegal",
    "Serbia": "Serbia",
    "Seychelles": "Seychelles",
    "Sierra Leone": "Sierra Leone",
    "Singapore": "Singapore",
    "Sint Maarten (Dutch part)": "Sint Maarten (Dutch part)",
    "Slovakia": "Slovakia (Slovak Republic)",
    "Slovenia": "Slovenia",
    "Solomon Islands": "Solomon Islands",
    "Somalia": "Somalia",
    "South Africa": "South Africa",
    "South Georgia and the South Sandwich Islands": "South Georgia and the South Sandwich Islands",
    "South Sudan": "South Sudan",
    "Spain": "Spain",
    "Sri Lanka": "Sri Lanka",
    "Sudan": "Sudan",
    "Suriname": "Suriname",
    "Svalbard and Jan Mayen": "Svalbard and Jan Mayen Islands",
    "Swaziland": "Swaziland",
    "Sweden": "Sweden",
    "Switzerland": "Switzerland",
    "Syrian Arab Republic": "Syria",
    "Taiwan, Province of China": "Taiwan",
    "Tajikistan": "Tajikistan",
    "Tanzania, United Republic of": "Tanzania, United Republic of",
    "Thailand": "Thailand",
    "Timor-Leste": "East Timor",
    "Togo": "Togo",
    "Tokelau": "Tokelau",
    "Tonga": "Tonga",
    "Trinidad and Tobago": "Trinidad and Tobago",
    "Tunisia": "Tunisia",
    "Turkey": "Turkey",
    "Turkmenistan": "Turkmenistan",
    "Turks and Caicos Islands": "Turks and Caicos Islands",
    "Tuvalu": "Tuvalu",
    "Uganda": "Uganda",
    "Ukraine": "Ukraine",
    "United Arab Emirates": "United Arab Emirates",
    "United Kingdom": "United Kingdom",
    "United States Minor Outlying Islands": "United States Minor Outlying Islands",
    "Uruguay": "Uruguay",
    "Uzbekistan": "Uzbekistan",
    "Vanuatu": "Vanuatu",
    "Venezuela, Bolivarian Republic of": "Venezuela",
    "Viet Nam": "Vietnam",
    "Virgin Islands, British": "Virgin Islands (British)",
    "Virgin Islands, U.S.": "Virgin Islands (U.S.)",
    "Wallis and Futuna": "Wallis and Futuna Islands",
    "Western Sahara": "Western Sahara",
    "Yemen": "Yemen",
    "Zambia": "Zambia",
    "Zimbabwe": "Zimbabwe",
}
province_map = {
    "AB": "Alberta",
    "BC": "British Columbia",
    "MB": "Manitoba",
    "NB": "New Brunswick",
    "NL": "Newfoundland & Labrador",
    "NS": "Nova Scotia",
    "NT": "Northwest Territories",
    "NU": "Nunavut",
    "ON": "Ontario",
    "PE": "Prince Edward Island",
    "QC": "Quebec",
    "SK": "Saskatchewan",
    "YT": "Yukon",
}

app_education_map = {
    "High school": "SSOL",
    "Less than high school": "SSOL",
    "Associate": "AD",
    "Diploma/Certificate": "DCNT",
    "Diploma/Certificate (trades)": "DCT",
    "Bachelor": "BD",
    "Post-graduate diploma": "PBD",
    "Master": "M",
    "Doctor": "PHD",
}

education_map = {
    "High school": "SSOL",
    "Less than high school": "SSOL",
    "Associate": "AD",
    "Diploma/Certificate": "DCNT",
    "Diploma/Certificate (trades)": "DCT",
    "Bachelor": "BD",
    "Post-graduate diploma": "PBD",
    "Master": "MD",
    "Doctor": "PHD",
}


def getEducation(edu_level, is_trade=None, is_reg=True):
    edu_map = education_map if is_reg else app_education_map
    return (
        edu_map[edu_level + " (trades)"]
        if is_trade and edu_level == "Diploma/Certificate"
        else edu_map[edu_level]
    )


eca_map = {
    "Comparative Education Service - University of Toronto School of Continuing Studies": "CES",
    "International Credential Assessment Service of Canada": "ICA",
    "World Education Services": "WES",
    "International Qualifications Assessment Service": "IQA",
    "International Credential Evaluation Service": "ICE",
    "Medical Council of Canada (for Doctors)": "MCC",
    "Pharmacy Examining Board of Canada (for Pharmacists)": "PEB",
}

city_map = {
    "100 Mile House": "100 Mile House",
    "105 Mile House": "105 Mile House",
    "108 Mile Ranch": "108 Mile Ranch",
    "111 Mile House": "111 Mile House",
    "114 Mile House": "114 Mile House",
    "12 Mile": "12 Mile",
    "122 Mile House": "122 Mile House",
    "127 Mile House": "127 Mile House",
    "141 Mile House": "141 Mile House",
    "150 Mile House": "150 Mile House",
    "40 Mile Flats": "40 Mile Flats",
    "70 Mile House": "70 Mile House",
    "93 Mile": "93 Mile",
    "Abbotsford": "Abbotsford",
    "Abbott Heights": "Abbott Heights",
    "Aberdeen": "Aberdeen",
    "Adams Lake": "Adams Lake",
    "Agassiz": "Agassiz",
    "Agate": "Agate",
    "Ahbau": "Ahbau",
    "Ahousat": "Ahousat",
    "Ainsworth": "Ainsworth",
    "Ainsworth Hot Springs": "Ainsworth Hot Springs",
    "Aiyansh": "Aiyansh",
    "Aiyansh 1": "Aiyansh 1",
    "Akiskinook": "Akiskinook",
    "Alamo": "Alamo",
    "Albas": "Albas",
    "Alberni": "Alberni",
    "Albert Canyon": "Albert Canyon",
    "Albert Head": "Albert Head",
    "Albion": "Albion",
    "Albreda": "Albreda",
    "Aldergrove": "Aldergrove",
    "Alert Bay": "Alert Bay",
    "Alexandria": "Alexandria",
    "Alexis Creek": "Alexis Creek",
    "Aleza Lake": "Aleza Lake",
    "Alice Arm": "Alice Arm",
    "Alice Siding": "Alice Siding",
    "Alkali Lake": "Alkali Lake",
    "Allenby": "Allenby",
    "Alliford Bay": "Alliford Bay",
    "Allison Lake": "Allison Lake",
    "Almond Gardens": "Almond Gardens",
    "Alpine Meadows": "Alpine Meadows",
    "Alta Lake": "Alta Lake",
    "Altona": "Altona",
    "Alvin": "Alvin",
    "Ambleside": "Ambleside",
    "Amsbury": "Amsbury",
    "Anaconda": "Anaconda",
    "Anahim Lake": "Anahim Lake",
    "Anderson": "Anderson",
    "Anderson Subdivision": "Anderson Subdivision",
    "Andimaul": "Andimaul",
    "Anglemont": "Anglemont",
    "Angusmac": "Angusmac",
    "Anmore": "Anmore",
    "Anniedale": "Anniedale",
    "Annis": "Annis",
    "Anvil Island": "Anvil Island",
    "Anyox": "Anyox",
    "Anzac": "Anzac",
    "Appledale": "Appledale",
    "Applegrove": "Applegrove",
    "Arbutus": "Arbutus",
    "Arbutus Ridge": "Arbutus Ridge",
    "Arden Park": "Arden Park",
    "Ardmore": "Ardmore",
    "Argenta": "Argenta",
    "Armstrong": "Armstrong",
    "Arnold": "Arnold",
    "Arras": "Arras",
    "Arrow Creek": "Arrow Creek",
    "Arrow Park": "Arrow Park",
    "Arrowhead": "Arrowhead",
    "Arrowsmith": "Arrowsmith",
    "Arrowview Heights": "Arrowview Heights",
    "Ashcroft": "Ashcroft",
    "Ashton Creek": "Ashton Creek",
    "Aspen Grove": "Aspen Grove",
    "Atbara": "Atbara",
    "Atchelitz": "Atchelitz",
    "Athalmer": "Athalmer",
    "Atlin": "Atlin",
    "Atluck": "Atluck",
    "Atnarko": "Atnarko",
    "Attachie": "Attachie",
    "Austin Heights": "Austin Heights",
    "Australian": "Australian",
    "Avola": "Avola",
    "Azouzetta": "Azouzetta",
    "Babcock Subdivision": "Babcock Subdivision",
    "Baker": "Baker",
    "Baker Creek": "Baker Creek",
    "Baldonnel": "Baldonnel",
    "Baldy Hughes": "Baldy Hughes",
    "Balfour": "Balfour",
    "Balmoral": "Balmoral",
    "Balmoral Beach": "Balmoral Beach",
    "Bamberton": "Bamberton",
    "Bamfield": "Bamfield",
    "Bankeir": "Bankeir",
    "Banks Island": "Banks Island",
    "Bargain Harbour": "Bargain Harbour",
    "Bargain Harbour Sechelt Band 24": "Bargain Harbour Sechelt Band 24",
    "Barkerville": "Barkerville",
    "Barlow": "Barlow",
    "Barlow Creek": "Barlow Creek",
    "Barnet": "Barnet",
    "Barnhartvale": "Barnhartvale",
    "Barrett Lake": "Barrett Lake",
    "Barriere": "Barriere",
    "Barrowtown": "Barrowtown",
    "Basford": "Basford",
    "Basque": "Basque",
    "Bastion Bay": "Bastion Bay",
    "Batchelor Hills": "Batchelor Hills",
    "Bates Beach": "Bates Beach",
    "Baynes Lake": "Baynes Lake",
    "Beach Grove": "Beach Grove",
    "Beachcomber": "Beachcomber",
    "Beachcomber Bay": "Beachcomber Bay",
    "Bealby Point": "Bealby Point",
    "Bear Camp": "Bear Camp",
    "Bear Creek": "Bear Creek",
    "Bear Flat": "Bear Flat",
    "Bear Lake": "Bear Lake",
    "Beard's Creek": "Beard's Creek",
    "Beasley": "Beasley",
    "Beaton": "Beaton",
    "Beatton": "Beatton",
    "Beatton Ranch": "Beatton Ranch",
    "Beaver Cove": "Beaver Cove",
    "Beaver Creek": "Beaver Creek",
    "Beaver Falls": "Beaver Falls",
    "Beaver Lake": "Beaver Lake",
    "Beaver Pass House": "Beaver Pass House",
    "Beaver Point": "Beaver Point",
    "Beaverdell": "Beaverdell",
    "Beaverley": "Beaverley",
    "Beavermouth": "Beavermouth",
    "Becher Bay 2": "Becher Bay 2",
    "Becher House": "Becher House",
    "Bedwell Harbour": "Bedwell Harbour",
    "Belcarra": "Belcarra",
    "Belford": "Belford",
    "Bell II": "Bell II",
    "Bella Bella": "Bella Bella",
    "Bella Coola": "Bella Coola",
    "Belleview": "Belleview",
    "Bellos": "Bellos",
    "Belmont Park": "Belmont Park",
    "Belvedere": "Belvedere",
    "Bend": "Bend",
    "Benledi": "Benledi",
    "Ben-My-Chree": "Ben-My-Chree",
    "Bennett": "Bennett",
    "Benson Lake": "Benson Lake",
    "Benvoulin": "Benvoulin",
    "Beresford": "Beresford",
    "Bergs": "Bergs",
    "Beryl Prairie": "Beryl Prairie",
    "Bessborough": "Bessborough",
    "Bestwick": "Bestwick",
    "Bevan": "Bevan",
    "Big Bar": "Big Bar",
    "Big Bar Creek": "Big Bar Creek",
    "Big Bay": "Big Bay",
    "Big Creek": "Big Creek",
    "Big Eddy": "Big Eddy",
    "Big Lake": "Big Lake",
    "Big Lake Ranch": "Big Lake Ranch",
    "Big White Village": "Big White Village",
    "Billings": "Billings",
    "Billings Bay": "Billings Bay",
    "Birch Island": "Birch Island",
    "Birchbank": "Birchbank",
    "Birchdale": "Birchdale",
    "Birchland Manor": "Birchland Manor",
    "Birken": "Birken",
    "Black Creek": "Black Creek",
    "Black Pines": "Black Pines",
    "Blackloam": "Blackloam",
    "Blackpool": "Blackpool",
    "Blackstock Subdivision": "Blackstock Subdivision",
    "Blackwater": "Blackwater",
    "Blaeberry": "Blaeberry",
    "Blake": "Blake",
    "Blakeburn": "Blakeburn",
    "Blewett": "Blewett",
    "Bligh Island": "Bligh Island",
    "Blind Bay": "Blind Bay",
    "Blind Channel": "Blind Channel",
    "Bliss Landing": "Bliss Landing",
    "Bloedel": "Bloedel",
    "Blowhole": "Blowhole",
    "Blubber Bay": "Blubber Bay",
    "Blucher Hall": "Blucher Hall",
    "Blue Hills": "Blue Hills",
    "Blue River": "Blue River",
    "Blue Springs": "Blue Springs",
    "Blueberry Creek": "Blueberry Creek",
    "Blueberry Farm": "Blueberry Farm",
    "Blueridge": "Blueridge",
    "Boat Basin": "Boat Basin",
    "Boat Harbour": "Boat Harbour",
    "Bob Quinn Lake": "Bob Quinn Lake",
    "Bold Point": "Bold Point",
    "Bond": "Bond",
    "Bonnet Hill": "Bonnet Hill",
    "Bonnington Falls": "Bonnington Falls",
    "Boothroyd (Part) 8A": "Boothroyd (Part) 8A",
    "Boston Bar": "Boston Bar",
    "Boston Flats": "Boston Flats",
    "Boswell": "Boswell",
    "Bouchie Lake": "Bouchie Lake",
    "Boulder": "Boulder",
    "Boulder City": "Boulder City",
    "Boulder Island Sechelt Band 25": "Boulder Island Sechelt Band 25",
    "Boundary Bay": "Boundary Bay",
    "Boundary Falls": "Boundary Falls",
    "Bowen Island": "Bowen Island",
    "Bowser": "Bowser",
    "Box Lake": "Box Lake",
    "Brackendale": "Brackendale",
    "Bradner": "Bradner",
    "Braeloch": "Braeloch",
    "Braemar Heights": "Braemar Heights",
    "Braeside": "Braeside",
    "Bralorne": "Bralorne",
    "Brandon": "Brandon",
    "Brandywine": "Brandywine",
    "Brauns Island": "Brauns Island",
    "Brem River": "Brem River",
    "Brennan Creek": "Brennan Creek",
    "Brentwood Bay": "Brentwood Bay",
    "Brew Bay": "Brew Bay",
    "Brexton": "Brexton",
    "Briar Ridge": "Briar Ridge",
    "Bridal Falls": "Bridal Falls",
    "Bridesville": "Bridesville",
    "Bridge": "Bridge",
    "Bridge Lake": "Bridge Lake",
    "Brigade Lake": "Brigade Lake",
    "Brighouse": "Brighouse",
    "Brighton Beach": "Brighton Beach",
    "Brilliant": "Brilliant",
    "Brisco": "Brisco",
    "Britannia Beach": "Britannia Beach",
    "Broadview": "Broadview",
    "Brocklehurst": "Brocklehurst",
    "Broman Lake": "Broman Lake",
    "Brookmere": "Brookmere",
    "Brouse": "Brouse",
    "Browns Bay": "Browns Bay",
    "Brownsville": "Brownsville",
    "Brunswick": "Brunswick",
    "Bryn": "Bryn",
    "Buccaneer Bay": "Buccaneer Bay",
    "Buckhorn": "Buckhorn",
    "Buckinghorse River": "Buckinghorse River",
    "Buckley Bay": "Buckley Bay",
    "Buffalo Creek": "Buffalo Creek",
    "Buick": "Buick",
    "Bulkley Canyon": "Bulkley Canyon",
    "Bulkley House": "Bulkley House",
    "Bull Harbour": "Bull Harbour",
    "Bull River": "Bull River",
    "Buntzen Bay": "Buntzen Bay",
    "Burke Road": "Burke Road",
    "Burkeville": "Burkeville",
    "Burnaby": "Burnaby",
    "Burns Lake": "Burns Lake",
    "Burnt Flats": "Burnt Flats",
    "Burton": "Burton",
    "Butedale": "Butedale",
    "Cache Creek": "Cache Creek",
    "Caesars": "Caesars",
    "Cahilty": "Cahilty",
    "Caithness": "Caithness",
    "Cale": "Cale",
    "Callison Ranch": "Callison Ranch",
    "Cambie": "Cambie",
    "Camborne": "Camborne",
    "Cameron Heights": "Cameron Heights",
    "Cameron Lake": "Cameron Lake",
    "Camp McKinney": "Camp McKinney",
    "Campbell Creek": "Campbell Creek",
    "Campbell Island": "Campbell Island",
    "Campbell River": "Campbell River",
    "Campbellton": "Campbellton",
    "Canal Flats": "Canal Flats",
    "Canford": "Canford",
    "Canim": "Canim",
    "Canim Lake": "Canim Lake",
    "Canoe": "Canoe",
    "Canoe River": "Canoe River",
    "Canyon": "Canyon",
    "Canyon Alpine": "Canyon Alpine",
    "Canyon Heights": "Canyon Heights",
    "Canyon Hot Springs": "Canyon Hot Springs",
    "Cariboo": "Cariboo",
    "Cariboo Meadows": "Cariboo Meadows",
    "Carlin": "Carlin",
    "Carlson": "Carlson",
    "Carmi": "Carmi",
    "Carmi Subdivision": "Carmi Subdivision",
    "Carnaby": "Carnaby",
    "Carp": "Carp",
    "Carrolls Landing": "Carrolls Landing",
    "Carrs": "Carrs",
    "Carrs Landing": "Carrs Landing",
    "Carson": "Carson",
    "Cascade": "Cascade",
    "Casino": "Casino",
    "Cassiar": "Cassiar",
    "Cassidy": "Cassidy",
    "Cassin": "Cassin",
    "Castle Rock": "Castle Rock",
    "Castledale": "Castledale",
    "Castlegar": "Castlegar",
    "Caswell": "Caswell",
    "Cathedral": "Cathedral",
    "Caulfeild": "Caulfeild",
    "Cawston": "Cawston",
    "Caycuse": "Caycuse",
    "Cecil Lake": "Cecil Lake",
    "Cedar": "Cedar",
    "Cedar Grove": "Cedar Grove",
    "Cedar Heights Estates": "Cedar Heights Estates",
    "Cedarside": "Cedarside",
    "Cedarvale": "Cedarvale",
    "Ceepeecee": "Ceepeecee",
    "Celista": "Celista",
    "Central Saanich": "Central Saanich",
    "Centreville": "Centreville",
    "Chaatl": "Chaatl",
    "Chain Lake": "Chain Lake",
    "Chamiss Bay": "Chamiss Bay",
    "Channel Ridge": "Channel Ridge",
    "Chapman Camp": "Chapman Camp",
    "Chapmans": "Chapmans",
    "Charella Garden": "Charella Garden",
    "Charles": "Charles",
    "Charlie Lake": "Charlie Lake",
    "Charlotte Lake": "Charlotte Lake",
    "Chase": "Chase",
    "Chase River": "Chase River",
    "Chasm": "Chasm",
    "Chaumox": "Chaumox",
    "Cheakamus": "Cheakamus",
    "Cheam View": "Cheam View",
    "Cheekye": "Cheekye",
    "Chelohsin Sechelt Band 13": "Chelohsin Sechelt Band 13",
    "Chemainus": "Chemainus",
    "Cherry Creek": "Cherry Creek",
    "Cherry Point": "Cherry Point",
    "Cherryville": "Cherryville",
    "Ches-la-kee 3": "Ches-la-kee 3",
    "Cheslatta": "Cheslatta",
    "Chetarpe": "Chetarpe",
    "Chetwynd": "Chetwynd",
    "Chezacut": "Chezacut",
    "Chickwat Sechelt Band 9": "Chickwat Sechelt Band 9",
    "Chilanko Forks": "Chilanko Forks",
    "Chilcotin Forest": "Chilcotin Forest",
    "Chilliwack": "Chilliwack",
    "Chilton Subdivision": "Chilton Subdivision",
    "Chimney Valley": "Chimney Valley",
    "China Bar": "China Bar",
    "Chinook Cove": "Chinook Cove",
    "Choate": "Choate",
    "Chopaka": "Chopaka",
    "Christian Valley": "Christian Valley",
    "Christina Lake": "Christina Lake",
    "Chu Chua": "Chu Chua",
    "Church House": "Church House",
    "Chute Lake": "Chute Lake",
    "Cinema": "Cinema",
    "Cinnabar Valley": "Cinnabar Valley",
    "Cisco": "Cisco",
    "Clairmont": "Clairmont",
    "Clanwilliam": "Clanwilliam",
    "Clapperton": "Clapperton",
    "Clayburn": "Clayburn",
    "Clayhurst": "Clayhurst",
    "Clayoquot": "Clayoquot",
    "Cleagh Creek": "Cleagh Creek",
    "Clearbrook": "Clearbrook",
    "Clearwater": "Clearwater",
    "Clemina East": "Clemina East",
    "Clemina West": "Clemina West",
    "Clemretta": "Clemretta",
    "Cleveland Park": "Cleveland Park",
    "Cliffside": "Cliffside",
    "Clinton": "Clinton",
    "Clode": "Clode",
    "Clo-oose": "Clo-oose",
    "Coal Harbour": "Coal Harbour",
    "Coal Island": "Coal Island",
    "Coal River": "Coal River",
    "Coalmont": "Coalmont",
    "Cobble Hill": "Cobble Hill",
    "Cody": "Cody",
    "Cokato": "Cokato",
    "Cokoqueneets Sechelt Band 23": "Cokoqueneets Sechelt Band 23",
    "Coldspring House": "Coldspring House",
    "Coldstream": "Coldstream",
    "Coldwell Beach": "Coldwell Beach",
    "Colebank": "Colebank",
    "Colebrook": "Colebrook",
    "College Heights": "College Heights",
    "Collettville": "Collettville",
    "Colleymount": "Colleymount",
    "Colquitz": "Colquitz",
    "Columbia Gardens": "Columbia Gardens",
    "Columere Park": "Columere Park",
    "Colvalli": "Colvalli",
    "Colwood": "Colwood",
    "Comer": "Comer",
    "Commodore Heights": "Commodore Heights",
    "Comox": "Comox",
    "Connaught Heights": "Connaught Heights",
    "Conrad": "Conrad",
    "Coombe": "Coombe",
    "Coombs": "Coombs",
    "Cooper Creek": "Cooper Creek",
    "Copper City": "Copper City",
    "Copper Cove": "Copper Cove",
    "Copper Creek": "Copper Creek",
    "Copper Mountain": "Copper Mountain",
    "Coquitlam": "Coquitlam",
    "Coral Beach": "Coral Beach",
    "Corbin": "Corbin",
    "Cordova Bay": "Cordova Bay",
    "Cormorant Island": "Cormorant Island",
    "Corra Linn": "Corra Linn",
    "Cortes Bay": "Cortes Bay",
    "Cortes Island": "Cortes Island",
    "Coryville": "Coryville",
    "Cottonwood": "Cottonwood",
    "Cottonwood Flats": "Cottonwood Flats",
    "Couldwell Subdivision": "Couldwell Subdivision",
    "Courtenay": "Courtenay",
    "Coutlee": "Coutlee",
    "Cove Cliff": "Cove Cliff",
    "Cowans Point": "Cowans Point",
    "Cowichan Bay": "Cowichan Bay",
    "Coykendahl": "Coykendahl",
    "Coyle": "Coyle",
    "Cracroft": "Cracroft",
    "Craigellachie": "Craigellachie",
    "Cranberry": "Cranberry",
    "Cranberry Junction": "Cranberry Junction",
    "Cranbrook": "Cranbrook",
    "Crawford Bay": "Crawford Bay",
    "Creekside": "Creekside",
    "Creighton Valley": "Creighton Valley",
    "Crescent Bay": "Crescent Bay",
    "Crescent Beach": "Crescent Beach",
    "Crescent Spur": "Crescent Spur",
    "Crescent Valley": "Crescent Valley",
    "Creston": "Creston",
    "Crestwood Subdivision": "Crestwood Subdivision",
    "Criss Creek": "Criss Creek",
    "Crofton": "Crofton",
    "Crowsnest": "Crowsnest",
    "Croydon": "Croydon",
    "Crysdale": "Crysdale",
    "Cultus Lake": "Cultus Lake",
    "Cumberland": "Cumberland",
    "Cumshewa": "Cumshewa",
    "Curzon": "Curzon",
    "Cypress Park": "Cypress Park",
    "Dallas": "Dallas",
    "Danskin": "Danskin",
    "D'Arcy": "D'Arcy",
    "D'Arcy Island": "D'Arcy Island",
    "Darfield": "Darfield",
    "Darrell Bay": "Darrell Bay",
    "Dartmoor": "Dartmoor",
    "Dashwood": "Dashwood",
    "Davidson": "Davidson",
    "Davis Bay": "Davis Bay",
    "Dawson Creek": "Dawson Creek",
    "Dawsons Landing": "Dawsons Landing",
    "Days Ranch": "Days Ranch",
    "Day's Subdivision": "Day's Subdivision",
    "De Courcy Island": "De Courcy Island",
    "Deadtree Point": "Deadtree Point",
    "Deadwood": "Deadwood",
    "Dease Lake": "Dease Lake",
    "Decker Lake": "Decker Lake",
    "Deep Bay": "Deep Bay",
    "Deep Cove": "Deep Cove",
    "Deep Creek": "Deep Creek",
    "Deer Park": "Deer Park",
    "Deerholme": "Deerholme",
    "Defot": "Defot",
    "Deka Lake": "Deka Lake",
    "Del Oro Subdivision": "Del Oro Subdivision",
    "Delkatla": "Delkatla",
    "Delta": "Delta",
    "Demean": "Demean",
    "Denman Island": "Denman Island",
    "Dentville": "Dentville",
    "Departure Bay": "Departure Bay",
    "Deroche": "Deroche",
    "Devine": "Devine",
    "Dewdney": "Dewdney",
    "Dewey": "Dewey",
    "Digby Island": "Digby Island",
    "Doe River": "Doe River",
    "Dog Creek": "Dog Creek",
    "Dogpatch": "Dogpatch",
    "Dogwood Valley": "Dogwood Valley",
    "Doig River": "Doig River",
    "Dokie": "Dokie",
    "Dokie Siding": "Dokie Siding",
    "Dolan Road Subdivision": "Dolan Road Subdivision",
    "Dollarton": "Dollarton",
    "Dolphin Beach": "Dolphin Beach",
    "Dolphin Island 1": "Dolphin Island 1",
    "Dome Creek": "Dome Creek",
    "Donald": "Donald",
    "Donald Landing": "Donald Landing",
    "Donnely Landing": "Donnely Landing",
    "Doriston": "Doriston",
    "Dorreen": "Dorreen",
    "Dot": "Dot",
    "Douglas": "Douglas",
    "Douglas Hill Estates": "Douglas Hill Estates",
    "Douglas Lake": "Douglas Lake",
    "Dove Creek": "Dove Creek",
    "Downie": "Downie",
    "Dragon": "Dragon",
    "Drew Harbour": "Drew Harbour",
    "Drewry": "Drewry",
    "Driftwood Creek": "Driftwood Creek",
    "Dry Gulch": "Dry Gulch",
    "Drynoch": "Drynoch",
    "DuBose": "DuBose",
    "Duck Range": "Duck Range",
    "Dufferin": "Dufferin",
    "Dugan Lake": "Dugan Lake",
    "Duncan": "Duncan",
    "Duncan Bay": "Duncan Bay",
    "Duncanby Landing": "Duncanby Landing",
    "Dunkley": "Dunkley",
    "Dunsmuir": "Dunsmuir",
    "Dunster": "Dunster",
    "Durieu": "Durieu",
    "Dutch Lake": "Dutch Lake",
    "Eagle Bay": "Eagle Bay",
    "Eagle Bluff": "Eagle Bluff",
    "Eagle Creek": "Eagle Creek",
    "Eagle Harbour": "Eagle Harbour",
    "Eagle Heights": "Eagle Heights",
    "Earls Cove": "Earls Cove",
    "East Arrow Park": "East Arrow Park",
    "East Gate": "East Gate",
    "East Kelowna": "East Kelowna",
    "East Osoyoos": "East Osoyoos",
    "East Pine": "East Pine",
    "East Sooke": "East Sooke",
    "East Thurlow Island": "East Thurlow Island",
    "East Trail": "East Trail",
    "East Wellington": "East Wellington",
    "Eastbourne": "Eastbourne",
    "Eastgate": "Eastgate",
    "Echo Bay": "Echo Bay",
    "Ecoole": "Ecoole",
    "Eddontenajon": "Eddontenajon",
    "Eddy": "Eddy",
    "Edelweiss": "Edelweiss",
    "Edgewater": "Edgewater",
    "Edgewood": "Edgewood",
    "Egmont": "Egmont",
    "Egmont Sechelt Band 26": "Egmont Sechelt Band 26",
    "Ehatisaht": "Ehatisaht",
    "Eholt": "Eholt",
    "Ekins Point": "Ekins Point",
    "Ekwan": "Ekwan",
    "Elephant Crossing": "Elephant Crossing",
    "Elk Bay": "Elk Bay",
    "Elk Prairie": "Elk Prairie",
    "Elkford": "Elkford",
    "Elko": "Elko",
    "Elkview": "Elkview",
    "Elleh": "Elleh",
    "Ellison": "Ellison",
    "Elphinstone": "Elphinstone",
    "Encombe": "Encombe",
    "Endako": "Endako",
    "Enderby": "Enderby",
    "Engen": "Engen",
    "Engineer": "Engineer",
    "Enterprise": "Enterprise",
    "Erickson": "Erickson",
    "Erie": "Erie",
    "Errington": "Errington",
    "Esler": "Esler",
    "Esperanza": "Esperanza",
    "Espinosa Inlet": "Espinosa Inlet",
    "Esquimalt": "Esquimalt",
    "Estevan Point": "Estevan Point",
    "Evans": "Evans",
    "Evelyn": "Evelyn",
    "Evergreen Acres": "Evergreen Acres",
    "Ewing": "Ewing",
    "Exeter": "Exeter",
    "Exlou": "Exlou",
    "Exstew": "Exstew",
    "Extension": "Extension",
    "Fair Harbour": "Fair Harbour",
    "Fairbridge": "Fairbridge",
    "Fairfield": "Fairfield",
    "Fairmont": "Fairmont",
    "Fairmont Hot Springs": "Fairmont Hot Springs",
    "Fairview": "Fairview",
    "Fairview Subdivision": "Fairview Subdivision",
    "Falkland": "Falkland",
    "Falls": "Falls",
    "Falls Creek": "Falls Creek",
    "Fallsway": "Fallsway",
    "False Bay": "False Bay",
    "Fanny Bay": "Fanny Bay",
    "Farmington": "Farmington",
    "Farrell Creek": "Farrell Creek",
    "Farron": "Farron",
    "Faulder": "Faulder",
    "Fauquier": "Fauquier",
    "Federal Ranch": "Federal Ranch",
    "Fellers Heights": "Fellers Heights",
    "Fenwick": "Fenwick",
    "Ferguson": "Ferguson",
    "Ferndale": "Ferndale",
    "Fernie": "Fernie",
    "Fernwood": "Fernwood",
    "Field": "Field",
    "Fife": "Fife",
    "Fifth Cabin": "Fifth Cabin",
    "Fill": "Fill",
    "Finmoore": "Finmoore",
    "Fintry": "Fintry",
    "Fireside": "Fireside",
    "Firvale": "Firvale",
    "Fitzwilliam": "Fitzwilliam",
    "Five Mile": "Five Mile",
    "Flat Creek": "Flat Creek",
    "Flathead": "Flathead",
    "Flatrock": "Flatrock",
    "Fleetwood": "Fleetwood",
    "Fleming": "Fleming",
    "Floods": "Floods",
    "Flores Island": "Flores Island",
    "Flying U": "Flying U",
    "Fontas": "Fontas",
    "Fontas 1": "Fontas 1",
    "Forde": "Forde",
    "Fording": "Fording",
    "Foreman": "Foreman",
    "Forest Grove": "Forest Grove",
    "Forest Hills": "Forest Hills",
    "Forest Knolls": "Forest Knolls",
    "Forestdale": "Forestdale",
    "Fort Babine": "Fort Babine",
    "Fort Fraser": "Fort Fraser",
    "Fort Langley": "Fort Langley",
    "Fort Nelson": "Fort Nelson",
    "Fort Nelson 2": "Fort Nelson 2",
    "Fort Rupert": "Fort Rupert",
    "Fort St. James": "Fort St. James",
    "Fort St. John": "Fort St. John",
    "Fort Steele": "Fort Steele",
    "Foss": "Foss",
    "Foster": "Foster",
    "Fosthall": "Fosthall",
    "Fountain": "Fountain",
    "Fountain Valley": "Fountain Valley",
    "Fourth Cabin": "Fourth Cabin",
    "Fowler": "Fowler",
    "Fox Mountain": "Fox Mountain",
    "Fraine": "Fraine",
    "Francis Lake": "Francis Lake",
    "Francis Peninsula": "Francis Peninsula",
    "Franklin Camp": "Franklin Camp",
    "Fraser": "Fraser",
    "Fraser Heights": "Fraser Heights",
    "Fraser Lake": "Fraser Lake",
    "Fraserview": "Fraserview",
    "Frederick": "Frederick",
    "French Creek": "French Creek",
    "Fruitvale": "Fruitvale",
    "Fry Creek": "Fry Creek",
    "Fulford Harbour": "Fulford Harbour",
    "Furry Creek": "Furry Creek",
    "Gabriola": "Gabriola",
    "Gabriola Island": "Gabriola Island",
    "Galena": "Galena",
    "Galiano": "Galiano",
    "Galiano Island": "Galiano Island",
    "Gallagher Lake": "Gallagher Lake",
    "Galloway": "Galloway",
    "Gambier Harbour": "Gambier Harbour",
    "Gang Ranch": "Gang Ranch",
    "Ganges": "Ganges",
    "Garbitt": "Garbitt",
    "Garden Bay": "Garden Bay",
    "Garden Village": "Garden Village",
    "Garibaldi": "Garibaldi",
    "Garibaldi Estates": "Garibaldi Estates",
    "Garibaldi Highlands": "Garibaldi Highlands",
    "Garnet Rock Trailer Court": "Garnet Rock Trailer Court",
    "Garnet Valley": "Garnet Valley",
    "Gates": "Gates",
    "Gateway": "Gateway",
    "Gellatly": "Gellatly",
    "Genelle": "Genelle",
    "Genoa Bay": "Genoa Bay",
    "George River": "George River",
    "Georgetown Mills": "Georgetown Mills",
    "Germansen Landing": "Germansen Landing",
    "Gerow Island": "Gerow Island",
    "Gerrard": "Gerrard",
    "Gibbs": "Gibbs",
    "Gibraltar": "Gibraltar",
    "Gibson Creek": "Gibson Creek",
    "Gibsons": "Gibsons",
    "Gifford": "Gifford",
    "Gill Island": "Gill Island",
    "Gillies Bay": "Gillies Bay",
    "Gilpin": "Gilpin",
    "Giscome": "Giscome",
    "Gitanyow": "Gitanyow",
    "Gitwinksihlkw": "Gitwinksihlkw",
    "Gitwinksihlkw 7": "Gitwinksihlkw 7",
    "Glacier": "Glacier",
    "Glacier Gulch": "Glacier Gulch",
    "Glade": "Glade",
    "Gladwin": "Gladwin",
    "Gleam": "Gleam",
    "Glen Fraser": "Glen Fraser",
    "Glen Lake": "Glen Lake",
    "Glen Valley": "Glen Valley",
    "Glen Vowell": "Glen Vowell",
    "Glenannan": "Glenannan",
    "Glenbank": "Glenbank",
    "Glenbrooke North": "Glenbrooke North",
    "Glendale": "Glendale",
    "Gleneagles": "Gleneagles",
    "Gleneden": "Gleneden",
    "Glenemma": "Glenemma",
    "Glenlily": "Glenlily",
    "Glenmerry": "Glenmerry",
    "Glenmore": "Glenmore",
    "Glenogle": "Glenogle",
    "Glenora": "Glenora",
    "Glenrosa": "Glenrosa",
    "Glentanna": "Glentanna",
    "Glimpse Lake": "Glimpse Lake",
    "Goat River": "Goat River",
    "Goatfell": "Goatfell",
    "Gold Bridge": "Gold Bridge",
    "Gold River": "Gold River",
    "Golden": "Golden",
    "Good Hope": "Good Hope",
    "Good Hope Lake": "Good Hope Lake",
    "Goodlow": "Goodlow",
    "Goose Bay": "Goose Bay",
    "Gordon River": "Gordon River",
    "Gorge Harbour": "Gorge Harbour",
    "Gosnell": "Gosnell",
    "Gossen Creek": "Gossen Creek",
    "Gossip Island": "Gossip Island",
    "Gower Point": "Gower Point",
    "Graham": "Graham",
    "Graham Island": "Graham Island",
    "Gramsons": "Gramsons",
    "Grand Forks": "Grand Forks",
    "Grand Haven": "Grand Haven",
    "Grand Rapids": "Grand Rapids",
    "Grand Trunk": "Grand Trunk",
    "Granduc": "Granduc",
    "Grandview Bench": "Grandview Bench",
    "Granisle": "Granisle",
    "Granite": "Granite",
    "Granite Bay": "Granite Bay",
    "Granite Falls": "Granite Falls",
    "Grant Brook": "Grant Brook",
    "Grantham": "Grantham",
    "Granthams Landing": "Granthams Landing",
    "Grasmere": "Grasmere",
    "Grassy Plains": "Grassy Plains",
    "Gravelle Ferry": "Gravelle Ferry",
    "Gray Creek": "Gray Creek",
    "Great Central": "Great Central",
    "Great Central Lake": "Great Central Lake",
    "Greata": "Greata",
    "Greeley": "Greeley",
    "Green Bay Resort": "Green Bay Resort",
    "Green Cove": "Green Cove",
    "Green River": "Green River",
    "Greendale": "Greendale",
    "Greenhills": "Greenhills",
    "Greening": "Greening",
    "Greenville": "Greenville",
    "Greenwood": "Greenwood",
    "Griffith": "Griffith",
    "Grindrod": "Grindrod",
    "Groundbirch": "Groundbirch",
    "Gun Lake": "Gun Lake",
    "Gundy": "Gundy",
    "Gutah": "Gutah",
    "Hagensborg": "Hagensborg",
    "Hagwilget": "Hagwilget",
    "Haig": "Haig",
    "Haina": "Haina",
    "Haisla": "Haisla",
    "Halfmoon Bay": "Halfmoon Bay",
    "Halfway Ranch": "Halfway Ranch",
    "Hall": "Hall",
    "Halliday": "Halliday",
    "Hanbury": "Hanbury",
    "Hanceville": "Hanceville",
    "Hansard": "Hansard",
    "Happy Valley": "Happy Valley",
    "Harbour Chines": "Harbour Chines",
    "Harbour Village": "Harbour Village",
    "Hardwicke Island": "Hardwicke Island",
    "Harmac": "Harmac",
    "Harmer": "Harmer",
    "Harrison Hot Springs": "Harrison Hot Springs",
    "Harrison Mills": "Harrison Mills",
    "Harrogate": "Harrogate",
    "Harrop": "Harrop",
    "Hart Highlands": "Hart Highlands",
    "Hartley Bay": "Hartley Bay",
    "Harvey": "Harvey",
    "Harwood Island": "Harwood Island",
    "Hasler Flat": "Hasler Flat",
    "Hastings-Sunrise": "Hastings-Sunrise",
    "Hatzic": "Hatzic",
    "Hawkins Lake Subdivision": "Hawkins Lake Subdivision",
    "Hawks": "Hawks",
    "Haysport": "Haysport",
    "Hayward": "Hayward",
    "Hazelmere": "Hazelmere",
    "Hazelton": "Hazelton",
    "Headquarters": "Headquarters",
    "Headwaters Ranch": "Headwaters Ranch",
    "Health Bay": "Health Bay",
    "Hecate": "Hecate",
    "Hector": "Hector",
    "Hedley": "Hedley",
    "Heffley Creek": "Heffley Creek",
    "Hells Gate": "Hells Gate",
    "Hemlock Valley": "Hemlock Valley",
    "Hendrix Lake": "Hendrix Lake",
    "Heriot Bay": "Heriot Bay",
    "Hernando Island": "Hernando Island",
    "Hesquiat": "Hesquiat",
    "Heydon Bay": "Heydon Bay",
    "Hickethier Ranch": "Hickethier Ranch",
    "Hicks": "Hicks",
    "Highlands": "Highlands",
    "Hillbank": "Hillbank",
    "Hillcrest": "Hillcrest",
    "Hilliers": "Hilliers",
    "Hills": "Hills",
    "Hippa": "Hippa",
    "Hiusta Meadow": "Hiusta Meadow",
    "Hixon": "Hixon",
    "Hkusam": "Hkusam",
    "Hodda": "Hodda",
    "Holachten 8": "Holachten 8",
    "Holberg": "Holberg",
    "Hollyburn": "Hollyburn",
    "Holmwood": "Holmwood",
    "Homfray Creek": "Homfray Creek",
    "Honeymoon Bay": "Honeymoon Bay",
    "Honeymoon Creek": "Honeymoon Creek",
    "Hope": "Hope",
    "Hope Bay": "Hope Bay",
    "Hope Island": "Hope Island",
    "Hopetown": "Hopetown",
    "Hopkins Landing": "Hopkins Landing",
    "Hornby Island": "Hornby Island",
    "Horse Creek": "Horse Creek",
    "Horsefly": "Horsefly",
    "Hosmer": "Hosmer",
    "Hospital Hill": "Hospital Hill",
    "Hot Springs Cove": "Hot Springs Cove",
    "Houston": "Houston",
    "Howser": "Howser",
    "Huble": "Huble",
    "Hudson's Hope": "Hudson's Hope",
    "Hulatt": "Hulatt",
    "Hulcross": "Hulcross",
    "Hullcar": "Hullcar",
    "Humpback Bay": "Humpback Bay",
    "Hunaechin Sechelt Band 11": "Hunaechin Sechelt Band 11",
    "Huntingdon": "Huntingdon",
    "Huntington": "Huntington",
    "Hunts Inlet": "Hunts Inlet",
    "Hupel": "Hupel",
    "Huscroft": "Huscroft",
    "Hutchinson": "Hutchinson",
    "Hutchison": "Hutchison",
    "Hutton": "Hutton",
    "Hyacinthe Bay": "Hyacinthe Bay",
    "Hyde Creek": "Hyde Creek",
    "Hydraulic": "Hydraulic",
    "Hyland Post": "Hyland Post",
    "Illecillewaet": "Illecillewaet",
    "Imperial Ranchettes": "Imperial Ranchettes",
    "Indian Rock": "Indian Rock",
    "Ingenika Mine": "Ingenika Mine",
    "Inkaneep": "Inkaneep",
    "Inkitsaph": "Inkitsaph",
    "Invermere": "Invermere",
    "Irvine": "Irvine",
    "Irvines Landing": "Irvines Landing",
    "Iskut": "Iskut",
    "Island Cache": "Island Cache",
    "Isle Pierre": "Isle Pierre",
    "Jackfish Lake Subdivision": "Jackfish Lake Subdivision",
    "Jackman": "Jackman",
    "Jackson Bay": "Jackson Bay",
    "Jacksons": "Jacksons",
    "Jade City": "Jade City",
    "Jaffray": "Jaffray",
    "Jaleslie": "Jaleslie",
    "James Island": "James Island",
    "Jayem": "Jayem",
    "Jedway": "Jedway",
    "Jellicoe": "Jellicoe",
    "Jersey": "Jersey",
    "Jervis Inlet": "Jervis Inlet",
    "Jesmond": "Jesmond",
    "Jeune Landing": "Jeune Landing",
    "Jim Smith Lake and Area": "Jim Smith Lake and Area",
    "Johnson": "Johnson",
    "Johnsons Landing": "Johnsons Landing",
    "Jordan River": "Jordan River",
    "June Springs Estates": "June Springs Estates",
    "Juniper Ridge": "Juniper Ridge",
    "Jura": "Jura",
    "Juskatla": "Juskatla",
    "Kahntah": "Kahntah",
    "Kahntah 3": "Kahntah 3",
    "Kaisun": "Kaisun",
    "Kakawis": "Kakawis",
    "Kalamalka": "Kalamalka",
    "Kaleden": "Kaleden",
    "Kaleva": "Kaleva",
    "Kallum": "Kallum",
    "Kamloops": "Kamloops",
    "Kanaka": "Kanaka",
    "Kanaka Bar": "Kanaka Bar",
    "Kaslo": "Kaslo",
    "Katz": "Katz",
    "Keating": "Keating",
    "Keats Island": "Keats Island",
    "Kedleston": "Kedleston",
    "Keefers": "Keefers",
    "Keekwillie Trailer Park": "Keekwillie Trailer Park",
    "Keithley Creek": "Keithley Creek",
    "Kelly Lake": "Kelly Lake",
    "Kelowna": "Kelowna",
    "Kemano": "Kemano",
    "Kemano Beach": "Kemano Beach",
    "Kendrick Camp": "Kendrick Camp",
    "Kennedy": "Kennedy",
    "Kent": "Kent",
    "Keremeos": "Keremeos",
    "Kerr Creek": "Kerr Creek",
    "Kersley": "Kersley",
    "Kettle Valley": "Kettle Valley",
    "Kidd": "Kidd",
    "Kilbella Bay": "Kilbella Bay",
    "Kildala Arm": "Kildala Arm",
    "Kildonan": "Kildonan",
    "Kilgard": "Kilgard",
    "Kilkerran": "Kilkerran",
    "Killiney Beach": "Killiney Beach",
    "Killy": "Killy",
    "Kimberley": "Kimberley",
    "Kimsquit": "Kimsquit",
    "Kincolith": "Kincolith",
    "Kingcome": "Kingcome",
    "Kingcome Inlet": "Kingcome Inlet",
    "Kingfisher": "Kingfisher",
    "Kingsgate": "Kingsgate",
    "Kingsvale": "Kingsvale",
    "Kinnaird": "Kinnaird",
    "Kiskatinaw": "Kiskatinaw",
    "Kispiox": "Kispiox",
    "Kispiox Valley": "Kispiox Valley",
    "Kissick": "Kissick",
    "Kitamaat Village": "Kitamaat Village",
    "Kitchener": "Kitchener",
    "Kitimat": "Kitimat",
    "Kitkatla": "Kitkatla",
    "Kitsault": "Kitsault",
    "Kitseguecla": "Kitseguecla",
    "Kitselas": "Kitselas",
    "Kitsumkalum": "Kitsumkalum",
    "Kitty Coleman": "Kitty Coleman",
    "Kitwanga": "Kitwanga",
    "Kiusta": "Kiusta",
    "Klaalth Sechelt Band 5": "Klaalth Sechelt Band 5",
    "Klayekwim Sechelt Band 6": "Klayekwim Sechelt Band 6",
    "Klayekwim Sechelt Band 6A": "Klayekwim Sechelt Band 6A",
    "Klayekwim Sechelt Band 7": "Klayekwim Sechelt Band 7",
    "Klayekwim Sechelt Band 8": "Klayekwim Sechelt Band 8",
    "Kleecoot": "Kleecoot",
    "Kleena Kleene": "Kleena Kleene",
    "Kleindale": "Kleindale",
    "Klemtu": "Klemtu",
    "Klua": "Klua",
    "Knockholt": "Knockholt",
    "Knutsford": "Knutsford",
    "Kobes": "Kobes",
    "Kokish": "Kokish",
    "Koksilah": "Koksilah",
    "Komo": "Komo",
    "Kootenay Bay": "Kootenay Bay",
    "Kootenay Crossing": "Kootenay Crossing",
    "Kootenay Landing": "Kootenay Landing",
    "Koster": "Koster",
    "Kragmont": "Kragmont",
    "Krestova": "Krestova",
    "Kuldo": "Kuldo",
    "Kulkayu 4": "Kulkayu 4",
    "Kung": "Kung",
    "Kuper Island": "Kuper Island",
    "Kuskonook": "Kuskonook",
    "Kwinitsa": "Kwinitsa",
    "Kye Bay": "Kye Bay",
    "Kyuquot": "Kyuquot",
    "Lac la Hache": "Lac la Hache",
    "Lac Le Jeune": "Lac Le Jeune",
    "Lachkaltsap 9": "Lachkaltsap 9",
    "Ladysmith": "Ladysmith",
    "Lafferty": "Lafferty",
    "Laidlaw": "Laidlaw",
    "Lakahahmen 11": "Lakahahmen 11",
    "Lake Buntzen": "Lake Buntzen",
    "Lake Country, District of": "Lake Country, District of",
    "Lake Cowichan": "Lake Cowichan",
    "Lake Errock": "Lake Errock",
    "Lake Kathlyn": "Lake Kathlyn",
    "Lakelse": "Lakelse",
    "Lakelse Lake": "Lakelse Lake",
    "Laketon": "Laketon",
    "Lakeview Heights": "Lakeview Heights",
    "Lamming Mills": "Lamming Mills",
    "Lang Bay": "Lang Bay",
    "Langdale": "Langdale",
    "Langford": "Langford",
    "Langley": "Langley",
    "Lantzville": "Lantzville",
    "Larch Hill": "Larch Hill",
    "Lardeau": "Lardeau",
    "Larkin": "Larkin",
    "Larsons Landing": "Larsons Landing",
    "Lasha": "Lasha",
    "Lasqueti": "Lasqueti",
    "Lasqueti Island": "Lasqueti Island",
    "Lauretta": "Lauretta",
    "Lavington": "Lavington",
    "Lawnhill": "Lawnhill",
    "Lax Kw'alaams": "Lax Kw'alaams",
    "Lazo": "Lazo",
    "Leanchoil": "Leanchoil",
    "Lebahdo": "Lebahdo",
    "Lee Creek": "Lee Creek",
    "Leechtown": "Leechtown",
    "Lees Corner": "Lees Corner",
    "Legrand": "Legrand",
    "Lejac": "Lejac",
    "Lemon Creek": "Lemon Creek",
    "Lemoray": "Lemoray",
    "Lempriere": "Lempriere",
    "Leo Creek": "Leo Creek",
    "Lexau Ranch": "Lexau Ranch",
    "Liard River": "Liard River",
    "Liard River 3": "Liard River 3",
    "Liersch": "Liersch",
    "Lighthouse Point": "Lighthouse Point",
    "Likely": "Likely",
    "Lillooet": "Lillooet",
    "Lily Lake": "Lily Lake",
    "Lime": "Lime",
    "Lincoln Park": "Lincoln Park",
    "Lindell Beach": "Lindell Beach",
    "Lindeman": "Lindeman",
    "Line Creek": "Line Creek",
    "Lions Bay": "Lions Bay",
    "Lister": "Lister",
    "Little Fort": "Little Fort",
    "Little River": "Little River",
    "Little Zeballos": "Little Zeballos",
    "Lockeport": "Lockeport",
    "Log Cabin": "Log Cabin",
    "Logan Lake": "Logan Lake",
    "Lone Butte": "Lone Butte",
    "Lone Prairie": "Lone Prairie",
    "Long Harbour": "Long Harbour",
    "Longbeach": "Longbeach",
    "Longworth": "Longworth",
    "Loon Lake": "Loon Lake",
    "Loon Lake Subdivision": "Loon Lake Subdivision",
    "Loos": "Loos",
    "Louis Creek": "Louis Creek",
    "Louise Island": "Louise Island",
    "Lower China Creek": "Lower China Creek",
    "Lower Nicola": "Lower Nicola",
    "Lower Post": "Lower Post",
    "Lubin": "Lubin",
    "Lucas": "Lucas",
    "Lucerne": "Lucerne",
    "Lulu 5": "Lulu 5",
    "Lumberton": "Lumberton",
    "Lumby": "Lumby",
    "Lund": "Lund",
    "Lust Subdivision": "Lust Subdivision",
    "Luxor": "Luxor",
    "Lyell Island": "Lyell Island",
    "Lynx Creek": "Lynx Creek",
    "Lytton": "Lytton",
    "Lytton 27B": "Lytton 27B",
    "Mabel Lake": "Mabel Lake",
    "Macalister": "Macalister",
    "Macdonald": "Macdonald",
    "Mackenzie": "Mackenzie",
    "Mackin": "Mackin",
    "MacNeill": "MacNeill",
    "Madeira Park": "Madeira Park",
    "Magic Lake Estates": "Magic Lake Estates",
    "Magna Bay": "Magna Bay",
    "Magnum Mine": "Magnum Mine",
    "Mahatta River": "Mahatta River",
    "Mahmalillikullah 1": "Mahmalillikullah 1",
    "Mahood Falls": "Mahood Falls",
    "Makinson": "Makinson",
    "Malahat": "Malahat",
    "Malakwa": "Malakwa",
    "Malcolm Island": "Malcolm Island",
    "Malibu": "Malibu",
    "Mamalilaculla": "Mamalilaculla",
    "Mammel Subdivision": "Mammel Subdivision",
    "Manning": "Manning",
    "Manning Park": "Manning Park",
    "Manson Creek": "Manson Creek",
    "Mansons Landing": "Mansons Landing",
    "Mapes": "Mapes",
    "Maple Bay": "Maple Bay",
    "Maple Ridge": "Maple Ridge",
    "Mara": "Mara",
    "Marblehead": "Marblehead",
    "Margaret Bay": "Margaret Bay",
    "Marguerite": "Marguerite",
    "Marigold": "Marigold",
    "Marilla": "Marilla",
    "Marktosis": "Marktosis",
    "Marne": "Marne",
    "Marron Valley": "Marron Valley",
    "Marsh Creek Area": "Marsh Creek Area",
    "Martel": "Martel",
    "Marten Lake": "Marten Lake",
    "Martin Prairie": "Martin Prairie",
    "Martin Valley": "Martin Valley",
    "Martinson": "Martinson",
    "Marysville": "Marysville",
    "Mason Creek": "Mason Creek",
    "Masset": "Masset",
    "Matilpi": "Matilpi",
    "Matsqui Main 2": "Matsqui Main 2",
    "Maurelle Island": "Maurelle Island",
    "Mayne Island": "Mayne Island",
    "Mayook": "Mayook",
    "McAbee": "McAbee",
    "McBride": "McBride",
    "McCabe": "McCabe",
    "McCall": "McCall",
    "McCalls Landing": "McCalls Landing",
    "McConnel": "McConnel",
    "McCracken": "McCracken",
    "McCulloch": "McCulloch",
    "McDame": "McDame",
    "McDonalds Landing": "McDonalds Landing",
    "McGillivray": "McGillivray",
    "McGregor": "McGregor",
    "McGuire": "McGuire",
    "McKearney Ranch": "McKearney Ranch",
    "McKinley Landing": "McKinley Landing",
    "McLean Ranch": "McLean Ranch",
    "McLeese Lake": "McLeese Lake",
    "McLeod": "McLeod",
    "McLeod Lake": "McLeod Lake",
    "McLeod Subdivision": "McLeod Subdivision",
    "McLure": "McLure",
    "McMillan Island 6": "McMillan Island 6",
    "McMurdo": "McMurdo",
    "McMurphy": "McMurphy",
    "McNab Creek": "McNab Creek",
    "Meachen": "Meachen",
    "Meadow Creek": "Meadow Creek",
    "Meadows": "Meadows",
    "Meares Island": "Meares Island",
    "Meem Quam Leese": "Meem Quam Leese",
    "Meldrum": "Meldrum",
    "Meldrum Creek": "Meldrum Creek",
    "Merritt": "Merritt",
    "Merton": "Merton",
    "Merville": "Merville",
    "Mesachie Lake": "Mesachie Lake",
    "Messiter": "Messiter",
    "Metchosin": "Metchosin",
    "Metlakatla": "Metlakatla",
    "Meziadin Junction": "Meziadin Junction",
    "Meziadin Subdivision": "Meziadin Subdivision",
    "Mica Creek": "Mica Creek",
    "Middlegate": "Middlegate",
    "Midway": "Midway",
    "Mile 19 Overhead": "Mile 19 Overhead",
    "Mile 422 Alaska Highway": "Mile 422 Alaska Highway",
    "Mile 62 1/2": "Mile 62 1/2",
    "Mill Bay": "Mill Bay",
    "Millers Landing": "Millers Landing",
    "Millstream": "Millstream",
    "Milnes Landing": "Milnes Landing",
    "Minaty Bay": "Minaty Bay",
    "Minstrel Island": "Minstrel Island",
    "Minto Landing": "Minto Landing",
    "Miocene": "Miocene",
    "Miracle Valley": "Miracle Valley",
    "Mirror Lake": "Mirror Lake",
    "Missezula Lake": "Missezula Lake",
    "Mission": "Mission",
    "Mission Island 2": "Mission Island 2",
    "Mitchell Bay": "Mitchell Bay",
    "Miworth": "Miworth",
    "Moberly": "Moberly",
    "Moberly Lake": "Moberly Lake",
    "Moffat": "Moffat",
    "Moha": "Moha",
    "Monias": "Monias",
    "Mons": "Mons",
    "Montague Harbour": "Montague Harbour",
    "Monte Creek": "Monte Creek",
    "Monte Lake": "Monte Lake",
    "Montney": "Montney",
    "Montrose": "Montrose",
    "Moose Heights": "Moose Heights",
    "Mooyah Bay": "Mooyah Bay",
    "Moran": "Moran",
    "Moresby Camp": "Moresby Camp",
    "Moresby Island": "Moresby Island",
    "Morey": "Morey",
    "Moricetown": "Moricetown",
    "Morrissey": "Morrissey",
    "Mount Baldy": "Mount Baldy",
    "Mount Currie": "Mount Currie",
    "Mount Lehman": "Mount Lehman",
    "Mount Robson": "Mount Robson",
    "Mountain Station": "Mountain Station",
    "Moyie": "Moyie",
    "Mud Bay": "Mud Bay",
    "Mud River": "Mud River",
    "Muncho Lake": "Muncho Lake",
    "Munro": "Munro",
    "Munroe": "Munroe",
    "Murdale": "Murdale",
    "Musgrave Landing": "Musgrave Landing",
    "Muskwa": "Muskwa",
    "Myra": "Myra",
    "Myrtle Point": "Myrtle Point",
    "Nadu": "Nadu",
    "Nahmint": "Nahmint",
    "Nahun": "Nahun",
    "Nakusp": "Nakusp",
    "Nalos Landing": "Nalos Landing",
    "Namu": "Namu",
    "Nanaimo": "Nanaimo",
    "Nanoose Bay": "Nanoose Bay",
    "Naramata": "Naramata",
    "Narcosli Creek": "Narcosli Creek",
    "Nasookin Road Subdivision": "Nasookin Road Subdivision",
    "Nass Camp": "Nass Camp",
    "Natal": "Natal",
    "Nazko": "Nazko",
    "Nechako": "Nechako",
    "Nechako Centre": "Nechako Centre",
    "Nedoats 11": "Nedoats 11",
    "Needles": "Needles",
    "Needley": "Needley",
    "Nelson": "Nelson",
    "Nelson Forks": "Nelson Forks",
    "Nelson Island": "Nelson Island",
    "Nelway": "Nelway",
    "Nemiah Valley": "Nemiah Valley",
    "New Aiyansh": "New Aiyansh",
    "New Barkerville": "New Barkerville",
    "New Bella Bella": "New Bella Bella",
    "New Brighton": "New Brighton",
    "New Clew": "New Clew",
    "New Denver": "New Denver",
    "New Hazelton": "New Hazelton",
    "New Settlement": "New Settlement",
    "New Westminster": "New Westminster",
    "Newcastle": "Newcastle",
    "Newgate": "Newgate",
    "Newlands": "Newlands",
    "Niagara": "Niagara",
    "Nichol": "Nichol",
    "Nicholson": "Nicholson",
    "Nicks Island": "Nicks Island",
    "Nicola": "Nicola",
    "Nicomen": "Nicomen",
    "Nig": "Nig",
    "Nigei Island": "Nigei Island",
    "Nimpkish": "Nimpkish",
    "Nimpkish Heights": "Nimpkish Heights",
    "Nimpo Lake": "Nimpo Lake",
    "Ninety Three Mile House": "Ninety Three Mile House",
    "Ninstints": "Ninstints",
    "Niteal": "Niteal",
    "Nootka": "Nootka",
    "Nootka Island": "Nootka Island",
    "Noralee": "Noralee",
    "Norgate": "Norgate",
    "Norlake": "Norlake",
    "North Bend": "North Bend",
    "North Bonaparte": "North Bonaparte",
    "North Bulkley": "North Bulkley",
    "North Campbell River": "North Campbell River",
    "North Cowichan": "North Cowichan",
    "North Galiano": "North Galiano",
    "North Kamloops": "North Kamloops",
    "North Nechako": "North Nechako",
    "North Pender Island": "North Pender Island",
    "North Pine": "North Pine",
    "North Poplar": "North Poplar",
    "North Saanich": "North Saanich",
    "North Star": "North Star",
    "North Vancouver": "North Vancouver",
    "Northfield": "Northfield",
    "Northridge": "Northridge",
    "Norton": "Norton",
    "Notch Hill": "Notch Hill",
    "Nuchatlitz": "Nuchatlitz",
    "Nukko Lake": "Nukko Lake",
    "Nulki": "Nulki",
    "Nursery": "Nursery",
    "Oak Bay": "Oak Bay",
    "Oak Hills": "Oak Hills",
    "Oalthkyim Sechelt Band 4": "Oalthkyim Sechelt Band 4",
    "Oasis": "Oasis",
    "Ocean Falls": "Ocean Falls",
    "Ocean Grove": "Ocean Grove",
    "O'Dell": "O'Dell",
    "Ogden": "Ogden",
    "Okanagan Centre": "Okanagan Centre",
    "Okanagan Falls": "Okanagan Falls",
    "Okanagan Landing": "Okanagan Landing",
    "Okanagan Mission": "Okanagan Mission",
    "O'Keefe": "O'Keefe",
    "Olalla": "Olalla",
    "Old Bella Bella": "Old Bella Bella",
    "Old Fort": "Old Fort",
    "Old Remo": "Old Remo",
    "Old Town": "Old Town",
    "Oliver": "Oliver",
    "Oliver's Landing": "Oliver's Landing",
    "Olson": "Olson",
    "Onward": "Onward",
    "Oona River": "Oona River",
    "Ootischenia": "Ootischenia",
    "Ootischenia Flats": "Ootischenia Flats",
    "Ootsa Lake": "Ootsa Lake",
    "Opitsat": "Opitsat",
    "Osborn": "Osborn",
    "Osborn Bay": "Osborn Bay",
    "Osland": "Osland",
    "Osoyoos": "Osoyoos",
    "Osprey Lake": "Osprey Lake",
    "Othello": "Othello",
    "Otter Bay": "Otter Bay",
    "Ottertail": "Ottertail",
    "Otway": "Otway",
    "Oweekeno": "Oweekeno",
    "Owen Bay": "Owen Bay",
    "Owl Creek": "Owl Creek",
    "Oyama": "Oyama",
    "Oyster River": "Oyster River",
    "Pacific": "Pacific",
    "Pahas 3": "Pahas 3",
    "Paldi": "Paldi",
    "Palling": "Palling",
    "Palling 1A": "Palling 1A",
    "Palliser": "Palliser",
    "Panorama": "Panorama",
    "Panorama Subdivision": "Panorama Subdivision",
    "Paradise Point": "Paradise Point",
    "Paradise Valley": "Paradise Valley",
    "Park Siding": "Park Siding",
    "Parkland": "Parkland",
    "Parksville": "Parksville",
    "Parson": "Parson",
    "Pasley Island": "Pasley Island",
    "Pass Creek": "Pass Creek",
    "Passmore": "Passmore",
    "Paterson": "Paterson",
    "Paul Lake": "Paul Lake",
    "Paulson": "Paulson",
    "Pavey": "Pavey",
    "Pavilion": "Pavilion",
    "Paxton Valley": "Paxton Valley",
    "Paykulkum Sechelt Band 14": "Paykulkum Sechelt Band 14",
    "Peachland": "Peachland",
    "Peejay": "Peejay",
    "Pemberton": "Pemberton",
    "Pemberton Heights": "Pemberton Heights",
    "Pemberton Meadows": "Pemberton Meadows",
    "Pender Island": "Pender Island",
    "Pendleton Bay": "Pendleton Bay",
    "Pennington": "Pennington",
    "Penny": "Penny",
    "Penticton": "Penticton",
    "Perow": "Perow",
    "Perrys": "Perrys",
    "Peterson": "Peterson",
    "Phelan": "Phelan",
    "Phillips Arm": "Phillips Arm",
    "Phoenix": "Phoenix",
    "Piers Island": "Piers Island",
    "Pilot Bay": "Pilot Bay",
    "Pinantan Lake": "Pinantan Lake",
    "Pinchi": "Pinchi",
    "Pinchi Lake": "Pinchi Lake",
    "Pine Valley": "Pine Valley",
    "Pinegrove": "Pinegrove",
    "Pinesul": "Pinesul",
    "Pineview": "Pineview",
    "Pinewood Subdivision": "Pinewood Subdivision",
    "Pink Mountain": "Pink Mountain",
    "Pioneer Mine": "Pioneer Mine",
    "Pitman": "Pitman",
    "Pitquah": "Pitquah",
    "Pitt Meadows": "Pitt Meadows",
    "Pixie Beach": "Pixie Beach",
    "Playmor Junction": "Playmor Junction",
    "Pleasant Camp": "Pleasant Camp",
    "Plumper Harbour": "Plumper Harbour",
    "Point Holmes": "Point Holmes",
    "Polley": "Polley",
    "Pope Landing": "Pope Landing",
    "Popkum": "Popkum",
    "Poplar Creek": "Poplar Creek",
    "Poplar Grove": "Poplar Grove",
    "Porcher Island": "Porcher Island",
    "Porpoise Bay": "Porpoise Bay",
    "Port Alberni": "Port Alberni",
    "Port Albion": "Port Albion",
    "Port Alice": "Port Alice",
    "Port Clements": "Port Clements",
    "Port Coquitlam": "Port Coquitlam",
    "Port Desire": "Port Desire",
    "Port Douglas": "Port Douglas",
    "Port Edward": "Port Edward",
    "Port Essington": "Port Essington",
    "Port Hammond - Haney": "Port Hammond - Haney",
    "Port Hardy": "Port Hardy",
    "Port Kells": "Port Kells",
    "Port McNeill": "Port McNeill",
    "Port Mellon": "Port Mellon",
    "Port Moody": "Port Moody",
    "Port Neville": "Port Neville",
    "Port Renfrew": "Port Renfrew",
    "Port Simpson 1": "Port Simpson 1",
    "Port Washington": "Port Washington",
    "Porteau": "Porteau",
    "Porteous": "Porteous",
    "Porter Landing": "Porter Landing",
    "Portland Island": "Portland Island",
    "Porto Rico": "Porto Rico",
    "Poser": "Poser",
    "Postill": "Postill",
    "Potter": "Potter",
    "Pouce Coupe": "Pouce Coupe",
    "Poupore": "Poupore",
    "Powell River": "Powell River",
    "Powers Addition": "Powers Addition",
    "Prairie Valley": "Prairie Valley",
    "Premier": "Premier",
    "Premier Lake": "Premier Lake",
    "Prespatou": "Prespatou",
    "Pressy Lake": "Pressy Lake",
    "Prince George": "Prince George",
    "Prince Rupert": "Prince Rupert",
    "Princeton": "Princeton",
    "Pritchard": "Pritchard",
    "Procter": "Procter",
    "Progress": "Progress",
    "Promontory": "Promontory",
    "Prophet River": "Prophet River",
    "Prospect Lake": "Prospect Lake",
    "Protection Island": "Protection Island",
    "Punchaw": "Punchaw",
    "Puntledge": "Puntledge",
    "Purden Lake": "Purden Lake",
    "Pyramid": "Pyramid",
    "Quadra Island": "Quadra Island",
    "Qualicum Bay": "Qualicum Bay",
    "Qualicum Beach": "Qualicum Beach",
    "Quamichan": "Quamichan",
    "Quathiaski Cove": "Quathiaski Cove",
    "Quatsino": "Quatsino",
    "Quaw": "Quaw",
    "Queen Charlotte City": "Queen Charlotte City",
    "Queens Bay": "Queens Bay",
    "Queens Cove": "Queens Cove",
    "Quesnel": "Quesnel",
    "Quesnel Canyon": "Quesnel Canyon",
    "Quesnel Forks": "Quesnel Forks",
    "Quesnel View": "Quesnel View",
    "Quick": "Quick",
    "Quilchena": "Quilchena",
    "Quinsam": "Quinsam",
    "Radium": "Radium",
    "Radium Hot Springs": "Radium Hot Springs",
    "Raft River": "Raft River",
    "Rail Lake": "Rail Lake",
    "Rainy Hollow": "Rainy Hollow",
    "Ranchero": "Ranchero",
    "Raspberry": "Raspberry",
    "Raush Valley": "Raush Valley",
    "Rayleigh": "Rayleigh",
    "Read Island": "Read Island",
    "Reclaim": "Reclaim",
    "Red Bluff": "Red Bluff",
    "Red Mountain": "Red Mountain",
    "Red Pass": "Red Pass",
    "Red Rock": "Red Rock",
    "Red Rose": "Red Rose",
    "Redgrave": "Redgrave",
    "Redroofs": "Redroofs",
    "Redstone": "Redstone",
    "Refuge Cove": "Refuge Cove",
    "Reid Lake": "Reid Lake",
    "Remac": "Remac",
    "Remo": "Remo",
    "Renata": "Renata",
    "Retallack": "Retallack",
    "Retaskit": "Retaskit",
    "Revelstoke": "Revelstoke",
    "Rhone": "Rhone",
    "Rich Bar": "Rich Bar",
    "Richmond": "Richmond",
    "Rider": "Rider",
    "Ridgedale": "Ridgedale",
    "Ridley": "Ridley",
    "Riley": "Riley",
    "Riondel": "Riondel",
    "Riske Creek": "Riske Creek",
    "Ritchie": "Ritchie",
    "River Jordan": "River Jordan",
    "River Springs": "River Springs",
    "Rivers Inlet": "Rivers Inlet",
    "Riverside": "Riverside",
    "Rivervale": "Rivervale",
    "Roberts Creek": "Roberts Creek",
    "Robin Creek": "Robin Creek",
    "Robson": "Robson",
    "Robson West": "Robson West",
    "Rock Bay": "Rock Bay",
    "Rock Creek": "Rock Creek",
    "Rockyview": "Rockyview",
    "Roe Lake": "Roe Lake",
    "Rogers": "Rogers",
    "Rogers Pass": "Rogers Pass",
    "Rolla": "Rolla",
    "Rolling Hills Park": "Rolling Hills Park",
    "Roosville": "Roosville",
    "Rose Harbour": "Rose Harbour",
    "Rose Lake": "Rose Lake",
    "Rose Prairie": "Rose Prairie",
    "Rosebery": "Rosebery",
    "Rosedale": "Rosedale",
    "Ross Peak": "Ross Peak",
    "Ross Spur": "Ross Spur",
    "Rossland": "Rossland",
    "Rosswood": "Rosswood",
    "Round Lake": "Round Lake",
    "Round Prairie": "Round Prairie",
    "Roy": "Roy",
    "Royston": "Royston",
    "Ruby Creek": "Ruby Creek",
    "Rumble Beach": "Rumble Beach",
    "Rupert": "Rupert",
    "Rushmere": "Rushmere",
    "Rutland": "Rutland",
    "Ryan": "Ryan",
    "Ryder Lake": "Ryder Lake",
    "Rykerts": "Rykerts",
    "Saanich": "Saanich",
    "Saanichton": "Saanichton",
    "Saddle Rock": "Saddle Rock",
    "Sahali": "Sahali",
    "Sahara Heights": "Sahara Heights",
    "Sahtlam": "Sahtlam",
    "Sallahlus Sechelt Band 20": "Sallahlus Sechelt Band 20",
    "Sallahlus Sechelt Band 20A": "Sallahlus Sechelt Band 20A",
    "Salmo": "Salmo",
    "Salmon Arm": "Salmon Arm",
    "Salmon Valley": "Salmon Valley",
    "Saloon": "Saloon",
    "Salt Spring Island": "Salt Spring Island",
    "Saltair": "Saltair",
    "Saltery Bay": "Saltery Bay",
    "Salvus": "Salvus",
    "Samuel Island": "Samuel Island",
    "San Josef": "San Josef",
    "Sanca": "Sanca",
    "Sanderson Site": "Sanderson Site",
    "Sandon": "Sandon",
    "Sandspit": "Sandspit",
    "Sandwick": "Sandwick",
    "Sandy Point": "Sandy Point",
    "Saratoga Beach": "Saratoga Beach",
    "Sardis": "Sardis",
    "Sarita": "Sarita",
    "Saseenos": "Saseenos",
    "Saturna Island": "Saturna Island",
    "Saughanaught Sechelt Band 22": "Saughanaught Sechelt Band 22",
    "Savary Island": "Savary Island",
    "Savona": "Savona",
    "Savory": "Savory",
    "Sawquamain Sechelt Band 19A": "Sawquamain Sechelt Band 19A",
    "Sayward": "Sayward",
    "Scotch Creek": "Scotch Creek",
    "Scotia Bay": "Scotia Bay",
    "Scott Cove": "Scott Cove",
    "Scotty Creek": "Scotty Creek",
    "Seaford": "Seaford",
    "Seal Bay Subdivision": "Seal Bay Subdivision",
    "Seaside Park": "Seaside Park",
    "Sechelt": "Sechelt",
    "Sechelt Indian Government District": "Sechelt Indian Government District",
    "Sechelt Sechelt Band 2": "Sechelt Sechelt Band 2",
    "Secret Cove": "Secret Cove",
    "Seddall": "Seddall",
    "Seeney": "Seeney",
    "Sekaleton Sechelt Band 21": "Sekaleton Sechelt Band 21",
    "Sekaleton Sechelt Band 21A": "Sekaleton Sechelt Band 21A",
    "Selma Park": "Selma Park",
    "Semlin": "Semlin",
    "Septimus": "Septimus",
    "Seton": "Seton",
    "Seton Portage": "Seton Portage",
    "Seven Mile Corner": "Seven Mile Corner",
    "Seventy Mile House": "Seventy Mile House",
    "Sewall": "Sewall",
    "Sewell Inlet": "Sewell Inlet",
    "Seymour Arm": "Seymour Arm",
    "Seymour Inlet": "Seymour Inlet",
    "Seymour Lake": "Seymour Lake",
    "Shady Valley": "Shady Valley",
    "Shalalth": "Shalalth",
    "Shames": "Shames",
    "Shannon": "Shannon",
    "Shannon Bay": "Shannon Bay",
    "Shannon Creek Sechelt Band 28": "Shannon Creek Sechelt Band 28",
    "Shawl Bay": "Shawl Bay",
    "Shawnigan Lake": "Shawnigan Lake",
    "Shearer Dale": "Shearer Dale",
    "Shearwater": "Shearwater",
    "Shelley": "Shelley",
    "Shelter Bay": "Shelter Bay",
    "Shelter Point": "Shelter Point",
    "Sheraton": "Sheraton",
    "Shere": "Shere",
    "Sheridan Lake": "Sheridan Lake",
    "Sheslay": "Sheslay",
    "Shingle Creek": "Shingle Creek",
    "Shirley": "Shirley",
    "Shoreacres": "Shoreacres",
    "Shoreholme": "Shoreholme",
    "Shulus": "Shulus",
    "Shushartie": "Shushartie",
    "Shuswap": "Shuswap",
    "Shuswap Falls": "Shuswap Falls",
    "Shutty Bench": "Shutty Bench",
    "Sicamous": "Sicamous",
    "Sidley": "Sidley",
    "Sidney": "Sidney",
    "Sikanni": "Sikanni",
    "Sikanni Chief": "Sikanni Chief",
    "Silica": "Silica",
    "Silver Creek": "Silver Creek",
    "Silver Lake": "Silver Lake",
    "Silver River": "Silver River",
    "Silverdale": "Silverdale",
    "Silverhill": "Silverhill",
    "Silverton": "Silverton",
    "Simpson Ranch": "Simpson Ranch",
    "Sinclair Mills": "Sinclair Mills",
    "Sinkut River": "Sinkut River",
    "Sirdar": "Sirdar",
    "Six Mile Point": "Six Mile Point",
    "Skedans": "Skedans",
    "Skeena": "Skeena",
    "Skeena Crossing": "Skeena Crossing",
    "Skidegate": "Skidegate",
    "Skidegate Landing": "Skidegate Landing",
    "Skooks Landing": "Skooks Landing",
    "Skookumchuck": "Skookumchuck",
    "Skookumchuck Sechelt Band 27": "Skookumchuck Sechelt Band 27",
    "Skoonka": "Skoonka",
    "Skwawkweehm Sechelt Band 17": "Skwawkweehm Sechelt Band 17",
    "Skweahm 10": "Skweahm 10",
    "Slaterville": "Slaterville",
    "Slayathlum Sechelt Band 16": "Slayathlum Sechelt Band 16",
    "Slesse Park": "Slesse Park",
    "Sliammon": "Sliammon",
    "Slocan": "Slocan",
    "Slocan Park": "Slocan Park",
    "Smeshalin Sechelt Band 18": "Smeshalin Sechelt Band 18",
    "Smith River": "Smith River",
    "Smithers": "Smithers",
    "Smithers Landing": "Smithers Landing",
    "Snake 5": "Snake 5",
    "Snake River": "Snake River",
    "Snyder": "Snyder",
    "Soames Point": "Soames Point",
    "Sockeye": "Sockeye",
    "Soda Creek": "Soda Creek",
    "Sointula": "Sointula",
    "Solly": "Solly",
    "Solsqua": "Solsqua",
    "Somenos": "Somenos",
    "Sonora Island": "Sonora Island",
    "Sooke": "Sooke",
    "Sorrento": "Sorrento",
    "South Bentinck": "South Bentinck",
    "South Canoe": "South Canoe",
    "South Dawson": "South Dawson",
    "South Fort George": "South Fort George",
    "South Hazelton": "South Hazelton",
    "South Lakeside": "South Lakeside",
    "South Lakeside (Williams Lake)": "South Lakeside (Williams Lake)",
    "South Pender Island": "South Pender Island",
    "South Poplar": "South Poplar",
    "South Shalalth": "South Shalalth",
    "South Slocan": "South Slocan",
    "South Slope": "South Slope",
    "South Sumas": "South Sumas",
    "South Taylor": "South Taylor",
    "South Thormanby Island": "South Thormanby Island",
    "South Wellington": "South Wellington",
    "Southbank": "Southbank",
    "Soyandostar 2": "Soyandostar 2",
    "Spallumcheen": "Spallumcheen",
    "Sparwood": "Sparwood",
    "Spatsum": "Spatsum",
    "Spences Bridge": "Spences Bridge",
    "Sperling": "Sperling",
    "Spicer": "Spicer",
    "Spillamacheen": "Spillamacheen",
    "Springfield Ranch": "Springfield Ranch",
    "Springhouse": "Springhouse",
    "Sproat Lake": "Sproat Lake",
    "Sproatt": "Sproatt",
    "Sproule Creek": "Sproule Creek",
    "Spur Valley Subdivision": "Spur Valley Subdivision",
    "Spuzzum": "Spuzzum",
    "Squamish": "Squamish",
    "Squawkum Creek 3": "Squawkum Creek 3",
    "Squeah": "Squeah",
    "Squilax": "Squilax",
    "Squirrel Cove": "Squirrel Cove",
    "St. Andrews": "St. Andrews",
    "St. Eugene Mission": "St. Eugene Mission",
    "St. Ives": "St. Ives",
    "St. Joseph Mission": "St. Joseph Mission",
    "St. Mary Lake": "St. Mary Lake",
    "St. Vincent Bay": "St. Vincent Bay",
    "Stanley": "Stanley",
    "Star Subdivision": "Star Subdivision",
    "Starks": "Starks",
    "Stave Falls": "Stave Falls",
    "Steamboat": "Steamboat",
    "Steelhead": "Steelhead",
    "Stellako": "Stellako",
    "Stephen": "Stephen",
    "Stepping Stones Estates": "Stepping Stones Estates",
    "Stewardson Inlet": "Stewardson Inlet",
    "Stewart": "Stewart",
    "Stikine": "Stikine",
    "Still Creek": "Still Creek",
    "Stillwater": "Stillwater",
    "Stockett": "Stockett",
    "Stoner": "Stoner",
    "Stones Bay": "Stones Bay",
    "Stoney Creek": "Stoney Creek",
    "Stories Beach": "Stories Beach",
    "Stout": "Stout",
    "Straiton": "Straiton",
    "Strathcona Lodge": "Strathcona Lodge",
    "Strathnaver": "Strathnaver",
    "Streatham": "Streatham",
    "Stuart Island": "Stuart Island",
    "Stuart River": "Stuart River",
    "Stuie": "Stuie",
    "Stump Lake": "Stump Lake",
    "Sturdies Bay": "Sturdies Bay",
    "Suahbin Sechelt Band 19": "Suahbin Sechelt Band 19",
    "Sugarcane": "Sugarcane",
    "Sullivan Bay": "Sullivan Bay",
    "Summerland": "Summerland",
    "Summit Lake": "Summit Lake",
    "Sun Peaks": "Sun Peaks",
    "Sundance": "Sundance",
    "Sundance Subdivision": "Sundance Subdivision",
    "Sunningdale": "Sunningdale",
    "Sunnybrae": "Sunnybrae",
    "Sunnyside": "Sunnyside",
    "Sunrise Valley": "Sunrise Valley",
    "Sunset Beach": "Sunset Beach",
    "Sunset Prairie": "Sunset Prairie",
    "Sunshine Bay": "Sunshine Bay",
    "Sunshine Valley": "Sunshine Valley",
    "Suquash": "Suquash",
    "Surge Narrows": "Surge Narrows",
    "Surprise": "Surprise",
    "Surrey": "Surrey",
    "Swansea": "Swansea",
    "Swartz Bay": "Swartz Bay",
    "Swaycalse Sechelt Band 3": "Swaycalse Sechelt Band 3",
    "Swaywelat Sechelt Band 12": "Swaywelat Sechelt Band 12",
    "Sweetsbridge": "Sweetsbridge",
    "Sweetwater": "Sweetwater",
    "Swift": "Swift",
    "Swiftwater": "Swiftwater",
    "Sydney Island": "Sydney Island",
    "Ta Ta Creek": "Ta Ta Creek",
    "Tabor": "Tabor",
    "Tacheeda": "Tacheeda",
    "Tachie": "Tachie",
    "Tadanac": "Tadanac",
    "Taft": "Taft",
    "Taghum": "Taghum",
    "Tahltan": "Tahltan",
    "Tahsis": "Tahsis",
    "Takla Landing": "Takla Landing",
    "Taku": "Taku",
    "Takysie Lake": "Takysie Lake",
    "Tallheo": "Tallheo",
    "Tamarack": "Tamarack",
    "Tamarisk": "Tamarisk",
    "Tantalus Acres": "Tantalus Acres",
    "Tanu": "Tanu",
    "Tappen": "Tappen",
    "Tarrys": "Tarrys",
    "Tasu": "Tasu",
    "Tatalrose": "Tatalrose",
    "Tatla Lake": "Tatla Lake",
    "Tatlow": "Tatlow",
    "Tatogga": "Tatogga",
    "Tatton": "Tatton",
    "Taverna": "Taverna",
    "Taylor": "Taylor",
    "Tchahchelailthtenum Sechelt Band 10": "Tchahchelailthtenum Sechelt Band 10",
    "Tchesinkut Lake": "Tchesinkut Lake",
    "Teakerne Arm": "Teakerne Arm",
    "Teko": "Teko",
    "Telachick": "Telachick",
    "Telegraph Cove": "Telegraph Cove",
    "Telegraph Creek": "Telegraph Creek",
    "Telkwa": "Telkwa",
    "Ten Mile Lake": "Ten Mile Lake",
    "Terrace": "Terrace",
    "Tete Jaune": "Tete Jaune",
    "Tete Jaune Cache": "Tete Jaune Cache",
    "Texada Island": "Texada Island",
    "Theodosia Arm": "Theodosia Arm",
    "Thetis Island": "Thetis Island",
    "Thompson": "Thompson",
    "Thompson River Estates": "Thompson River Estates",
    "Thompson Sound": "Thompson Sound",
    "Thornhill": "Thornhill",
    "Three Forks": "Three Forks",
    "Three Valley": "Three Valley",
    "Thrums": "Thrums",
    "Thunder River": "Thunder River",
    "Thunderbird": "Thunderbird",
    "Thurlow": "Thurlow",
    "Thurston Harbour": "Thurston Harbour",
    "Tibbets": "Tibbets",
    "Tiilis Landing": "Tiilis Landing",
    "Tillicum": "Tillicum",
    "Tintagel": "Tintagel",
    "Tipella": "Tipella",
    "Tisdall": "Tisdall",
    "Tlell": "Tlell",
    "Toad River": "Toad River",
    "Toby Creek": "Toby Creek",
    "Tochty": "Tochty",
    "Tofino": "Tofino",
    "Toketic": "Toketic",
    "Tomslake": "Tomslake",
    "Topley": "Topley",
    "Torrent": "Torrent",
    "Towdystan": "Towdystan",
    "Tower Lake": "Tower Lake",
    "Townsend": "Townsend",
    "Tracard": "Tracard",
    "Traders Cove": "Traders Cove",
    "Trafalgar": "Trafalgar",
    "Trail": "Trail",
    "Tranquille": "Tranquille",
    "Tremblay": "Tremblay",
    "Trembleur": "Trembleur",
    "Trepanier": "Trepanier",
    "Trevor Channel": "Trevor Channel",
    "Trinity Valley": "Trinity Valley",
    "Troup": "Troup",
    "Trout Creek": "Trout Creek",
    "Trout Lake": "Trout Lake",
    "Trutch": "Trutch",
    "Tsawcome Sechelt Band 1": "Tsawcome Sechelt Band 1",
    "Tsawwassen Beach": "Tsawwassen Beach",
    "Tsay Keh Dene": "Tsay Keh Dene",
    "Tsimpsean 2 North Part": "Tsimpsean 2 North Part",
    "Tsolum River": "Tsolum River",
    "Tsooahdie Sechelt Band 15": "Tsooahdie Sechelt Band 15",
    "Tulameen": "Tulameen",
    "Tulsequah": "Tulsequah",
    "Tumbler Ridge": "Tumbler Ridge",
    "Tupper": "Tupper",
    "Turner Subdivision": "Turner Subdivision",
    "Turtle Valley": "Turtle Valley",
    "Tuwanek": "Tuwanek",
    "Twidwell Bend": "Twidwell Bend",
    "Twin Bays": "Twin Bays",
    "Twin Butte": "Twin Butte",
    "Twin Creeks": "Twin Creeks",
    "Twin Islands": "Twin Islands",
    "Two Mile": "Two Mile",
    "Two Mile Hazelton": "Two Mile Hazelton",
    "Two Rivers": "Two Rivers",
    "Tye": "Tye",
    "Tyee": "Tyee",
    "Tzouhalem": "Tzouhalem",
    "Tzuhalem": "Tzuhalem",
    "Ucluelet": "Ucluelet",
    "Ulkatcho": "Ulkatcho",
    "Union Bay": "Union Bay",
    "Upper Bench": "Upper Bench",
    "Upper China Creek": "Upper China Creek",
    "Upper Cutbank": "Upper Cutbank",
    "Upper Fraser": "Upper Fraser",
    "Upper Halfway": "Upper Halfway",
    "Upper Sumas 6": "Upper Sumas 6",
    "Urling": "Urling",
    "Urquhart": "Urquhart",
    "Usk": "Usk",
    "Valdes Island": "Valdes Island",
    "Valemount": "Valemount",
    "Valhalla": "Valhalla",
    "Valley View": "Valley View",
    "Valleycliffe": "Valleycliffe",
    "Valleyview": "Valleyview",
    "Vallican": "Vallican",
    "Van Anda": "Van Anda",
    "Vancouver": "Vancouver",
    "Vanderhoof": "Vanderhoof",
    "Vanway": "Vanway",
    "Vargas Island": "Vargas Island",
    "Vaseaux Lake": "Vaseaux Lake",
    "Vaucroft Beach": "Vaucroft Beach",
    "Vavenby": "Vavenby",
    "Vedder Crossing": "Vedder Crossing",
    "Vermilion Crossing": "Vermilion Crossing",
    "Vernon": "Vernon",
    "Vesuvius": "Vesuvius",
    "Victoria": "Victoria",
    "Victoria Lake": "Victoria Lake",
    "Vidette": "Vidette",
    "View Royal": "View Royal",
    "Vinsulla": "Vinsulla",
    "Von Zuben": "Von Zuben",
    "Vye": "Vye",
    "Wabi": "Wabi",
    "Wabron": "Wabron",
    "Wadhams": "Wadhams",
    "Waglisla": "Waglisla",
    "Wagner Ranch": "Wagner Ranch",
    "Wakely": "Wakely",
    "Walcott": "Walcott",
    "Walhachin": "Walhachin",
    "Walker": "Walker",
    "Walkers": "Walkers",
    "Wall Beach": "Wall Beach",
    "Waneta": "Waneta",
    "Wanklyn": "Wanklyn",
    "Wardner": "Wardner",
    "Ware": "Ware",
    "Warfield": "Warfield",
    "Warner Bay": "Warner Bay",
    "Wasa": "Wasa",
    "Wasa Lake": "Wasa Lake",
    "Watson": "Watson",
    "Watson Island": "Watson Island",
    "Websters Corners": "Websters Corners",
    "Wedeene": "Wedeene",
    "Wedge": "Wedge",
    "Wedgwood": "Wedgwood",
    "Weewanie": "Weewanie",
    "Welcome Beach": "Welcome Beach",
    "Wellington": "Wellington",
    "Wells": "Wells",
    "Weneez": "Weneez",
    "West Bench": "West Bench",
    "West Fernie": "West Fernie",
    "West Heights": "West Heights",
    "West Kelowna": "West Kelowna",
    "West Landing": "West Landing",
    "West Mara Lake": "West Mara Lake",
    "West Midway": "West Midway",
    "West Sechelt": "West Sechelt",
    "West Thurlow Island": "West Thurlow Island",
    "West Trail": "West Trail",
    "West Vancouver": "West Vancouver",
    "Westbank": "Westbank",
    "Westbridge": "Westbridge",
    "Westholme": "Westholme",
    "Westley": "Westley",
    "Westply": "Westply",
    "Westside": "Westside",
    "Westsyde": "Westsyde",
    "Westview": "Westview",
    "Westwold": "Westwold",
    "Whaletown": "Whaletown",
    "Whiplash Ranch": "Whiplash Ranch",
    "Whisky Creek": "Whisky Creek",
    "Whistler": "Whistler",
    "Whistler Creek": "Whistler Creek",
    "White Lake": "White Lake",
    "White Pass": "White Pass",
    "White Rock": "White Rock",
    "Whitecroft": "Whitecroft",
    "Whonnock": "Whonnock",
    "Whyac": "Whyac",
    "Wildwood": "Wildwood",
    "Wildwood Subdivision": "Wildwood Subdivision",
    "Wiley": "Wiley",
    "Williams Beach": "Williams Beach",
    "Williams Lake": "Williams Lake",
    "Williams Landing": "Williams Landing",
    "Williamsons Landing": "Williamsons Landing",
    "Willow Brook": "Willow Brook",
    "Willow Flats": "Willow Flats",
    "Willow Point": "Willow Point",
    "Willow Ranch": "Willow Ranch",
    "Willow River": "Willow River",
    "Willow Valley": "Willow Valley",
    "Willowbrook": "Willowbrook",
    "Willowvale": "Willowvale",
    "Wilmer": "Wilmer",
    "Wilson Creek": "Wilson Creek",
    "Wilson Landing": "Wilson Landing",
    "Windermere": "Windermere",
    "Windy": "Windy",
    "Winfield": "Winfield",
    "Wingdam": "Wingdam",
    "Winlaw": "Winlaw",
    "Winter Harbour": "Winter Harbour",
    "Wistaria": "Wistaria",
    "Wolf": "Wolf",
    "Wolfenden": "Wolfenden",
    "Wolverine": "Wolverine",
    "Wonowon": "Wonowon",
    "Woodcock": "Woodcock",
    "Woodfibre": "Woodfibre",
    "Woodmere": "Woodmere",
    "Woodpecker": "Woodpecker",
    "Woods Landing": "Woods Landing",
    "Woodsdale": "Woodsdale",
    "Worth": "Worth",
    "Woss": "Woss",
    "Wright": "Wright",
    "Wycliffe": "Wycliffe",
    "Wyman": "Wyman",
    "Wynndel": "Wynndel",
    "Yaculta": "Yaculta",
    "Yahk": "Yahk",
    "Yaku": "Yaku",
    "Yale": "Yale",
    "Yankee Flats": "Yankee Flats",
    "Yarksis": "Yarksis",
    "Yarrow": "Yarrow",
    "Yekooche": "Yekooche",
    "Yellow Point": "Yellow Point",
    "Yellowhead": "Yellowhead",
    "Yennadon": "Yennadon",
    "Ymir": "Ymir",
    "Yoho": "Yoho",
    "Youbou": "Youbou",
    "Yreka": "Yreka",
    "Yuquot": "Yuquot",
    "Zamora": "Zamora",
    "Zeballos": "Zeballos",
    "Zeke": "Zeke",
    "Zincton": "Zincton",
}

language_map = {"IELTS": "IELTS", "CELPIP": "CELPIP", "TEF": "TEF", "TCF": "TCF"}

bc_city_map = {
    "100 Mile House": "100 Mile House",
    "105 Mile House": "105 Mile House",
    "108 Mile Ranch": "108 Mile Ranch",
    "111 Mile House": "111 Mile House",
    "114 Mile House": "114 Mile House",
    "12 Mile": "12 Mile",
    "122 Mile House": "122 Mile House",
    "127 Mile House": "127 Mile House",
    "141 Mile House": "141 Mile House",
    "150 Mile House": "150 Mile House",
    "40 Mile Flats": "40 Mile Flats",
    "70 Mile House": "70 Mile House",
    "93 Mile": "93 Mile",
    "Abbotsford": "Abbotsford",
    "Abbott Heights": "Abbott Heights",
    "Aberdeen": "Aberdeen",
    "Adams Lake": "Adams Lake",
    "Agassiz": "Agassiz",
    "Agate": "Agate",
    "Ahbau": "Ahbau",
    "Ahousat": "Ahousat",
    "Ainsworth": "Ainsworth",
    "Ainsworth Hot Springs": "Ainsworth Hot Springs",
    "Aiyansh": "Aiyansh",
    "Aiyansh 1": "Aiyansh 1",
    "Akiskinook": "Akiskinook",
    "Alamo": "Alamo",
    "Albas": "Albas",
    "Alberni": "Alberni",
    "Albert Canyon": "Albert Canyon",
    "Albert Head": "Albert Head",
    "Albion": "Albion",
    "Albreda": "Albreda",
    "Aldergrove": "Aldergrove",
    "Alert Bay": "Alert Bay",
    "Alexandria": "Alexandria",
    "Alexis Creek": "Alexis Creek",
    "Aleza Lake": "Aleza Lake",
    "Alice Arm": "Alice Arm",
    "Alice Siding": "Alice Siding",
    "Alkali Lake": "Alkali Lake",
    "Allenby": "Allenby",
    "Alliford Bay": "Alliford Bay",
    "Allison Lake": "Allison Lake",
    "Almond Gardens": "Almond Gardens",
    "Alpine Meadows": "Alpine Meadows",
    "Alta Lake": "Alta Lake",
    "Altona": "Altona",
    "Alvin": "Alvin",
    "Ambleside": "Ambleside",
    "Amsbury": "Amsbury",
    "Anaconda": "Anaconda",
    "Anahim Lake": "Anahim Lake",
    "Anderson": "Anderson",
    "Anderson Subdivision": "Anderson Subdivision",
    "Andimaul": "Andimaul",
    "Anglemont": "Anglemont",
    "Angusmac": "Angusmac",
    "Anmore": "Anmore",
    "Anniedale": "Anniedale",
    "Annis": "Annis",
    "Anvil Island": "Anvil Island",
    "Anyox": "Anyox",
    "Anzac": "Anzac",
    "Appledale": "Appledale",
    "Applegrove": "Applegrove",
    "Arbutus": "Arbutus",
    "Arbutus Ridge": "Arbutus Ridge",
    "Arden Park": "Arden Park",
    "Ardmore": "Ardmore",
    "Argenta": "Argenta",
    "Armstrong": "Armstrong",
    "Arnold": "Arnold",
    "Arras": "Arras",
    "Arrow Creek": "Arrow Creek",
    "Arrow Park": "Arrow Park",
    "Arrowhead": "Arrowhead",
    "Arrowsmith": "Arrowsmith",
    "Arrowview Heights": "Arrowview Heights",
    "Ashcroft": "Ashcroft",
    "Ashton Creek": "Ashton Creek",
    "Aspen Grove": "Aspen Grove",
    "Atbara": "Atbara",
    "Atchelitz": "Atchelitz",
    "Athalmer": "Athalmer",
    "Atlin": "Atlin",
    "Atluck": "Atluck",
    "Atnarko": "Atnarko",
    "Attachie": "Attachie",
    "Austin Heights": "Austin Heights",
    "Australian": "Australian",
    "Avola": "Avola",
    "Azouzetta": "Azouzetta",
    "Babcock Subdivision": "Babcock Subdivision",
    "Baker": "Baker",
    "Baker Creek": "Baker Creek",
    "Baldonnel": "Baldonnel",
    "Baldy Hughes": "Baldy Hughes",
    "Balfour": "Balfour",
    "Balmoral": "Balmoral",
    "Balmoral Beach": "Balmoral Beach",
    "Bamberton": "Bamberton",
    "Bamfield": "Bamfield",
    "Bankeir": "Bankeir",
    "Banks Island": "Banks Island",
    "Bargain Harbour": "Bargain Harbour",
    "Bargain Harbour Sechelt Band 24": "Bargain Harbour Sechelt Band 24",
    "Barkerville": "Barkerville",
    "Barlow": "Barlow",
    "Barlow Creek": "Barlow Creek",
    "Barnet": "Barnet",
    "Barnhartvale": "Barnhartvale",
    "Barrett Lake": "Barrett Lake",
    "Barriere": "Barriere",
    "Barrowtown": "Barrowtown",
    "Basford": "Basford",
    "Basque": "Basque",
    "Bastion Bay": "Bastion Bay",
    "Batchelor Hills": "Batchelor Hills",
    "Bates Beach": "Bates Beach",
    "Baynes Lake": "Baynes Lake",
    "Beach Grove": "Beach Grove",
    "Beachcomber": "Beachcomber",
    "Beachcomber Bay": "Beachcomber Bay",
    "Bealby Point": "Bealby Point",
    "Bear Camp": "Bear Camp",
    "Bear Creek": "Bear Creek",
    "Bear Flat": "Bear Flat",
    "Bear Lake": "Bear Lake",
    "Beard's Creek": "Beard's Creek",
    "Beasley": "Beasley",
    "Beaton": "Beaton",
    "Beatton": "Beatton",
    "Beatton Ranch": "Beatton Ranch",
    "Beaver Cove": "Beaver Cove",
    "Beaver Creek": "Beaver Creek",
    "Beaver Falls": "Beaver Falls",
    "Beaver Lake": "Beaver Lake",
    "Beaver Pass House": "Beaver Pass House",
    "Beaver Point": "Beaver Point",
    "Beaverdell": "Beaverdell",
    "Beaverley": "Beaverley",
    "Beavermouth": "Beavermouth",
    "Becher Bay 2": "Becher Bay 2",
    "Becher House": "Becher House",
    "Bedwell Harbour": "Bedwell Harbour",
    "Belcarra": "Belcarra",
    "Belford": "Belford",
    "Bell II": "Bell II",
    "Bella Bella": "Bella Bella",
    "Bella Coola": "Bella Coola",
    "Belleview": "Belleview",
    "Bellos": "Bellos",
    "Belmont Park": "Belmont Park",
    "Belvedere": "Belvedere",
    "Bend": "Bend",
    "Benledi": "Benledi",
    "Ben-My-Chree": "Ben-My-Chree",
    "Bennett": "Bennett",
    "Benson Lake": "Benson Lake",
    "Benvoulin": "Benvoulin",
    "Beresford": "Beresford",
    "Bergs": "Bergs",
    "Beryl Prairie": "Beryl Prairie",
    "Bessborough": "Bessborough",
    "Bestwick": "Bestwick",
    "Bevan": "Bevan",
    "Big Bar": "Big Bar",
    "Big Bar Creek": "Big Bar Creek",
    "Big Bay": "Big Bay",
    "Big Creek": "Big Creek",
    "Big Eddy": "Big Eddy",
    "Big Lake": "Big Lake",
    "Big Lake Ranch": "Big Lake Ranch",
    "Big White Village": "Big White Village",
    "Billings": "Billings",
    "Billings Bay": "Billings Bay",
    "Birch Island": "Birch Island",
    "Birchbank": "Birchbank",
    "Birchdale": "Birchdale",
    "Birchland Manor": "Birchland Manor",
    "Birken": "Birken",
    "Black Creek": "Black Creek",
    "Black Pines": "Black Pines",
    "Blackloam": "Blackloam",
    "Blackpool": "Blackpool",
    "Blackstock Subdivision": "Blackstock Subdivision",
    "Blackwater": "Blackwater",
    "Blaeberry": "Blaeberry",
    "Blake": "Blake",
    "Blakeburn": "Blakeburn",
    "Blewett": "Blewett",
    "Bligh Island": "Bligh Island",
    "Blind Bay": "Blind Bay",
    "Blind Channel": "Blind Channel",
    "Bliss Landing": "Bliss Landing",
    "Bloedel": "Bloedel",
    "Blowhole": "Blowhole",
    "Blubber Bay": "Blubber Bay",
    "Blucher Hall": "Blucher Hall",
    "Blue Hills": "Blue Hills",
    "Blue River": "Blue River",
    "Blue Springs": "Blue Springs",
    "Blueberry Creek": "Blueberry Creek",
    "Blueberry Farm": "Blueberry Farm",
    "Blueridge": "Blueridge",
    "Boat Basin": "Boat Basin",
    "Boat Harbour": "Boat Harbour",
    "Bob Quinn Lake": "Bob Quinn Lake",
    "Bold Point": "Bold Point",
    "Bond": "Bond",
    "Bonnet Hill": "Bonnet Hill",
    "Bonnington Falls": "Bonnington Falls",
    "Boothroyd (Part) 8A": "Boothroyd (Part) 8A",
    "Boston Bar": "Boston Bar",
    "Boston Flats": "Boston Flats",
    "Boswell": "Boswell",
    "Bouchie Lake": "Bouchie Lake",
    "Boulder": "Boulder",
    "Boulder City": "Boulder City",
    "Boulder Island Sechelt Band 25": "Boulder Island Sechelt Band 25",
    "Boundary Bay": "Boundary Bay",
    "Boundary Falls": "Boundary Falls",
    "Bowen Island": "Bowen Island",
    "Bowser": "Bowser",
    "Box Lake": "Box Lake",
    "Brackendale": "Brackendale",
    "Bradner": "Bradner",
    "Braeloch": "Braeloch",
    "Braemar Heights": "Braemar Heights",
    "Braeside": "Braeside",
    "Bralorne": "Bralorne",
    "Brandon": "Brandon",
    "Brandywine": "Brandywine",
    "Brauns Island": "Brauns Island",
    "Brem River": "Brem River",
    "Brennan Creek": "Brennan Creek",
    "Brentwood Bay": "Brentwood Bay",
    "Brew Bay": "Brew Bay",
    "Brexton": "Brexton",
    "Briar Ridge": "Briar Ridge",
    "Bridal Falls": "Bridal Falls",
    "Bridesville": "Bridesville",
    "Bridge": "Bridge",
    "Bridge Lake": "Bridge Lake",
    "Brigade Lake": "Brigade Lake",
    "Brighouse": "Brighouse",
    "Brighton Beach": "Brighton Beach",
    "Brilliant": "Brilliant",
    "Brisco": "Brisco",
    "Britannia Beach": "Britannia Beach",
    "Broadview": "Broadview",
    "Brocklehurst": "Brocklehurst",
    "Broman Lake": "Broman Lake",
    "Brookmere": "Brookmere",
    "Brouse": "Brouse",
    "Browns Bay": "Browns Bay",
    "Brownsville": "Brownsville",
    "Brunswick": "Brunswick",
    "Bryn": "Bryn",
    "Buccaneer Bay": "Buccaneer Bay",
    "Buckhorn": "Buckhorn",
    "Buckinghorse River": "Buckinghorse River",
    "Buckley Bay": "Buckley Bay",
    "Buffalo Creek": "Buffalo Creek",
    "Buick": "Buick",
    "Bulkley Canyon": "Bulkley Canyon",
    "Bulkley House": "Bulkley House",
    "Bull Harbour": "Bull Harbour",
    "Bull River": "Bull River",
    "Buntzen Bay": "Buntzen Bay",
    "Burke Road": "Burke Road",
    "Burkeville": "Burkeville",
    "Burnaby": "Burnaby",
    "Burns Lake": "Burns Lake",
    "Burnt Flats": "Burnt Flats",
    "Burton": "Burton",
    "Butedale": "Butedale",
    "Cache Creek": "Cache Creek",
    "Caesars": "Caesars",
    "Cahilty": "Cahilty",
    "Caithness": "Caithness",
    "Cale": "Cale",
    "Callison Ranch": "Callison Ranch",
    "Cambie": "Cambie",
    "Camborne": "Camborne",
    "Cameron Heights": "Cameron Heights",
    "Cameron Lake": "Cameron Lake",
    "Camp McKinney": "Camp McKinney",
    "Campbell Creek": "Campbell Creek",
    "Campbell Island": "Campbell Island",
    "Campbell River": "Campbell River",
    "Campbellton": "Campbellton",
    "Canal Flats": "Canal Flats",
    "Canford": "Canford",
    "Canim": "Canim",
    "Canim Lake": "Canim Lake",
    "Canoe": "Canoe",
    "Canoe River": "Canoe River",
    "Canyon": "Canyon",
    "Canyon Alpine": "Canyon Alpine",
    "Canyon Heights": "Canyon Heights",
    "Canyon Hot Springs": "Canyon Hot Springs",
    "Cariboo": "Cariboo",
    "Cariboo Meadows": "Cariboo Meadows",
    "Carlin": "Carlin",
    "Carlson": "Carlson",
    "Carmi": "Carmi",
    "Carmi Subdivision": "Carmi Subdivision",
    "Carnaby": "Carnaby",
    "Carp": "Carp",
    "Carrolls Landing": "Carrolls Landing",
    "Carrs": "Carrs",
    "Carrs Landing": "Carrs Landing",
    "Carson": "Carson",
    "Cascade": "Cascade",
    "Casino": "Casino",
    "Cassiar": "Cassiar",
    "Cassidy": "Cassidy",
    "Cassin": "Cassin",
    "Castle Rock": "Castle Rock",
    "Castledale": "Castledale",
    "Castlegar": "Castlegar",
    "Caswell": "Caswell",
    "Cathedral": "Cathedral",
    "Caulfeild": "Caulfeild",
    "Cawston": "Cawston",
    "Caycuse": "Caycuse",
    "Cecil Lake": "Cecil Lake",
    "Cedar": "Cedar",
    "Cedar Grove": "Cedar Grove",
    "Cedar Heights Estates": "Cedar Heights Estates",
    "Cedarside": "Cedarside",
    "Cedarvale": "Cedarvale",
    "Ceepeecee": "Ceepeecee",
    "Celista": "Celista",
    "Central Saanich": "Central Saanich",
    "Centreville": "Centreville",
    "Chaatl": "Chaatl",
    "Chain Lake": "Chain Lake",
    "Chamiss Bay": "Chamiss Bay",
    "Channel Ridge": "Channel Ridge",
    "Chapman Camp": "Chapman Camp",
    "Chapmans": "Chapmans",
    "Charella Garden": "Charella Garden",
    "Charles": "Charles",
    "Charlie Lake": "Charlie Lake",
    "Charlotte Lake": "Charlotte Lake",
    "Chase": "Chase",
    "Chase River": "Chase River",
    "Chasm": "Chasm",
    "Chaumox": "Chaumox",
    "Cheakamus": "Cheakamus",
    "Cheam View": "Cheam View",
    "Cheekye": "Cheekye",
    "Chelohsin Sechelt Band 13": "Chelohsin Sechelt Band 13",
    "Chemainus": "Chemainus",
    "Cherry Creek": "Cherry Creek",
    "Cherry Point": "Cherry Point",
    "Cherryville": "Cherryville",
    "Ches-la-kee 3": "Ches-la-kee 3",
    "Cheslatta": "Cheslatta",
    "Chetarpe": "Chetarpe",
    "Chetwynd": "Chetwynd",
    "Chezacut": "Chezacut",
    "Chickwat Sechelt Band 9": "Chickwat Sechelt Band 9",
    "Chilanko Forks": "Chilanko Forks",
    "Chilcotin Forest": "Chilcotin Forest",
    "Chilliwack": "Chilliwack",
    "Chilton Subdivision": "Chilton Subdivision",
    "Chimney Valley": "Chimney Valley",
    "China Bar": "China Bar",
    "Chinook Cove": "Chinook Cove",
    "Choate": "Choate",
    "Chopaka": "Chopaka",
    "Christian Valley": "Christian Valley",
    "Christina Lake": "Christina Lake",
    "Chu Chua": "Chu Chua",
    "Church House": "Church House",
    "Chute Lake": "Chute Lake",
    "Cinema": "Cinema",
    "Cinnabar Valley": "Cinnabar Valley",
    "Cisco": "Cisco",
    "Clairmont": "Clairmont",
    "Clanwilliam": "Clanwilliam",
    "Clapperton": "Clapperton",
    "Clayburn": "Clayburn",
    "Clayhurst": "Clayhurst",
    "Clayoquot": "Clayoquot",
    "Cleagh Creek": "Cleagh Creek",
    "Clearbrook": "Clearbrook",
    "Clearwater": "Clearwater",
    "Clemina East": "Clemina East",
    "Clemina West": "Clemina West",
    "Clemretta": "Clemretta",
    "Cleveland Park": "Cleveland Park",
    "Cliffside": "Cliffside",
    "Clinton": "Clinton",
    "Clode": "Clode",
    "Clo-oose": "Clo-oose",
    "Coal Harbour": "Coal Harbour",
    "Coal Island": "Coal Island",
    "Coal River": "Coal River",
    "Coalmont": "Coalmont",
    "Cobble Hill": "Cobble Hill",
    "Cody": "Cody",
    "Cokato": "Cokato",
    "Cokoqueneets Sechelt Band 23": "Cokoqueneets Sechelt Band 23",
    "Coldspring House": "Coldspring House",
    "Coldstream": "Coldstream",
    "Coldwell Beach": "Coldwell Beach",
    "Colebank": "Colebank",
    "Colebrook": "Colebrook",
    "College Heights": "College Heights",
    "Collettville": "Collettville",
    "Colleymount": "Colleymount",
    "Colquitz": "Colquitz",
    "Columbia Gardens": "Columbia Gardens",
    "Columere Park": "Columere Park",
    "Colvalli": "Colvalli",
    "Colwood": "Colwood",
    "Comer": "Comer",
    "Commodore Heights": "Commodore Heights",
    "Comox": "Comox",
    "Connaught Heights": "Connaught Heights",
    "Conrad": "Conrad",
    "Coombe": "Coombe",
    "Coombs": "Coombs",
    "Cooper Creek": "Cooper Creek",
    "Copper City": "Copper City",
    "Copper Cove": "Copper Cove",
    "Copper Creek": "Copper Creek",
    "Copper Mountain": "Copper Mountain",
    "Coquitlam": "Coquitlam",
    "Coral Beach": "Coral Beach",
    "Corbin": "Corbin",
    "Cordova Bay": "Cordova Bay",
    "Cormorant Island": "Cormorant Island",
    "Corra Linn": "Corra Linn",
    "Cortes Bay": "Cortes Bay",
    "Cortes Island": "Cortes Island",
    "Coryville": "Coryville",
    "Cottonwood": "Cottonwood",
    "Cottonwood Flats": "Cottonwood Flats",
    "Couldwell Subdivision": "Couldwell Subdivision",
    "Courtenay": "Courtenay",
    "Coutlee": "Coutlee",
    "Cove Cliff": "Cove Cliff",
    "Cowans Point": "Cowans Point",
    "Cowichan Bay": "Cowichan Bay",
    "Coykendahl": "Coykendahl",
    "Coyle": "Coyle",
    "Cracroft": "Cracroft",
    "Craigellachie": "Craigellachie",
    "Cranberry": "Cranberry",
    "Cranberry Junction": "Cranberry Junction",
    "Cranbrook": "Cranbrook",
    "Crawford Bay": "Crawford Bay",
    "Creekside": "Creekside",
    "Creighton Valley": "Creighton Valley",
    "Crescent Bay": "Crescent Bay",
    "Crescent Beach": "Crescent Beach",
    "Crescent Spur": "Crescent Spur",
    "Crescent Valley": "Crescent Valley",
    "Creston": "Creston",
    "Crestwood Subdivision": "Crestwood Subdivision",
    "Criss Creek": "Criss Creek",
    "Crofton": "Crofton",
    "Crowsnest": "Crowsnest",
    "Croydon": "Croydon",
    "Crysdale": "Crysdale",
    "Cultus Lake": "Cultus Lake",
    "Cumberland": "Cumberland",
    "Cumshewa": "Cumshewa",
    "Curzon": "Curzon",
    "Cypress Park": "Cypress Park",
    "Dallas": "Dallas",
    "Danskin": "Danskin",
    "D'Arcy": "D'Arcy",
    "D'Arcy Island": "D'Arcy Island",
    "Darfield": "Darfield",
    "Darrell Bay": "Darrell Bay",
    "Dartmoor": "Dartmoor",
    "Dashwood": "Dashwood",
    "Davidson": "Davidson",
    "Davis Bay": "Davis Bay",
    "Dawson Creek": "Dawson Creek",
    "Dawsons Landing": "Dawsons Landing",
    "Days Ranch": "Days Ranch",
    "Day's Subdivision": "Day's Subdivision",
    "De Courcy Island": "De Courcy Island",
    "Deadtree Point": "Deadtree Point",
    "Deadwood": "Deadwood",
    "Dease Lake": "Dease Lake",
    "Decker Lake": "Decker Lake",
    "Deep Bay": "Deep Bay",
    "Deep Cove": "Deep Cove",
    "Deep Creek": "Deep Creek",
    "Deer Park": "Deer Park",
    "Deerholme": "Deerholme",
    "Defot": "Defot",
    "Deka Lake": "Deka Lake",
    "Del Oro Subdivision": "Del Oro Subdivision",
    "Delkatla": "Delkatla",
    "Delta": "Delta",
    "Demean": "Demean",
    "Denman Island": "Denman Island",
    "Dentville": "Dentville",
    "Departure Bay": "Departure Bay",
    "Deroche": "Deroche",
    "Devine": "Devine",
    "Dewdney": "Dewdney",
    "Dewey": "Dewey",
    "Digby Island": "Digby Island",
    "Doe River": "Doe River",
    "Dog Creek": "Dog Creek",
    "Dogpatch": "Dogpatch",
    "Dogwood Valley": "Dogwood Valley",
    "Doig River": "Doig River",
    "Dokie": "Dokie",
    "Dokie Siding": "Dokie Siding",
    "Dolan Road Subdivision": "Dolan Road Subdivision",
    "Dollarton": "Dollarton",
    "Dolphin Beach": "Dolphin Beach",
    "Dolphin Island 1": "Dolphin Island 1",
    "Dome Creek": "Dome Creek",
    "Donald": "Donald",
    "Donald Landing": "Donald Landing",
    "Donnely Landing": "Donnely Landing",
    "Doriston": "Doriston",
    "Dorreen": "Dorreen",
    "Dot": "Dot",
    "Douglas": "Douglas",
    "Douglas Hill Estates": "Douglas Hill Estates",
    "Douglas Lake": "Douglas Lake",
    "Dove Creek": "Dove Creek",
    "Downie": "Downie",
    "Dragon": "Dragon",
    "Drew Harbour": "Drew Harbour",
    "Drewry": "Drewry",
    "Driftwood Creek": "Driftwood Creek",
    "Dry Gulch": "Dry Gulch",
    "Drynoch": "Drynoch",
    "DuBose": "DuBose",
    "Duck Range": "Duck Range",
    "Dufferin": "Dufferin",
    "Dugan Lake": "Dugan Lake",
    "Duncan": "Duncan",
    "Duncan Bay": "Duncan Bay",
    "Duncanby Landing": "Duncanby Landing",
    "Dunkley": "Dunkley",
    "Dunsmuir": "Dunsmuir",
    "Dunster": "Dunster",
    "Durieu": "Durieu",
    "Dutch Lake": "Dutch Lake",
    "Eagle Bay": "Eagle Bay",
    "Eagle Bluff": "Eagle Bluff",
    "Eagle Creek": "Eagle Creek",
    "Eagle Harbour": "Eagle Harbour",
    "Eagle Heights": "Eagle Heights",
    "Earls Cove": "Earls Cove",
    "East Arrow Park": "East Arrow Park",
    "East Gate": "East Gate",
    "East Kelowna": "East Kelowna",
    "East Osoyoos": "East Osoyoos",
    "East Pine": "East Pine",
    "East Sooke": "East Sooke",
    "East Thurlow Island": "East Thurlow Island",
    "East Trail": "East Trail",
    "East Wellington": "East Wellington",
    "Eastbourne": "Eastbourne",
    "Eastgate": "Eastgate",
    "Echo Bay": "Echo Bay",
    "Ecoole": "Ecoole",
    "Eddontenajon": "Eddontenajon",
    "Eddy": "Eddy",
    "Edelweiss": "Edelweiss",
    "Edgewater": "Edgewater",
    "Edgewood": "Edgewood",
    "Egmont": "Egmont",
    "Egmont Sechelt Band 26": "Egmont Sechelt Band 26",
    "Ehatisaht": "Ehatisaht",
    "Eholt": "Eholt",
    "Ekins Point": "Ekins Point",
    "Ekwan": "Ekwan",
    "Elephant Crossing": "Elephant Crossing",
    "Elk Bay": "Elk Bay",
    "Elk Prairie": "Elk Prairie",
    "Elkford": "Elkford",
    "Elko": "Elko",
    "Elkview": "Elkview",
    "Elleh": "Elleh",
    "Ellison": "Ellison",
    "Elphinstone": "Elphinstone",
    "Encombe": "Encombe",
    "Endako": "Endako",
    "Enderby": "Enderby",
    "Engen": "Engen",
    "Engineer": "Engineer",
    "Enterprise": "Enterprise",
    "Erickson": "Erickson",
    "Erie": "Erie",
    "Errington": "Errington",
    "Esler": "Esler",
    "Esperanza": "Esperanza",
    "Espinosa Inlet": "Espinosa Inlet",
    "Esquimalt": "Esquimalt",
    "Estevan Point": "Estevan Point",
    "Evans": "Evans",
    "Evelyn": "Evelyn",
    "Evergreen Acres": "Evergreen Acres",
    "Ewing": "Ewing",
    "Exeter": "Exeter",
    "Exlou": "Exlou",
    "Exstew": "Exstew",
    "Extension": "Extension",
    "Fair Harbour": "Fair Harbour",
    "Fairbridge": "Fairbridge",
    "Fairfield": "Fairfield",
    "Fairmont": "Fairmont",
    "Fairmont Hot Springs": "Fairmont Hot Springs",
    "Fairview": "Fairview",
    "Fairview Subdivision": "Fairview Subdivision",
    "Falkland": "Falkland",
    "Falls": "Falls",
    "Falls Creek": "Falls Creek",
    "Fallsway": "Fallsway",
    "False Bay": "False Bay",
    "Fanny Bay": "Fanny Bay",
    "Farmington": "Farmington",
    "Farrell Creek": "Farrell Creek",
    "Farron": "Farron",
    "Faulder": "Faulder",
    "Fauquier": "Fauquier",
    "Federal Ranch": "Federal Ranch",
    "Fellers Heights": "Fellers Heights",
    "Fenwick": "Fenwick",
    "Ferguson": "Ferguson",
    "Ferndale": "Ferndale",
    "Fernie": "Fernie",
    "Fernwood": "Fernwood",
    "Field": "Field",
    "Fife": "Fife",
    "Fifth Cabin": "Fifth Cabin",
    "Fill": "Fill",
    "Finmoore": "Finmoore",
    "Fintry": "Fintry",
    "Fireside": "Fireside",
    "Firvale": "Firvale",
    "Fitzwilliam": "Fitzwilliam",
    "Five Mile": "Five Mile",
    "Flat Creek": "Flat Creek",
    "Flathead": "Flathead",
    "Flatrock": "Flatrock",
    "Fleetwood": "Fleetwood",
    "Fleming": "Fleming",
    "Floods": "Floods",
    "Flores Island": "Flores Island",
    "Flying U": "Flying U",
    "Fontas": "Fontas",
    "Fontas 1": "Fontas 1",
    "Forde": "Forde",
    "Fording": "Fording",
    "Foreman": "Foreman",
    "Forest Grove": "Forest Grove",
    "Forest Hills": "Forest Hills",
    "Forest Knolls": "Forest Knolls",
    "Forestdale": "Forestdale",
    "Fort Babine": "Fort Babine",
    "Fort Fraser": "Fort Fraser",
    "Fort Langley": "Fort Langley",
    "Fort Nelson": "Fort Nelson",
    "Fort Nelson 2": "Fort Nelson 2",
    "Fort Rupert": "Fort Rupert",
    "Fort St. James": "Fort St. James",
    "Fort St. John": "Fort St. John",
    "Fort Steele": "Fort Steele",
    "Foss": "Foss",
    "Foster": "Foster",
    "Fosthall": "Fosthall",
    "Fountain": "Fountain",
    "Fountain Valley": "Fountain Valley",
    "Fourth Cabin": "Fourth Cabin",
    "Fowler": "Fowler",
    "Fox Mountain": "Fox Mountain",
    "Fraine": "Fraine",
    "Francis Lake": "Francis Lake",
    "Francis Peninsula": "Francis Peninsula",
    "Franklin Camp": "Franklin Camp",
    "Fraser": "Fraser",
    "Fraser Heights": "Fraser Heights",
    "Fraser Lake": "Fraser Lake",
    "Fraserview": "Fraserview",
    "Frederick": "Frederick",
    "French Creek": "French Creek",
    "Fruitvale": "Fruitvale",
    "Fry Creek": "Fry Creek",
    "Fulford Harbour": "Fulford Harbour",
    "Furry Creek": "Furry Creek",
    "Gabriola": "Gabriola",
    "Gabriola Island": "Gabriola Island",
    "Galena": "Galena",
    "Galiano": "Galiano",
    "Galiano Island": "Galiano Island",
    "Gallagher Lake": "Gallagher Lake",
    "Galloway": "Galloway",
    "Gambier Harbour": "Gambier Harbour",
    "Gang Ranch": "Gang Ranch",
    "Ganges": "Ganges",
    "Garbitt": "Garbitt",
    "Garden Bay": "Garden Bay",
    "Garden Village": "Garden Village",
    "Garibaldi": "Garibaldi",
    "Garibaldi Estates": "Garibaldi Estates",
    "Garibaldi Highlands": "Garibaldi Highlands",
    "Garnet Rock Trailer Court": "Garnet Rock Trailer Court",
    "Garnet Valley": "Garnet Valley",
    "Gates": "Gates",
    "Gateway": "Gateway",
    "Gellatly": "Gellatly",
    "Genelle": "Genelle",
    "Genoa Bay": "Genoa Bay",
    "George River": "George River",
    "Georgetown Mills": "Georgetown Mills",
    "Germansen Landing": "Germansen Landing",
    "Gerow Island": "Gerow Island",
    "Gerrard": "Gerrard",
    "Gibbs": "Gibbs",
    "Gibraltar": "Gibraltar",
    "Gibson Creek": "Gibson Creek",
    "Gibsons": "Gibsons",
    "Gifford": "Gifford",
    "Gill Island": "Gill Island",
    "Gillies Bay": "Gillies Bay",
    "Gilpin": "Gilpin",
    "Giscome": "Giscome",
    "Gitanyow": "Gitanyow",
    "Gitwinksihlkw": "Gitwinksihlkw",
    "Gitwinksihlkw 7": "Gitwinksihlkw 7",
    "Glacier": "Glacier",
    "Glacier Gulch": "Glacier Gulch",
    "Glade": "Glade",
    "Gladwin": "Gladwin",
    "Gleam": "Gleam",
    "Glen Fraser": "Glen Fraser",
    "Glen Lake": "Glen Lake",
    "Glen Valley": "Glen Valley",
    "Glen Vowell": "Glen Vowell",
    "Glenannan": "Glenannan",
    "Glenbank": "Glenbank",
    "Glenbrooke North": "Glenbrooke North",
    "Glendale": "Glendale",
    "Gleneagles": "Gleneagles",
    "Gleneden": "Gleneden",
    "Glenemma": "Glenemma",
    "Glenlily": "Glenlily",
    "Glenmerry": "Glenmerry",
    "Glenmore": "Glenmore",
    "Glenogle": "Glenogle",
    "Glenora": "Glenora",
    "Glenrosa": "Glenrosa",
    "Glentanna": "Glentanna",
    "Glimpse Lake": "Glimpse Lake",
    "Goat River": "Goat River",
    "Goatfell": "Goatfell",
    "Gold Bridge": "Gold Bridge",
    "Gold River": "Gold River",
    "Golden": "Golden",
    "Good Hope": "Good Hope",
    "Good Hope Lake": "Good Hope Lake",
    "Goodlow": "Goodlow",
    "Goose Bay": "Goose Bay",
    "Gordon River": "Gordon River",
    "Gorge Harbour": "Gorge Harbour",
    "Gosnell": "Gosnell",
    "Gossen Creek": "Gossen Creek",
    "Gossip Island": "Gossip Island",
    "Gower Point": "Gower Point",
    "Graham": "Graham",
    "Graham Island": "Graham Island",
    "Gramsons": "Gramsons",
    "Grand Forks": "Grand Forks",
    "Grand Haven": "Grand Haven",
    "Grand Rapids": "Grand Rapids",
    "Grand Trunk": "Grand Trunk",
    "Granduc": "Granduc",
    "Grandview Bench": "Grandview Bench",
    "Granisle": "Granisle",
    "Granite": "Granite",
    "Granite Bay": "Granite Bay",
    "Granite Falls": "Granite Falls",
    "Grant Brook": "Grant Brook",
    "Grantham": "Grantham",
    "Granthams Landing": "Granthams Landing",
    "Grasmere": "Grasmere",
    "Grassy Plains": "Grassy Plains",
    "Gravelle Ferry": "Gravelle Ferry",
    "Gray Creek": "Gray Creek",
    "Great Central": "Great Central",
    "Great Central Lake": "Great Central Lake",
    "Greata": "Greata",
    "Greeley": "Greeley",
    "Green Bay Resort": "Green Bay Resort",
    "Green Cove": "Green Cove",
    "Green River": "Green River",
    "Greendale": "Greendale",
    "Greenhills": "Greenhills",
    "Greening": "Greening",
    "Greenville": "Greenville",
    "Greenwood": "Greenwood",
    "Griffith": "Griffith",
    "Grindrod": "Grindrod",
    "Groundbirch": "Groundbirch",
    "Gun Lake": "Gun Lake",
    "Gundy": "Gundy",
    "Gutah": "Gutah",
    "Hagensborg": "Hagensborg",
    "Hagwilget": "Hagwilget",
    "Haig": "Haig",
    "Haina": "Haina",
    "Haisla": "Haisla",
    "Halfmoon Bay": "Halfmoon Bay",
    "Halfway Ranch": "Halfway Ranch",
    "Hall": "Hall",
    "Halliday": "Halliday",
    "Hanbury": "Hanbury",
    "Hanceville": "Hanceville",
    "Hansard": "Hansard",
    "Happy Valley": "Happy Valley",
    "Harbour Chines": "Harbour Chines",
    "Harbour Village": "Harbour Village",
    "Hardwicke Island": "Hardwicke Island",
    "Harmac": "Harmac",
    "Harmer": "Harmer",
    "Harrison Hot Springs": "Harrison Hot Springs",
    "Harrison Mills": "Harrison Mills",
    "Harrogate": "Harrogate",
    "Harrop": "Harrop",
    "Hart Highlands": "Hart Highlands",
    "Hartley Bay": "Hartley Bay",
    "Harvey": "Harvey",
    "Harwood Island": "Harwood Island",
    "Hasler Flat": "Hasler Flat",
    "Hastings-Sunrise": "Hastings-Sunrise",
    "Hatzic": "Hatzic",
    "Hawkins Lake Subdivision": "Hawkins Lake Subdivision",
    "Hawks": "Hawks",
    "Haysport": "Haysport",
    "Hayward": "Hayward",
    "Hazelmere": "Hazelmere",
    "Hazelton": "Hazelton",
    "Headquarters": "Headquarters",
    "Headwaters Ranch": "Headwaters Ranch",
    "Health Bay": "Health Bay",
    "Hecate": "Hecate",
    "Hector": "Hector",
    "Hedley": "Hedley",
    "Heffley Creek": "Heffley Creek",
    "Hells Gate": "Hells Gate",
    "Hemlock Valley": "Hemlock Valley",
    "Hendrix Lake": "Hendrix Lake",
    "Heriot Bay": "Heriot Bay",
    "Hernando Island": "Hernando Island",
    "Hesquiat": "Hesquiat",
    "Heydon Bay": "Heydon Bay",
    "Hickethier Ranch": "Hickethier Ranch",
    "Hicks": "Hicks",
    "Highlands": "Highlands",
    "Hillbank": "Hillbank",
    "Hillcrest": "Hillcrest",
    "Hilliers": "Hilliers",
    "Hills": "Hills",
    "Hippa": "Hippa",
    "Hiusta Meadow": "Hiusta Meadow",
    "Hixon": "Hixon",
    "Hkusam": "Hkusam",
    "Hodda": "Hodda",
    "Holachten 8": "Holachten 8",
    "Holberg": "Holberg",
    "Hollyburn": "Hollyburn",
    "Holmwood": "Holmwood",
    "Homfray Creek": "Homfray Creek",
    "Honeymoon Bay": "Honeymoon Bay",
    "Honeymoon Creek": "Honeymoon Creek",
    "Hope": "Hope",
    "Hope Bay": "Hope Bay",
    "Hope Island": "Hope Island",
    "Hopetown": "Hopetown",
    "Hopkins Landing": "Hopkins Landing",
    "Hornby Island": "Hornby Island",
    "Horse Creek": "Horse Creek",
    "Horsefly": "Horsefly",
    "Hosmer": "Hosmer",
    "Hospital Hill": "Hospital Hill",
    "Hot Springs Cove": "Hot Springs Cove",
    "Houston": "Houston",
    "Howser": "Howser",
    "Huble": "Huble",
    "Hudson's Hope": "Hudson's Hope",
    "Hulatt": "Hulatt",
    "Hulcross": "Hulcross",
    "Hullcar": "Hullcar",
    "Humpback Bay": "Humpback Bay",
    "Hunaechin Sechelt Band 11": "Hunaechin Sechelt Band 11",
    "Huntingdon": "Huntingdon",
    "Huntington": "Huntington",
    "Hunts Inlet": "Hunts Inlet",
    "Hupel": "Hupel",
    "Huscroft": "Huscroft",
    "Hutchinson": "Hutchinson",
    "Hutchison": "Hutchison",
    "Hutton": "Hutton",
    "Hyacinthe Bay": "Hyacinthe Bay",
    "Hyde Creek": "Hyde Creek",
    "Hydraulic": "Hydraulic",
    "Hyland Post": "Hyland Post",
    "Illecillewaet": "Illecillewaet",
    "Imperial Ranchettes": "Imperial Ranchettes",
    "Indian Rock": "Indian Rock",
    "Ingenika Mine": "Ingenika Mine",
    "Inkaneep": "Inkaneep",
    "Inkitsaph": "Inkitsaph",
    "Invermere": "Invermere",
    "Irvine": "Irvine",
    "Irvines Landing": "Irvines Landing",
    "Iskut": "Iskut",
    "Island Cache": "Island Cache",
    "Isle Pierre": "Isle Pierre",
    "Jackfish Lake Subdivision": "Jackfish Lake Subdivision",
    "Jackman": "Jackman",
    "Jackson Bay": "Jackson Bay",
    "Jacksons": "Jacksons",
    "Jade City": "Jade City",
    "Jaffray": "Jaffray",
    "Jaleslie": "Jaleslie",
    "James Island": "James Island",
    "Jayem": "Jayem",
    "Jedway": "Jedway",
    "Jellicoe": "Jellicoe",
    "Jersey": "Jersey",
    "Jervis Inlet": "Jervis Inlet",
    "Jesmond": "Jesmond",
    "Jeune Landing": "Jeune Landing",
    "Jim Smith Lake and Area": "Jim Smith Lake and Area",
    "Johnson": "Johnson",
    "Johnsons Landing": "Johnsons Landing",
    "Jordan River": "Jordan River",
    "June Springs Estates": "June Springs Estates",
    "Juniper Ridge": "Juniper Ridge",
    "Jura": "Jura",
    "Juskatla": "Juskatla",
    "Kahntah": "Kahntah",
    "Kahntah 3": "Kahntah 3",
    "Kaisun": "Kaisun",
    "Kakawis": "Kakawis",
    "Kalamalka": "Kalamalka",
    "Kaleden": "Kaleden",
    "Kaleva": "Kaleva",
    "Kallum": "Kallum",
    "Kamloops": "Kamloops",
    "Kanaka": "Kanaka",
    "Kanaka Bar": "Kanaka Bar",
    "Kaslo": "Kaslo",
    "Katz": "Katz",
    "Keating": "Keating",
    "Keats Island": "Keats Island",
    "Kedleston": "Kedleston",
    "Keefers": "Keefers",
    "Keekwillie Trailer Park": "Keekwillie Trailer Park",
    "Keithley Creek": "Keithley Creek",
    "Kelly Lake": "Kelly Lake",
    "Kelowna": "Kelowna",
    "Kemano": "Kemano",
    "Kemano Beach": "Kemano Beach",
    "Kendrick Camp": "Kendrick Camp",
    "Kennedy": "Kennedy",
    "Kent": "Kent",
    "Keremeos": "Keremeos",
    "Kerr Creek": "Kerr Creek",
    "Kersley": "Kersley",
    "Kettle Valley": "Kettle Valley",
    "Kidd": "Kidd",
    "Kilbella Bay": "Kilbella Bay",
    "Kildala Arm": "Kildala Arm",
    "Kildonan": "Kildonan",
    "Kilgard": "Kilgard",
    "Kilkerran": "Kilkerran",
    "Killiney Beach": "Killiney Beach",
    "Killy": "Killy",
    "Kimberley": "Kimberley",
    "Kimsquit": "Kimsquit",
    "Kincolith": "Kincolith",
    "Kingcome": "Kingcome",
    "Kingcome Inlet": "Kingcome Inlet",
    "Kingfisher": "Kingfisher",
    "Kingsgate": "Kingsgate",
    "Kingsvale": "Kingsvale",
    "Kinnaird": "Kinnaird",
    "Kiskatinaw": "Kiskatinaw",
    "Kispiox": "Kispiox",
    "Kispiox Valley": "Kispiox Valley",
    "Kissick": "Kissick",
    "Kitamaat Village": "Kitamaat Village",
    "Kitchener": "Kitchener",
    "Kitimat": "Kitimat",
    "Kitkatla": "Kitkatla",
    "Kitsault": "Kitsault",
    "Kitseguecla": "Kitseguecla",
    "Kitselas": "Kitselas",
    "Kitsumkalum": "Kitsumkalum",
    "Kitty Coleman": "Kitty Coleman",
    "Kitwanga": "Kitwanga",
    "Kiusta": "Kiusta",
    "Klaalth Sechelt Band 5": "Klaalth Sechelt Band 5",
    "Klayekwim Sechelt Band 6": "Klayekwim Sechelt Band 6",
    "Klayekwim Sechelt Band 6A": "Klayekwim Sechelt Band 6A",
    "Klayekwim Sechelt Band 7": "Klayekwim Sechelt Band 7",
    "Klayekwim Sechelt Band 8": "Klayekwim Sechelt Band 8",
    "Kleecoot": "Kleecoot",
    "Kleena Kleene": "Kleena Kleene",
    "Kleindale": "Kleindale",
    "Klemtu": "Klemtu",
    "Klua": "Klua",
    "Knockholt": "Knockholt",
    "Knutsford": "Knutsford",
    "Kobes": "Kobes",
    "Kokish": "Kokish",
    "Koksilah": "Koksilah",
    "Komo": "Komo",
    "Kootenay Bay": "Kootenay Bay",
    "Kootenay Crossing": "Kootenay Crossing",
    "Kootenay Landing": "Kootenay Landing",
    "Koster": "Koster",
    "Kragmont": "Kragmont",
    "Krestova": "Krestova",
    "Kuldo": "Kuldo",
    "Kulkayu 4": "Kulkayu 4",
    "Kung": "Kung",
    "Kuper Island": "Kuper Island",
    "Kuskonook": "Kuskonook",
    "Kwinitsa": "Kwinitsa",
    "Kye Bay": "Kye Bay",
    "Kyuquot": "Kyuquot",
    "Lac la Hache": "Lac la Hache",
    "Lac Le Jeune": "Lac Le Jeune",
    "Lachkaltsap 9": "Lachkaltsap 9",
    "Ladysmith": "Ladysmith",
    "Lafferty": "Lafferty",
    "Laidlaw": "Laidlaw",
    "Lakahahmen 11": "Lakahahmen 11",
    "Lake Buntzen": "Lake Buntzen",
    "Lake Country, District of": "Lake Country, District of",
    "Lake Cowichan": "Lake Cowichan",
    "Lake Errock": "Lake Errock",
    "Lake Kathlyn": "Lake Kathlyn",
    "Lakelse": "Lakelse",
    "Lakelse Lake": "Lakelse Lake",
    "Laketon": "Laketon",
    "Lakeview Heights": "Lakeview Heights",
    "Lamming Mills": "Lamming Mills",
    "Lang Bay": "Lang Bay",
    "Langdale": "Langdale",
    "Langford": "Langford",
    "Langley": "Langley",
    "Lantzville": "Lantzville",
    "Larch Hill": "Larch Hill",
    "Lardeau": "Lardeau",
    "Larkin": "Larkin",
    "Larsons Landing": "Larsons Landing",
    "Lasha": "Lasha",
    "Lasqueti": "Lasqueti",
    "Lasqueti Island": "Lasqueti Island",
    "Lauretta": "Lauretta",
    "Lavington": "Lavington",
    "Lawnhill": "Lawnhill",
    "Lax Kw'alaams": "Lax Kw'alaams",
    "Lazo": "Lazo",
    "Leanchoil": "Leanchoil",
    "Lebahdo": "Lebahdo",
    "Lee Creek": "Lee Creek",
    "Leechtown": "Leechtown",
    "Lees Corner": "Lees Corner",
    "Legrand": "Legrand",
    "Lejac": "Lejac",
    "Lemon Creek": "Lemon Creek",
    "Lemoray": "Lemoray",
    "Lempriere": "Lempriere",
    "Leo Creek": "Leo Creek",
    "Lexau Ranch": "Lexau Ranch",
    "Liard River": "Liard River",
    "Liard River 3": "Liard River 3",
    "Liersch": "Liersch",
    "Lighthouse Point": "Lighthouse Point",
    "Likely": "Likely",
    "Lillooet": "Lillooet",
    "Lily Lake": "Lily Lake",
    "Lime": "Lime",
    "Lincoln Park": "Lincoln Park",
    "Lindell Beach": "Lindell Beach",
    "Lindeman": "Lindeman",
    "Line Creek": "Line Creek",
    "Lions Bay": "Lions Bay",
    "Lister": "Lister",
    "Little Fort": "Little Fort",
    "Little River": "Little River",
    "Little Zeballos": "Little Zeballos",
    "Lockeport": "Lockeport",
    "Log Cabin": "Log Cabin",
    "Logan Lake": "Logan Lake",
    "Lone Butte": "Lone Butte",
    "Lone Prairie": "Lone Prairie",
    "Long Harbour": "Long Harbour",
    "Longbeach": "Longbeach",
    "Longworth": "Longworth",
    "Loon Lake": "Loon Lake",
    "Loon Lake Subdivision": "Loon Lake Subdivision",
    "Loos": "Loos",
    "Louis Creek": "Louis Creek",
    "Louise Island": "Louise Island",
    "Lower China Creek": "Lower China Creek",
    "Lower Nicola": "Lower Nicola",
    "Lower Post": "Lower Post",
    "Lubin": "Lubin",
    "Lucas": "Lucas",
    "Lucerne": "Lucerne",
    "Lulu 5": "Lulu 5",
    "Lumberton": "Lumberton",
    "Lumby": "Lumby",
    "Lund": "Lund",
    "Lust Subdivision": "Lust Subdivision",
    "Luxor": "Luxor",
    "Lyell Island": "Lyell Island",
    "Lynx Creek": "Lynx Creek",
    "Lytton": "Lytton",
    "Lytton 27B": "Lytton 27B",
    "Mabel Lake": "Mabel Lake",
    "Macalister": "Macalister",
    "Macdonald": "Macdonald",
    "Mackenzie": "Mackenzie",
    "Mackin": "Mackin",
    "MacNeill": "MacNeill",
    "Madeira Park": "Madeira Park",
    "Magic Lake Estates": "Magic Lake Estates",
    "Magna Bay": "Magna Bay",
    "Magnum Mine": "Magnum Mine",
    "Mahatta River": "Mahatta River",
    "Mahmalillikullah 1": "Mahmalillikullah 1",
    "Mahood Falls": "Mahood Falls",
    "Makinson": "Makinson",
    "Malahat": "Malahat",
    "Malakwa": "Malakwa",
    "Malcolm Island": "Malcolm Island",
    "Malibu": "Malibu",
    "Mamalilaculla": "Mamalilaculla",
    "Mammel Subdivision": "Mammel Subdivision",
    "Manning": "Manning",
    "Manning Park": "Manning Park",
    "Manson Creek": "Manson Creek",
    "Mansons Landing": "Mansons Landing",
    "Mapes": "Mapes",
    "Maple Bay": "Maple Bay",
    "Maple Ridge": "Maple Ridge",
    "Mara": "Mara",
    "Marblehead": "Marblehead",
    "Margaret Bay": "Margaret Bay",
    "Marguerite": "Marguerite",
    "Marigold": "Marigold",
    "Marilla": "Marilla",
    "Marktosis": "Marktosis",
    "Marne": "Marne",
    "Marron Valley": "Marron Valley",
    "Marsh Creek Area": "Marsh Creek Area",
    "Martel": "Martel",
    "Marten Lake": "Marten Lake",
    "Martin Prairie": "Martin Prairie",
    "Martin Valley": "Martin Valley",
    "Martinson": "Martinson",
    "Marysville": "Marysville",
    "Mason Creek": "Mason Creek",
    "Masset": "Masset",
    "Matilpi": "Matilpi",
    "Matsqui Main 2": "Matsqui Main 2",
    "Maurelle Island": "Maurelle Island",
    "Mayne Island": "Mayne Island",
    "Mayook": "Mayook",
    "McAbee": "McAbee",
    "McBride": "McBride",
    "McCabe": "McCabe",
    "McCall": "McCall",
    "McCalls Landing": "McCalls Landing",
    "McConnel": "McConnel",
    "McCracken": "McCracken",
    "McCulloch": "McCulloch",
    "McDame": "McDame",
    "McDonalds Landing": "McDonalds Landing",
    "McGillivray": "McGillivray",
    "McGregor": "McGregor",
    "McGuire": "McGuire",
    "McKearney Ranch": "McKearney Ranch",
    "McKinley Landing": "McKinley Landing",
    "McLean Ranch": "McLean Ranch",
    "McLeese Lake": "McLeese Lake",
    "McLeod": "McLeod",
    "McLeod Lake": "McLeod Lake",
    "McLeod Subdivision": "McLeod Subdivision",
    "McLure": "McLure",
    "McMillan Island 6": "McMillan Island 6",
    "McMurdo": "McMurdo",
    "McMurphy": "McMurphy",
    "McNab Creek": "McNab Creek",
    "Meachen": "Meachen",
    "Meadow Creek": "Meadow Creek",
    "Meadows": "Meadows",
    "Meares Island": "Meares Island",
    "Meem Quam Leese": "Meem Quam Leese",
    "Meldrum": "Meldrum",
    "Meldrum Creek": "Meldrum Creek",
    "Merritt": "Merritt",
    "Merton": "Merton",
    "Merville": "Merville",
    "Mesachie Lake": "Mesachie Lake",
    "Messiter": "Messiter",
    "Metchosin": "Metchosin",
    "Metlakatla": "Metlakatla",
    "Meziadin Junction": "Meziadin Junction",
    "Meziadin Subdivision": "Meziadin Subdivision",
    "Mica Creek": "Mica Creek",
    "Middlegate": "Middlegate",
    "Midway": "Midway",
    "Mile 19 Overhead": "Mile 19 Overhead",
    "Mile 422 Alaska Highway": "Mile 422 Alaska Highway",
    "Mile 62 1/2": "Mile 62 1/2",
    "Mill Bay": "Mill Bay",
    "Millers Landing": "Millers Landing",
    "Millstream": "Millstream",
    "Milnes Landing": "Milnes Landing",
    "Minaty Bay": "Minaty Bay",
    "Minstrel Island": "Minstrel Island",
    "Minto Landing": "Minto Landing",
    "Miocene": "Miocene",
    "Miracle Valley": "Miracle Valley",
    "Mirror Lake": "Mirror Lake",
    "Missezula Lake": "Missezula Lake",
    "Mission": "Mission",
    "Mission Island 2": "Mission Island 2",
    "Mitchell Bay": "Mitchell Bay",
    "Miworth": "Miworth",
    "Moberly": "Moberly",
    "Moberly Lake": "Moberly Lake",
    "Moffat": "Moffat",
    "Moha": "Moha",
    "Monias": "Monias",
    "Mons": "Mons",
    "Montague Harbour": "Montague Harbour",
    "Monte Creek": "Monte Creek",
    "Monte Lake": "Monte Lake",
    "Montney": "Montney",
    "Montrose": "Montrose",
    "Moose Heights": "Moose Heights",
    "Mooyah Bay": "Mooyah Bay",
    "Moran": "Moran",
    "Moresby Camp": "Moresby Camp",
    "Moresby Island": "Moresby Island",
    "Morey": "Morey",
    "Moricetown": "Moricetown",
    "Morrissey": "Morrissey",
    "Mount Baldy": "Mount Baldy",
    "Mount Currie": "Mount Currie",
    "Mount Lehman": "Mount Lehman",
    "Mount Robson": "Mount Robson",
    "Mountain Station": "Mountain Station",
    "Moyie": "Moyie",
    "Mud Bay": "Mud Bay",
    "Mud River": "Mud River",
    "Muncho Lake": "Muncho Lake",
    "Munro": "Munro",
    "Munroe": "Munroe",
    "Murdale": "Murdale",
    "Musgrave Landing": "Musgrave Landing",
    "Muskwa": "Muskwa",
    "Myra": "Myra",
    "Myrtle Point": "Myrtle Point",
    "Nadu": "Nadu",
    "Nahmint": "Nahmint",
    "Nahun": "Nahun",
    "Nakusp": "Nakusp",
    "Nalos Landing": "Nalos Landing",
    "Namu": "Namu",
    "Nanaimo": "Nanaimo",
    "Nanoose Bay": "Nanoose Bay",
    "Naramata": "Naramata",
    "Narcosli Creek": "Narcosli Creek",
    "Nasookin Road Subdivision": "Nasookin Road Subdivision",
    "Nass Camp": "Nass Camp",
    "Natal": "Natal",
    "Nazko": "Nazko",
    "Nechako": "Nechako",
    "Nechako Centre": "Nechako Centre",
    "Nedoats 11": "Nedoats 11",
    "Needles": "Needles",
    "Needley": "Needley",
    "Nelson": "Nelson",
    "Nelson Forks": "Nelson Forks",
    "Nelson Island": "Nelson Island",
    "Nelway": "Nelway",
    "Nemiah Valley": "Nemiah Valley",
    "New Aiyansh": "New Aiyansh",
    "New Barkerville": "New Barkerville",
    "New Bella Bella": "New Bella Bella",
    "New Brighton": "New Brighton",
    "New Clew": "New Clew",
    "New Denver": "New Denver",
    "New Hazelton": "New Hazelton",
    "New Settlement": "New Settlement",
    "New Westminster": "New Westminster",
    "Newcastle": "Newcastle",
    "Newgate": "Newgate",
    "Newlands": "Newlands",
    "Niagara": "Niagara",
    "Nichol": "Nichol",
    "Nicholson": "Nicholson",
    "Nicks Island": "Nicks Island",
    "Nicola": "Nicola",
    "Nicomen": "Nicomen",
    "Nig": "Nig",
    "Nigei Island": "Nigei Island",
    "Nimpkish": "Nimpkish",
    "Nimpkish Heights": "Nimpkish Heights",
    "Nimpo Lake": "Nimpo Lake",
    "Ninety Three Mile House": "Ninety Three Mile House",
    "Ninstints": "Ninstints",
    "Niteal": "Niteal",
    "Nootka": "Nootka",
    "Nootka Island": "Nootka Island",
    "Noralee": "Noralee",
    "Norgate": "Norgate",
    "Norlake": "Norlake",
    "North Bend": "North Bend",
    "North Bonaparte": "North Bonaparte",
    "North Bulkley": "North Bulkley",
    "North Campbell River": "North Campbell River",
    "North Cowichan": "North Cowichan",
    "North Galiano": "North Galiano",
    "North Kamloops": "North Kamloops",
    "North Nechako": "North Nechako",
    "North Pender Island": "North Pender Island",
    "North Pine": "North Pine",
    "North Poplar": "North Poplar",
    "North Saanich": "North Saanich",
    "North Star": "North Star",
    "North Vancouver": "North Vancouver",
    "Northfield": "Northfield",
    "Northridge": "Northridge",
    "Norton": "Norton",
    "Notch Hill": "Notch Hill",
    "Nuchatlitz": "Nuchatlitz",
    "Nukko Lake": "Nukko Lake",
    "Nulki": "Nulki",
    "Nursery": "Nursery",
    "Oak Bay": "Oak Bay",
    "Oak Hills": "Oak Hills",
    "Oalthkyim Sechelt Band 4": "Oalthkyim Sechelt Band 4",
    "Oasis": "Oasis",
    "Ocean Falls": "Ocean Falls",
    "Ocean Grove": "Ocean Grove",
    "O'Dell": "O'Dell",
    "Ogden": "Ogden",
    "Okanagan Centre": "Okanagan Centre",
    "Okanagan Falls": "Okanagan Falls",
    "Okanagan Landing": "Okanagan Landing",
    "Okanagan Mission": "Okanagan Mission",
    "O'Keefe": "O'Keefe",
    "Olalla": "Olalla",
    "Old Bella Bella": "Old Bella Bella",
    "Old Fort": "Old Fort",
    "Old Remo": "Old Remo",
    "Old Town": "Old Town",
    "Oliver": "Oliver",
    "Oliver's Landing": "Oliver's Landing",
    "Olson": "Olson",
    "Onward": "Onward",
    "Oona River": "Oona River",
    "Ootischenia": "Ootischenia",
    "Ootischenia Flats": "Ootischenia Flats",
    "Ootsa Lake": "Ootsa Lake",
    "Opitsat": "Opitsat",
    "Osborn": "Osborn",
    "Osborn Bay": "Osborn Bay",
    "Osland": "Osland",
    "Osoyoos": "Osoyoos",
    "Osprey Lake": "Osprey Lake",
    "Othello": "Othello",
    "Otter Bay": "Otter Bay",
    "Ottertail": "Ottertail",
    "Otway": "Otway",
    "Oweekeno": "Oweekeno",
    "Owen Bay": "Owen Bay",
    "Owl Creek": "Owl Creek",
    "Oyama": "Oyama",
    "Oyster River": "Oyster River",
    "Pacific": "Pacific",
    "Pahas 3": "Pahas 3",
    "Paldi": "Paldi",
    "Palling": "Palling",
    "Palling 1A": "Palling 1A",
    "Palliser": "Palliser",
    "Panorama": "Panorama",
    "Panorama Subdivision": "Panorama Subdivision",
    "Paradise Point": "Paradise Point",
    "Paradise Valley": "Paradise Valley",
    "Park Siding": "Park Siding",
    "Parkland": "Parkland",
    "Parksville": "Parksville",
    "Parson": "Parson",
    "Pasley Island": "Pasley Island",
    "Pass Creek": "Pass Creek",
    "Passmore": "Passmore",
    "Paterson": "Paterson",
    "Paul Lake": "Paul Lake",
    "Paulson": "Paulson",
    "Pavey": "Pavey",
    "Pavilion": "Pavilion",
    "Paxton Valley": "Paxton Valley",
    "Paykulkum Sechelt Band 14": "Paykulkum Sechelt Band 14",
    "Peachland": "Peachland",
    "Peejay": "Peejay",
    "Pemberton": "Pemberton",
    "Pemberton Heights": "Pemberton Heights",
    "Pemberton Meadows": "Pemberton Meadows",
    "Pender Island": "Pender Island",
    "Pendleton Bay": "Pendleton Bay",
    "Pennington": "Pennington",
    "Penny": "Penny",
    "Penticton": "Penticton",
    "Perow": "Perow",
    "Perrys": "Perrys",
    "Peterson": "Peterson",
    "Phelan": "Phelan",
    "Phillips Arm": "Phillips Arm",
    "Phoenix": "Phoenix",
    "Piers Island": "Piers Island",
    "Pilot Bay": "Pilot Bay",
    "Pinantan Lake": "Pinantan Lake",
    "Pinchi": "Pinchi",
    "Pinchi Lake": "Pinchi Lake",
    "Pine Valley": "Pine Valley",
    "Pinegrove": "Pinegrove",
    "Pinesul": "Pinesul",
    "Pineview": "Pineview",
    "Pinewood Subdivision": "Pinewood Subdivision",
    "Pink Mountain": "Pink Mountain",
    "Pioneer Mine": "Pioneer Mine",
    "Pitman": "Pitman",
    "Pitquah": "Pitquah",
    "Pitt Meadows": "Pitt Meadows",
    "Pixie Beach": "Pixie Beach",
    "Playmor Junction": "Playmor Junction",
    "Pleasant Camp": "Pleasant Camp",
    "Plumper Harbour": "Plumper Harbour",
    "Point Holmes": "Point Holmes",
    "Polley": "Polley",
    "Pope Landing": "Pope Landing",
    "Popkum": "Popkum",
    "Poplar Creek": "Poplar Creek",
    "Poplar Grove": "Poplar Grove",
    "Porcher Island": "Porcher Island",
    "Porpoise Bay": "Porpoise Bay",
    "Port Alberni": "Port Alberni",
    "Port Albion": "Port Albion",
    "Port Alice": "Port Alice",
    "Port Clements": "Port Clements",
    "Port Coquitlam": "Port Coquitlam",
    "Port Desire": "Port Desire",
    "Port Douglas": "Port Douglas",
    "Port Edward": "Port Edward",
    "Port Essington": "Port Essington",
    "Port Hammond - Haney": "Port Hammond - Haney",
    "Port Hardy": "Port Hardy",
    "Port Kells": "Port Kells",
    "Port McNeill": "Port McNeill",
    "Port Mellon": "Port Mellon",
    "Port Moody": "Port Moody",
    "Port Neville": "Port Neville",
    "Port Renfrew": "Port Renfrew",
    "Port Simpson 1": "Port Simpson 1",
    "Port Washington": "Port Washington",
    "Porteau": "Porteau",
    "Porteous": "Porteous",
    "Porter Landing": "Porter Landing",
    "Portland Island": "Portland Island",
    "Porto Rico": "Porto Rico",
    "Poser": "Poser",
    "Postill": "Postill",
    "Potter": "Potter",
    "Pouce Coupe": "Pouce Coupe",
    "Poupore": "Poupore",
    "Powell River": "Powell River",
    "Powers Addition": "Powers Addition",
    "Prairie Valley": "Prairie Valley",
    "Premier": "Premier",
    "Premier Lake": "Premier Lake",
    "Prespatou": "Prespatou",
    "Pressy Lake": "Pressy Lake",
    "Prince George": "Prince George",
    "Prince Rupert": "Prince Rupert",
    "Princeton": "Princeton",
    "Pritchard": "Pritchard",
    "Procter": "Procter",
    "Progress": "Progress",
    "Promontory": "Promontory",
    "Prophet River": "Prophet River",
    "Prospect Lake": "Prospect Lake",
    "Protection Island": "Protection Island",
    "Punchaw": "Punchaw",
    "Puntledge": "Puntledge",
    "Purden Lake": "Purden Lake",
    "Pyramid": "Pyramid",
    "Quadra Island": "Quadra Island",
    "Qualicum Bay": "Qualicum Bay",
    "Qualicum Beach": "Qualicum Beach",
    "Quamichan": "Quamichan",
    "Quathiaski Cove": "Quathiaski Cove",
    "Quatsino": "Quatsino",
    "Quaw": "Quaw",
    "Queen Charlotte City": "Queen Charlotte City",
    "Queens Bay": "Queens Bay",
    "Queens Cove": "Queens Cove",
    "Quesnel": "Quesnel",
    "Quesnel Canyon": "Quesnel Canyon",
    "Quesnel Forks": "Quesnel Forks",
    "Quesnel View": "Quesnel View",
    "Quick": "Quick",
    "Quilchena": "Quilchena",
    "Quinsam": "Quinsam",
    "Radium": "Radium",
    "Radium Hot Springs": "Radium Hot Springs",
    "Raft River": "Raft River",
    "Rail Lake": "Rail Lake",
    "Rainy Hollow": "Rainy Hollow",
    "Ranchero": "Ranchero",
    "Raspberry": "Raspberry",
    "Raush Valley": "Raush Valley",
    "Rayleigh": "Rayleigh",
    "Read Island": "Read Island",
    "Reclaim": "Reclaim",
    "Red Bluff": "Red Bluff",
    "Red Mountain": "Red Mountain",
    "Red Pass": "Red Pass",
    "Red Rock": "Red Rock",
    "Red Rose": "Red Rose",
    "Redgrave": "Redgrave",
    "Redroofs": "Redroofs",
    "Redstone": "Redstone",
    "Refuge Cove": "Refuge Cove",
    "Reid Lake": "Reid Lake",
    "Remac": "Remac",
    "Remo": "Remo",
    "Renata": "Renata",
    "Retallack": "Retallack",
    "Retaskit": "Retaskit",
    "Revelstoke": "Revelstoke",
    "Rhone": "Rhone",
    "Rich Bar": "Rich Bar",
    "Richmond": "Richmond",
    "Rider": "Rider",
    "Ridgedale": "Ridgedale",
    "Ridley": "Ridley",
    "Riley": "Riley",
    "Riondel": "Riondel",
    "Riske Creek": "Riske Creek",
    "Ritchie": "Ritchie",
    "River Jordan": "River Jordan",
    "River Springs": "River Springs",
    "Rivers Inlet": "Rivers Inlet",
    "Riverside": "Riverside",
    "Rivervale": "Rivervale",
    "Roberts Creek": "Roberts Creek",
    "Robin Creek": "Robin Creek",
    "Robson": "Robson",
    "Robson West": "Robson West",
    "Rock Bay": "Rock Bay",
    "Rock Creek": "Rock Creek",
    "Rockyview": "Rockyview",
    "Roe Lake": "Roe Lake",
    "Rogers": "Rogers",
    "Rogers Pass": "Rogers Pass",
    "Rolla": "Rolla",
    "Rolling Hills Park": "Rolling Hills Park",
    "Roosville": "Roosville",
    "Rose Harbour": "Rose Harbour",
    "Rose Lake": "Rose Lake",
    "Rose Prairie": "Rose Prairie",
    "Rosebery": "Rosebery",
    "Rosedale": "Rosedale",
    "Ross Peak": "Ross Peak",
    "Ross Spur": "Ross Spur",
    "Rossland": "Rossland",
    "Rosswood": "Rosswood",
    "Round Lake": "Round Lake",
    "Round Prairie": "Round Prairie",
    "Roy": "Roy",
    "Royston": "Royston",
    "Ruby Creek": "Ruby Creek",
    "Rumble Beach": "Rumble Beach",
    "Rupert": "Rupert",
    "Rushmere": "Rushmere",
    "Rutland": "Rutland",
    "Ryan": "Ryan",
    "Ryder Lake": "Ryder Lake",
    "Rykerts": "Rykerts",
    "Saanich": "Saanich",
    "Saanichton": "Saanichton",
    "Saddle Rock": "Saddle Rock",
    "Sahali": "Sahali",
    "Sahara Heights": "Sahara Heights",
    "Sahtlam": "Sahtlam",
    "Sallahlus Sechelt Band 20": "Sallahlus Sechelt Band 20",
    "Sallahlus Sechelt Band 20A": "Sallahlus Sechelt Band 20A",
    "Salmo": "Salmo",
    "Salmon Arm": "Salmon Arm",
    "Salmon Valley": "Salmon Valley",
    "Saloon": "Saloon",
    "Salt Spring Island": "Salt Spring Island",
    "Saltair": "Saltair",
    "Saltery Bay": "Saltery Bay",
    "Salvus": "Salvus",
    "Samuel Island": "Samuel Island",
    "San Josef": "San Josef",
    "Sanca": "Sanca",
    "Sanderson Site": "Sanderson Site",
    "Sandon": "Sandon",
    "Sandspit": "Sandspit",
    "Sandwick": "Sandwick",
    "Sandy Point": "Sandy Point",
    "Saratoga Beach": "Saratoga Beach",
    "Sardis": "Sardis",
    "Sarita": "Sarita",
    "Saseenos": "Saseenos",
    "Saturna Island": "Saturna Island",
    "Saughanaught Sechelt Band 22": "Saughanaught Sechelt Band 22",
    "Savary Island": "Savary Island",
    "Savona": "Savona",
    "Savory": "Savory",
    "Sawquamain Sechelt Band 19A": "Sawquamain Sechelt Band 19A",
    "Sayward": "Sayward",
    "Scotch Creek": "Scotch Creek",
    "Scotia Bay": "Scotia Bay",
    "Scott Cove": "Scott Cove",
    "Scotty Creek": "Scotty Creek",
    "Seaford": "Seaford",
    "Seal Bay Subdivision": "Seal Bay Subdivision",
    "Seaside Park": "Seaside Park",
    "Sechelt": "Sechelt",
    "Sechelt Indian Government District": "Sechelt Indian Government District",
    "Sechelt Sechelt Band 2": "Sechelt Sechelt Band 2",
    "Secret Cove": "Secret Cove",
    "Seddall": "Seddall",
    "Seeney": "Seeney",
    "Sekaleton Sechelt Band 21": "Sekaleton Sechelt Band 21",
    "Sekaleton Sechelt Band 21A": "Sekaleton Sechelt Band 21A",
    "Selma Park": "Selma Park",
    "Semlin": "Semlin",
    "Septimus": "Septimus",
    "Seton": "Seton",
    "Seton Portage": "Seton Portage",
    "Seven Mile Corner": "Seven Mile Corner",
    "Seventy Mile House": "Seventy Mile House",
    "Sewall": "Sewall",
    "Sewell Inlet": "Sewell Inlet",
    "Seymour Arm": "Seymour Arm",
    "Seymour Inlet": "Seymour Inlet",
    "Seymour Lake": "Seymour Lake",
    "Shady Valley": "Shady Valley",
    "Shalalth": "Shalalth",
    "Shames": "Shames",
    "Shannon": "Shannon",
    "Shannon Bay": "Shannon Bay",
    "Shannon Creek Sechelt Band 28": "Shannon Creek Sechelt Band 28",
    "Shawl Bay": "Shawl Bay",
    "Shawnigan Lake": "Shawnigan Lake",
    "Shearer Dale": "Shearer Dale",
    "Shearwater": "Shearwater",
    "Shelley": "Shelley",
    "Shelter Bay": "Shelter Bay",
    "Shelter Point": "Shelter Point",
    "Sheraton": "Sheraton",
    "Shere": "Shere",
    "Sheridan Lake": "Sheridan Lake",
    "Sheslay": "Sheslay",
    "Shingle Creek": "Shingle Creek",
    "Shirley": "Shirley",
    "Shoreacres": "Shoreacres",
    "Shoreholme": "Shoreholme",
    "Shulus": "Shulus",
    "Shushartie": "Shushartie",
    "Shuswap": "Shuswap",
    "Shuswap Falls": "Shuswap Falls",
    "Shutty Bench": "Shutty Bench",
    "Sicamous": "Sicamous",
    "Sidley": "Sidley",
    "Sidney": "Sidney",
    "Sikanni": "Sikanni",
    "Sikanni Chief": "Sikanni Chief",
    "Silica": "Silica",
    "Silver Creek": "Silver Creek",
    "Silver Lake": "Silver Lake",
    "Silver River": "Silver River",
    "Silverdale": "Silverdale",
    "Silverhill": "Silverhill",
    "Silverton": "Silverton",
    "Simpson Ranch": "Simpson Ranch",
    "Sinclair Mills": "Sinclair Mills",
    "Sinkut River": "Sinkut River",
    "Sirdar": "Sirdar",
    "Six Mile Point": "Six Mile Point",
    "Skedans": "Skedans",
    "Skeena": "Skeena",
    "Skeena Crossing": "Skeena Crossing",
    "Skidegate": "Skidegate",
    "Skidegate Landing": "Skidegate Landing",
    "Skooks Landing": "Skooks Landing",
    "Skookumchuck": "Skookumchuck",
    "Skookumchuck Sechelt Band 27": "Skookumchuck Sechelt Band 27",
    "Skoonka": "Skoonka",
    "Skwawkweehm Sechelt Band 17": "Skwawkweehm Sechelt Band 17",
    "Skweahm 10": "Skweahm 10",
    "Slaterville": "Slaterville",
    "Slayathlum Sechelt Band 16": "Slayathlum Sechelt Band 16",
    "Slesse Park": "Slesse Park",
    "Sliammon": "Sliammon",
    "Slocan": "Slocan",
    "Slocan Park": "Slocan Park",
    "Smeshalin Sechelt Band 18": "Smeshalin Sechelt Band 18",
    "Smith River": "Smith River",
    "Smithers": "Smithers",
    "Smithers Landing": "Smithers Landing",
    "Snake 5": "Snake 5",
    "Snake River": "Snake River",
    "Snyder": "Snyder",
    "Soames Point": "Soames Point",
    "Sockeye": "Sockeye",
    "Soda Creek": "Soda Creek",
    "Sointula": "Sointula",
    "Solly": "Solly",
    "Solsqua": "Solsqua",
    "Somenos": "Somenos",
    "Sonora Island": "Sonora Island",
    "Sooke": "Sooke",
    "Sorrento": "Sorrento",
    "South Bentinck": "South Bentinck",
    "South Canoe": "South Canoe",
    "South Dawson": "South Dawson",
    "South Fort George": "South Fort George",
    "South Hazelton": "South Hazelton",
    "South Lakeside": "South Lakeside",
    "South Lakeside (Williams Lake)": "South Lakeside (Williams Lake)",
    "South Pender Island": "South Pender Island",
    "South Poplar": "South Poplar",
    "South Shalalth": "South Shalalth",
    "South Slocan": "South Slocan",
    "South Slope": "South Slope",
    "South Sumas": "South Sumas",
    "South Taylor": "South Taylor",
    "South Thormanby Island": "South Thormanby Island",
    "South Wellington": "South Wellington",
    "Southbank": "Southbank",
    "Soyandostar 2": "Soyandostar 2",
    "Spallumcheen": "Spallumcheen",
    "Sparwood": "Sparwood",
    "Spatsum": "Spatsum",
    "Spences Bridge": "Spences Bridge",
    "Sperling": "Sperling",
    "Spicer": "Spicer",
    "Spillamacheen": "Spillamacheen",
    "Springfield Ranch": "Springfield Ranch",
    "Springhouse": "Springhouse",
    "Sproat Lake": "Sproat Lake",
    "Sproatt": "Sproatt",
    "Sproule Creek": "Sproule Creek",
    "Spur Valley Subdivision": "Spur Valley Subdivision",
    "Spuzzum": "Spuzzum",
    "Squamish": "Squamish",
    "Squawkum Creek 3": "Squawkum Creek 3",
    "Squeah": "Squeah",
    "Squilax": "Squilax",
    "Squirrel Cove": "Squirrel Cove",
    "St. Andrews": "St. Andrews",
    "St. Eugene Mission": "St. Eugene Mission",
    "St. Ives": "St. Ives",
    "St. Joseph Mission": "St. Joseph Mission",
    "St. Mary Lake": "St. Mary Lake",
    "St. Vincent Bay": "St. Vincent Bay",
    "Stanley": "Stanley",
    "Star Subdivision": "Star Subdivision",
    "Starks": "Starks",
    "Stave Falls": "Stave Falls",
    "Steamboat": "Steamboat",
    "Steelhead": "Steelhead",
    "Stellako": "Stellako",
    "Stephen": "Stephen",
    "Stepping Stones Estates": "Stepping Stones Estates",
    "Stewardson Inlet": "Stewardson Inlet",
    "Stewart": "Stewart",
    "Stikine": "Stikine",
    "Still Creek": "Still Creek",
    "Stillwater": "Stillwater",
    "Stockett": "Stockett",
    "Stoner": "Stoner",
    "Stones Bay": "Stones Bay",
    "Stoney Creek": "Stoney Creek",
    "Stories Beach": "Stories Beach",
    "Stout": "Stout",
    "Straiton": "Straiton",
    "Strathcona Lodge": "Strathcona Lodge",
    "Strathnaver": "Strathnaver",
    "Streatham": "Streatham",
    "Stuart Island": "Stuart Island",
    "Stuart River": "Stuart River",
    "Stuie": "Stuie",
    "Stump Lake": "Stump Lake",
    "Sturdies Bay": "Sturdies Bay",
    "Suahbin Sechelt Band 19": "Suahbin Sechelt Band 19",
    "Sugarcane": "Sugarcane",
    "Sullivan Bay": "Sullivan Bay",
    "Summerland": "Summerland",
    "Summit Lake": "Summit Lake",
    "Sun Peaks": "Sun Peaks",
    "Sundance": "Sundance",
    "Sundance Subdivision": "Sundance Subdivision",
    "Sunningdale": "Sunningdale",
    "Sunnybrae": "Sunnybrae",
    "Sunnyside": "Sunnyside",
    "Sunrise Valley": "Sunrise Valley",
    "Sunset Beach": "Sunset Beach",
    "Sunset Prairie": "Sunset Prairie",
    "Sunshine Bay": "Sunshine Bay",
    "Sunshine Valley": "Sunshine Valley",
    "Suquash": "Suquash",
    "Surge Narrows": "Surge Narrows",
    "Surprise": "Surprise",
    "Surrey": "Surrey",
    "Swansea": "Swansea",
    "Swartz Bay": "Swartz Bay",
    "Swaycalse Sechelt Band 3": "Swaycalse Sechelt Band 3",
    "Swaywelat Sechelt Band 12": "Swaywelat Sechelt Band 12",
    "Sweetsbridge": "Sweetsbridge",
    "Sweetwater": "Sweetwater",
    "Swift": "Swift",
    "Swiftwater": "Swiftwater",
    "Sydney Island": "Sydney Island",
    "Ta Ta Creek": "Ta Ta Creek",
    "Tabor": "Tabor",
    "Tacheeda": "Tacheeda",
    "Tachie": "Tachie",
    "Tadanac": "Tadanac",
    "Taft": "Taft",
    "Taghum": "Taghum",
    "Tahltan": "Tahltan",
    "Tahsis": "Tahsis",
    "Takla Landing": "Takla Landing",
    "Taku": "Taku",
    "Takysie Lake": "Takysie Lake",
    "Tallheo": "Tallheo",
    "Tamarack": "Tamarack",
    "Tamarisk": "Tamarisk",
    "Tantalus Acres": "Tantalus Acres",
    "Tanu": "Tanu",
    "Tappen": "Tappen",
    "Tarrys": "Tarrys",
    "Tasu": "Tasu",
    "Tatalrose": "Tatalrose",
    "Tatla Lake": "Tatla Lake",
    "Tatlow": "Tatlow",
    "Tatogga": "Tatogga",
    "Tatton": "Tatton",
    "Taverna": "Taverna",
    "Taylor": "Taylor",
    "Tchahchelailthtenum Sechelt Band 10": "Tchahchelailthtenum Sechelt Band 10",
    "Tchesinkut Lake": "Tchesinkut Lake",
    "Teakerne Arm": "Teakerne Arm",
    "Teko": "Teko",
    "Telachick": "Telachick",
    "Telegraph Cove": "Telegraph Cove",
    "Telegraph Creek": "Telegraph Creek",
    "Telkwa": "Telkwa",
    "Ten Mile Lake": "Ten Mile Lake",
    "Terrace": "Terrace",
    "Tete Jaune": "Tete Jaune",
    "Tete Jaune Cache": "Tete Jaune Cache",
    "Texada Island": "Texada Island",
    "Theodosia Arm": "Theodosia Arm",
    "Thetis Island": "Thetis Island",
    "Thompson": "Thompson",
    "Thompson River Estates": "Thompson River Estates",
    "Thompson Sound": "Thompson Sound",
    "Thornhill": "Thornhill",
    "Three Forks": "Three Forks",
    "Three Valley": "Three Valley",
    "Thrums": "Thrums",
    "Thunder River": "Thunder River",
    "Thunderbird": "Thunderbird",
    "Thurlow": "Thurlow",
    "Thurston Harbour": "Thurston Harbour",
    "Tibbets": "Tibbets",
    "Tiilis Landing": "Tiilis Landing",
    "Tillicum": "Tillicum",
    "Tintagel": "Tintagel",
    "Tipella": "Tipella",
    "Tisdall": "Tisdall",
    "Tlell": "Tlell",
    "Toad River": "Toad River",
    "Toby Creek": "Toby Creek",
    "Tochty": "Tochty",
    "Tofino": "Tofino",
    "Toketic": "Toketic",
    "Tomslake": "Tomslake",
    "Topley": "Topley",
    "Torrent": "Torrent",
    "Towdystan": "Towdystan",
    "Tower Lake": "Tower Lake",
    "Townsend": "Townsend",
    "Tracard": "Tracard",
    "Traders Cove": "Traders Cove",
    "Trafalgar": "Trafalgar",
    "Trail": "Trail",
    "Tranquille": "Tranquille",
    "Tremblay": "Tremblay",
    "Trembleur": "Trembleur",
    "Trepanier": "Trepanier",
    "Trevor Channel": "Trevor Channel",
    "Trinity Valley": "Trinity Valley",
    "Troup": "Troup",
    "Trout Creek": "Trout Creek",
    "Trout Lake": "Trout Lake",
    "Trutch": "Trutch",
    "Tsawcome Sechelt Band 1": "Tsawcome Sechelt Band 1",
    "Tsawwassen Beach": "Tsawwassen Beach",
    "Tsay Keh Dene": "Tsay Keh Dene",
    "Tsimpsean 2 North Part": "Tsimpsean 2 North Part",
    "Tsolum River": "Tsolum River",
    "Tsooahdie Sechelt Band 15": "Tsooahdie Sechelt Band 15",
    "Tulameen": "Tulameen",
    "Tulsequah": "Tulsequah",
    "Tumbler Ridge": "Tumbler Ridge",
    "Tupper": "Tupper",
    "Turner Subdivision": "Turner Subdivision",
    "Turtle Valley": "Turtle Valley",
    "Tuwanek": "Tuwanek",
    "Twidwell Bend": "Twidwell Bend",
    "Twin Bays": "Twin Bays",
    "Twin Butte": "Twin Butte",
    "Twin Creeks": "Twin Creeks",
    "Twin Islands": "Twin Islands",
    "Two Mile": "Two Mile",
    "Two Mile Hazelton": "Two Mile Hazelton",
    "Two Rivers": "Two Rivers",
    "Tye": "Tye",
    "Tyee": "Tyee",
    "Tzouhalem": "Tzouhalem",
    "Tzuhalem": "Tzuhalem",
    "Ucluelet": "Ucluelet",
    "Ulkatcho": "Ulkatcho",
    "Union Bay": "Union Bay",
    "Upper Bench": "Upper Bench",
    "Upper China Creek": "Upper China Creek",
    "Upper Cutbank": "Upper Cutbank",
    "Upper Fraser": "Upper Fraser",
    "Upper Halfway": "Upper Halfway",
    "Upper Sumas 6": "Upper Sumas 6",
    "Urling": "Urling",
    "Urquhart": "Urquhart",
    "Usk": "Usk",
    "Valdes Island": "Valdes Island",
    "Valemount": "Valemount",
    "Valhalla": "Valhalla",
    "Valley View": "Valley View",
    "Valleycliffe": "Valleycliffe",
    "Valleyview": "Valleyview",
    "Vallican": "Vallican",
    "Van Anda": "Van Anda",
    "Vancouver": "Vancouver",
    "Vanderhoof": "Vanderhoof",
    "Vanway": "Vanway",
    "Vargas Island": "Vargas Island",
    "Vaseaux Lake": "Vaseaux Lake",
    "Vaucroft Beach": "Vaucroft Beach",
    "Vavenby": "Vavenby",
    "Vedder Crossing": "Vedder Crossing",
    "Vermilion Crossing": "Vermilion Crossing",
    "Vernon": "Vernon",
    "Vesuvius": "Vesuvius",
    "Victoria": "Victoria",
    "Victoria Lake": "Victoria Lake",
    "Vidette": "Vidette",
    "View Royal": "View Royal",
    "Vinsulla": "Vinsulla",
    "Von Zuben": "Von Zuben",
    "Vye": "Vye",
    "Wabi": "Wabi",
    "Wabron": "Wabron",
    "Wadhams": "Wadhams",
    "Waglisla": "Waglisla",
    "Wagner Ranch": "Wagner Ranch",
    "Wakely": "Wakely",
    "Walcott": "Walcott",
    "Walhachin": "Walhachin",
    "Walker": "Walker",
    "Walkers": "Walkers",
    "Wall Beach": "Wall Beach",
    "Waneta": "Waneta",
    "Wanklyn": "Wanklyn",
    "Wardner": "Wardner",
    "Ware": "Ware",
    "Warfield": "Warfield",
    "Warner Bay": "Warner Bay",
    "Wasa": "Wasa",
    "Wasa Lake": "Wasa Lake",
    "Watson": "Watson",
    "Watson Island": "Watson Island",
    "Websters Corners": "Websters Corners",
    "Wedeene": "Wedeene",
    "Wedge": "Wedge",
    "Wedgwood": "Wedgwood",
    "Weewanie": "Weewanie",
    "Welcome Beach": "Welcome Beach",
    "Wellington": "Wellington",
    "Wells": "Wells",
    "Weneez": "Weneez",
    "West Bench": "West Bench",
    "West Fernie": "West Fernie",
    "West Heights": "West Heights",
    "West Kelowna": "West Kelowna",
    "West Landing": "West Landing",
    "West Mara Lake": "West Mara Lake",
    "West Midway": "West Midway",
    "West Sechelt": "West Sechelt",
    "West Thurlow Island": "West Thurlow Island",
    "West Trail": "West Trail",
    "West Vancouver": "West Vancouver",
    "Westbank": "Westbank",
    "Westbridge": "Westbridge",
    "Westholme": "Westholme",
    "Westley": "Westley",
    "Westply": "Westply",
    "Westside": "Westside",
    "Westsyde": "Westsyde",
    "Westview": "Westview",
    "Westwold": "Westwold",
    "Whaletown": "Whaletown",
    "Whiplash Ranch": "Whiplash Ranch",
    "Whisky Creek": "Whisky Creek",
    "Whistler": "Whistler",
    "Whistler Creek": "Whistler Creek",
    "White Lake": "White Lake",
    "White Pass": "White Pass",
    "White Rock": "White Rock",
    "Whitecroft": "Whitecroft",
    "Whonnock": "Whonnock",
    "Whyac": "Whyac",
    "Wildwood": "Wildwood",
    "Wildwood Subdivision": "Wildwood Subdivision",
    "Wiley": "Wiley",
    "Williams Beach": "Williams Beach",
    "Williams Lake": "Williams Lake",
    "Williams Landing": "Williams Landing",
    "Williamsons Landing": "Williamsons Landing",
    "Willow Brook": "Willow Brook",
    "Willow Flats": "Willow Flats",
    "Willow Point": "Willow Point",
    "Willow Ranch": "Willow Ranch",
    "Willow River": "Willow River",
    "Willow Valley": "Willow Valley",
    "Willowbrook": "Willowbrook",
    "Willowvale": "Willowvale",
    "Wilmer": "Wilmer",
    "Wilson Creek": "Wilson Creek",
    "Wilson Landing": "Wilson Landing",
    "Windermere": "Windermere",
    "Windy": "Windy",
    "Winfield": "Winfield",
    "Wingdam": "Wingdam",
    "Winlaw": "Winlaw",
    "Winter Harbour": "Winter Harbour",
    "Wistaria": "Wistaria",
    "Wolf": "Wolf",
    "Wolfenden": "Wolfenden",
    "Wolverine": "Wolverine",
    "Wonowon": "Wonowon",
    "Woodcock": "Woodcock",
    "Woodfibre": "Woodfibre",
    "Woodmere": "Woodmere",
    "Woodpecker": "Woodpecker",
    "Woods Landing": "Woods Landing",
    "Woodsdale": "Woodsdale",
    "Worth": "Worth",
    "Woss": "Woss",
    "Wright": "Wright",
    "Wycliffe": "Wycliffe",
    "Wyman": "Wyman",
    "Wynndel": "Wynndel",
    "Yaculta": "Yaculta",
    "Yahk": "Yahk",
    "Yaku": "Yaku",
    "Yale": "Yale",
    "Yankee Flats": "Yankee Flats",
    "Yarksis": "Yarksis",
    "Yarrow": "Yarrow",
    "Yekooche": "Yekooche",
    "Yellow Point": "Yellow Point",
    "Yellowhead": "Yellowhead",
    "Yennadon": "Yennadon",
    "Ymir": "Ymir",
    "Yoho": "Yoho",
    "Youbou": "Youbou",
    "Yreka": "Yreka",
    "Yuquot": "Yuquot",
    "Zamora": "Zamora",
    "Zeballos": "Zeballos",
    "Zeke": "Zeke",
    "Zincton": "Zincton",
}

status_in_canada_map = {"Student": "S", "Visitor": "V", "Worker": "W", "Other": "O"}

family_imm_status_canada_map = {
    "Citizen": "C",
    "Permanent Resident": "PR",
    "Refugee Claimant": "RC",
    "Student": "S",
    "Visitor": "V",
    "Worker": "W",
    "Other": "OTH",
}
workpermit_type_map = {
    "International Experience Canada (IEC)": "IEC",
    "LMIA": "LMIA",
    "Other/Employer Specified": "OES",
    "Other/Open (no employer specified)": "OO",
}

field_of_study_map = {
    "Aboriginal and foreign languages, literatures and linguistics": "AFLLL",
    "Agriculture, agriculture operations and related sciences": "ARS",
    "Architecture and related services": "AARS",
    "Area, ethnic, cultural, gender, and group studies": "AECG",
    "Biological and Biomedical Sciences": "BABS",
    "Business, management, marketing and related support services": "BMAMCOJ",
    "Communication, journalism and related programs": "CJRP",
    "Communications technologies/technicians and support services": "CT",
    "Computer and information sciences and support services": "CS",
    "Construction Trades": "CTD",
    "Culinary Services": "CSEV",
    "Education": "E",
    "Engineering technologies and engineering-related fields": "ENG",
    "English language and literature/letters": "ENGLL",
    "Family and consumer sciences/human sciences": "FCSHS",
    "French language and literature/letters": "FLLL",
    "Health professions and related programs": "HP",
    "History": "HI",
    "Legal Profession and Studies": "LPAS",
    "Liberal arts and sciences, general studies and humanities": "LAAS",
    "Library Sciences": "LS",
    "Mathematics and Statistics": "MAS",
    "Mechanic and repair technologies/technicians": "M",
    "Military science, leadership and operational art": "MSLOA",
    "Military technologies and applied sciences": "MTAS",
    "Natural Resources and Conservation": "NRAC",
    "Parks, recreation, leisure and fitness studies": "PRLFS",
    "Personal and culinary services": "PCS",
    "Philosophy and Religious Studies": "PARS",
    "Physical Sciences": "PS",
    "Precision production": "PP",
    "Pre-technology education/pre-industrial arts programs": "PTEPRIAP",
    "Psychology": "P",
    "Public administration and social service professions": "PA",
    "Science technologies/technicians": "STT",
    "Security and protective services": "SPS",
    "Social sciences": "SS",
    "Transportation and materials moving": "TMM",
    "Visual and Performing Arts": "VAPA",
    "Other": "OTH",
}


def getFieldofStudy(field):
    for key, value in field_of_study_map.items():
        if field.lower() in key.lower():
            return value
    return field_of_study_map["Other"]


company_legal_structure = {
    "Incorporated": "IBC",
    "Limited Liability Partnership": "LLP",
    "Extra-provincially-registered": "EPR",
    "federally-incorporated companies": "EPR",
    "Other": "Other",
}


def getLegalStructure(structure, province):
    if province == "BC":
        return company_legal_structure[structure]


company_indsutry_map = {
    "Aerospace": "AE",
    "Agriculture": "AG",
    "Biotechnology": "BIO",
    "Communication": "COM",
    "E-Commerce": "EC",
    "Education": "ED",
    "Engineering": "EN",
    "Entertainment": "ET",
    "Financial": "FIN",
    "Food Processing": "FF",
    "Health (Physicians)": "HP",
    "Health (Registered Nurses)": "HRN",
    "Health (Other)": "HO",
    "High Technology": "HT",
    "Hospitality": "H",
    "Information Technologies": "IT",
    "Manufacturing": "M",
    "Natural Resources": "NR",
    "Professional Business Services": "PBS",
    "Property Management": "PMT",
    "Recreation": "REC",
    "Retail": "R",
    "Skilled Trade": "ST",
    "Tourism/Culture": "TC",
    "Transportation": "T",
}


def getCompanyIndustry(field):
    for key, value in company_indsutry_map.items():
        if field.lower() in key.lower():
            return value


marriage_map = {
    "Common-Law": "CL",
    "Divorced": "D",
    "Married": "M",
    "Separated": "S",
    "Single": "SG",
    "Widowed": "W",
    "Married - Physically Present": "M",
}
