# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at https://mozilla.org/MPL/2.0/.
#
# Copyright (C) 2020 - Equinor ASA.

import json

import dash
import dash_html_components as html

import webviz_subsurface_components

with open("./react/src/demo/example-data/L898MUD.json", encoding="utf8") as json_file:
    logs = json.load(json_file)

with open(
    "./react/src/demo/example-data/welllog_template_1.json", encoding="utf8"
) as json_file:
    template = json.load(json_file)
colortables = [
    {
        "name": "Physics",
        "discrete": False,
        "description": "Full options color table",
        "colorNaN": [255, 255, 255],
        "colorBelow": [255, 0, 0],
        "colorAbove": [0, 0, 255],
        "colors": [
            [0, 255, 0, 0],
            [0.25, 255, 255, 0],
            [0.5, 0, 255, 0],
            [0.75, 0, 255, 255],
            [1, 0, 0, 255],
        ],
    },
    {
        "name": "Physics reverse",
        "discrete": False,
        "colors": [
            [0, 0, 0, 255],
            [0.25, 0, 182, 182],
            [0.5, 0, 255, 0],
            [0.75, 182, 182, 0],
            [1, 255, 0, 0],
        ],
    },
    {
        "name": "Rainbow",
        "discrete": False,
        "colors": [
            [0, 255, 0, 0],
            [0.2, 255, 255, 0],
            [0.4, 0, 255, 0],
            [0.6, 0, 255, 255],
            [0.8, 0, 0, 255],
            [1, 255, 0, 255],
        ],
    },
    {
        "name": "Rainbow reverse",
        "discrete": False,
        "colors": [
            [0, 182, 0, 182],
            [0.2, 0, 0, 255],
            [0.4, 0, 182, 182],
            [0.6, 0, 255, 0],
            [0.8, 182, 182, 0],
            [1, 255, 0, 0],
        ],
    },
    {
        "name": "Porosity",
        "discrete": False,
        "colors": [
            [0, 255, 246, 117],
            [0.11, 255, 243, 53],
            [0.18, 255, 241, 0],
            [0.25, 155, 193, 0],
            [0.32, 255, 155, 23],
            [0.39, 255, 162, 61],
            [0.46, 255, 126, 45],
            [0.53, 227, 112, 24],
            [0.6, 246, 96, 31],
            [0.67, 229, 39, 48],
            [0.74, 252, 177, 170],
            [0.81, 236, 103, 146],
            [0.88, 226, 44, 118],
            [1, 126, 40, 111],
        ],
    },
    {
        "name": "Permeability",
        "discrete": False,
        "colors": [
            [0, 119, 63, 49],
            [0.148, 135, 49, 45],
            [0.246, 154, 89, 24],
            [0.344, 191, 88, 22],
            [0.441, 190, 142, 97],
            [0.539, 255, 126, 45],
            [0.637, 255, 162, 61],
            [0.734, 255, 155, 23],
            [0.832, 255, 241, 0],
            [1, 255, 246, 117],
        ],
    },
    {
        "name": "Seismic",
        "discrete": False,
        "colors": [[0, 0, 0, 255], [0.5, 255, 255, 255], [1, 255, 2, 2]],
    },
    {
        "name": "Time/Depth",
        "discrete": False,
        "colors": [
            [0, 252, 174, 169],
            [0.1, 226, 44, 118],
            [0.168, 229, 39, 48],
            [0.234, 150, 40, 34],
            [0.301, 255, 126, 45],
            [0.367, 255, 162, 61],
            [0.434, 255, 241, 0],
            [0.5, 219, 228, 163],
            [0.566, 0, 143, 74],
            [0.633, 0, 110, 78],
            [0.699, 0, 124, 140],
            [0.766, 116, 190, 230],
            [0.832, 0, 143, 212],
            [0.898, 0, 51, 116],
            [1, 74, 19, 86],
        ],
    },
    {
        "name": "Stratigraphy",
        "discrete": True,
        "colorNaN": [255, 64, 64],
        "colors": [
            [0, 255, 120, 61],
            [1, 255, 193, 0],
            [2, 255, 155, 76],
            [3, 255, 223, 161],
            [4, 226, 44, 118],
            [5, 255, 243, 53],
            [6, 255, 212, 179],
            [7, 255, 155, 23],
            [8, 255, 246, 117],
            [9, 255, 241, 0],
            [10, 255, 211, 178],
            [11, 255, 173, 128],
            [12, 248, 152, 0],
            [13, 154, 89, 24],
            [14, 0, 138, 185],
            [15, 82, 161, 40],
            [16, 219, 228, 163],
            [17, 0, 119, 64],
            [18, 0, 110, 172],
            [19, 116, 190, 230],
            [20, 0, 155, 212],
            [21, 0, 117, 190],
            [22, 143, 40, 112],
            [23, 220, 153, 190],
            [24, 226, 44, 118],
            [25, 126, 40, 111],
            [26, 73, 69, 43],
            [27, 203, 63, 42],
            [28, 255, 198, 190],
            [29, 135, 49, 45],
            [30, 150, 136, 120],
            [31, 198, 182, 175],
            [32, 166, 154, 145],
            [33, 191, 88, 22],
            [34, 255, 212, 179],
            [35, 251, 139, 105],
            [36, 154, 89, 24],
            [37, 186, 222, 200],
            [38, 0, 124, 140],
            [39, 87, 84, 83],
        ],
    },
    {
        "name": "Facies",
        "discrete": True,
        "colors": [
            [0, 255, 193, 0],
            [1, 255, 246, 117],
            [2, 166, 194, 42],
            [3, 149, 160, 24],
            [4, 9, 143, 74],
            [5, 125, 98, 15],
            [6, 0, 108, 154],
            [7, 0, 117, 190],
            [8, 28, 22, 59],
            [9, 39, 142, 199],
            [10, 0, 138, 185],
            [11, 52, 178, 188],
            [12, 235, 63, 34],
            [13, 74, 19, 86],
            [14, 248, 152, 0],
            [15, 1, 1, 1],
            [16, 128, 128, 128],
        ],
    },
    {
        "name": "GasOilWater",
        "discrete": True,
        "colors": [
            [0, 255, 46, 0],
            [1, 0, 184, 0],
            [2, 0, 25, 255],
            [3, 179, 179, 179],
        ],
    },
    {
        "name": "GasWater",
        "discrete": True,
        "colors": [[0, 255, 46, 0], [1, 0, 25, 255], [2, 179, 179, 179]],
    },
    {
        "name": "OilWater",
        "discrete": True,
        "colors": [[0, 0, 184, 0], [1, 0, 25, 255], [2, 179, 179, 179]],
    },
    {
        "name": "Accent",
        "discrete": True,
        "colors": [
            [0, 127, 201, 127],
            [1, 190, 174, 212],
            [2, 253, 192, 134],
            [4, 255, 255, 153],
            [5, 56, 108, 176],
            [6, 240, 2, 127],
            [7, 191, 91, 23],
            [8, 102, 102, 102],
        ],
    },
    {
        "name": "Colors_set_1",
        "discrete": "True",
        "colors": [
            [0, 255, 13, 186],
            [1, 255, 64, 53],
            [2, 247, 255, 164],
            [3, 112, 255, 97],
            [4, 9, 254, 133],
            [5, 254, 4, 135],
            [6, 255, 5, 94],
            [7, 32, 50, 255],
            [8, 109, 255, 32],
            [9, 254, 146, 92],
            [10, 185, 116, 255],
            [11, 255, 144, 1],
            [12, 157, 32, 255],
            [13, 255, 26, 202],
            [14, 73, 255, 35],
        ],
    },
    {
        "name": "Colors_set_3",
        "discrete": "True",
        "colors": [
            [0, 120, 181, 255],
            [1, 255, 29, 102],
            [2, 247, 255, 173],
            [3, 239, 157, 255],
            [4, 186, 255, 236],
            [5, 46, 255, 121],
            [6, 212, 255, 144],
            [7, 165, 255, 143],
            [8, 122, 255, 89],
            [9, 255, 212, 213],
        ],
    },
]

app = dash.Dash(__name__)

app.layout = html.Div(
    style={"height": "800px"},
    children=[
        webviz_subsurface_components.WellLogViewer(
            id="well_completions",
            welllog=logs,
            template=template,
            colorTables=colortables,
        ),
    ],
)

if __name__ == "__main__":
    app.run_server(debug=True)
