import { Construct } from 'constructs';
import { Chain } from '../chain';
import { CatchProps, IChainable, INextable, RetryProps } from '../types';
import { State } from './state';
/**
 * Properties for defining a Parallel state.
 *
 * @stability stable
 */
export interface ParallelProps {
    /**
     * An optional description for this state.
     *
     * @default No comment
     * @stability stable
     */
    readonly comment?: string;
    /**
     * JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @stability stable
     */
    readonly inputPath?: string;
    /**
     * JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @stability stable
     */
    readonly outputPath?: string;
    /**
     * JSONPath expression to indicate where to inject the state's output.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default $
     * @stability stable
     */
    readonly resultPath?: string;
    /**
     * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
     *
     * You can use ResultSelector to create a payload with values that are static
     * or selected from the state's raw result.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector
     * @stability stable
     */
    readonly resultSelector?: {
        [key: string]: any;
    };
}
/**
 * Define a Parallel state in the state machine.
 *
 * A Parallel state can be used to run one or more state machines at the same
 * time.
 *
 * The Result of a Parallel state is an array of the results of its substatemachines.
 *
 * @stability stable
 */
export declare class Parallel extends State implements INextable {
    /**
     * Continuable states of this Chainable.
     *
     * @stability stable
     */
    readonly endStates: INextable[];
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ParallelProps);
    /**
     * Add retry configuration for this state.
     *
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     *
     * @stability stable
     */
    addRetry(props?: RetryProps): Parallel;
    /**
     * Add a recovery handler for this state.
     *
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     *
     * @stability stable
     */
    addCatch(handler: IChainable, props?: CatchProps): Parallel;
    /**
     * Continue normal execution with the given state.
     *
     * @stability stable
     */
    next(next: IChainable): Chain;
    /**
     * Define one or more branches to run in parallel.
     *
     * @stability stable
     */
    branch(...branches: IChainable[]): Parallel;
    /**
     * Return the Amazon States Language object for this state.
     *
     * @stability stable
     */
    toStateJson(): object;
    /**
     * Validate this state.
     *
     * @stability stable
     */
    protected validate(): string[];
}
