"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDataSetBucketName = exports.packageAsset = exports.toS3Path = exports.buildPolicyStatementId = exports.sanitizeStackName = exports.buildRoleArn = exports.buildRoleName = exports.buildS3BucketArn = exports.buildDynamoDBTableName = exports.buildEventRuleName = exports.buildStateMachineName = exports.buildGlueEndpointName = exports.buildGlueCrawlerName = exports.buildGlueJobName = exports.buildLambdaFunctionName = exports.buildQueueName = exports.buildKinesisStreamName = exports.buildKinesisApplicationName = exports.buildS3BucketName = exports.buildUniqueName = exports.notUndefined = void 0;
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
const pipeline_1 = require("./pipeline");
function notUndefined(obj) {
    return obj !== undefined;
}
exports.notUndefined = notUndefined;
function buildUniqueName(props, maxLength) {
    const baseString = [props.name, props.resourceUse, props.stage, props.region, props.accountId]
        .filter(r => r != undefined)
        .join('-')
        .substring(0, maxLength);
    return baseString.toLowerCase();
}
exports.buildUniqueName = buildUniqueName;
function buildS3BucketName(props) {
    return buildUniqueName(props, 63).replace(/[^a-z0-9\-.]/g, '-');
}
exports.buildS3BucketName = buildS3BucketName;
function buildKinesisApplicationName(props) {
    return buildUniqueName(props, 128);
}
exports.buildKinesisApplicationName = buildKinesisApplicationName;
function buildKinesisStreamName(props) {
    return buildUniqueName(props, 128);
}
exports.buildKinesisStreamName = buildKinesisStreamName;
function buildQueueName(props) {
    return buildUniqueName(props, 80);
}
exports.buildQueueName = buildQueueName;
function buildLambdaFunctionName(props) {
    return buildUniqueName(props, 64);
}
exports.buildLambdaFunctionName = buildLambdaFunctionName;
function buildGlueJobName(props) {
    return buildUniqueName(props, 60);
}
exports.buildGlueJobName = buildGlueJobName;
function buildGlueCrawlerName(props) {
    return buildUniqueName(props, 60);
}
exports.buildGlueCrawlerName = buildGlueCrawlerName;
function buildGlueEndpointName(props) {
    return buildUniqueName(props, 60);
}
exports.buildGlueEndpointName = buildGlueEndpointName;
function buildStateMachineName(props) {
    return buildUniqueName(props, 80);
}
exports.buildStateMachineName = buildStateMachineName;
function buildEventRuleName(props) {
    return buildUniqueName(props, 64);
}
exports.buildEventRuleName = buildEventRuleName;
function buildDynamoDBTableName(props) {
    return buildUniqueName(props, 255);
}
exports.buildDynamoDBTableName = buildDynamoDBTableName;
function buildS3BucketArn(props) {
    const bucketName = buildS3BucketName(props);
    return `arn:aws:s3:::${bucketName}`;
}
exports.buildS3BucketArn = buildS3BucketArn;
function buildRoleName(props) {
    return buildUniqueName(props, 64);
}
exports.buildRoleName = buildRoleName;
function buildRoleArn(props) {
    const roleName = buildRoleName(props);
    return `arn:aws:iam::${props.accountId}:role/${roleName}`;
}
exports.buildRoleArn = buildRoleArn;
function sanitizeStackName(name) {
    return name.replace(/[^a-zA-Z0-9]/g, '-');
}
exports.sanitizeStackName = sanitizeStackName;
function buildPolicyStatementId(name, service, accessType) {
    return `${name}-${service}-${accessType}-access`;
}
exports.buildPolicyStatementId = buildPolicyStatementId;
function toS3Path(asset) {
    return `s3://${asset.s3BucketName}/${asset.s3ObjectKey}`;
}
exports.toS3Path = toS3Path;
function packageAsset(scope, id, projectRelativePath) {
    return new aws_s3_assets_1.Asset(scope, id, { path: projectRelativePath });
}
exports.packageAsset = packageAsset;
;
function getDataSetBucketName(dataSetLocation, dataSet) {
    return dataSetLocation == pipeline_1.DataSetLocation.RAW ? dataSet.rawBucketName :
        dataSetLocation == pipeline_1.DataSetLocation.REFINED ? dataSet.refinedBucketName :
            dataSet.trustedBucketName;
}
exports.getDataSetBucketName = getDataSetBucketName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMERBQStDO0FBRy9DLHlDQUE2QztBQUU3QyxTQUFnQixZQUFZLENBQUksR0FBa0I7SUFDaEQsT0FBTyxHQUFHLEtBQUssU0FBUyxDQUFDO0FBQzNCLENBQUM7QUFGRCxvQ0FFQztBQVVELFNBQWdCLGVBQWUsQ0FBQyxLQUE0QixFQUFFLFNBQWlCO0lBQzdFLE1BQU0sVUFBVSxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDO1NBQzNGLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsSUFBSSxTQUFTLENBQUM7U0FDM0IsSUFBSSxDQUFDLEdBQUcsQ0FBQztTQUNULFNBQVMsQ0FBQyxDQUFDLEVBQUUsU0FBUyxDQUFDLENBQUM7SUFFM0IsT0FBTyxVQUFVLENBQUMsV0FBVyxFQUFFLENBQUM7QUFDbEMsQ0FBQztBQVBELDBDQU9DO0FBRUQsU0FBZ0IsaUJBQWlCLENBQUMsS0FBNEI7SUFDNUQsT0FBTyxlQUFlLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLENBQUM7QUFDbEUsQ0FBQztBQUZELDhDQUVDO0FBRUQsU0FBZ0IsMkJBQTJCLENBQUMsS0FBNEI7SUFDdEUsT0FBTyxlQUFlLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBQ3JDLENBQUM7QUFGRCxrRUFFQztBQUVELFNBQWdCLHNCQUFzQixDQUFDLEtBQTRCO0lBQ2pFLE9BQU8sZUFBZSxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FBQztBQUNyQyxDQUFDO0FBRkQsd0RBRUM7QUFFRCxTQUFnQixjQUFjLENBQUMsS0FBNEI7SUFDekQsT0FBTyxlQUFlLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQ3BDLENBQUM7QUFGRCx3Q0FFQztBQUVELFNBQWdCLHVCQUF1QixDQUFDLEtBQTRCO0lBQ2xFLE9BQU8sZUFBZSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztBQUNwQyxDQUFDO0FBRkQsMERBRUM7QUFFRCxTQUFnQixnQkFBZ0IsQ0FBQyxLQUE0QjtJQUMzRCxPQUFPLGVBQWUsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDcEMsQ0FBQztBQUZELDRDQUVDO0FBRUQsU0FBZ0Isb0JBQW9CLENBQUMsS0FBNEI7SUFDL0QsT0FBTyxlQUFlLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQ3BDLENBQUM7QUFGRCxvREFFQztBQUVELFNBQWdCLHFCQUFxQixDQUFDLEtBQTRCO0lBQ2hFLE9BQU8sZUFBZSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztBQUNwQyxDQUFDO0FBRkQsc0RBRUM7QUFFRCxTQUFnQixxQkFBcUIsQ0FBQyxLQUE0QjtJQUNoRSxPQUFPLGVBQWUsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDcEMsQ0FBQztBQUZELHNEQUVDO0FBRUQsU0FBZ0Isa0JBQWtCLENBQUMsS0FBNEI7SUFDN0QsT0FBTyxlQUFlLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQ3BDLENBQUM7QUFGRCxnREFFQztBQUVELFNBQWdCLHNCQUFzQixDQUFDLEtBQTRCO0lBQ2pFLE9BQU8sZUFBZSxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FBQztBQUNyQyxDQUFDO0FBRkQsd0RBRUM7QUFFRCxTQUFnQixnQkFBZ0IsQ0FBQyxLQUE0QjtJQUMzRCxNQUFNLFVBQVUsR0FBRyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM1QyxPQUFPLGdCQUFnQixVQUFVLEVBQUUsQ0FBQztBQUN0QyxDQUFDO0FBSEQsNENBR0M7QUFFRCxTQUFnQixhQUFhLENBQUMsS0FBNEI7SUFDeEQsT0FBTyxlQUFlLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQ3BDLENBQUM7QUFGRCxzQ0FFQztBQUVELFNBQWdCLFlBQVksQ0FBQyxLQUE0QjtJQUN2RCxNQUFNLFFBQVEsR0FBRyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdEMsT0FBTyxnQkFBZ0IsS0FBSyxDQUFDLFNBQVMsU0FBUyxRQUFRLEVBQUUsQ0FBQztBQUM1RCxDQUFDO0FBSEQsb0NBR0M7QUFFRCxTQUFnQixpQkFBaUIsQ0FBQyxJQUFZO0lBQzVDLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLENBQUM7QUFDNUMsQ0FBQztBQUZELDhDQUVDO0FBRUQsU0FBZ0Isc0JBQXNCLENBQUMsSUFBWSxFQUFFLE9BQWUsRUFBRSxVQUFrQjtJQUN0RixPQUFPLEdBQUcsSUFBSSxJQUFJLE9BQU8sSUFBSSxVQUFVLFNBQVMsQ0FBQztBQUNuRCxDQUFDO0FBRkQsd0RBRUM7QUFFRCxTQUFnQixRQUFRLENBQUMsS0FBWTtJQUNuQyxPQUFPLFFBQVEsS0FBSyxDQUFDLFlBQVksSUFBSSxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7QUFDM0QsQ0FBQztBQUZELDRCQUVDO0FBRUQsU0FBZ0IsWUFBWSxDQUFFLEtBQW9CLEVBQUUsRUFBVSxFQUFFLG1CQUEyQjtJQUN6RixPQUFPLElBQUkscUJBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLG1CQUFtQixFQUFFLENBQUMsQ0FBQztBQUM3RCxDQUFDO0FBRkQsb0NBRUM7QUFBQSxDQUFDO0FBRUYsU0FBZ0Isb0JBQW9CLENBQUMsZUFBZ0MsRUFBRSxPQUFnQjtJQUNyRixPQUFPLGVBQWUsSUFBSSwwQkFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3JFLGVBQWUsSUFBSSwwQkFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLGlCQUFpQixDQUFDLENBQUM7WUFDdEUsT0FBTyxDQUFDLGlCQUFpQixDQUFDO0FBQ2hDLENBQUM7QUFKRCxvREFJQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFzc2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXMzLWFzc2V0cyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBEYXRhU2V0IH0gZnJvbSAnLi9kYXRhLXNldHMvZGF0YS1zZXQnO1xuaW1wb3J0IHsgRGF0YVNldExvY2F0aW9uIH0gZnJvbSAnLi9waXBlbGluZSc7XG5cbmV4cG9ydCBmdW5jdGlvbiBub3RVbmRlZmluZWQ8VD4ob2JqOiBUIHwgdW5kZWZpbmVkKTogb2JqIGlzIFQge1xuICByZXR1cm4gb2JqICE9PSB1bmRlZmluZWQ7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTmFtZUJ1aWxkZXJQYXJhbWV0ZXJzIHtcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICByZWFkb25seSByZXNvdXJjZVVzZT86IHN0cmluZztcbiAgcmVhZG9ubHkgc3RhZ2U/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlZ2lvbj86IHN0cmluZztcbiAgcmVhZG9ubHkgYWNjb3VudElkPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYnVpbGRVbmlxdWVOYW1lKHByb3BzOiBOYW1lQnVpbGRlclBhcmFtZXRlcnMsIG1heExlbmd0aDogbnVtYmVyKTogc3RyaW5nIHtcbiAgY29uc3QgYmFzZVN0cmluZyA9IFtwcm9wcy5uYW1lLCBwcm9wcy5yZXNvdXJjZVVzZSwgcHJvcHMuc3RhZ2UsIHByb3BzLnJlZ2lvbiwgcHJvcHMuYWNjb3VudElkXVxuICAgIC5maWx0ZXIociA9PiByICE9IHVuZGVmaW5lZClcbiAgICAuam9pbignLScpXG4gICAgLnN1YnN0cmluZygwLCBtYXhMZW5ndGgpO1xuXG4gIHJldHVybiBiYXNlU3RyaW5nLnRvTG93ZXJDYXNlKCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBidWlsZFMzQnVja2V0TmFtZShwcm9wczogTmFtZUJ1aWxkZXJQYXJhbWV0ZXJzKTogc3RyaW5nIHtcbiAgcmV0dXJuIGJ1aWxkVW5pcXVlTmFtZShwcm9wcywgNjMpLnJlcGxhY2UoL1teYS16MC05XFwtLl0vZywgJy0nKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkS2luZXNpc0FwcGxpY2F0aW9uTmFtZShwcm9wczogTmFtZUJ1aWxkZXJQYXJhbWV0ZXJzKTogc3RyaW5nIHtcbiAgcmV0dXJuIGJ1aWxkVW5pcXVlTmFtZShwcm9wcywgMTI4KTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkS2luZXNpc1N0cmVhbU5hbWUocHJvcHM6IE5hbWVCdWlsZGVyUGFyYW1ldGVycyk6IHN0cmluZyB7XG4gIHJldHVybiBidWlsZFVuaXF1ZU5hbWUocHJvcHMsIDEyOCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBidWlsZFF1ZXVlTmFtZShwcm9wczogTmFtZUJ1aWxkZXJQYXJhbWV0ZXJzKTogc3RyaW5nIHtcbiAgcmV0dXJuIGJ1aWxkVW5pcXVlTmFtZShwcm9wcywgODApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYnVpbGRMYW1iZGFGdW5jdGlvbk5hbWUocHJvcHM6IE5hbWVCdWlsZGVyUGFyYW1ldGVycyk6IHN0cmluZyB7XG4gIHJldHVybiBidWlsZFVuaXF1ZU5hbWUocHJvcHMsIDY0KTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkR2x1ZUpvYk5hbWUocHJvcHM6IE5hbWVCdWlsZGVyUGFyYW1ldGVycyk6IHN0cmluZyB7XG4gIHJldHVybiBidWlsZFVuaXF1ZU5hbWUocHJvcHMsIDYwKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkR2x1ZUNyYXdsZXJOYW1lKHByb3BzOiBOYW1lQnVpbGRlclBhcmFtZXRlcnMpOiBzdHJpbmcge1xuICByZXR1cm4gYnVpbGRVbmlxdWVOYW1lKHByb3BzLCA2MCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBidWlsZEdsdWVFbmRwb2ludE5hbWUocHJvcHM6IE5hbWVCdWlsZGVyUGFyYW1ldGVycyk6IHN0cmluZyB7XG4gIHJldHVybiBidWlsZFVuaXF1ZU5hbWUocHJvcHMsIDYwKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkU3RhdGVNYWNoaW5lTmFtZShwcm9wczogTmFtZUJ1aWxkZXJQYXJhbWV0ZXJzKTogc3RyaW5nIHtcbiAgcmV0dXJuIGJ1aWxkVW5pcXVlTmFtZShwcm9wcywgODApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYnVpbGRFdmVudFJ1bGVOYW1lKHByb3BzOiBOYW1lQnVpbGRlclBhcmFtZXRlcnMpOiBzdHJpbmcge1xuICByZXR1cm4gYnVpbGRVbmlxdWVOYW1lKHByb3BzLCA2NCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBidWlsZER5bmFtb0RCVGFibGVOYW1lKHByb3BzOiBOYW1lQnVpbGRlclBhcmFtZXRlcnMpOiBzdHJpbmcge1xuICByZXR1cm4gYnVpbGRVbmlxdWVOYW1lKHByb3BzLCAyNTUpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYnVpbGRTM0J1Y2tldEFybihwcm9wczogTmFtZUJ1aWxkZXJQYXJhbWV0ZXJzKTogc3RyaW5nIHtcbiAgY29uc3QgYnVja2V0TmFtZSA9IGJ1aWxkUzNCdWNrZXROYW1lKHByb3BzKTtcbiAgcmV0dXJuIGBhcm46YXdzOnMzOjo6JHtidWNrZXROYW1lfWA7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBidWlsZFJvbGVOYW1lKHByb3BzOiBOYW1lQnVpbGRlclBhcmFtZXRlcnMpOiBzdHJpbmcge1xuICByZXR1cm4gYnVpbGRVbmlxdWVOYW1lKHByb3BzLCA2NCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBidWlsZFJvbGVBcm4ocHJvcHM6IE5hbWVCdWlsZGVyUGFyYW1ldGVycyk6IHN0cmluZyB7XG4gIGNvbnN0IHJvbGVOYW1lID0gYnVpbGRSb2xlTmFtZShwcm9wcyk7XG4gIHJldHVybiBgYXJuOmF3czppYW06OiR7cHJvcHMuYWNjb3VudElkfTpyb2xlLyR7cm9sZU5hbWV9YDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHNhbml0aXplU3RhY2tOYW1lKG5hbWU6IHN0cmluZykge1xuICByZXR1cm4gbmFtZS5yZXBsYWNlKC9bXmEtekEtWjAtOV0vZywgJy0nKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkUG9saWN5U3RhdGVtZW50SWQobmFtZTogc3RyaW5nLCBzZXJ2aWNlOiBzdHJpbmcsIGFjY2Vzc1R5cGU6IHN0cmluZyk6IHN0cmluZyB7XG4gIHJldHVybiBgJHtuYW1lfS0ke3NlcnZpY2V9LSR7YWNjZXNzVHlwZX0tYWNjZXNzYDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHRvUzNQYXRoKGFzc2V0OiBBc3NldCk6IHN0cmluZyB7XG4gIHJldHVybiBgczM6Ly8ke2Fzc2V0LnMzQnVja2V0TmFtZX0vJHthc3NldC5zM09iamVjdEtleX1gO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcGFja2FnZUFzc2V0IChzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvamVjdFJlbGF0aXZlUGF0aDogc3RyaW5nKTogQXNzZXQge1xuICByZXR1cm4gbmV3IEFzc2V0KHNjb3BlLCBpZCwgeyBwYXRoOiBwcm9qZWN0UmVsYXRpdmVQYXRoIH0pO1xufTtcblxuZXhwb3J0IGZ1bmN0aW9uIGdldERhdGFTZXRCdWNrZXROYW1lKGRhdGFTZXRMb2NhdGlvbjogRGF0YVNldExvY2F0aW9uLCBkYXRhU2V0OiBEYXRhU2V0KSA6IHN0cmluZyB7XG4gIHJldHVybiBkYXRhU2V0TG9jYXRpb24gPT0gRGF0YVNldExvY2F0aW9uLlJBVyA/IGRhdGFTZXQucmF3QnVja2V0TmFtZSA6XG4gICAgZGF0YVNldExvY2F0aW9uID09IERhdGFTZXRMb2NhdGlvbi5SRUZJTkVEID8gZGF0YVNldC5yZWZpbmVkQnVja2V0TmFtZSA6XG4gICAgICBkYXRhU2V0LnRydXN0ZWRCdWNrZXROYW1lO1xufSJdfQ==