"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const glue = require("@aws-cdk/aws-glue");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class GlueTable extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.tableName = props.tableName;
        this.table = new glue.CfnTable(this, `${props.tableName}-glue-table`, {
            catalogId: props.catalogId,
            databaseName: props.databaseName,
            tableInput: {
                description: props.description,
                name: props.tableName,
                tableType: 'EXTERNAL_TABLE',
                partitionKeys: props.partitionKeys,
                parameters: {
                    EXTERNAL: true,
                    has_encrypted_data: false,
                    ...props.parameters,
                },
                storageDescriptor: {
                    columns: props.columns,
                    location: props.s3Location,
                    serdeInfo: {
                        serializationLibrary: props.serializationLibrary,
                        parameters: {
                            ...props.serdeParameters,
                        },
                    },
                    inputFormat: props.inputFormat,
                    outputFormat: props.outputFormat,
                    parameters: {
                        'serialization.format': '1',
                    },
                },
            },
        });
    }
}
exports.GlueTable = GlueTable;
_a = JSII_RTTI_SYMBOL_1;
GlueTable[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.GlueTable", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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