import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as cdk from '@aws-cdk/core';
import { GlueJob } from './glue-job';
/**
 * @experimental
 */
export interface IGlueOpsProperties {
    /**
     * @experimental
     */
    job: GlueJob;
    /**
     * @experimental
     */
    jvmHeapSizeExceeding80percent?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    jvmHeapSizeExceeding90percent?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    metricExecutionFailure?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    metricAllExecutionAttemptsFailed?: cloudwatch.CreateAlarmOptions;
}
/**
 * @experimental
 */
export declare class GlueJobOps extends cdk.Construct {
    /**
     * @experimental
     */
    readonly job: GlueJob;
    /**
     * @experimental
     */
    dashboard: cloudwatch.Dashboard;
    /**
     * @experimental
     */
    readonly jvmHeapSizeExceeding80PercentAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly jvmHeapSizeExceeding90PercentAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly metricExecutionFailureAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly metricAllExecutionAttemptsFailedAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly alarmsSev2: cloudwatch.Alarm[];
    /**
     * @experimental
     */
    readonly alarmsSev3: cloudwatch.Alarm[];
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: IGlueOpsProperties);
    private addWidgets;
    private setupDashboard;
    private alarmWidget;
}
