"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3DeliveryStream = exports.CompressionType = exports.ProcessorType = exports.DeliveryStreamType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const iam = require("@aws-cdk/aws-iam");
const firehose = require("@aws-cdk/aws-kinesisfirehose");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
var DeliveryStreamType;
(function (DeliveryStreamType) {
    DeliveryStreamType["DIRECT_PUT"] = "DirectPut";
    DeliveryStreamType["KINESIS_STREAM_AS_SOURCE"] = "KinesisStreamAsSource";
})(DeliveryStreamType = exports.DeliveryStreamType || (exports.DeliveryStreamType = {}));
var ProcessorType;
(function (ProcessorType) {
    ProcessorType["LAMBDA"] = "Lambda";
})(ProcessorType = exports.ProcessorType || (exports.ProcessorType = {}));
/**
 * @experimental
 */
var CompressionType;
(function (CompressionType) {
    CompressionType["UNCOMPRESSED"] = "UNCOMPRESSED";
    CompressionType["GZIP"] = "GZIP";
    CompressionType["ZIP"] = "ZIP";
    CompressionType["SNAPPY"] = "Snappy";
})(CompressionType = exports.CompressionType || (exports.CompressionType = {}));
/**
 * @experimental
 */
class S3DeliveryStream extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(parent, name, props) {
        super(parent, name);
        this.role = new iam.Role(this, 'kinesis-role', {
            assumedBy: new iam.ServicePrincipal('firehose.amazonaws.com'),
        });
        this.s3Bucket = props.s3Bucket;
        this.deliveryStreamResource = new firehose.CfnDeliveryStream(this, 'delivery-stream', {
            deliveryStreamType: DeliveryStreamType.KINESIS_STREAM_AS_SOURCE,
            kinesisStreamSourceConfiguration: this.makeKinesisSourceConfig(props),
            extendedS3DestinationConfiguration: this.makeS3Config(props),
        });
        this.deliveryStreamResource.node.addDependency(this.role);
        this.deliveryStreamArn = this.deliveryStreamResource.getAtt('Arn').toString();
        this.deliveryStreamName = this.deliveryStreamResource.ref;
    }
    /**
     * @experimental
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/Firehose',
            metricName,
            dimensions: {
                DeliveryStreamName: this.deliveryStreamName,
            },
            ...props,
        });
    }
    /**
     * @experimental
     */
    metricBackupToS3Bytes(props) {
        return this.metric('BackupToS3.Bytes', props);
    }
    /**
     * @experimental
     */
    metricBackupToS3DataFreshness(props) {
        return this.metric('BackupToS3.DataFreshness', props);
    }
    /**
     * @experimental
     */
    metricBackupToS3Records(props) {
        return this.metric('BackupToS3.Records', props);
    }
    /**
     * @experimental
     */
    metricBackupToS3Success(props) {
        return this.metric('BackupToS3.Success', props);
    }
    /**
     * @experimental
     */
    metricDataReadFromKinesisStreamBytes(props) {
        return this.metric('DataReadFromKinesisStream.Bytes', props);
    }
    /**
     * @experimental
     */
    metricDataReadFromKinesisStreamRecords(props) {
        return this.metric('DataReadFromKinesisStream.Records', props);
    }
    /**
     * @experimental
     */
    metricDeliveryToS3Bytes(props) {
        return this.metric('DeliveryToS3.Bytes', props);
    }
    /**
     * @experimental
     */
    metricDeliveryToS3DataFreshness(props) {
        return this.metric('DeliveryToS3.DataFreshness', props);
    }
    /**
     * @experimental
     */
    metricDeliveryToS3Records(props) {
        return this.metric('DeliveryToS3.Records', props);
    }
    /**
     * @experimental
     */
    metricDeliveryToS3Success(props) {
        return this.metric('DeliveryToS3.Success', props);
    }
    /**
     * @experimental
     */
    metricIncomingBytes(props) {
        return this.metric('IncomingBytes', props);
    }
    /**
     * @experimental
     */
    metricIncomingRecords(props) {
        return this.metric('IncomingRecords', props);
    }
    makeKinesisSourceConfig(props) {
        if (props.kinesisStream) {
            props.kinesisStream.grantRead(this.role);
            props.kinesisStream.grant(this.role, 'kinesis:DescribeStream');
            return {
                kinesisStreamArn: props.kinesisStream.streamArn,
                roleArn: this.role.roleArn,
            };
        }
        else {
            throw new Error("must provide a Kinesis stream if type is 'KinesisStreamAsSource'");
        }
    }
    makeS3Config(props) {
        this.s3Bucket.grantReadWrite(this.role);
        if (props.kinesisStream) {
            props.kinesisStream.grantRead(this.role);
        }
        return {
            bucketArn: this.s3Bucket.bucketArn,
            bufferingHints: {
                intervalInSeconds: 60,
                sizeInMBs: 64,
            },
            compressionFormat: props.compression || CompressionType.UNCOMPRESSED,
            prefix: props.s3Prefix || '',
            roleArn: this.role.roleArn,
            processingConfiguration: this.makeProcessorConfig(props),
        };
    }
    makeProcessorConfig(props) {
        if (props.transformFunction) {
            this.role.addToPolicy(new iam.PolicyStatement({
                actions: ['lambda:InvokeFunction'],
                resources: [props.transformFunction.functionArn, `${props.transformFunction.functionArn}:*`],
            }));
            return {
                enabled: true,
                processors: [
                    {
                        type: ProcessorType.LAMBDA,
                        parameters: [
                            {
                                parameterName: 'LambdaArn',
                                parameterValue: props.transformFunction.functionArn,
                            },
                            {
                                parameterName: 'NumberOfRetries',
                                parameterValue: '3',
                            },
                        ],
                    },
                ],
            };
        }
        else {
            return undefined;
        }
    }
}
exports.S3DeliveryStream = S3DeliveryStream;
_a = JSII_RTTI_SYMBOL_1;
S3DeliveryStream[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.S3DeliveryStream", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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