import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as iam from '@aws-cdk/aws-iam';
import * as kinesis from '@aws-cdk/aws-kinesis';
import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
/**
 * @experimental
 */
export declare enum DeliveryStreamType {
    /**
     * @experimental
     */
    DIRECT_PUT = "DirectPut",
    /**
     * @experimental
     */
    KINESIS_STREAM_AS_SOURCE = "KinesisStreamAsSource"
}
export declare enum ProcessorType {
    /**
     * @experimental
     */
    LAMBDA = "Lambda"
}
/**
 * @experimental
 */
export declare enum CompressionType {
    /**
     * @experimental
     */
    UNCOMPRESSED = "UNCOMPRESSED",
    /**
     * @experimental
     */
    GZIP = "GZIP",
    /**
     * @experimental
     */
    ZIP = "ZIP",
    /**
     * @experimental
     */
    SNAPPY = "Snappy"
}
/**
 * @experimental
 */
export interface DeliveryStreamProperties {
    /**
     * @experimental
     */
    readonly kinesisStream: kinesis.Stream;
    /**
     * @experimental
     */
    readonly s3Bucket: s3.IBucket;
    /**
     * @experimental
     */
    readonly s3Prefix?: string;
    /**
     * @experimental
     */
    readonly compression?: CompressionType;
    /**
     * @experimental
     */
    readonly transformFunction?: lambda.Function;
}
/**
 * @experimental
 */
export declare class S3DeliveryStream extends cdk.Resource {
    /**
     * @experimental
     */
    s3Bucket: s3.IBucket;
    /**
     * @experimental
     */
    protected cloudWatchLogsRole?: iam.Role;
    /**
     * @experimental
     */
    readonly deliveryStreamArn: string;
    /**
     * @experimental
     */
    readonly deliveryStreamName: string;
    private readonly role;
    private readonly deliveryStreamResource;
    /**
     * @experimental
     */
    constructor(parent: cdk.Construct, name: string, props: DeliveryStreamProperties);
    /**
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricBackupToS3Bytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricBackupToS3DataFreshness(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricBackupToS3Records(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricBackupToS3Success(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricDataReadFromKinesisStreamBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricDataReadFromKinesisStreamRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricDeliveryToS3Bytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricDeliveryToS3DataFreshness(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricDeliveryToS3Records(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricDeliveryToS3Success(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricIncomingBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricIncomingRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private makeKinesisSourceConfig;
    private makeS3Config;
    private makeProcessorConfig;
}
