"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3sns = require("@aws-cdk/aws-s3-notifications");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const data_lake_bucket_1 = require("../data-lake-bucket");
const utils_1 = require("../utils");
/**
 * @experimental
 */
class DataSet extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.pipeline.name;
        this.dropLocation = props.pipeline.dataSetDropLocation;
        this.pipeline = props.pipeline;
        this.dataProduct = props.dataProduct;
        this.rawBucketName = utils_1.buildS3BucketName({
            name: props.pipeline.name,
            accountId: this.dataProduct.accountId,
            resourceUse: 'raw',
            stage: props.stage,
        });
        this.trustedBucketName = utils_1.buildS3BucketName({
            name: props.pipeline.name,
            accountId: this.dataProduct.accountId,
            resourceUse: 'trusted',
            stage: props.stage,
        });
        this.refinedBucketName = utils_1.buildS3BucketName({
            name: props.pipeline.name,
            accountId: this.dataProduct.accountId,
            resourceUse: 'refined',
            stage: props.stage,
        });
        const dataCatalogAccountId = props.dataProduct.dataCatalogAccountId ?
            props.dataProduct.dataCatalogAccountId : props.dataProduct.accountId;
        const crossAccount = props.dataProduct.dataCatalogAccountId ?
            props.dataProduct.dataCatalogAccountId != props.dataProduct.accountId ? true : false : false;
        // only create the buckets in the data owner account if using in multi account scenario
        if (props.accountId == props.dataProduct.accountId) {
            const rawBucket = new data_lake_bucket_1.DataLakeBucket(this, `s3-raw-bucket-${props.pipeline.name}`, {
                bucketName: this.rawBucketName,
                dataCatalogAccountId: dataCatalogAccountId,
                logBucket: props.logBucket,
                crossAccount: crossAccount,
                s3Properties: props.s3BucketProps,
            }).bucket;
            const trustedBucket = new data_lake_bucket_1.DataLakeBucket(this, `s3-trusted-bucket-${props.pipeline.name}`, {
                bucketName: this.trustedBucketName,
                dataCatalogAccountId: dataCatalogAccountId,
                logBucket: props.logBucket,
                crossAccount: crossAccount,
                s3Properties: props.s3BucketProps,
            }).bucket;
            const refinedBucket = new data_lake_bucket_1.DataLakeBucket(this, `s3-refined-bucket-${props.pipeline.name}`, {
                bucketName: this.refinedBucketName,
                dataCatalogAccountId: dataCatalogAccountId,
                logBucket: props.logBucket,
                crossAccount: crossAccount,
                s3Properties: props.s3BucketProps,
            }).bucket;
            if (props.pipeline.s3NotificationProps) {
                this.createS3NotificationTopic(props.pipeline.s3NotificationProps, rawBucket);
                this.createS3NotificationTopic(props.pipeline.s3NotificationProps, trustedBucket);
                this.createS3NotificationTopic(props.pipeline.s3NotificationProps, refinedBucket);
            }
            if (this.dropLocation) {
                this.downloadLocations = {
                    destinationPrefix: props.pipeline.destinationPrefix,
                    destinationBucketName: utils_1.getDataSetBucketName(this.dropLocation, this),
                    sourceBucketName: props.pipeline.s3Properties ? props.pipeline.s3Properties.sourceBucketName : undefined,
                    sourceKeys: props.pipeline.s3Properties ? props.pipeline.s3Properties.sourceKeys : undefined,
                };
            }
        }
    }
    createS3NotificationTopic(s3NotificationProps, bucket) {
        this.s3NotificationTopic = new sns.Topic(this, 'sns-datalake-notification-topic');
        bucket.addEventNotification(s3NotificationProps.event, new s3sns.SnsDestination(this.s3NotificationTopic), {
            prefix: s3NotificationProps.prefix,
            suffix: s3NotificationProps.suffix,
        });
    }
}
exports.DataSet = DataSet;
_a = JSII_RTTI_SYMBOL_1;
DataSet[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataSet", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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